/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.pagepane;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.debugger.pagepane.DebugTextOverlay;
import org.apache.pdfbox.debugger.ui.ErrorDialog;
import org.apache.pdfbox.debugger.ui.HighResolutionImageIcon;
import org.apache.pdfbox.debugger.ui.ImageTypeMenu;
import org.apache.pdfbox.debugger.ui.ImageUtil;
import org.apache.pdfbox.debugger.ui.RenderDestinationMenu;
import org.apache.pdfbox.debugger.ui.RotationMenu;
import org.apache.pdfbox.debugger.ui.TextDialog;
import org.apache.pdfbox.debugger.ui.ViewMenu;
import org.apache.pdfbox.debugger.ui.ZoomMenu;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.fixup.AcroFormDefaultFixup;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;

public class PagePane
implements ActionListener,
AncestorListener,
MouseMotionListener,
MouseListener {
    private static final Log LOG = LogFactory.getLog(PagePane.class);
    private final PDDocument document;
    private final JLabel statuslabel;
    private final PDPage page;
    private JPanel panel;
    private int pageIndex = -1;
    private JLabel label;
    private ZoomMenu zoomMenu;
    private RotationMenu rotationMenu;
    private ImageTypeMenu imageTypeMenu;
    private RenderDestinationMenu renderDestinationMenu;
    private ViewMenu viewMenu;
    private String labelText = "";
    private String currentURI = "";
    private final Map<PDRectangle, String> rectMap = new HashMap<PDRectangle, String>();
    private final AffineTransform defaultTransform = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();

    public PagePane(PDDocument document, COSDictionary pageDict, JLabel statuslabel) {
        this.page = new PDPage(pageDict);
        this.pageIndex = document.getPages().indexOf(this.page);
        this.document = document;
        this.statuslabel = statuslabel;
        this.initUI();
        this.initRectMap();
    }

    private void initRectMap() {
        try {
            this.collectFieldLocations();
            this.collectLinkLocations();
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    private void collectLinkLocations() throws IOException {
        for (PDAnnotation annotation : this.page.getAnnotations()) {
            if (!(annotation instanceof PDAnnotationLink)) continue;
            this.collectLinkLocation((PDAnnotationLink)annotation);
        }
    }

    private void collectLinkLocation(PDAnnotationLink linkAnnotation) throws IOException {
        PDPageDestination pageDestination;
        int pageNum;
        if (linkAnnotation.getRectangle() == null) {
            return;
        }
        PDAction action = linkAnnotation.getAction();
        if (action instanceof PDActionURI) {
            PDActionURI uriAction = (PDActionURI)action;
            this.rectMap.put(linkAnnotation.getRectangle(), "URI: " + uriAction.getURI());
            return;
        }
        PDDestination destination = null;
        try {
            if (action instanceof PDActionGoTo) {
                PDActionGoTo goToAction = (PDActionGoTo)action;
                destination = goToAction.getDestination();
            } else {
                destination = linkAnnotation.getDestination();
            }
            if (destination instanceof PDNamedDestination) {
                destination = this.document.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)destination);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
        }
        if (destination instanceof PDPageDestination && (pageNum = (pageDestination = (PDPageDestination)destination).retrievePageNumber()) != -1) {
            this.rectMap.put(linkAnnotation.getRectangle(), "Page destination: " + (pageNum + 1));
        }
    }

    private void collectFieldLocations() throws IOException {
        AcroFormDefaultFixup fixup = ViewMenu.isRepairAcroformSelected() ? new AcroFormDefaultFixup(this.document) : null;
        PDAcroForm acroForm = this.document.getDocumentCatalog().getAcroForm(fixup);
        if (acroForm == null) {
            return;
        }
        HashSet<COSDictionary> dictionarySet = new HashSet<COSDictionary>();
        for (PDAnnotation annotation : this.page.getAnnotations()) {
            dictionarySet.add(annotation.getCOSObject());
        }
        for (PDField field : acroForm.getFieldTree()) {
            for (PDAnnotationWidget widget : field.getWidgets()) {
                if (!dictionarySet.contains(widget.getCOSObject()) || widget.getRectangle() == null) continue;
                this.rectMap.put(widget.getRectangle(), "Field name: " + field.getFullyQualifiedName());
            }
        }
    }

    private void initUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        String pageLabelText = this.pageIndex < 0 ? "Page number not found (may be an orphan page)" : "Page " + (this.pageIndex + 1);
        String lbl = PDFDebugger.getPageLabel(this.document, this.pageIndex);
        if (lbl != null) {
            pageLabelText = pageLabelText + " - " + lbl;
        }
        JLabel pageLabel = new JLabel(pageLabelText);
        pageLabel.setAlignmentX(0.5f);
        pageLabel.setFont(new Font("Monospaced", 0, 20));
        pageLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.panel.add(pageLabel);
        this.label = new JLabel();
        this.label.addMouseMotionListener(this);
        this.label.addMouseListener(this);
        this.label.setAlignmentX(0.5f);
        this.panel.add(this.label);
        this.panel.addAncestorListener(this);
        this.zoomMenu = ZoomMenu.getInstance();
        this.zoomMenu.changeZoomSelection(this.zoomMenu.getPageZoomScale());
        this.startRendering();
    }

    public Component getPanel() {
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (ViewMenu.isRepairAcroformEvent(actionEvent)) {
            AcroFormDefaultFixup fixup = ViewMenu.isRepairAcroformSelected() ? new AcroFormDefaultFixup(this.document) : null;
            this.document.getDocumentCatalog().getAcroForm(fixup);
            this.startRendering();
        } else if (ZoomMenu.isZoomMenu(actionCommand) || RotationMenu.isRotationMenu(actionCommand) || ImageTypeMenu.isImageTypeMenu(actionCommand) || RenderDestinationMenu.isRenderDestinationMenu(actionCommand) || ViewMenu.isRenderingOption(actionCommand)) {
            this.startRendering();
        } else if (ViewMenu.isExtractTextEvent(actionEvent)) {
            this.startExtracting();
        }
    }

    private void startExtracting() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        TextDialog textDialog = TextDialog.instance();
        textDialog.setSize(screenWidth / 3, screenHeight / 3);
        textDialog.setVisible(true);
        Point locationOnScreen = this.getPanel().getLocationOnScreen();
        int x = Math.min(locationOnScreen.x + this.getPanel().getWidth() / 2, screenWidth * 3 / 4);
        int y = Math.min(locationOnScreen.y + this.getPanel().getHeight() / 2, screenHeight * 3 / 4);
        x = Math.max(0, x);
        y = Math.max(0, y);
        textDialog.setLocation(x, y);
        try {
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setStartPage(this.pageIndex + 1);
            stripper.setEndPage(this.pageIndex + 1);
            textDialog.setText(stripper.getText(this.document));
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    private void startRendering() {
        if (this.pageIndex < 0) {
            return;
        }
        new RenderWorker().execute();
        this.zoomMenu.setPageZoomScale(ZoomMenu.getZoomScale());
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.zoomMenu.addMenuListeners(this);
        this.zoomMenu.setEnableMenu(true);
        this.rotationMenu = RotationMenu.getInstance();
        this.rotationMenu.addMenuListeners(this);
        this.rotationMenu.setEnableMenu(true);
        this.imageTypeMenu = ImageTypeMenu.getInstance();
        this.imageTypeMenu.addMenuListeners(this);
        this.imageTypeMenu.setEnableMenu(true);
        this.renderDestinationMenu = RenderDestinationMenu.getInstance();
        this.renderDestinationMenu.addMenuListeners(this);
        this.renderDestinationMenu.setEnableMenu(true);
        this.viewMenu = ViewMenu.getInstance(null);
        JMenu menuInstance = this.viewMenu.getMenu();
        int itemCount = menuInstance.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            JMenuItem item = menuInstance.getItem(i);
            if (item == null) continue;
            item.setEnabled(true);
            item.addActionListener(this);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        boolean isFirstEntrySkipped = false;
        this.zoomMenu.setEnableMenu(false);
        this.rotationMenu.setEnableMenu(false);
        this.imageTypeMenu.setEnableMenu(false);
        this.renderDestinationMenu.setEnableMenu(false);
        JMenu menuInstance = this.viewMenu.getMenu();
        int itemCount = menuInstance.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            JMenuItem item = menuInstance.getItem(i);
            if (item == null) continue;
            if (!isFirstEntrySkipped) {
                isFirstEntrySkipped = true;
                continue;
            }
            item.setEnabled(false);
            item.removeActionListener(this);
        }
        this.label.removeMouseMotionListener(this);
        this.label.removeMouseListener(this);
        this.label.setIcon(null);
        this.panel.removeAncestorListener(this);
        this.panel.removeAll();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y1;
        int x1;
        PDRectangle cropBox = this.page.getCropBox();
        float height = cropBox.getHeight();
        float width = cropBox.getWidth();
        float offsetX = cropBox.getLowerLeftX();
        float offsetY = cropBox.getLowerLeftY();
        float zoomScale = this.zoomMenu.getPageZoomScale();
        float x = (float)e.getX() / zoomScale * (float)this.defaultTransform.getScaleX();
        float y = (float)e.getY() / zoomScale * (float)this.defaultTransform.getScaleY();
        switch ((RotationMenu.getRotationDegrees() + this.page.getRotation()) % 360) {
            case 90: {
                x1 = (int)(y + offsetX);
                y1 = (int)(x + offsetY);
                break;
            }
            case 180: {
                x1 = (int)(width - x + offsetX);
                y1 = (int)(y - offsetY);
                break;
            }
            case 270: {
                x1 = (int)(width - y + offsetX);
                y1 = (int)(height - x + offsetY);
                break;
            }
            default: {
                x1 = (int)(x + offsetX);
                y1 = (int)(height - y + offsetY);
            }
        }
        String text = "x: " + x1 + ", y: " + y1;
        Cursor cursor = Cursor.getDefaultCursor();
        this.currentURI = "";
        for (Map.Entry<PDRectangle, String> entry : this.rectMap.entrySet()) {
            if (!entry.getKey().contains(x1, y1)) continue;
            String s = this.rectMap.get(entry.getKey());
            text = text + ", " + s;
            if (!s.startsWith("URI: ")) break;
            this.currentURI = s.substring(5);
            cursor = Cursor.getPredefinedCursor(12);
            break;
        }
        this.panel.setCursor(cursor);
        this.statuslabel.setText(text);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.currentURI.isEmpty() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(this.currentURI));
            }
            catch (IOException | URISyntaxException ex) {
                new ErrorDialog(ex).setVisible(true);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.statuslabel.setText(this.labelText);
    }

    private final class RenderWorker
    extends SwingWorker<BufferedImage, Integer> {
        private RenderWorker() {
        }

        @Override
        protected BufferedImage doInBackground() throws IOException {
            float scale = ZoomMenu.getZoomScale();
            boolean showTextStripper = ViewMenu.isShowTextStripper();
            boolean showTextStripperBeads = ViewMenu.isShowTextStripperBeads();
            boolean showFontBBox = ViewMenu.isShowFontBBox();
            int rotation = RotationMenu.getRotationDegrees();
            PagePane.this.label.setIcon(null);
            PagePane.this.labelText = "Rendering...";
            PagePane.this.label.setText(PagePane.this.labelText);
            PagePane.this.statuslabel.setText(PagePane.this.labelText);
            PDFRenderer renderer = new PDFRenderer(PagePane.this.document);
            renderer.setSubsamplingAllowed(ViewMenu.isAllowSubsampling());
            long t0 = System.nanoTime();
            BufferedImage image = renderer.renderImage(PagePane.this.pageIndex, scale, ImageTypeMenu.getImageType(), RenderDestinationMenu.getRenderDestination());
            long t1 = System.nanoTime();
            float s = (float)TimeUnit.MILLISECONDS.convert(t1 - t0, TimeUnit.NANOSECONDS) / 1000.0f;
            PagePane.this.labelText = "Rendered in " + s + " second" + (s > 1.0f ? "s" : "");
            PagePane.this.statuslabel.setText(PagePane.this.labelText);
            DebugTextOverlay debugText = new DebugTextOverlay(PagePane.this.document, PagePane.this.pageIndex, scale, showTextStripper, showTextStripperBeads, showFontBBox, ViewMenu.isShowGlyphBounds());
            Graphics2D g = image.createGraphics();
            debugText.renderTo(g);
            g.dispose();
            return ImageUtil.getRotatedImage(image, rotation);
        }

        @Override
        protected void done() {
            try {
                BufferedImage image = (BufferedImage)this.get();
                PagePane.this.label.setSize((int)Math.ceil((double)image.getWidth() / PagePane.this.defaultTransform.getScaleX()), (int)Math.ceil((double)image.getHeight() / PagePane.this.defaultTransform.getScaleY()));
                PagePane.this.label.setIcon(new HighResolutionImageIcon(image, PagePane.this.label.getWidth(), PagePane.this.label.getHeight()));
                PagePane.this.label.setText(null);
            }
            catch (InterruptedException | ExecutionException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

