/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ComObjectValueType {
    BIT1(0, 1),
    BIT2(1, 1),
    BIT3(2, 1),
    BIT4(3, 1),
    BIT5(4, 1),
    BIT6(5, 1),
    BIT7(6, 1),
    BYTE1(7, 1),
    BYTE2(8, 2),
    BYTE3(9, 3),
    BYTE4(10, 4),
    BYTE6(11, 6),
    BYTE8(12, 8),
    BYTE10(13, 10),
    BYTE14(14, 14);

    private static final Map<Short, ComObjectValueType> map;
    private final short value;
    private final short sizeInBytes;

    static {
        map = new HashMap<Short, ComObjectValueType>();
        ComObjectValueType[] comObjectValueTypeArray = ComObjectValueType.values();
        int n = comObjectValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComObjectValueType value = comObjectValueTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private ComObjectValueType(short value, short sizeInBytes) {
        this.value = value;
        this.sizeInBytes = sizeInBytes;
    }

    public short getValue() {
        return this.value;
    }

    public short getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static ComObjectValueType firstEnumForFieldSizeInBytes(short fieldValue) {
        ComObjectValueType[] comObjectValueTypeArray = ComObjectValueType.values();
        int n = comObjectValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComObjectValueType _val = comObjectValueTypeArray[n2];
            if (_val.getSizeInBytes() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<ComObjectValueType> enumsForFieldSizeInBytes(short fieldValue) {
        ArrayList<ComObjectValueType> _values = new ArrayList<ComObjectValueType>();
        ComObjectValueType[] comObjectValueTypeArray = ComObjectValueType.values();
        int n = comObjectValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComObjectValueType _val = comObjectValueTypeArray[n2];
            if (_val.getSizeInBytes() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static ComObjectValueType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

