/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum KnxMedium {
    MEDIUM_RESERVED_1(1),
    MEDIUM_TP1(2),
    MEDIUM_PL110(4),
    MEDIUM_RESERVED_2(8),
    MEDIUM_RF(16),
    MEDIUM_KNX_IP(32);

    private static final Map<Short, KnxMedium> map;
    private final short value;

    static {
        map = new HashMap<Short, KnxMedium>();
        KnxMedium[] knxMediumArray = KnxMedium.values();
        int n = knxMediumArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxMedium value = knxMediumArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private KnxMedium(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static KnxMedium enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

