/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.admin.internal.http.AsyncHttpRequestExecutor;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.WithSNISslEngineFactory;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.shade.com.spotify.futures.ConcurrencyReducer;
import org.apache.pulsar.shade.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.javax.ws.rs.ProcessingException;
import org.apache.pulsar.shade.javax.ws.rs.client.Client;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.Validate;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncCompletionHandlerBase;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.BoundRequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.ListenableFuture;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.Response;
import org.apache.pulsar.shade.org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.apache.pulsar.shade.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import org.apache.pulsar.shade.org.asynchttpclient.uri.Uri;
import org.apache.pulsar.shade.org.asynchttpclient.util.HttpConstants;
import org.apache.pulsar.shade.org.asynchttpclient.util.MiscUtils;
import org.apache.pulsar.shade.org.glassfish.jersey.client.ClientRequest;
import org.apache.pulsar.shade.org.glassfish.jersey.client.ClientResponse;
import org.apache.pulsar.shade.org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.apache.pulsar.shade.org.glassfish.jersey.client.spi.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpConnector
implements Connector,
AsyncHttpRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpConnector.class);
    private static final TimeoutException REQUEST_TIMEOUT_EXCEPTION = FutureUtil.createTimeoutException("Request timeout", AsyncHttpConnector.class, "retryOrTimeout(...)");
    private static final int DEFAULT_MAX_QUEUE_SIZE_PER_HOST = 10000;
    private final AsyncHttpClient httpClient;
    private final Duration requestTimeout;
    private final int maxRetries;
    private final ServiceNameResolver serviceNameResolver;
    private final ScheduledExecutorService delayer = Executors.newScheduledThreadPool(1, new DefaultThreadFactory("delayer"));
    private final boolean acceptGzipCompression;
    private final Map<String, ConcurrencyReducer<Response>> concurrencyReducers = new ConcurrentHashMap<String, ConcurrencyReducer<Response>>();

    public AsyncHttpConnector(Client client, ClientConfigurationData conf, int autoCertRefreshTimeSeconds, boolean acceptGzipCompression) {
        this((Integer)client.getConfiguration().getProperty("org.apache.pulsar.shade.jersey.config.client.connectTimeout"), (Integer)client.getConfiguration().getProperty("org.apache.pulsar.shade.jersey.config.client.readTimeout"), 300000, autoCertRefreshTimeSeconds, conf, acceptGzipCompression);
    }

    public AsyncHttpConnector(int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs, int autoCertRefreshTimeSeconds, ClientConfigurationData conf, boolean acceptGzipCompression) {
        Validate.notEmpty(conf.getServiceUrl(), "Service URL is not provided", new Object[0]);
        this.serviceNameResolver = new PulsarServiceNameResolver();
        String serviceUrl = conf.getServiceUrl();
        this.serviceNameResolver.updateServiceUrl(serviceUrl);
        this.acceptGzipCompression = acceptGzipCompression;
        AsyncHttpClientConfig asyncHttpClientConfig = this.createAsyncHttpClientConfig(conf, connectTimeoutMs, readTimeoutMs, requestTimeoutMs, autoCertRefreshTimeSeconds);
        this.httpClient = this.createAsyncHttpClient(asyncHttpClientConfig);
        this.requestTimeout = requestTimeoutMs > 0 ? Duration.ofMillis(requestTimeoutMs) : null;
        this.maxRetries = this.httpClient.getConfig().getMaxRequestRetry();
    }

    private AsyncHttpClientConfig createAsyncHttpClientConfig(ClientConfigurationData conf, int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs, int autoCertRefreshTimeSeconds) throws GeneralSecurityException, IOException {
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        this.configureAsyncHttpClientConfig(conf, connectTimeoutMs, readTimeoutMs, requestTimeoutMs, confBuilder);
        if (conf.getServiceUrl().startsWith("https://")) {
            this.configureAsyncHttpClientSslEngineFactory(conf, autoCertRefreshTimeSeconds, confBuilder);
        }
        DefaultAsyncHttpClientConfig asyncHttpClientConfig = confBuilder.build();
        return asyncHttpClientConfig;
    }

    private void configureAsyncHttpClientConfig(ClientConfigurationData conf, int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs, DefaultAsyncHttpClientConfig.Builder confBuilder) {
        if (conf.getConnectionsPerBroker() > 0) {
            confBuilder.setMaxConnectionsPerHost(conf.getConnectionsPerBroker());
            confBuilder.setAcquireFreeChannelTimeout(conf.getRequestTimeoutMs());
        }
        if (conf.getConnectionMaxIdleSeconds() > 0) {
            confBuilder.setPooledConnectionIdleTimeout(conf.getConnectionMaxIdleSeconds() * 1000);
        }
        confBuilder.setUseProxyProperties(true);
        confBuilder.setFollowRedirect(false);
        confBuilder.setRequestTimeout(conf.getRequestTimeoutMs());
        confBuilder.setConnectTimeout(connectTimeoutMs);
        confBuilder.setReadTimeout(readTimeoutMs);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setRequestTimeout(requestTimeoutMs);
        confBuilder.setIoThreadsCount(conf.getNumIoThreads());
        confBuilder.setKeepAliveStrategy(new DefaultKeepAliveStrategy(){

            @Override
            public boolean keepAlive(InetSocketAddress remoteAddress, Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(remoteAddress, ahcRequest, request, response);
            }
        });
        confBuilder.setDisableHttpsEndpointIdentificationAlgorithm(!conf.isTlsHostnameVerificationEnable());
    }

    protected AsyncHttpClient createAsyncHttpClient(AsyncHttpClientConfig asyncHttpClientConfig) {
        return new DefaultAsyncHttpClient(asyncHttpClientConfig);
    }

    private void configureAsyncHttpClientSslEngineFactory(ClientConfigurationData conf, int autoCertRefreshTimeSeconds, DefaultAsyncHttpClientConfig.Builder confBuilder) throws GeneralSecurityException, IOException {
        AuthenticationDataProvider authData = conf.getAuthentication().getAuthData();
        JsseSslEngineFactory sslEngineFactory = null;
        if (conf.isUseKeyStoreTls()) {
            KeyStoreParams params = authData.hasDataForTls() ? authData.getTlsKeyStoreParams() : new KeyStoreParams(conf.getTlsKeyStoreType(), conf.getTlsKeyStorePath(), conf.getTlsKeyStorePassword());
            SSLContext sslCtx = KeyStoreSSLContext.createClientSslContext(conf.getSslProvider(), params.getKeyStoreType(), params.getKeyStorePath(), params.getKeyStorePassword(), conf.isTlsAllowInsecureConnection(), conf.getTlsTrustStoreType(), conf.getTlsTrustStorePath(), conf.getTlsTrustStorePassword(), conf.getTlsCiphers(), conf.getTlsProtocols());
            sslEngineFactory = new JsseSslEngineFactory(sslCtx);
            confBuilder.setSslEngineFactory(sslEngineFactory);
        } else {
            SslProvider sslProvider = null;
            if (conf.getSslProvider() != null) {
                sslProvider = SslProvider.valueOf(conf.getSslProvider());
            }
            SslContext sslCtx = null;
            sslCtx = authData.hasDataForTls() ? (authData.getTlsTrustStoreStream() == null ? SecurityUtility.createAutoRefreshSslContextForClient(sslProvider, conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath(), authData.getTlsCertificateFilePath(), authData.getTlsPrivateKeyFilePath(), null, autoCertRefreshTimeSeconds, this.delayer) : SecurityUtility.createNettySslContextForClient(sslProvider, conf.isTlsAllowInsecureConnection(), authData.getTlsTrustStoreStream(), authData.getTlsCertificates(), authData.getTlsPrivateKey(), conf.getTlsCiphers(), conf.getTlsProtocols())) : SecurityUtility.createNettySslContextForClient(sslProvider, conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath(), conf.getTlsCertificateFilePath(), conf.getTlsKeyFilePath(), conf.getTlsCiphers(), conf.getTlsProtocols());
            confBuilder.setSslContext(sslCtx);
            if (!conf.isTlsHostnameVerificationEnable()) {
                confBuilder.setSslEngineFactory(new WithSNISslEngineFactory(this.serviceNameResolver.resolveHostUri().getHost()));
            }
        }
    }

    @Override
    public ClientResponse apply(ClientRequest jerseyRequest) {
        final CompletableFuture future = new CompletableFuture();
        this.apply(jerseyRequest, new AsyncConnectorCallback(){

            @Override
            public void response(ClientResponse response) {
                future.complete(response);
            }

            @Override
            public void failure(Throwable failure) {
                future.completeExceptionally(failure);
            }
        });
        try {
            return (ClientResponse)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ProcessingException(e.getCause());
        }
    }

    private URI replaceWithNew(InetSocketAddress address, URI uri) {
        String originalUri = uri.toString();
        String newUri = originalUri.split(":")[0] + "://" + address.getHostString() + ":" + address.getPort() + uri.getRawPath();
        if (uri.getRawQuery() != null) {
            newUri = newUri + "?" + uri.getRawQuery();
        }
        return URI.create(newUri);
    }

    @Override
    public Future<?> apply(ClientRequest jerseyRequest, AsyncConnectorCallback callback) {
        CompletableFuture<Response> responseFuture = this.retryOrTimeOut(jerseyRequest);
        responseFuture.whenComplete((response, throwable) -> {
            if (throwable != null) {
                callback.failure((Throwable)throwable);
            } else {
                ClientResponse jerseyResponse = new ClientResponse(Response.Status.fromStatusCode(response.getStatusCode()), jerseyRequest);
                jerseyResponse.setStatusInfo(new Response.StatusType(){
                    final /* synthetic */ Response val$response;
                    {
                        this.val$response = response;
                    }

                    @Override
                    public int getStatusCode() {
                        return this.val$response.getStatusCode();
                    }

                    @Override
                    public Response.Status.Family getFamily() {
                        return Response.Status.Family.familyOf(this.val$response.getStatusCode());
                    }

                    @Override
                    public String getReasonPhrase() {
                        if (this.val$response.hasResponseBody()) {
                            return this.val$response.getResponseBody();
                        }
                        return this.val$response.getStatusText();
                    }
                });
                response.getHeaders().forEach(e -> jerseyResponse.header((String)e.getKey(), e.getValue()));
                if (response.hasResponseBody()) {
                    jerseyResponse.setEntityStream(response.getResponseBodyAsStream());
                }
                callback.response(jerseyResponse);
            }
        });
        return responseFuture;
    }

    private CompletableFuture<Response> retryOrTimeOut(ClientRequest request) {
        CompletableFuture<Response> resultFuture = new CompletableFuture<Response>();
        this.retryOperation(resultFuture, () -> this.oneShot(this.serviceNameResolver.resolveHost(), request), this.maxRetries);
        if (this.requestTimeout != null) {
            FutureUtil.addTimeoutHandling(resultFuture, this.requestTimeout, this.delayer, () -> REQUEST_TIMEOUT_EXCEPTION);
        }
        return resultFuture;
    }

    private <T> void retryOperation(CompletableFuture<T> resultFuture, Supplier<CompletableFuture<T>> operation, int retries) {
        if (!resultFuture.isDone()) {
            CompletableFuture operationFuture = operation.get();
            operationFuture.whenComplete((t, throwable) -> {
                if (throwable != null) {
                    if ((throwable = FutureUtil.unwrapCompletionException(throwable)) instanceof CancellationException) {
                        resultFuture.completeExceptionally(new RetryException("Operation future was cancelled.", (Throwable)throwable));
                    } else if (throwable instanceof MaxRedirectException) {
                        resultFuture.completeExceptionally((Throwable)throwable);
                    } else if (retries > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("Retrying operation. Remaining retries: {}", (Object)retries);
                        }
                        this.retryOperation(resultFuture, operation, retries - 1);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Number of retries has been exhausted. Failing the operation.", throwable);
                        }
                        resultFuture.completeExceptionally(new RetryException("Could not complete the operation. Number of retries has been exhausted. Failed reason: " + throwable.getMessage(), (Throwable)throwable));
                    }
                } else {
                    resultFuture.complete(t);
                }
            });
            resultFuture.whenComplete((t, throwable) -> operationFuture.cancel(false));
        }
    }

    protected CompletableFuture<Response> oneShot(InetSocketAddress host, ClientRequest request) {
        Request preparedRequest;
        try {
            preparedRequest = this.prepareRequest(host, request);
        }
        catch (IOException e) {
            return FutureUtil.failedFuture(e);
        }
        return this.executeRequest(preparedRequest);
    }

    @Override
    public CompletableFuture<Response> executeRequest(Request request) {
        return this.executeRequest(request, () -> new AsyncCompletionHandlerBase());
    }

    @Override
    public CompletableFuture<Response> executeRequest(Request request, Supplier<AsyncHandler<Response>> handlerSupplier) {
        return this.executeRequest(request, handlerSupplier, 0);
    }

    private CompletableFuture<Response> executeRequest(Request request, Supplier<AsyncHandler<Response>> handlerSupplier, int redirectCount) {
        CompletableFuture<Response> responseFuture;
        int maxRedirects = this.httpClient.getConfig().getMaxRedirects();
        if (redirectCount > maxRedirects) {
            return FutureUtil.failedFuture(new MaxRedirectException("Maximum redirect reached: " + maxRedirects + " uri:" + request.getUri()));
        }
        if (this.httpClient.getConfig().getMaxConnectionsPerHost() > 0) {
            String hostAndPort = request.getUri().getHost() + ":" + request.getUri().getPort();
            ConcurrencyReducer responseConcurrencyReducer = this.concurrencyReducers.computeIfAbsent(hostAndPort, h -> ConcurrencyReducer.create(this.httpClient.getConfig().getMaxConnectionsPerHost(), 10000));
            responseFuture = responseConcurrencyReducer.add(() -> this.doExecuteRequest(request, handlerSupplier));
        } else {
            responseFuture = this.doExecuteRequest(request, handlerSupplier);
        }
        CompletionStage futureWithRedirect = responseFuture.thenCompose(response -> {
            if (AsyncHttpConnector.isRedirectStatusCode(response.getStatusCode())) {
                return this.executeRedirect(request, (Response)response, handlerSupplier, redirectCount);
            }
            return CompletableFuture.completedFuture(response);
        });
        ((CompletableFuture)futureWithRedirect).whenComplete((response, throwable) -> responseFuture.cancel(false));
        return futureWithRedirect;
    }

    private CompletableFuture<Response> executeRedirect(Request request, Response response, Supplier<AsyncHandler<Response>> handlerSupplier, int redirectCount) {
        String originalMethod = request.getMethod();
        int statusCode = response.getStatusCode();
        boolean switchToGet = !originalMethod.equals(HttpConstants.Methods.GET) && !originalMethod.equals(HttpConstants.Methods.OPTIONS) && !originalMethod.equals(HttpConstants.Methods.HEAD) && (statusCode == HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301 || statusCode == HttpConstants.ResponseStatusCodes.SEE_OTHER_303 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302);
        boolean keepBody = statusCode == HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307 || statusCode == HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308;
        String location = response.getHeader("Location");
        Uri newUri = Uri.create(request.getUri(), location);
        BoundRequestBuilder builder = this.httpClient.prepareRequest(request);
        if (switchToGet) {
            builder.setMethod(HttpConstants.Methods.GET);
        }
        builder.setUri(newUri);
        if (keepBody) {
            builder.setCharset(request.getCharset());
            if (MiscUtils.isNonEmpty(request.getFormParams())) {
                builder.setFormParams(request.getFormParams());
            } else if (request.getStringData() != null) {
                builder.setBody(request.getStringData());
            } else if (request.getByteData() != null) {
                builder.setBody(request.getByteData());
            } else if (request.getByteBufferData() != null) {
                builder.setBody(request.getByteBufferData());
            } else if (request.getBodyGenerator() != null) {
                builder.setBody(request.getBodyGenerator());
            } else if (MiscUtils.isNonEmpty(request.getBodyParts())) {
                builder.setBodyParts(request.getBodyParts());
            }
        } else {
            builder.resetFormParams();
            builder.resetNonMultipartData();
            builder.resetMultipartData();
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            ((HttpHeaders)headers).add(request.getHeaders());
            ((HttpHeaders)headers).remove("Content-Length");
            ((HttpHeaders)headers).remove("Content-Type");
            ((HttpHeaders)headers).remove("Content-Encoding");
            builder.setHeaders(headers);
        }
        return this.executeRequest(builder.build(), handlerSupplier, redirectCount + 1);
    }

    private static boolean isRedirectStatusCode(int statusCode) {
        return statusCode == HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302 || statusCode == HttpConstants.ResponseStatusCodes.SEE_OTHER_303 || statusCode == HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307 || statusCode == HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308;
    }

    private CompletableFuture<Response> doExecuteRequest(Request request, Supplier<AsyncHandler<Response>> handlerSupplier) {
        ListenableFuture<Response> responseFuture = this.httpClient.executeRequest(request, handlerSupplier.get());
        CompletableFuture<Response> completableFuture = responseFuture.toCompletableFuture();
        completableFuture.whenComplete((response, throwable) -> {
            if ((throwable = FutureUtil.unwrapCompletionException(throwable)) != null && (throwable instanceof CancellationException || throwable instanceof TimeoutException)) {
                responseFuture.abort((Throwable)throwable);
            }
        });
        return completableFuture;
    }

    private Request prepareRequest(InetSocketAddress host, ClientRequest request) throws IOException {
        ClientRequest currentRequest = new ClientRequest(request);
        URI newUri = this.replaceWithNew(host, currentRequest.getUri());
        currentRequest.setUri(newUri);
        BoundRequestBuilder builder = this.httpClient.prepare(currentRequest.getMethod(), currentRequest.getUri().toString());
        if (currentRequest.hasEntity()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            currentRequest.setStreamProvider(contentLength -> outStream);
            currentRequest.writeEntity();
            builder.setBody(outStream.toByteArray());
        }
        currentRequest.getHeaders().forEach((key, headers) -> {
            if (!"User-Agent".equals(key)) {
                builder.addHeader((CharSequence)key, (Iterable<?>)headers);
            }
        });
        if (this.acceptGzipCompression) {
            builder.setHeader((CharSequence)"Accept-Encoding", "gzip");
        }
        return builder.build();
    }

    @Override
    public String getName() {
        return "Pulsar-Admin";
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
            this.delayer.shutdownNow();
        }
        catch (IOException e) {
            log.warn("Failed to close http client", (Throwable)e);
        }
    }

    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public static class MaxRedirectException
    extends Exception {
        public MaxRedirectException(String msg) {
            super(msg, null, true, false);
        }
    }

    public static class RetryException
    extends Exception {
        public RetryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

