/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Flatten$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(arrayOfArrays) - Transforms an array of arrays into a single array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(array(1, 2), array(3, 4)));\n       [1,2,3,4]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u000f\u001f\u0001.B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0012)A\u0005w!)q\b\u0001C\u0001\u0001\")1\t\u0001C\u0005\t\")1\n\u0001C!\u0019\"A\u0001\u000b\u0001EC\u0002\u0013\u0005\u0013\u000b\u0003\u0005Z\u0001!\u0015\r\u0011\"\u0003R\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015A\b\u0001\"\u0003z\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\t\u0001\t\u0003\n)\u0003C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u0011Q\u0006\u0001\u0012\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000fB\u0011\"a\u0016\u0001\u0003\u0003%\t!!\u0017\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0011\u0002\u0002\u001eI\u0011q\u0014\u0010\u0002\u0002#\u0005\u0011\u0011\u0015\u0004\t;y\t\t\u0011#\u0001\u0002$\"1qh\u0006C\u0001\u0003cC\u0011\"a-\u0018\u0003\u0003%)%!.\t\u0013\u0005]v#!A\u0005\u0002\u0006e\u0006\"CA_/\u0005\u0005I\u0011QA`\u0011%\tYmFA\u0001\n\u0013\tiMA\u0004GY\u0006$H/\u001a8\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0012\u0002\u0011\r\fG/\u00197zgRT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u00171mA\u0011QFL\u0007\u0002=%\u0011qF\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t9\u0001K]8ek\u000e$\bCA\u00198\u0013\tA$G\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001<!\tiC(\u0003\u0002>=\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011I\u0011\t\u0003[\u0001AQ!O\u0002A\u0002m\nQb\u00195jY\u0012$\u0015\r^1UsB,W#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!\u0013\u0013!\u0002;za\u0016\u001c\u0018B\u0001&H\u0005%\t%O]1z)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005i\u0005CA\u0019O\u0013\ty%GA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0015\t\u0003\rNK!\u0001V$\u0003\u0011\u0011\u000bG/\u0019+za\u0016D#A\u0002,\u0011\u0005E:\u0016B\u0001-3\u0005%!(/\u00198tS\u0016tG/A\u0006fY\u0016lWM\u001c;UsB,\u0007FA\u0004W\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011!\u0003!\tg.\u00197zg&\u001c\u0018B\u00012`\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCA3i!\t\td-\u0003\u0002he\t\u0019\u0011I\\=\t\u000beJ\u0001\u0019A3\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA6rmB\u0011An\\\u0007\u0002[*\u0011aNH\u0001\bG>$WmZ3o\u0013\t\u0001XN\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015\u0011(\u00021\u0001t\u0003\r\u0019G\u000f\u001f\t\u0003YRL!!^7\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")qO\u0003a\u0001W\u0006\u0011QM^\u0001\u001bO\u0016t7i\u001c3f\r>\u0014h*^7cKJ|e-\u00127f[\u0016tGo\u001d\u000b\u0006u\u0006E\u00111\u0003\t\u0005cmlX0\u0003\u0002}e\t1A+\u001e9mKJ\u00022A`A\u0006\u001d\ry\u0018q\u0001\t\u0004\u0003\u0003\u0011TBAA\u0002\u0015\r\t)AK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%!'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013\u0011\u0004\"\u0002:\f\u0001\u0004\u0019\bBBA\u000b\u0017\u0001\u0007Q0A\tdQ&dGMV1sS\u0006\u0014G.\u001a(b[\u0016\f\u0011cZ3o\u0007>$WMR8s\r2\fG\u000f^3o)\u001di\u00181DA\u000f\u0003?AQA\u001d\u0007A\u0002MDa!!\u0006\r\u0001\u0004i\bBBA\u0011\u0019\u0001\u0007Q0A\u0007beJ\f\u0017\u0010R1uC:\u000bW.Z\u0001\u000baJ,G\u000f^=OC6,W#A?\u0002\t\r|\u0007/\u001f\u000b\u0004\u0003\u0006-\u0002bB\u001d\u000f!\u0003\u0005\raO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tDK\u0002<\u0003gY#!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f\u0011\u0014AC1o]>$\u0018\r^5p]&!\u00111IA\u001d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0003\u0003BA&\u0003+j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0005Y\u0006twM\u0003\u0002\u0002T\u0005!!.\u0019<b\u0013\u0011\ti!!\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0003cA\u0019\u0002^%\u0019\u0011q\f\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\u0015\f)\u0007C\u0005\u0002hI\t\t\u00111\u0001\u0002\\\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001c\u0011\u000b\u0005=\u0014QO3\u000e\u0005\u0005E$bAA:e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0014\u0011\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002N\u0003{B\u0001\"a\u001a\u0015\u0003\u0003\u0005\r!Z\u0001\u0007KF,\u0018\r\\:\u0015\u00075\u000b\u0019\t\u0003\u0005\u0002hU\t\t\u00111\u0001fQ=\u0001\u0011qQAG\u0003\u001f\u000b\u0019*!&\u0002\u001a\u0006m\u0005cA\u0017\u0002\n&\u0019\u00111\u0012\u0010\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011S\u0001K?\u001a+fjQ0)CJ\u0014\u0018-_(g\u0003J\u0014\u0018-_:*A5\u0002CK]1og\u001a|'/\\:!C:\u0004\u0013M\u001d:bs\u0002zg\rI1se\u0006L8\u000fI5oi>\u0004\u0013\rI:j]\u001edW\rI1se\u0006Lh&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9*\u0001.\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0014\u0006\f\u0011beJ\f\u0017\u0010K\u001a-AQJ\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Fb#\u0007L\u001a-iuS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003;\u000bQA\r\u00185]A\nqA\u00127biR,g\u000e\u0005\u0002./M!q#!*7!\u0019\t9+!,<\u00036\u0011\u0011\u0011\u0016\u0006\u0004\u0003W\u0013\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003_\u000bIKA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u0005\u000bY\fC\u0003:5\u0001\u00071(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0017q\u0019\t\u0005c\u0005\r7(C\u0002\u0002FJ\u0012aa\u00149uS>t\u0007\u0002CAe7\u0005\u0005\t\u0019A!\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAh!\u0011\tY%!5\n\t\u0005M\u0017Q\n\u0002\u0007\u001f\nTWm\u0019;")
public class Flatten
extends UnaryExpression
implements scala.Serializable {
    private transient DataType dataType;
    private transient DataType elementType;
    private final Expression child;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(Flatten flatten) {
        return Flatten$.MODULE$.unapply(flatten);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Flatten, A> function1) {
        return Flatten$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Flatten> compose(Function1<A, Expression> function1) {
        return Flatten$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private ArrayType childDataType() {
        return (ArrayType)this.child().dataType();
    }

    @Override
    public boolean nullable() {
        return this.child().nullable() || this.childDataType().containsNull();
    }

    private DataType dataType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.childDataType().elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    private DataType elementType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType = this.child().dataType();
        TypeCheckResult typeCheckResult = dataType instanceof ArrayType && (arrayType = (ArrayType)dataType).elementType() instanceof ArrayType ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(43).append("The argument should be an array of arrays, ").append(new StringBuilder(19).append("but '").append(this.child().sql()).append("' is of ").append(this.child().dataType().catalogString()).append(" type.").toString()).toString());
        return typeCheckResult;
    }

    @Override
    public Object nullSafeEval(Object child) {
        GenericArrayData genericArrayData;
        Object[] elements = ((ArrayData)child).toObjectArray(this.dataType());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).contains(null)) {
            genericArrayData = null;
        } else {
            ArrayData[] arrayData = (ArrayData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).map((Function1 & Serializable & scala.Serializable)x$59 -> (ArrayData)x$59, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayData.class)));
            long numberOfElements = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(sum, e) -> BoxesRunTime.boxToLong((long)Flatten.$anonfun$nullSafeEval$6(BoxesRunTime.unboxToLong((Object)sum), e))));
            if (numberOfElements > (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                throw new RuntimeException(new StringBuilder(53).append("Unsuccessful try to flatten an array of arrays with ").append(new StringBuilder(48).append(numberOfElements).append(" elements due to exceeding the array size limit ").toString()).append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(".").toString());
            }
            Object[] flattenedData = (Object[])ClassTag$.MODULE$.Nothing().newArray((int)numberOfElements);
            IntRef position = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foreach((Function1 & Serializable & scala.Serializable)ad -> {
                Flatten.$anonfun$nullSafeEval$7(this, flattenedData, position, ad);
                return BoxedUnit.UNIT;
            });
            genericArrayData = new GenericArrayData((Object)flattenedData);
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String code = this.genCodeForFlatten(ctx, (String)c, ExprValue$.MODULE$.exprValueToString(ev.value()));
            return ctx.nullArrayElementsSaveExec(this.childDataType().containsNull(), ExprValue$.MODULE$.exprValueToString(ev.isNull()), (String)c, code);
        });
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String childVariableName) {
        String variableName = ctx.freshName("numElements");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n      |long ").append(variableName).append(" = 0;\n      |for (int z = 0; z < ").append(childVariableName).append(".numElements(); z++) {\n      |  ").append(variableName).append(" += ").append(childVariableName).append(".getArray(z).numElements();\n      |}\n      ").toString())).stripMargin();
        return new Tuple2((Object)code, (Object)variableName);
    }

    private String genCodeForFlatten(CodegenContext ctx, String childVariableName, String arrayDataName) {
        String counter = ctx.freshName("counter");
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        String l = ctx.freshName("l");
        String arr = ctx.freshName("arr");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, childVariableName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        Tuple2 tuple23 = tuple22;
        String numElemCode2 = (String)tuple23._1();
        String numElemName2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, this.elementType(), numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(tempArrayDataName, this.elementType(), arr, counter, l, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n    |").append(numElemCode2).append("\n    |").append(allocation).append("\n    |int ").append(counter).append(" = 0;\n    |for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(childVariableName).append(".numElements(); ").append(k).append("++) {\n    |  ArrayData ").append(arr).append(" = ").append(childVariableName).append(".getArray(").append(k).append(");\n    |  for (int ").append(l).append(" = 0; ").append(l).append(" < ").append(arr).append(".numElements(); ").append(l).append("++) {\n    |   ").append(assignment).append("\n    |   ").append(counter).append("++;\n    | }\n    |}\n    |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n    ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "flatten";
    }

    public Flatten copy(Expression child) {
        return new Flatten(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Flatten";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Flatten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Flatten)) return false;
        boolean bl = true;
        if (!bl) return false;
        Flatten flatten = (Flatten)x$1;
        Expression expression = this.child();
        Expression expression2 = flatten.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!flatten.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$nullSafeEval$6(long sum, ArrayData e) {
        return sum + (long)e.numElements();
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$7(Flatten $this, Object[] flattenedData$1, IntRef position$3, ArrayData ad) {
        Object[] arr = ad.toObjectArray($this.elementType());
        Array$.MODULE$.copy((Object)arr, 0, (Object)flattenedData$1, position$3.elem, arr.length);
        position$3.elem += arr.length;
    }

    public Flatten(Expression child) {
        this.child = child;
    }
}

