/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Minute$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp) - Returns the minute component of the string/timestamp.", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 12:58:59');\n       58\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0010 \u00012B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005W\u0001\tE\t\u0015!\u0003I\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001]\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015!\b\u0001\"\u0011v\u0011\u00159\b\u0001\"\u0015y\u0011\u0015q\b\u0001\"\u0011\u0000\u0011%\tY\u0002AA\u0001\n\u0003\ti\u0002C\u0005\u0002$\u0001\t\n\u0011\"\u0001\u0002&!I\u00111\b\u0001\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u0003\u0002\u0011\u0011!C!\u0003\u0007B\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA3\u0001\u0005\u0005I\u0011IA4\u0011%\t)\bAA\u0001\n\u0003\t9\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\u001eI\u0011\u0011U\u0010\u0002\u0002#\u0005\u00111\u0015\u0004\t=}\t\t\u0011#\u0001\u0002&\"1qK\u0006C\u0001\u0003gC\u0011\"!.\u0017\u0003\u0003%)%a.\t\u0013\u0005ef#!A\u0005\u0002\u0006m\u0006\"CAa-E\u0005I\u0011AA\u001f\u0011%\t\u0019MFA\u0001\n\u0003\u000b)\rC\u0005\u0002TZ\t\n\u0011\"\u0001\u0002>!I\u0011Q\u001b\f\u0002\u0002\u0013%\u0011q\u001b\u0002\u0007\u001b&tW\u000f^3\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00172i]j\u0004C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00183\u0013\t\u0019tDA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011a&N\u0005\u0003m}\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\b!J|G-^2u!\tAd(\u0003\u0002@s\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t!\t\u0005\u0002/\u0007&\u0011Ai\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012\u0001\u0013\t\u0004q%[\u0015B\u0001&:\u0005\u0019y\u0005\u000f^5p]B\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u001d\u000e\u0003=S!\u0001U\u0016\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0016(\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*:\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?)\rI&l\u0017\t\u0003]\u0001AQ\u0001Q\u0003A\u0002\tCqAR\u0003\u0011\u0002\u0003\u0007\u0001\n\u0006\u0002Z;\")\u0001I\u0002a\u0001\u0005\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u0001\u00042!\u00194j\u001d\t\u0011GM\u0004\u0002OG&\t!(\u0003\u0002fs\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\r\u0019V-\u001d\u0006\u0003Kf\u0002\"A[7\u000e\u0003-T!\u0001\\\u0012\u0002\u000bQL\b/Z:\n\u00059\\'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A9\u0011\u0005)\u0014\u0018BA:l\u0005!!\u0015\r^1UsB,\u0017\u0001D<ji\"$\u0016.\\3[_:,GCA\u0019w\u0011\u00151\u0015\u00021\u0001L\u00031qW\u000f\u001c7TC\u001a,WI^1m)\tIH\u0010\u0005\u00029u&\u001110\u000f\u0002\u0004\u0003:L\b\"B?\u000b\u0001\u0004I\u0018!\u0003;j[\u0016\u001cH/Y7q\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0002\u00055\u0011q\u0003\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA\u0010\u0002\u000f\r|G-Z4f]&!\u00111BA\u0003\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\b\u0017\u0001\u0007\u0011\u0011C\u0001\u0004GRD\b\u0003BA\u0002\u0003'IA!!\u0006\u0002\u0006\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\r\u0017\u0001\u0007\u0011\u0011A\u0001\u0003KZ\fAaY8qsR)\u0011,a\b\u0002\"!9\u0001\t\u0004I\u0001\u0002\u0004\u0011\u0005b\u0002$\r!\u0003\u0005\r\u0001S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9CK\u0002C\u0003SY#!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003kI\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011HA\u0018\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyDK\u0002I\u0003S\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nA\u0001\\1oO*\u0011\u0011qJ\u0001\u0005U\u00064\u0018-C\u0002U\u0003\u0013\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0016\u0011\u0007a\nI&C\u0002\u0002\\e\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!_A1\u0011%\t\u0019'EA\u0001\u0002\u0004\t9&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0002R!a\u001b\u0002rel!!!\u001c\u000b\u0007\u0005=\u0014(\u0001\u0006d_2dWm\u0019;j_:LA!a\u001d\u0002n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI(a \u0011\u0007a\nY(C\u0002\u0002~e\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002dM\t\t\u00111\u0001z\u0003\u0019)\u0017/^1mgR!\u0011\u0011PAC\u0011!\t\u0019\u0007FA\u0001\u0002\u0004I\bf\u0004\u0001\u0002\n\u0006=\u0015\u0011SAK\u0003/\u000bY*!(\u0011\u00079\nY)C\u0002\u0002\u000e~\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0014\u0006IuLR+O\u0007~CC/[7fgR\fW\u000e]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3![&tW\u000f^3!G>l\u0007o\u001c8f]R\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001e|C/[7fgR\fW\u000e\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!'\u0002\u0013*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002t'L\u001a1AE\u0012$(\u000e\u001d;ke:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116q)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002 \u0006)\u0011GL\u001b/a\u00051Q*\u001b8vi\u0016\u0004\"A\f\f\u0014\tY\t9+\u0010\t\b\u0003S\u000byK\u0011%Z\u001b\t\tYKC\u0002\u0002.f\nqA];oi&lW-\u0003\u0003\u00022\u0006-&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u00111U\u0001\ti>\u001cFO]5oOR\u0011\u0011QI\u0001\u0006CB\u0004H.\u001f\u000b\u00063\u0006u\u0016q\u0018\u0005\u0006\u0001f\u0001\rA\u0011\u0005\b\rf\u0001\n\u00111\u0001I\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u000f\fy\r\u0005\u00039\u0013\u0006%\u0007#\u0002\u001d\u0002L\nC\u0015bAAgs\t1A+\u001e9mKJB\u0001\"!5\u001c\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GCAAm!\u0011\t9%a7\n\t\u0005u\u0017\u0011\n\u0002\u0007\u001f\nTWm\u0019;")
public class Minute
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$2() {
        return Minute$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<String>>> unapply(Minute minute) {
        return Minute$.MODULE$.unapply(minute);
    }

    public static Option<String> apply$default$2() {
        return Minute$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<String>>, Minute> tupled() {
        return Minute$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, Minute>> curried() {
        return Minute$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        Minute minute = this;
        synchronized (minute) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        Minute minute = this;
        synchronized (minute) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(BoxesRunTime.unboxToLong((Object)timestamp), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(15).append(dtu).append(".getMinutes(").append((String)c).append(", ").append(tz).append(")").toString());
    }

    public Minute copy(Expression child, Option<String> timeZoneId) {
        return new Minute(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Minute";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.child();
                break;
            }
            case 1: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Minute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Minute)) return false;
        boolean bl = true;
        if (!bl) return false;
        Minute minute = (Minute)x$1;
        Expression expression = this.child();
        Expression expression2 = minute.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = minute.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!minute.canEqual(this)) return false;
        return true;
    }

    public Minute(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public Minute(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

