/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple9;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 13, 1, 10, 11, 12, 'PST');\n       NULL\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\t]h\u0001\u0002\u001f>\u0001*C\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tU\u0002\u0011\t\u0012)A\u0005O\"A1\u000e\u0001BK\u0002\u0013\u0005a\r\u0003\u0005m\u0001\tE\t\u0015!\u0003h\u0011!i\u0007A!f\u0001\n\u00031\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B4\t\u0011=\u0004!Q3A\u0005\u0002\u0019D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001a\u0005\tc\u0002\u0011)\u001a!C\u0001M\"A!\u000f\u0001B\tB\u0003%q\r\u0003\u0005t\u0001\tU\r\u0011\"\u0001g\u0011!!\bA!E!\u0002\u00139\u0007\u0002C;\u0001\u0005+\u0007I\u0011\u0001<\t\u0011i\u0004!\u0011#Q\u0001\n]D\u0001b\u001f\u0001\u0003\u0016\u0004%\t\u0001 \u0005\n\u0003'\u0001!\u0011#Q\u0001\nuD!\"!\u0006\u0001\u0005+\u0007I\u0011AA\f\u0011)\ty\u0002\u0001B\tB\u0003%\u0011\u0011\u0004\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\t\t\u0003\u0001C\u0001\u0003sAq!!\t\u0001\t\u0003\t9\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAD\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!a2\u0001\t\u0003\nI\rC\u0004\u0002\\\u0002!\t%!8\t\u000f\u0005e\b\u0001\"\u0011\u0002|\"I\u0011Q \u0001\u0002\u0002\u0013\u0005\u0011q \u0005\n\u0005'\u0001\u0011\u0013!C\u0001\u0005+A\u0011Ba\u000b\u0001#\u0003%\tA!\u0006\t\u0013\t5\u0002!%A\u0005\u0002\tU\u0001\"\u0003B\u0018\u0001E\u0005I\u0011\u0001B\u000b\u0011%\u0011\t\u0004AI\u0001\n\u0003\u0011)\u0002C\u0005\u00034\u0001\t\n\u0011\"\u0001\u0003\u0016!I!Q\u0007\u0001\u0012\u0002\u0013\u0005!q\u0007\u0005\n\u0005w\u0001\u0011\u0013!C\u0001\u0005{A\u0011B!\u0011\u0001#\u0003%\tAa\u0011\t\u0013\t\u001d\u0003!!A\u0005B\t%\u0003\"\u0003B+\u0001\u0005\u0005I\u0011\u0001B,\u0011%\u0011I\u0006AA\u0001\n\u0003\u0011Y\u0006C\u0005\u0003b\u0001\t\t\u0011\"\u0011\u0003d!I!\u0011\u000f\u0001\u0002\u0002\u0013\u0005!1\u000f\u0005\n\u0005o\u0002\u0011\u0011!C!\u0005s:\u0011Ba)>\u0003\u0003E\tA!*\u0007\u0011qj\u0014\u0011!E\u0001\u0005OCq!!\t1\t\u0003\u0011)\fC\u0005\u00038B\n\t\u0011\"\u0012\u0003:\"I!1\u0018\u0019\u0002\u0002\u0013\u0005%Q\u0018\u0005\n\u0005#\u0004\u0014\u0013!C\u0001\u0005oA\u0011Ba51#\u0003%\tA!\u0010\t\u0013\tU\u0007'%A\u0005\u0002\t\r\u0003\"\u0003Bla\u0005\u0005I\u0011\u0011Bm\u0011%\u00119\u000fMI\u0001\n\u0003\u00119\u0004C\u0005\u0003jB\n\n\u0011\"\u0001\u0003>!I!1\u001e\u0019\u0012\u0002\u0013\u0005!1\t\u0005\n\u0005[\u0004\u0014\u0011!C\u0005\u0005_\u0014Q\"T1lKRKW.Z:uC6\u0004(B\u0001 @\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0001\u000b\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001b\u0015aA:rY*\u0011A)R\u0001\u0006gB\f'o\u001b\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001YuJU+]EB\u0011A*T\u0007\u0002{%\u0011a*\u0010\u0002\u0014'\u0016\u0004H/\u001a8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0019BK!!U\u001f\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007C\u0001'T\u0013\t!VH\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t1\u0016L\u0004\u0002M/&\u0011\u0001,P\u0001\ba\u0006\u001c7.Y4f\u0013\tQ6L\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005ak\u0004CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&a\u0002)s_\u0012,8\r\u001e\t\u0003;\u000eL!\u0001\u001a0\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\te,\u0017M]\u000b\u0002OB\u0011A\n[\u0005\u0003Sv\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015IX-\u0019:!\u0003\u0015iwN\u001c;i\u0003\u0019iwN\u001c;iA\u0005\u0019A-Y=\u0002\t\u0011\f\u0017\u0010I\u0001\u0005Q>,(/A\u0003i_V\u0014\b%A\u0002nS:\fA!\\5oA\u0005\u00191/Z2\u0002\tM,7\rI\u0001\ti&lWM_8oKV\tq\u000fE\u0002^q\u001eL!!\u001f0\u0003\r=\u0003H/[8o\u0003%!\u0018.\\3{_:,\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012! \t\u0004;bt\bcA@\u0002\u000e9!\u0011\u0011AA\u0005!\r\t\u0019AX\u0007\u0003\u0003\u000bQ1!a\u0002J\u0003\u0019a$o\\8u}%\u0019\u00111\u00020\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0005\u0003\rM#(/\u001b8h\u0015\r\tYAX\u0001\fi&lWMW8oK&#\u0007%A\u0006gC&dwJ\\#se>\u0014XCAA\r!\ri\u00161D\u0005\u0004\u0003;q&a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0012QGA\u001c!\ta\u0005\u0001C\u0003f'\u0001\u0007q\rC\u0003l'\u0001\u0007q\rC\u0003n'\u0001\u0007q\rC\u0003p'\u0001\u0007q\rC\u0003r'\u0001\u0007q\rC\u0003t'\u0001\u0007q\rC\u0004v'A\u0005\t\u0019A<\t\u000fm\u001c\u0002\u0013!a\u0001{\"I\u0011QC\n\u0011\u0002\u0003\u0007\u0011\u0011\u0004\u000b\u000f\u0003K\tY$!\u0010\u0002@\u0005\u0005\u00131IA#\u0011\u0015)G\u00031\u0001h\u0011\u0015YG\u00031\u0001h\u0011\u0015iG\u00031\u0001h\u0011\u0015yG\u00031\u0001h\u0011\u0015\tH\u00031\u0001h\u0011\u0015\u0019H\u00031\u0001h)A\t)#!\u0013\u0002L\u00055\u0013qJA)\u0003'\n)\u0006C\u0003f+\u0001\u0007q\rC\u0003l+\u0001\u0007q\rC\u0003n+\u0001\u0007q\rC\u0003p+\u0001\u0007q\rC\u0003r+\u0001\u0007q\rC\u0003t+\u0001\u0007q\rC\u0003v+\u0001\u0007q-\u0001\u0005dQ&dGM]3o+\t\tY\u0006E\u0003\u0002^\u0005\u0015tM\u0004\u0003\u0002`\u0005\rd\u0002BA\u0002\u0003CJ\u0011aX\u0005\u00031zKA!a\u001a\u0002j\t\u00191+Z9\u000b\u0005as\u0016AC5oaV$H+\u001f9fgV\u0011\u0011q\u000e\t\u0007\u0003;\n)'!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001eB\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY(!\u001e\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0005\u0005\u0003BA:\u0003\u0007KA!!\"\u0002v\tAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\ry\u0015Q\u0012\u0005\u0006wj\u0001\rA`\u0001\ti>l\u0015n\u0019:pgR\u0001\u00121SAM\u0003C\u000b\u0019+!*\u0002(\u0006%\u00161\u0017\t\u0004;\u0006U\u0015bAAL=\n\u0019\u0011I\\=\t\r\u0015\\\u0002\u0019AAN!\ri\u0016QT\u0005\u0004\u0003?s&aA%oi\"11n\u0007a\u0001\u00037Ca!\\\u000eA\u0002\u0005m\u0005BB8\u001c\u0001\u0004\tY\n\u0003\u0004r7\u0001\u0007\u00111\u0014\u0005\b\u0003W[\u0002\u0019AAW\u00031\u0019XmY!oI6K7M]8t!\u0011\t\u0019(a,\n\t\u0005E\u0016Q\u000f\u0002\b\t\u0016\u001c\u0017.\\1m\u0011\u001d\t)l\u0007a\u0001\u0003o\u000baA_8oK&#\u0007\u0003BA]\u0003\u0007l!!a/\u000b\t\u0005u\u0016qX\u0001\u0005i&lWM\u0003\u0002\u0002B\u0006!!.\u0019<b\u0013\u0011\t)-a/\u0003\ri{g.Z%e\u00031qW\u000f\u001c7TC\u001a,WI^1m)A\t\u0019*a3\u0002N\u0006=\u0017\u0011[Aj\u0003+\f9\u000e\u0003\u0004f9\u0001\u0007\u00111\u0013\u0005\u0007Wr\u0001\r!a%\t\r5d\u0002\u0019AAJ\u0011\u0019yG\u00041\u0001\u0002\u0014\"1\u0011\u000f\ba\u0001\u0003'Caa\u001d\u000fA\u0002\u0005M\u0005BB;\u001d\u0001\u0004\tI\u000e\u0005\u0003^q\u0006M\u0015!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ty.a;\u0002vB!\u0011\u0011]At\u001b\t\t\u0019OC\u0002\u0002fv\nqaY8eK\u001e,g.\u0003\u0003\u0002j\u0006\r(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u00055X\u00041\u0001\u0002p\u0006\u00191\r\u001e=\u0011\t\u0005\u0005\u0018\u0011_\u0005\u0005\u0003g\f\u0019O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005]X\u00041\u0001\u0002`\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,W#\u0001@\u0002\t\r|\u0007/\u001f\u000b\u0015\u0003K\u0011\tAa\u0001\u0003\u0006\t\u001d!\u0011\u0002B\u0006\u0005\u001b\u0011yA!\u0005\t\u000f\u0015|\u0002\u0013!a\u0001O\"91n\bI\u0001\u0002\u00049\u0007bB7 !\u0003\u0005\ra\u001a\u0005\b_~\u0001\n\u00111\u0001h\u0011\u001d\tx\u0004%AA\u0002\u001dDqa]\u0010\u0011\u0002\u0003\u0007q\rC\u0004v?A\u0005\t\u0019A<\t\u000fm|\u0002\u0013!a\u0001{\"I\u0011QC\u0010\u0011\u0002\u0003\u0007\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119BK\u0002h\u00053Y#Aa\u0007\u0011\t\tu!qE\u0007\u0003\u0005?QAA!\t\u0003$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Kq\u0016AC1o]>$\u0018\r^5p]&!!\u0011\u0006B\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:TC\u0001B\u001dU\r9(\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011yDK\u0002~\u00053\tabY8qs\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003F)\"\u0011\u0011\u0004B\r\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\n\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)!!\u0011KA`\u0003\u0011a\u0017M\\4\n\t\u0005=!qJ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00037\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\nu\u0003\"\u0003B0W\u0005\u0005\t\u0019AAN\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\r\t\u0007\u0005O\u0012i'a%\u000e\u0005\t%$b\u0001B6=\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=$\u0011\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u001a\tU\u0004\"\u0003B0[\u0005\u0005\t\u0019AAJ\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0004B>\u0011%\u0011yFLA\u0001\u0002\u0004\t\u0019\nK\f\u0001\u0005\u007f\u0012)Ia\"\u0003\f\n5%\u0011\u0013BJ\u0005/\u0013IJ!(\u0003 B\u0019AJ!!\n\u0007\t\rUHA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t%\u0015!!\u0002`\rVs5i\u0018\u0015zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs2\u0002\u0003n\\;sY\u0001j\u0017N\u001c\u0017!g\u0016\u001c7\f\f\u0011uS6,'p\u001c8f;&\u0002S\u0006I\"sK\u0006$X\r\t;j[\u0016\u001cH/Y7qA\u0019\u0014x.\u001c\u0011zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs2\u0002\u0003n\\;sY\u0001j\u0017N\u001c\u0017!g\u0016\u001c\u0007%\u00198eAQLW.\u001a>p]\u0016\u0004c-[3mINt\u0013!C1sOVlWM\u001c;tC\t\u0011y)\u0001Cv\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Q>,(\u000fI\u0017!i\",\u0007\u0005[8ve6zg-\f3bs\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!a\u0001\"x\u000e\t\u001a4\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001j\u0017N\u001c\u0011.AQDW\rI7j]V$X-L8g[!|WO\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u0011u_\u0002*\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u000e\u0004S\u0006\t;iK\u0002\u001aXmY8oI6zg-L7j]V$X\rI1oI\u0002JGo\u001d\u0011nS\u000e\u0014x.\f4sC\u000e$\u0018n\u001c8!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|WN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0019!i>\u0004c\u0007\r\u0018!\u0013\u001a\u0004C\u000f[3!g\u0016\u001c\u0007%\u0019:hk6,g\u000e\u001e\u0011fcV\fGn\u001d\u0011u_\u00022\u0004\u0007\f\u0011uQ\u0016\u00043/Z2p]\u0012\u001c\bEZ5fY\u0012\u0004\u0013n\u001d\u0011tKRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002Co\u001c\u00111A\u0005tG\rI\u0019![&tW\u000f^3!SN\u0004\u0013\r\u001a3fI\u0002\"x\u000e\t;iK\u00022\u0017N\\1mAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,'p\u001c8fA5\u0002C\u000f[3!i&lW\r\t>p]\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!\u0007\u0016#F\u0006I+U\u0007\u0002\ng\u000e\u001a\u0011fi\u000et#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!&\u0002\u0007\u001fQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192i1\u0002\u0013G\r\u0017!eab\u0003E\u000e\u0017!gAb\u0003\u0005N\u001b/qa:\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\"T&\r\u001a.ea\u0002\u0003G\u000e\u001e4ai\"TG\f\u001d9o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]b\u0003eJ\"F)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173o\u0001\u0012\u0014GO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'M\u001d-AYb\u0003e\r\u0019-AI\u001aD\u0006I\u001b:Y\u00012\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014(\f\u00198[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\n\u0014\b\f\u00112g1\u0002\u0013\u0007\f\u00112a1\u0002\u0013'\r\u0017!cIb\u0003e\n)T)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\\;mY2\u0002s\u0007\f\u00113e1\u0002\u0013'\u000e\u0017!gAb\u0003\u0005M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012!1T\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t+A\u00034]Ar\u0003'A\u0007NC.,G+[7fgR\fW\u000e\u001d\t\u0003\u0019B\u001aB\u0001\rBUEB\u0001\"1\u0016BYO\u001e<wmZ4x{\u0006e\u0011QE\u0007\u0003\u0005[S1Aa,_\u0003\u001d\u0011XO\u001c;j[\u0016LAAa-\u0003.\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001d\u0015\u0005\t\u0015\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0013!B1qa2LH\u0003FA\u0013\u0005\u007f\u0013\tMa1\u0003F\n\u001d'\u0011\u001aBf\u0005\u001b\u0014y\rC\u0003fg\u0001\u0007q\rC\u0003lg\u0001\u0007q\rC\u0003ng\u0001\u0007q\rC\u0003pg\u0001\u0007q\rC\u0003rg\u0001\u0007q\rC\u0003tg\u0001\u0007q\rC\u0004vgA\u0005\t\u0019A<\t\u000fm\u001c\u0004\u0013!a\u0001{\"I\u0011QC\u001a\u0011\u0002\u0003\u0007\u0011\u0011D\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0003(A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u0013:\u0003\u001d)h.\u00199qYf$BAa7\u0003dB!Q\f\u001fBo!5i&q\\4hO\u001e<wm^?\u0002\u001a%\u0019!\u0011\u001d0\u0003\rQ+\b\u000f\\3:\u0011%\u0011)oNA\u0001\u0002\u0004\t)#A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003rB!!Q\nBz\u0013\u0011\u0011)Pa\u0014\u0003\r=\u0013'.Z2u\u0001")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$9() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object>> unapply(MakeTimestamp makeTimestamp) {
        return MakeTimestamp$.MODULE$.unapply(makeTimestamp);
    }

    public static boolean apply$default$9() {
        return MakeTimestamp$.MODULE$.apply$default$9();
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, MakeTimestamp>>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.year(), this.month(), this.day(), this.hour(), this.min(), this.sec()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(8, 6)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone().map((Function1 & Serializable & scala.Serializable)x$10 -> StringType$.MODULE$)), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nullable())) : true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$9();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1, x$9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndMicros, ZoneId zoneId) {
        try {
            LocalDateTime localDateTime;
            Predef$.MODULE$.assert(secAndMicros.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Seconds fraction must have 6 digits for microseconds but got ").append(secAndMicros.scale()).toString());
            long unscaledSecFrac = secAndMicros.toUnscaledLong();
            Predef$.MODULE$.assert(secAndMicros.precision() <= 8, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Seconds and fraction cannot have more than 8 digits but got ").append(secAndMicros.precision()).toString());
            int totalMicros = (int)unscaledSecFrac;
            int seconds = Math.floorDiv(totalMicros, (int)1000000L);
            int nanos = Math.floorMod(totalMicros, (int)1000000L) * (int)1000L;
            if (seconds == 60) {
                if (nanos != 0) throw new DateTimeException("The fraction of sec must be zero. Valid range is [0, 60].");
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            Long l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant()));
            return l;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof DateTimeException)) throw throwable;
            if (this.failOnError()) throw throwable;
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable & scala.Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = new StringOps(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName())).stripSuffix("$");
        String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable & scala.Serializable)tz -> new StringBuilder(23).append(dtu).append(".getZoneId(").append((String)tz).append(".toString())").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> zid);
            return new StringBuilder(887).append("\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = ").append((String)secAndNanos).append(".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = ").append(d).append("$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((").append((String)secAndNanos).append(".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              ").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", 0, 0).plusMinutes(1);\n          } else {\n            throw new java.time.DateTimeException(\n              \"The fraction of sec must be zero. Valid range is [0, 60].\");\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", seconds, nanos);\n        }\n        java.time.Instant instant = ldt.atZone(").append(zoneId).append(").toInstant();\n        ").append(ev.value()).append(" = ").append(dtu).append(".instantToMicros(instant);\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_timestamp";
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    public boolean copy$default$9() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 9;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = this.timeZoneId();
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.failOnError() != makeTimestamp.failOnError()) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

