/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.8446490682263027\n      > SELECT _FUNC_(null);\n       0.8446490682263027\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005K\u0001\tE\t\u0015!\u0003H\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015Y\u0005\u0001\"\u0001Q\u0011\u0015Y\u0005\u0001\"\u0001R\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015Q\u0006\u0001\"\u0015\\\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015!\b\u0001\"\u0011Q\u0011\u0015)\b\u0001\"\u0011w\u0011\u00191\u0003\u0001\"\u0011\u0002\u000e!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"a\u0010\u0001#\u0003%\t!!\u0011\t\u0013\u0005\u0015\u0003!!A\u0005B\u0005\u001d\u0003\"CA,\u0001\u0005\u0005I\u0011AA-\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003{\u0002\u0011\u0011!C!\u0003\u007f:q!a)\"\u0011\u0003\t)K\u0002\u0004!C!\u0005\u0011q\u0015\u0005\u0007\u0017b!\t!a,\t\u000f\u0005E\u0006\u0004\"\u0001\u00024\"I\u0011\u0011\u0017\r\u0002\u0002\u0013\u0005\u0015q\u0017\u0005\n\u0003{C\u0012\u0013!C\u0001\u0003\u0003B\u0011\"a0\u0019\u0003\u0003%\t)!1\t\u0013\u0005M\u0007$%A\u0005\u0002\u0005\u0005\u0003\"CAk1\u0005\u0005I\u0011BAl\u0005\u0011\u0011\u0016M\u001c3\u000b\u0005\t\u001a\u0013aC3yaJ,7o]5p]NT!\u0001J\u0013\u0002\u0011\r\fG/\u00197zgRT!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00184mq\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003\u0007I#u\t\u0005\u00021i%\u0011Q'\t\u0002\u0019\u000bb\u0004(/Z:tS>tw+\u001b;i%\u0006tGm\\7TK\u0016$\u0007CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$a\u0002)s_\u0012,8\r\u001e\t\u0003ouJ!A\u0010\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u0005\u0003\"\u0001\r\"\n\u0005\r\u000b#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n\u0001\u0002[5eKN+W\rZ\u000b\u0002\u000fB\u0011q\u0007S\u0005\u0003\u0013b\u0012qAQ8pY\u0016\fg.A\u0005iS\u0012,7+Z3eA\u00051A(\u001b8jiz\"2!\u0014(P!\t\u0001\u0004\u0001C\u0003@\u000b\u0001\u0007\u0011\tC\u0004F\u000bA\u0005\t\u0019A$\u0015\u00035#\"!\u0014*\t\u000b}:\u0001\u0019A!\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003\u001bVCQA\u0016\u0005A\u0002]\u000bAa]3fIB\u0011q\u0007W\u0005\u00033b\u0012A\u0001T8oO\u0006aQM^1m\u0013:$XM\u001d8bYR\u0011Al\u0018\t\u0003ouK!A\u0018\u001d\u0003\r\u0011{WO\u00197f\u0011\u0015\u0001\u0017\u00021\u0001b\u0003\u0015Ig\u000e];u!\t\u00117-D\u0001$\u0013\t!7EA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\r9WN\u001d\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u0006\nqaY8eK\u001e,g.\u0003\u0002mS\nAQ\t\u001f9s\u0007>$W\rC\u0003o\u0015\u0001\u0007q.A\u0002dib\u0004\"\u0001\u001b9\n\u0005EL'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006g*\u0001\raZ\u0001\u0003KZ\f\u0011B\u001a:fg\"\u001cu\u000e]=\u0002\u001b\u0019d\u0017\r^!sOVlWM\u001c;t+\u00059\b#\u0002=\u0002\u0002\u0005\u001daBA=\u007f\u001d\tQX0D\u0001|\u0015\taX&\u0001\u0004=e>|GOP\u0005\u0002s%\u0011q\u0010O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019!!\u0002\u0003\u0011%#XM]1u_JT!a \u001d\u0011\u0007]\nI!C\u0002\u0002\fa\u00121!\u00118z+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"A\u001f\u001d\n\u0007\u0005]\u0001(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/A\u0014\u0001B2paf$R!TA\u0012\u0003KAqa\u0010\b\u0011\u0002\u0003\u0007\u0011\tC\u0004F\u001dA\u0005\t\u0019A$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0006\u0016\u0004\u0003\u000652FAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0002(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0010\u00024\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\t\u0016\u0004\u000f\u00065\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001\u00027b]\u001eT!!a\u0015\u0002\t)\fg/Y\u0005\u0005\u00037\ti%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\\A\u0019q'!\u0018\n\u0007\u0005}\u0003HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\b\u0005\u0015\u0004\"CA4'\u0005\u0005\t\u0019AA.\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000e\t\u0007\u0003_\n)(a\u0002\u000e\u0005\u0005E$bAA:q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0011\u0011O\u0001\tG\u0006tW)];bYR\u0019q)a\u001f\t\u0013\u0005\u001dT#!AA\u0002\u0005\u001d\u0011AB3rk\u0006d7\u000fF\u0002H\u0003\u0003C\u0011\"a\u001a\u0017\u0003\u0003\u0005\r!a\u0002)'\u0001\t))a#\u0002\u000e\u0006E\u00151SAL\u00033\u000bi*a(\u0011\u0007A\n9)C\u0002\u0002\n\u0006\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0010\u0006\tYa\u0018$V\u001d\u000e{\u0006fW:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!S:$W\r]3oI\u0016tG\u000fI1oI\u0002JG-\u001a8uS\u000e\fG\u000e\\=!I&\u001cHO]5ckR,G\r\t\u0015j]%tCML\u0015!k:Lgm\u001c:nYf\u0004C-[:ue&\u0014W\u000f^3eAY\fG.^3tA%t\u0007e\u0017\u0019-AEJc&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t)*AA0\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019/sY\u0012\u0014h\u000e\u001b3sU\nDg\r\u001b6iMR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAr\u0003\b\u000e\u001b7ie\u0002d\u0007\u000f\u001a3mM\u0002$g\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9BD\u0007\u000e\u001c5sA2\u0004H\r\u001a7gA\u0012tG\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005m\u0015A\u000f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg\u000eI4f]\u0016\u0014\u0018\r\u001c\u0011dCN,gF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\t+A\u00032]Ur\u0003'\u0001\u0003SC:$\u0007C\u0001\u0019\u0019'\u0011A\u0012\u0011\u0016\u001f\u0011\u0007]\nY+C\u0002\u0002.b\u0012a!\u00118z%\u00164GCAAS\u0003\u0015\t\u0007\u000f\u001d7z)\ri\u0015Q\u0017\u0005\u0006-j\u0001\ra\u0016\u000b\u0006\u001b\u0006e\u00161\u0018\u0005\u0006\u007fm\u0001\r!\u0011\u0005\b\u000bn\u0001\n\u00111\u0001H\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\fy\rE\u00038\u0003\u000b\fI-C\u0002\u0002Hb\u0012aa\u00149uS>t\u0007#B\u001c\u0002L\u0006;\u0015bAAgq\t1A+\u001e9mKJB\u0001\"!5\u001e\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GCAAm!\u0011\tY%a7\n\t\u0005u\u0017Q\n\u0002\u0007\u001f\nTWm\u0019;")
public class Rand
extends RDG
implements ExpressionWithRandomSeed,
Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Rand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Rand rand) {
        return Rand$.MODULE$.unapply(rand);
    }

    public static boolean apply$default$2() {
        return Rand$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$), Rand$.MODULE$.apply$default$2());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Rand freshCopy() {
        return new Rand(this.child(), this.hideSeed());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(6).append("rand(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    public Rand copy(Expression child, boolean hideSeed) {
        return new Rand(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.hideSeed() != rand.hideSeed()) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Rand() {
        this(new Literal(BoxesRunTime.boxToLong((long)Utils$.MODULE$.random().nextLong()), LongType$.MODULE$), true);
    }

    public Rand(Expression child) {
        this(child, false);
    }
}

