/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.DecimalPrecision$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the mean calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (3) AS tab(col);\n       2.0\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (NULL) AS tab(col);\n       1.5\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\u0012$\u0001JB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")1\f\u0001C!9\")a\r\u0001C!O\")q\u000e\u0001C!a\")q\u000f\u0001C!q\")A\u0010\u0001C!{\"Q\u00111\u0001\u0001\t\u0006\u0004%I!!\u0002\t\u0015\u0005M\u0001\u0001#b\u0001\n\u0013\t)\u0002\u0003\u0006\u0002\u001c\u0001A)\u0019!C\u0005\u0003;A!\"!\n\u0001\u0011\u000b\u0007I\u0011BA\u000f\u0011)\t9\u0003\u0001EC\u0002\u0013\u0005\u0013\u0011\u0006\u0005\u000b\u0003w\u0001\u0001R1A\u0005B\u0005u\u0002BCA&\u0001!\u0015\r\u0011\"\u0011\u0002N!I\u0011\u0011\u000b\u0001\t\u0006\u0004%\t%\u0012\u0005\n\u0003'\u0002\u0001R1A\u0005BqC\u0011\"!\u0016\u0001\u0003\u0003%\t!a\u0016\t\u0013\u0005m\u0003!%A\u0005\u0002\u0005u\u0003\"CA:\u0001\u0005\u0005I\u0011IA;\u0011%\t)\tAA\u0001\n\u0003\t9\tC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0001\u0002\u0012\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0013q\u0014\u0005\n\u0003O\u0003\u0011\u0011!C\u0001\u0003SC\u0011\"!,\u0001\u0003\u0003%\t%a,\b\u0013\u0005M7%!A\t\u0002\u0005Ug\u0001\u0003\u0012$\u0003\u0003E\t!a6\t\r)cB\u0011AAs\u0011%\t9\u000fHA\u0001\n\u000b\nI\u000fC\u0005\u0002lr\t\t\u0011\"!\u0002n\"I\u0011\u0011\u001f\u000f\u0002\u0002\u0013\u0005\u00151\u001f\u0005\n\u0003\u007fd\u0012\u0011!C\u0005\u0005\u0003\u0011q!\u0011<fe\u0006<WM\u0003\u0002%K\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003M\u001d\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001&K\u0001\tG\u0006$\u0018\r\\=ti*\u0011!fK\u0001\u0004gFd'B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M)\u0001aM\u001c<\u0003B\u0011A'N\u0007\u0002G%\u0011ag\t\u0002\u0015\t\u0016\u001cG.\u0019:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005aJT\"A\u0013\n\u0005i*#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011AHQ\u0005\u0003\u0007v\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012A\u0012\t\u0003q\u001dK!\u0001S\u0013\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051k\u0005C\u0001\u001b\u0001\u0011\u0015!5\u00011\u0001G\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002!B\u0011\u0011\u000b\u0017\b\u0003%Z\u0003\"aU\u001f\u000e\u0003QS!!V\u0019\u0002\rq\u0012xn\u001c;?\u0013\t9V(\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,>\u0003!\u0019\u0007.\u001b7ee\u0016tW#A/\u0011\u0007y\u001bgI\u0004\u0002`C:\u00111\u000bY\u0005\u0002}%\u0011!-P\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0002TKFT!AY\u001f\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001i!\rq6-\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y&\nQ\u0001^=qKNL!A\\6\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A9\u0011\u0005I,X\"A:\u000b\u0005Q<\u0013\u0001C1oC2L8/[:\n\u0005Y\u001c(a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u001f\t\u0003yiL!a_\u001f\u0003\u000f\t{w\u000e\\3b]\u0006AA-\u0019;b)f\u0004X-F\u0001\u007f!\tQw0C\u0002\u0002\u0002-\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000be\u0016\u001cX\u000f\u001c;UsB,WCAA\u0004%\u0019\tI!!\u0004<\u0003\u001a1\u00111\u0002\u0001\u0001\u0003\u000f\u0011A\u0002\u0010:fM&tW-\\3oiz\u00022A[A\b\u0013\r\t\tb\u001b\u0002\u000f\rJ\f7\r^5p]\u0006dG+\u001f9f\u0003-\u0019X/\u001c#bi\u0006$\u0016\u0010]3\u0016\u0005\u0005]!CBA\r\u0003\u001bY\u0014I\u0002\u0004\u0002\f\u0001\u0001\u0011qC\u0001\u0004gVlWCAA\u0010!\rA\u0014\u0011E\u0005\u0004\u0003G)#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\fQaY8v]R\f1#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN,\"!a\u000b\u0011\r\u00055\u0012qGA\u0010\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012!C5n[V$\u0018M\u00197f\u0015\r\t)$P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001d\u0003_\u0011A\u0001T5ti\u0006i\u0011N\\5uS\u0006dg+\u00197vKN,\"!a\u0010\u0011\r\u0005\u0005\u00131IA#\u001b\t\t\u0019$C\u0002e\u0003g\u00012\u0001OA$\u0013\r\tI%\n\u0002\b\u0019&$XM]1m\u0003AiWM]4f\u000bb\u0004(/Z:tS>t7/\u0006\u0002\u0002PA)\u0011\u0011IA\"\r\u0006\u0011RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8o\u0003E)\b\u000fZ1uK\u0016C\bO]3tg&|gn]\u0001\u0005G>\u0004\u0018\u0010F\u0002M\u00033Bq\u0001R\n\u0011\u0002\u0003\u0007a)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}#f\u0001$\u0002b-\u0012\u00111\r\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003%)hn\u00195fG.,GMC\u0002\u0002nu\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t(a\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0003mC:<'BAAA\u0003\u0011Q\u0017M^1\n\u0007e\u000bY(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\nB\u0019A(a#\n\u0007\u00055UHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0006e\u0005c\u0001\u001f\u0002\u0016&\u0019\u0011qS\u001f\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001c^\t\t\u00111\u0001\u0002\n\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!)\u0011\r\u0005\u0005\u00131UAJ\u0013\u0011\t)+a\r\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004s\u0006-\u0006\"CAN3\u0005\u0005\t\u0019AAJ\u0003\u0019)\u0017/^1mgR\u0019\u00110!-\t\u0013\u0005m%$!AA\u0002\u0005M\u0005f\u0005\u0001\u00026\u0006m\u0016QXAa\u0003\u0007\f9-!3\u0002N\u0006=\u0007c\u0001\u001d\u00028&\u0019\u0011\u0011X\u0013\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qX\u0001C?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011nK\u0006t\u0007eY1mGVd\u0017\r^3eA\u0019\u0014x.\u001c\u0011wC2,Xm\u001d\u0011pM\u0002\n\u0007e\u001a:pkBt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0017!!\u0018\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B#'\u000b\u0017!QMJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u0002#G\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B#'\u000b\u0017!Q9+F\nT\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112]UR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0017\f\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005E\u0017!B\u0019/a9\u0002\u0014aB!wKJ\fw-\u001a\t\u0003iq\u0019B\u0001HAm\u0003B1\u00111\\Aq\r2k!!!8\u000b\u0007\u0005}W(A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0018Q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAAk\u0003!!xn\u0015;sS:<GCAA<\u0003\u0015\t\u0007\u000f\u001d7z)\ra\u0015q\u001e\u0005\u0006\t~\u0001\rAR\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)0a?\u0011\tq\n9PR\u0005\u0004\u0003sl$AB(qi&|g\u000e\u0003\u0005\u0002~\u0002\n\t\u00111\u0001M\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0004A!\u0011\u0011\u0010B\u0003\u0013\u0011\u00119!a\u001f\u0003\r=\u0013'.Z2u\u0001")
public class Average
extends DeclarativeAggregate
implements ImplicitCastInputTypes {
    private FractionalType resultType;
    private FractionalType sumDataType;
    private AttributeReference sum;
    private AttributeReference count;
    private List<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<Expression> updateExpressions;
    private final Expression child;
    private volatile int bitmap$0;

    public static Option<Expression> unapply(Average average) {
        return Average$.MODULE$.unapply(average);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Average, A> function1) {
        return Average$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Average> compose(Function1<A, Expression> function1) {
        return Average$.MODULE$.compose(function1);
    }

    public Expression child() {
        return this.child;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "avg");
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType$[]{NumericType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForNumericExpr(this.child().dataType(), "function average");
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    private FractionalType resultType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 1) == 0) {
                FractionalType fractionalType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    fractionalType = DecimalType$.MODULE$.bounded(p + 4, s + 4);
                } else {
                    fractionalType = DoubleType$.MODULE$;
                }
                this.resultType = fractionalType;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private FractionalType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private FractionalType sumDataType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 2) == 0) {
                FractionalType fractionalType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    fractionalType = DecimalType$.MODULE$.bounded(p + 10, s);
                } else {
                    fractionalType = DoubleType$.MODULE$;
                }
                this.sumDataType = fractionalType;
                this.bitmap$0 |= 2;
            }
        }
        return this.sumDataType;
    }

    private FractionalType sumDataType() {
        return (this.bitmap$0 & 2) == 0 ? this.sumDataType$lzycompute() : this.sumDataType;
    }

    private AttributeReference sum$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "sum";
                FractionalType x$2 = this.sumDataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.sum = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        return (this.bitmap$0 & 4) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private AttributeReference count$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.count = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        return (this.bitmap$0 & 8) == 0 ? this.count$lzycompute() : this.count;
    }

    private List<AttributeReference> aggBufferAttributes$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.sum();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    public List<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.default(this.sumDataType()), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.mergeExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).$plus(this.RichAttribute(this.sum()).right()), package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.count()).left()).$plus(this.RichAttribute(this.count()).right())}));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x80) == 0) {
                DataType dataType = this.child().dataType();
                Expression expression = dataType instanceof DecimalType ? package$expressions$.MODULE$.DslExpression((Expression)DecimalPrecision$.MODULE$.decimalAndDecimal().apply((Object)new Divide(this.sum(), package$expressions$.MODULE$.DslExpression(this.count()).cast(DecimalType$.MODULE$.LongDecimal()), false))).cast(this.resultType()) : new Divide(package$expressions$.MODULE$.DslExpression(this.sum()).cast(this.resultType()), package$expressions$.MODULE$.DslExpression(this.count()).cast(this.resultType()), false);
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.updateExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Add(this.sum(), package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.child()).cast(this.sumDataType()), Literal$.MODULE$.default(this.sumDataType())})), Add$.MODULE$.apply$default$3()), new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)))}));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x100) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    public Average copy(Expression child) {
        return new Average(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Average";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Average;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Average)) return false;
        boolean bl = true;
        if (!bl) return false;
        Average average = (Average)x$1;
        Expression expression = this.child();
        Expression expression2 = average.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!average.canEqual(this)) return false;
        return true;
    }

    public Average(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

