/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.unsafe.types.UTF8String;

public class CharVarcharCodegenUtils {
    private static final UTF8String SPACE = UTF8String.fromString((String)" ");

    private static UTF8String trimTrailingSpaces(UTF8String inputStr, int numChars, int limit) {
        if (inputStr.trimRight().numChars() > limit) {
            throw new RuntimeException("Exceeds char/varchar type length limitation: " + limit);
        }
        return inputStr.substring(0, limit);
    }

    public static UTF8String charTypeWriteSideCheck(UTF8String inputStr, int limit) {
        int numChars = inputStr.numChars();
        if (numChars == limit) {
            return inputStr;
        }
        if (numChars < limit) {
            return inputStr.rpad(limit, SPACE);
        }
        return CharVarcharCodegenUtils.trimTrailingSpaces(inputStr, numChars, limit);
    }

    public static UTF8String varcharTypeWriteSideCheck(UTF8String inputStr, int limit) {
        int numChars = inputStr.numChars();
        if (numChars <= limit) {
            return inputStr;
        }
        return CharVarcharCodegenUtils.trimTrailingSpaces(inputStr, numChars, limit);
    }
}

