/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp[, idx]) - Extract the first string in the `str` that match the `regexp`\n    expression and corresponding to the regex group index.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * idx - an integer expression that representing the group index. The regex maybe contains\n          multiple groups. `idx` indicates which regex group to extract. The group index should\n          be non-negative. The minimum value of `idx` is 0, which means matching the entire\n          regular expression. If `idx` is not specified, the default group index value is 1. The\n          `idx` parameter is the Java regex Matcher group() method index.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)-(\\\\d+)', 1);\n       100\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0010!\u00016B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011!\u0019\u0005A!f\u0001\n\u0003a\u0004\u0002\u0003#\u0001\u0005#\u0005\u000b\u0011B\u001f\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b\u0015\u0003A\u0011A&\t\u000bA\u0003A\u0011I)\t\u000be\u0003A\u0011\t.\t\u000b\u0005\u0004A\u0011\t2\t\u000b9\u0004A\u0011K8\t\u000bu\u0004A\u0011\u000b@\t\u0013\u0005-\u0001!!A\u0005\u0002\u00055\u0001\"CA\u000b\u0001E\u0005I\u0011AA\f\u0011%\ti\u0003AI\u0001\n\u0003\t9\u0002C\u0005\u00020\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"!\u0014\u0001\u0003\u0003%\t!a\u0014\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\t\t\bAA\u0001\n\u0003\n\u0019hB\u0005\u0002\u001e\u0002\n\t\u0011#\u0001\u0002 \u001aAq\u0004IA\u0001\u0012\u0003\t\t\u000b\u0003\u0004F3\u0011\u0005\u0011q\u0016\u0005\n\u0003cK\u0012\u0011!C#\u0003gC\u0011\"!.\u001a\u0003\u0003%\t)a.\t\u0013\u0005}\u0016$!A\u0005\u0002\u0006\u0005\u0007\"CAj3\u0005\u0005I\u0011BAk\u00055\u0011VmZ#ya\u0016CHO]1di*\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001]IB\u0004CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005E\u0011VmZ#ya\u0016CHO]1di\n\u000b7/\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\b!J|G-^2u!\t\u0019\u0014(\u0003\u0002;i\ta1+\u001a:jC2L'0\u00192mK\u000691/\u001e2kK\u000e$X#A\u001f\u0011\u0005=r\u0014BA !\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\tgV\u0014'.Z2uA\u00051!/Z4fqB\fqA]3hKb\u0004\b%A\u0002jIb\fA!\u001b3yA\u00051A(\u001b8jiz\"Ba\u0012%J\u0015B\u0011q\u0006\u0001\u0005\u0006w\u001d\u0001\r!\u0010\u0005\u0006\u0003\u001e\u0001\r!\u0010\u0005\u0006\u0007\u001e\u0001\r!\u0010\u000b\u0004\u000f2s\u0005\"B'\t\u0001\u0004i\u0014!A:\t\u000b=C\u0001\u0019A\u001f\u0002\u0003I\fAB\\;mYN\u000bg-Z#wC2$BAU+W1B\u00111gU\u0005\u0003)R\u00121!\u00118z\u0011\u0015i\u0015\u00021\u0001S\u0011\u00159\u0016\u00021\u0001S\u0003\u0005\u0001\b\"B(\n\u0001\u0004\u0011\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS!A\u0018\u0013\u0002\u000bQL\b/Z:\n\u0005\u0001l&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001d!\t!7N\u0004\u0002fSB\u0011a\rN\u0007\u0002O*\u0011\u0001\u000eL\u0001\u0007yI|w\u000e\u001e \n\u0005)$\u0014A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A\u001b\u001b\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00019wwB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fI\u0001\bG>$WmZ3o\u0013\t)(O\u0001\u0005FqB\u00148i\u001c3f\u0011\u00159H\u00021\u0001y\u0003\r\u0019G\u000f\u001f\t\u0003cfL!A\u001f:\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")A\u0010\u0004a\u0001a\u0006\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$baR@\u0002\u0004\u0005\u001d\u0001BBA\u0001\u001b\u0001\u0007Q(\u0001\u0005oK^4\u0015N]:u\u0011\u0019\t)!\u0004a\u0001{\u0005Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003\u0013i\u0001\u0019A\u001f\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9q)a\u0004\u0002\u0012\u0005M\u0001bB\u001e\u000f!\u0003\u0005\r!\u0010\u0005\b\u0003:\u0001\n\u00111\u0001>\u0011\u001d\u0019e\u0002%AA\u0002u\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a)\u001aQ(a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\tAA[1wC&\u0019A.!\u000f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0003cA\u001a\u0002J%\u0019\u00111\n\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007I\u000b\t\u0006C\u0005\u0002TQ\t\t\u00111\u0001\u0002H\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0017\u0011\u000b\u0005m\u0013\u0011\r*\u000e\u0005\u0005u#bAA0i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0014Q\f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002j\u0005=\u0004cA\u001a\u0002l%\u0019\u0011Q\u000e\u001b\u0003\u000f\t{w\u000e\\3b]\"A\u00111\u000b\f\u0002\u0002\u0003\u0007!+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\n)\b\u0003\u0005\u0002T]\t\t\u00111\u0001SQ]\u0001\u0011\u0011PA@\u0003\u0003\u000b))a\"\u0002\f\u00065\u0015\u0011SAJ\u0003/\u000bI\nE\u00020\u0003wJ1!! !\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a!\u0002\u0003wQ\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016D\bo\u0017\u0017!S\u0012DX,\u000b\u0011.A\u0015CHO]1di\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI:ue&tw\rI5oAQDW\r\t1tiJ\u0004\u0007\u0005\u001e5bi\u0002j\u0017\r^2iAQDW\r\t1sK\u001e,\u0007\u0010\u001d1\u000bA\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8oA\u0005tG\rI2peJ,7\u000f]8oI&tw\r\t;pAQDW\r\t:fO\u0016D\be\u001a:pkB\u0004\u0013N\u001c3fq:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!#\u0002\u0011\u000fT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:t#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b\u000fI\u0017!C\u0002\u001aHO]5oO\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hA\u0005\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011sK\u001e,\u0007\u0010I:ue&tw\rI:i_VdG\r\t2fA\u0005T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011KCZ\f\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000f\t\u0015j]\u000edW\u000fZ5oO\u0002\u0012XmZ3yAA\fG\u000f^3s]NL\u0003%\u0019:fAUtWm]2ba\u0016$\u0007%\u001b8!_V\u0014\beU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005]1sg\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003\u0005^8![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0017!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!M>\u0014\b\u0005\u0019:fO\u0016D\b\u000f\u0019\u0011dC:\u0004#-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012c\f\u0018/bE\u000e$#E\f\u001fcezb$M\u001d \u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000b[3sK\u0002J7\u000fI1!'Fc\u0005eY8oM&<\u0007eJ:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg\u001e\u0002C\u000f[1uA\r\fg\u000e\t2fAU\u001cX\r\u001a\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t4bY2\u0014\u0017mY6!i>\u0004C\u000f[3!'B\f'o\u001b\u00112]Y\u0002#-\u001a5bm&|'\u000f\t:fO\u0006\u0014H-\u001b8hAM$(/\u001b8hA1LG/\u001a:bY\u0002\u0002\u0018M]:j]\u001et\u0003ER8sA\u0015D\u0018-\u001c9mK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg\u0002*g.\u00192mK\u0012d\u0003\u0005\u001e5fA\u0001\u0014XmZ3ya\u0002\u0004C\u000f[1uA\r\fg\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014\u0003%[:!Eyc\u0016MY2%E9R\u0001\u0005\t\u0011!A\u0001R\u0003%\u001b3yA5\u0002\u0013M\u001c\u0011j]R,w-\u001a:!Kb\u0004(/Z:tS>t\u0007\u0005\u001e5bi\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hAQDW\rI4s_V\u0004\b%\u001b8eKbt\u0003\u0005\u00165fAI,w-\u001a=![\u0006L(-\u001a\u0011d_:$\u0018-\u001b8t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\\;mi&\u0004H.\u001a\u0011he>,\bo\u001d\u0018!A&$\u0007\u0010\u0019\u0011j]\u0012L7-\u0019;fg\u0002:\b.[2iAI,w-\u001a=!OJ|W\u000f\u001d\u0011u_\u0002*\u0007\u0010\u001e:bGRt\u0003\u0005\u00165fA\u001d\u0014x.\u001e9!S:$W\r\u001f\u0011tQ>,H\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012W\r\t8p]6rWmZ1uSZ,g\u0006\t+iK\u0002j\u0017N\\5nk6\u0004c/\u00197vK\u0002zg\r\t1jIb\u0004\u0007%[:!a1\u0002s\u000f[5dQ\u0002jW-\u00198tA5\fGo\u00195j]\u001e\u0004C\u000f[3!K:$\u0018N]3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]\u0001Je\r\t1jIb\u0004\u0007%[:!]>$\be\u001d9fG&4\u0017.\u001a3-AQDW\r\t3fM\u0006,H\u000e\u001e\u0011he>,\b\u000fI5oI\u0016D\bE^1mk\u0016\u0004\u0013n\u001d\u00112]\u0001\"\u0006.\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0017\u000e\u001a=aAA\f'/Y7fi\u0016\u0014\b%[:!i\",\u0007ES1wC\u0002\u0012XmZ3yA5\u000bGo\u00195fe\u0002:'o\\;qQ%\u0002S.\u001a;i_\u0012\u0004\u0013N\u001c3fq:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qR\u0001S\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013\u0007\r\u0019.eA\u0002t\u0005\f\u0011(QqcFmK\u0015.QqcFmK\u0015(Y\u0001\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112aAR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003+\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!a'\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u001bI+w-\u0012=q\u000bb$(/Y2u!\ty\u0013d\u0005\u0003\u001a\u0003GC\u0004\u0003CAS\u0003WkT(P$\u000e\u0005\u0005\u001d&bAAUi\u00059!/\u001e8uS6,\u0017\u0002BAW\u0003O\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\ty*\u0001\u0005u_N#(/\u001b8h)\t\t)$A\u0003baBd\u0017\u0010F\u0004H\u0003s\u000bY,!0\t\u000bmb\u0002\u0019A\u001f\t\u000b\u0005c\u0002\u0019A\u001f\t\u000b\rc\u0002\u0019A\u001f\u0002\u000fUt\u0017\r\u001d9msR!\u00111YAh!\u0015\u0019\u0014QYAe\u0013\r\t9\r\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rM\nY-P\u001f>\u0013\r\ti\r\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005EW$!AA\u0002\u001d\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\u0007\u0003BA\u001c\u00033LA!a7\u0002:\t1qJ\u00196fGR\u0004")
public class RegExpExtract
extends RegExpExtractBase
implements scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtract regExpExtract) {
        return RegExpExtract$.MODULE$.unapply(regExpExtract);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtract> tupled() {
        return RegExpExtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtract>>> curried() {
        return RegExpExtract$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        UTF8String uTF8String;
        Matcher m = this.getLastMatcher(s, p);
        if (m.find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtractBase$.MODULE$.checkGroupIndex(mr.groupCount(), index);
            String group = mr.group(index);
            uTF8String = group == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group);
        } else {
            uTF8String = UTF8String.EMPTY_UTF8;
        }
        return uTF8String;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameRegExpExtractBase = RegExpExtractBase.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, idx) -> new StringBuilder(519).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      java.util.regex.Matcher ").append(matcher).append(" =\n        ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n      if (").append(matcher).append(".find()) {\n        java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n        ").append(classNameRegExpExtractBase).append(".checkGroupIndex(").append(matchResult).append(".groupCount(), ").append((String)idx).append(");\n        if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n          ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        } else {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append("));\n        }\n        ").append(setEvNotNull).append("\n      } else {\n        ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        ").append(setEvNotNull).append("\n      }").toString());
    }

    @Override
    public RegExpExtract withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.idx();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

