/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.util.Arrays;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vector$class;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,g+Z2u_JT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011aAV3di>\u0014\b\u0002C\r\u0001\u0005\u000b\u0007I\u0011\t\u000e\u0002\tML'0Z\u000b\u00027A\u0011q\u0002H\u0005\u0003;A\u00111!\u00138u\u0011!y\u0002A!A!\u0002\u0013Y\u0012!B:ju\u0016\u0004\u0003\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u000f%tG-[2fgV\t1\u0005E\u0002\u0010ImI!!\n\t\u0003\u000b\u0005\u0013(/Y=)\u0007\u0001:S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051J#!B*j]\u000e,\u0017%\u0001\u0018\u0002\u000bIr\u0003G\f\u0019\t\u0011A\u0002!\u0011!Q\u0001\n\r\n\u0001\"\u001b8eS\u000e,7\u000f\t\u0015\u0004_\u001dj\u0003\u0002C\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\u0002\rY\fG.^3t+\u0005)\u0004cA\b%mA\u0011qbN\u0005\u0003qA\u0011a\u0001R8vE2,\u0007f\u0001\u001a([!A1\b\u0001B\u0001B\u0003%Q'A\u0004wC2,Xm\u001d\u0011)\u0007i:S\u0006C\u0003?\u0001\u0011\u0005q(\u0001\u0004=S:LGO\u0010\u000b\u0005\u0001\u0006\u0013E\t\u0005\u0002\u0016\u0001!)\u0011$\u0010a\u00017!)\u0011%\u0010a\u0001G!\u001a!iJ\u0017\t\u000bMj\u0004\u0019A\u001b)\u0007\u0011;S\u0006K\u0002>O5BQ\u0001\u0013\u0001\u0005B%\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u0015B\u00111J\u0014\b\u0003\u001f1K!!\u0014\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001bBAQA\u0015\u0001\u0005BQ\nq\u0001^8BeJ\f\u0017\u0010C\u0003U\u0001\u0011\u0005S+\u0001\u0003d_BLX#\u0001!\t\r]\u0003A\u0011\t\u0004Y\u0003!\t7O\u0011:fKj,W#A-\u0011\u0007isf'D\u0001\\\u0015\t\u0019ALC\u0001^\u0003\u0019\u0011'/Z3{K&\u0011qc\u0017\u0005\u0006A\u0002!\t%Y\u0001\u0006CB\u0004H.\u001f\u000b\u0003m\tDQaY0A\u0002m\t\u0011!\u001b\u0005\u0006K\u0002!\tEZ\u0001\u000eM>\u0014X-Y2i\u0003\u000e$\u0018N^3\u0015\u0005\u001dT\u0007CA\bi\u0013\tI\u0007C\u0001\u0003V]&$\b\"B6e\u0001\u0004a\u0017!\u00014\u0011\u000b=i7DN4\n\u00059\u0004\"!\u0003$v]\u000e$\u0018n\u001c83\u0011\u0015\u0001\b\u0001\"\u0011r\u0003\u0019)\u0017/^1mgR\u0011!/\u001e\t\u0003\u001fML!\u0001\u001e\t\u0003\u000f\t{w\u000e\\3b]\")ao\u001ca\u0001o\u0006)q\u000e\u001e5feB\u0011q\u0002_\u0005\u0003sB\u00111!\u00118z\u0011\u0015Y\b\u0001\"\u0011}\u0003!A\u0017m\u001d5D_\u0012,G#A\u000e\t\u000by\u0004A\u0011\t\u000e\u0002\u00159,X.Q2uSZ,7\u000f\u0003\u0004\u0002\u0002\u0001!\tEG\u0001\f]Vlgj\u001c8{KJ|7\u000f\u0003\u0005\u0002\u0006\u0001!\tEAA\u0004\u0003A!xn\u00159beN,w+\u001b;i'&TX\rF\u0002A\u0003\u0013Aq!a\u0003\u0002\u0004\u0001\u00071$A\u0002o]jDa!a\u0004\u0001\t\u0003R\u0012AB1sO6\f\u0007\u0010\u0003\u0005\u0002\u0014\u0001!\tABA\u000b\u0003\u0015\u0019H.[2f)\r\u0001\u0015q\u0003\u0005\b\u00033\t\t\u00021\u0001$\u0003=\u0019X\r\\3di\u0016$\u0017J\u001c3jG\u0016\u001c\bf\u0001\u0001([\u001d9\u0011q\u0004\u0002\t\u0002\u0005\u0005\u0012\u0001D*qCJ\u001cXMV3di>\u0014\bcA\u000b\u0002$\u00191\u0011A\u0001E\u0001\u0003K\u0019R!a\t\u000f\u0003O\u00012aDA\u0015\u0013\r\tY\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b}\u0005\rB\u0011AA\u0018)\t\t\t\u0003\u0003\u0005\u00024\u0005\rB\u0011AA\u001b\u0003\u001d)h.\u00199qYf$B!a\u000e\u0002DA)q\"!\u000f\u0002>%\u0019\u00111\b\t\u0003\r=\u0003H/[8o!\u0019y\u0011qH\u000e$k%\u0019\u0011\u0011\t\t\u0003\rQ+\b\u000f\\34\u0011\u001d\t)%!\rA\u0002\u0001\u000b!a\u001d<)\t\u0005Er%\f\u0005\u000b\u0003\u0017\n\u0019#!A\u0005\n\u00055\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005!A.\u00198h\u0015\t\tI&\u0001\u0003kCZ\f\u0017\u0002BA/\u0003'\u0012aa\u00142kK\u000e$\b\u0006BA\u0012O5BC!!\b([\u0001")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public SparseVector toSparse() {
        return Vector$class.toSparse(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size()), Predef$.MODULE$.intArrayOps(this.indices()).mkString("[", ",", "]"), Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]")}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " out of bounds [0, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)this.size())})));
        }
        int j = Arrays.binarySearch(this.indices(), i);
        return j < 0 ? 0.0 : this.values()[j];
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$3;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$3.elem;
                }
            }
            {
                this.nnz$3 = nnz$3;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
                public static final long serialVersionUID = 0L;
                private final int[] ii$2;
                private final double[] vv$2;
                private final IntRef k$2;

                public final void apply(int i, double v) {
                    this.apply$mcVID$sp(i, v);
                }

                public void apply$mcVID$sp(int i, double v) {
                    if (v != 0.0) {
                        this.ii$2[this.k$2.elem] = i;
                        this.vv$2[this.k$2.elem] = v;
                        ++this.k$2.elem;
                    }
                }
                {
                    this.ii$2 = ii$2;
                    this.vv$2 = vv$2;
                    this.k$2 = k$2;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(selectedIndices).flatMap((Function1)new Serializable(this, currentIdx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;
            private final IntRef currentIdx$1;

            /*
             * WARNING - void declaration
             */
            public final Iterator<Tuple2<Object, Object>> apply(int origIdx) {
                void var3_3;
                int iIdx = Arrays.binarySearch(this.$outer.indices(), origIdx);
                Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(this.currentIdx$1.elem, this.$outer.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                ++this.currentIdx$1.elem;
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentIdx$1 = currentIdx$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 != null) {
            Tuple2 tuple22;
            int[] sliceInds = (int[])tuple2._1();
            double[] sliceVals = (double[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
            int[] sliceInds2 = (int[])tuple23._1();
            double[] sliceVals2 = (double[])tuple23._2();
            return new SparseVector(selectedIndices.length, (int[])Predef$.MODULE$.intArrayOps(sliceInds2).toArray(ClassTag$.MODULE$.Int()), (double[])Predef$.MODULE$.doubleArrayOps(sliceVals2).toArray(ClassTag$.MODULE$.Double()));
        }
        throw new MatchError((Object)tuple2);
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector$class.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The size of the requested sparse vector must be no less than 0.";
            }
        });
        Predef$.MODULE$.require(indices.length == values.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Sparse vectors require that the dimension of the").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" indices match the dimension of the values. You provided ", " indices and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(indices.length <= size, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You provided ", " indices and values, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which exceeds the specified vector size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.size())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (Predef$.MODULE$.intArrayOps(indices).nonEmpty()) {
            Predef$.MODULE$.require(indices[0] >= 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparseVector $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found negative index: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices()[0])}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        IntRef prev = IntRef.create((int)-1);
        Predef$.MODULE$.intArrayOps(indices).foreach((Function1)new Serializable(this, prev){
            public static final long serialVersionUID = 0L;
            public final IntRef prev$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Predef$.MODULE$.require(this.prev$1.elem < i, (Function0)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final int i$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " follows ", " and is not strictly increasing"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1), BoxesRunTime.boxToInteger((int)this.$outer.prev$1.elem)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
                this.prev$1.elem = i;
            }
            {
                this.prev$1 = prev$1;
            }
        });
        Predef$.MODULE$.require(prev.elem < size, (Function0)new Serializable(this, prev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;
            private final IntRef prev$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " out of bounds for vector of size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.prev$1.elem), BoxesRunTime.boxToInteger((int)this.$outer.size())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.prev$1 = prev$1;
            }
        });
    }
}

