/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.HasFeatureSubsetStrategy;
import org.apache.spark.ml.tree.HasFeatureSubsetStrategy$class;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassificationModelParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeClassifierParams$class;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleModel$class;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u0001\u0003\u00015\u0011qDU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0007\u00019Ir$J\u0016\u0011\t=\u0001\"\u0003G\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051A.\u001b8bY\u001eL!a\u0006\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\t\u0005!AO]3f\u0013\tq2DA\u0013SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|g.T8eK2\u0004\u0016M]1ngB\u0019!\u0004\t\u0012\n\u0005\u0005Z\"!\u0005+sK\u0016,en]3nE2,Wj\u001c3fYB\u0011qbI\u0005\u0003I\t\u0011q\u0004R3dSNLwN\u001c+sK\u0016\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\t1\u0013&D\u0001(\u0015\tAC!\u0001\u0003vi&d\u0017B\u0001\u0016(\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\te\u0001\u0011)\u0019!C!g\u0005\u0019Q/\u001b3\u0016\u0003Q\u0002\"!\u000e\u001d\u000f\u000512\u0014BA\u001c.\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]j\u0003fA\u0019=\u0005B\u0011Q\bQ\u0007\u0002})\u0011qHB\u0001\u000bC:tw\u000e^1uS>t\u0017BA!?\u0005\u0015\u0019\u0016N\\2fC\u0005\u0019\u0015!B\u0019/k9\u0002\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\tULG\r\t\u0015\u0004\tr\u0012\u0005\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011B%\u0002\r}#(/Z3t+\u0005Q\u0005c\u0001\u0017LE%\u0011A*\f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0015\u00069q\f\u001e:fKN\u0004\u0003\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011I)\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002%B\u0011AfU\u0005\u0003)6\u00121!\u00138uQ\ryEHV\u0011\u0002/\u0006)\u0011G\f\u001c/a!A\u0011\f\u0001B\u0001B\u0003%!+\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005K\u0002YyYC\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t%U\u0001\u000b]Vl7\t\\1tg\u0016\u001c\bfA.=\u0005\"Aq\f\u0001B\u0001B\u0003%!+A\u0006ok6\u001cE.Y:tKN\u0004\u0003f\u00010=\u0005\"1!\r\u0001C\u0001\t\r\fa\u0001P5oSRtD#\u0002\reM\u001eL\u0007\"\u0002\u001ab\u0001\u0004!\u0004f\u00013=\u0005\")\u0001*\u0019a\u0001\u0015\")\u0001+\u0019a\u0001%\"\u001aq\r\u0010,\t\u000bq\u000b\u0007\u0019\u0001*)\u0007%d$\t\u0003\u0004c\u0001\u0011\u0005A\u0001\u001c\u000b\u000515|\u0007\u000fC\u0003oW\u0002\u0007!*A\u0003ue\u0016,7\u000fC\u0003QW\u0002\u0007!\u000bC\u0003]W\u0002\u0007!\u000bC\u0003o\u0001\u0011\u0005\u0013\nK\u0002ryM\f\u0013\u0001^\u0001\u0006c9\"d\u0006\r\u0005\tm\u0002A)\u0019!C\u0005o\u0006aq\f\u001e:fK^+\u0017n\u001a5ugV\t\u0001\u0010E\u0002-\u0017f\u0004\"\u0001\f>\n\u0005ml#A\u0002#pk\ndW\r\u0003\u0005~\u0001!\u0005\t\u0015)\u0003y\u00035yFO]3f/\u0016Lw\r\u001b;tA!)q\u0010\u0001C!o\u0006YAO]3f/\u0016Lw\r\u001b;tQ\rqHh\u001d\u0005\b\u0003\u000b\u0001A\u0011KA\u0004\u00035!(/\u00198tM>\u0014X.S7qYR!\u0011\u0011BA\u0019!\u0011\tY!a\u000b\u000f\t\u00055\u0011Q\u0005\b\u0005\u0003\u001f\t\tC\u0004\u0003\u0002\u0012\u0005}a\u0002BA\n\u0003;qA!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033a\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0019\u00111\u0005\u0004\u0002\u0007M\fH.\u0003\u0003\u0002(\u0005%\u0012a\u00029bG.\fw-\u001a\u0006\u0004\u0003G1\u0011\u0002BA\u0017\u0003_\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005\u001d\u0012\u0011\u0006\u0005\t\u0003g\t\u0019\u00011\u0001\u00026\u00059A-\u0019;bg\u0016$\b\u0007BA\u001c\u0003\u0007\u0002b!!\u000f\u0002<\u0005}RBAA\u0015\u0013\u0011\ti$!\u000b\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011IA\"\u0019\u0001!A\"!\u0012\u00022\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00121a\u0018\u00133#\u0011\tI%a\u0014\u0011\u00071\nY%C\u0002\u0002N5\u0012qAT8uQ&tw\rE\u0002-\u0003#J1!a\u0015.\u0005\r\te.\u001f\u0005\b\u0003/\u0002A\u0011KA-\u0003)\u0001(/\u001a3jGR\u0014\u0016m\u001e\u000b\u0004%\u0005m\u0003bBA/\u0003+\u0002\rAE\u0001\tM\u0016\fG/\u001e:fg\"9\u0011\u0011\r\u0001\u0005R\u0005\r\u0014A\u0006:boJ\u0002(o\u001c2bE&d\u0017\u000e^=J]Bc\u0017mY3\u0015\u0007I\t)\u0007C\u0004\u0002h\u0005}\u0003\u0019\u0001\n\u0002\u001bI\fw\u000f\u0015:fI&\u001cG/[8o\u0011!\tY\u0007\u0001b\u0001\n\u0003\t\u0016\u0001\u00038v[R\u0013X-Z:)\u0011\u0005%\u0014qNA;\u0003s\u00022\u0001LA9\u0013\r\t\u0019(\f\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA<\u0003}*6/\u001a\u0011hKRtU/\u001c+sK\u0016\u001c\b%\u001b8ti\u0016\fGM\f\u0011!)\"L7\u000fI7fi\"|G\rI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004#GL\u0019/a9\n#!a\u001f\u0002\u000bIr\u0003G\f\u0019\t\u000f\u0005}\u0004\u0001)A\u0005%\u0006Ia.^7Ue\u0016,7\u000f\t\u0005\b\u0003\u0007\u0003A\u0011IAC\u0003\u0011\u0019w\u000e]=\u0015\u0007a\t9\t\u0003\u0005\u0002\n\u0006\u0005\u0005\u0019AAF\u0003\u0015)\u0007\u0010\u001e:b!\u0011\ti)a%\u000e\u0005\u0005=%bAAI\t\u0005)\u0001/\u0019:b[&!\u0011QSAH\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006BAAyMDq!a'\u0001\t\u0003\ni*\u0001\u0005u_N#(/\u001b8h)\u0005!\u0004\u0006BAMyMD!\"a)\u0001\u0011\u000b\u0007I\u0011AAS\u0003I1W-\u0019;ve\u0016LU\u000e]8si\u0006t7-Z:\u0016\u0003IAC!!)=\u0005\"I\u00111\u0016\u0001\t\u0002\u0003\u0006KAE\u0001\u0014M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7\u000f\t\u0015\u0005\u0003Sc$\t\u0003\u0005\u00022\u0002!\t\u0001BAZ\u0003\u0015!xn\u00147e+\t\t)\f\u0005\u0003\u00028\u0006\rWBAA]\u0015\u0011\tY,!0\u0002\u000b5|G-\u001a7\u000b\u0007q\tyLC\u0002\u0002B\u001a\tQ!\u001c7mS\nLA!!2\u0002:\n\t\"+\u00198e_64uN]3ti6{G-\u001a7\t\u000f\u0005%\u0007\u0001\"\u0011\u0002L\u0006)qO]5uKV\u0011\u0011Q\u001a\t\u0004M\u0005=\u0017bAAiO\tAQ\nT,sSR,'\u000fK\u0003\u0002Hr\nI\bK\u0002\u0001yM<q!!7\u0003\u0011\u0003\tY.A\u0010SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|g.T8eK2\u00042aDAo\r\u0019\t!\u0001#\u0001\u0002`N9\u0011Q\\Aq\u0003O\\\u0003c\u0001\u0017\u0002d&\u0019\u0011Q]\u0017\u0003\r\u0005s\u0017PU3g!\u00111\u0013\u0011\u001e\r\n\u0007\u0005-xE\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016DqAYAo\t\u0003\ty\u000f\u0006\u0002\u0002\\\"A\u00111_Ao\t\u0003\n)0\u0001\u0003sK\u0006$WCAA|!\u00111\u0013\u0011 \r\n\u0007\u0005mxE\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0015\t\t\u0010PA=\u0011!\u0011\t!!8\u0005B\t\r\u0011\u0001\u00027pC\u0012$2\u0001\u0007B\u0003\u0011\u001d\u00119!a@A\u0002Q\nA\u0001]1uQ\"*\u0011q \u001f\u0002z\u0019I!QBAo\u0001\u0005u'q\u0002\u0002&%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016dwK]5uKJ\u001cBAa\u0003\u0002N\"Q!1\u0003B\u0006\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0011%t7\u000f^1oG\u0016DqA\u0019B\u0006\t\u0003\u00119\u0002\u0006\u0003\u0003\u001a\tu\u0001\u0003\u0002B\u000e\u0005\u0017i!!!8\t\u000f\tM!Q\u0003a\u00011!A!\u0011\u0005B\u0006\t#\u0012\u0019#\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0011)Ca\u000b\u0011\u00071\u00129#C\u0002\u0003*5\u0012A!\u00168ji\"9!q\u0001B\u0010\u0001\u0004!da\u0002B\u0018\u0003;$!\u0011\u0007\u0002&%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001cBA!\f\u0002x\"9!M!\f\u0005\u0002\tUBC\u0001B\u001c!\u0011\u0011YB!\f\t\u0015\tm\"Q\u0006b\u0001\n\u0013\u0011i$A\u0005dY\u0006\u001c8OT1nKV\u0011!q\b\t\u0005\u0005\u0003\u0012Y%\u0004\u0002\u0003D)!!Q\tB$\u0003\u0011a\u0017M\\4\u000b\u0005\t%\u0013\u0001\u00026bm\u0006L1!\u000fB\"\u0011%\u0011yE!\f!\u0002\u0013\u0011y$\u0001\u0006dY\u0006\u001c8OT1nK\u0002B!Ba\u0015\u0003.\t\u0007I\u0011\u0002B\u001f\u00035!(/Z3DY\u0006\u001c8OT1nK\"I!q\u000bB\u0017A\u0003%!qH\u0001\u000fiJ,Wm\u00117bgNt\u0015-\\3!\u0011!\u0011\tA!\f\u0005B\tmCc\u0001\r\u0003^!9!q\u0001B-\u0001\u0004!\u0004\"\u0003B1\u0003;$\t\u0001\u0002B2\u0003\u001d1'o\\7PY\u0012$2\u0002\u0007B3\u0005S\u0012\u0019H! \u0003\u0000!A!q\rB0\u0001\u0004\t),\u0001\u0005pY\u0012lu\u000eZ3m\u0011!\u0011YGa\u0018A\u0002\t5\u0014A\u00029be\u0016tG\u000fE\u0002\u0010\u0005_J1A!\u001d\u0003\u0005Y\u0011\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u0016\u0014\b\u0002\u0003B;\u0005?\u0002\rAa\u001e\u0002'\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:\u0011\u000bU\u0012IH\u0015*\n\u0007\tm$HA\u0002NCBDa\u0001\u0018B0\u0001\u0004\u0011\u0006\u0002\u0003)\u0003`A\u0005\t\u0019\u0001*\t\u0015\t\r\u0015Q\\I\u0001\n\u0003\u0011))A\tge>lw\n\u001c3%I\u00164\u0017-\u001e7uIU*\"Aa\"+\u0007I\u0013Ii\u000b\u0002\u0003\fB!!Q\u0012BK\u001b\t\u0011yI\u0003\u0003\u0003\u0012\nM\u0015!C;oG\",7m[3e\u0015\tyT&\u0003\u0003\u0003\u0018\n=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!1TAo\u0003\u0003%IA!(\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005?\u0003BA!\u0011\u0003\"&!!1\u0015B\"\u0005\u0019y%M[3di\"*\u0011Q\u001c\u001f\u0002z!*\u0011q\u001b\u001f\u0002z\u0001")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassificationModelParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable {
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private double[] _treeWeights;
    private final int numTrees;
    private Vector featureImportances;
    private final int getNumTrees;
    private final int totalNumNodes;
    private final Param<String> impurity;
    private final Param<String> featureSubsetStrategy;
    private final DoubleParam subsamplingRate;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static int fromOld$default$5() {
        return RandomForestClassificationModel$.MODULE$.fromOld$default$5();
    }

    public static RandomForestClassificationModel load(String string) {
        return RandomForestClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 1.0;
                    }
                }, ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this._treeWeights;
        }
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.featureImportances;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public int getNumTrees() {
        return this.getNumTrees;
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel$class.totalNumNodes(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.totalNumNodes;
        }
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public void org$apache$spark$ml$tree$TreeEnsembleModel$_setter_$getNumTrees_$eq(int x$1) {
        this.getNumTrees = x$1;
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel$class.javaTreeWeights(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel$class.toDebugString(this);
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public TreeClassifierParams setImpurity(String value) {
        return TreeClassifierParams$class.setImpurity(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams$class.getOldImpurity(this);
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasFeatureSubsetStrategy$_setter_$featureSubsetStrategy_$eq(Param x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public HasFeatureSubsetStrategy setFeatureSubsetStrategy(String value) {
        return HasFeatureSubsetStrategy$class.setFeatureSubsetStrategy(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return HasFeatureSubsetStrategy$class.getFeatureSubsetStrategy(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(RandomForestClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this, bcastModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcastModel$1;

            public final double apply(Object features) {
                return ((ClassificationModel)this.bcastModel$1.value()).predict((Vector)features);
            }
            {
                this.bcastModel$1 = bcastModel$1;
            }
        }, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.fill(this.numClasses(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        Predef$.MODULE$.refArrayOps((Object[])this._trees()).view().foreach((Function1)new Serializable(this, features, votes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassificationModel $outer;
            private final Vector features$1;
            private final double[] votes$1;

            public final void apply(DecisionTreeClassificationModel tree) {
                double[] classCounts = tree.rootNode().predictImpl(this.features$1).impurityStats().stats();
                double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classCounts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                if (total != 0.0) {
                    for (int i = 0; i < this.$outer.numClasses(); ++i) {
                        int n = i;
                        this.votes$1[n] = this.votes$1[n] + classCounts[i] / total;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.features$1 = features$1;
                this.votes$1 = votes$1;
            }
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    public int numTrees() {
        return this.numTrees;
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForestClassificationModel (uid=", ") with ", " trees"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid(), BoxesRunTime.boxToInteger((int)this.getNumTrees())}));
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])this._trees()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DecisionTreeModel apply(DecisionTreeClassificationModel x$2) {
                return x$2.toOld();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasFeatureSubsetStrategy$class.$init$(this);
        TreeClassifierParams$class.$init$(this);
        TreeEnsembleModel$class.$init$(this);
        MLWritable$class.$init$(this);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])_trees).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "RandomForestClassificationModel requires at least 1 tree.";
            }
        });
        this.numTrees = this.trees().length;
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            });
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }

    public static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultFormats$ format2 = DefaultFormats$.MODULE$;
            Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
            if (tuple3 != null) {
                DefaultParamsReader.Metadata metadata = (DefaultParamsReader.Metadata)tuple3._1();
                Tuple2[] treesData = (Tuple2[])tuple3._2();
                if (metadata != null) {
                    DefaultParamsReader.Metadata metadata2 = metadata;
                    if (treesData != null) {
                        DecisionTreeClassificationModel[] trees;
                        Tuple2 tuple2;
                        Tuple2[] tuple2Array = treesData;
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)metadata2, (Object)tuple2Array);
                        DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple22._1();
                        Tuple2[] treesData2 = (Tuple2[])tuple22._2();
                        int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                        int numClasses = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numClasses")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                        int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                        Predef$.MODULE$.require(numTrees == (trees = (DecisionTreeClassificationModel[])Predef$.MODULE$.refArrayOps((Object[])treesData2).map((Function1)new Serializable(this, numFeatures, numClasses){
                            public static final long serialVersionUID = 0L;
                            private final int numFeatures$1;
                            private final int numClasses$1;

                            public final DecisionTreeClassificationModel apply(Tuple2<DefaultParamsReader.Metadata, Node> x0$1) {
                                Tuple2<DefaultParamsReader.Metadata, Node> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                                    Node root = (Node)tuple2._2();
                                    DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, this.numFeatures$1, this.numClasses$1);
                                    DefaultParamsReader$.MODULE$.getAndSetParams(tree, treeMetadata);
                                    DecisionTreeClassificationModel decisionTreeClassificationModel = tree;
                                    return decisionTreeClassificationModel;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.numFeatures$1 = numFeatures$1;
                                this.numClasses$1 = numClasses$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class)))).length, (Function0)new Serializable(this, numTrees, trees){
                            public static final long serialVersionUID = 0L;
                            private final int numTrees$1;
                            private final DecisionTreeClassificationModel[] trees$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForestClassificationModel.load expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" trees based on metadata but found ", " trees."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.trees$1.length)}))).toString();
                            }
                            {
                                this.numTrees$1 = numTrees$1;
                                this.trees$1 = trees$1;
                            }
                        });
                        RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
                        DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata3);
                        return model;
                    }
                }
            }
            throw new MatchError(tuple3);
        }
    }
}

