/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.NaiveBayesWrapper;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;

public final class NaiveBayesWrapper$
implements MLReadable<NaiveBayesWrapper> {
    public static final NaiveBayesWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new NaiveBayesWrapper$();
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public NaiveBayesWrapper fit(String formula, Dataset<Row> data, double smoothing) {
        Model rFormula = new RFormula().setFormula(formula).fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormula).transform(data).schema();
        NominalAttribute labelAttr = (NominalAttribute)Attribute$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormula).getLabelCol()));
        String[] labels = (String[])labelAttr.values().get();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormula).getFeaturesCol())).attributes().get();
        String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])featureAttrs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$1) {
                return (String)x$1.name().get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        NaiveBayes naiveBayes = (NaiveBayes)new NaiveBayes().setSmoothing(smoothing).setModelType("bernoulli").setPredictionCol(this.PREDICTED_LABEL_INDEX_COL());
        IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormula, naiveBayes, idxToStr})).fit((Dataset)data);
        return new NaiveBayesWrapper((PipelineModel)pipeline, labels, features);
    }

    @Override
    public MLReader<NaiveBayesWrapper> read() {
        return new NaiveBayesWrapper.NaiveBayesWrapperReader();
    }

    @Override
    public NaiveBayesWrapper load(String path) {
        return (NaiveBayesWrapper)MLReadable$class.load(this, path);
    }

    private NaiveBayesWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

