/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r\u001db\u0001B\u0001\u0003\u00015\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2T!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)]\u00012a\u0004\t\u0013\u001b\u0005!\u0011BA\t\u0005\u0005\u0015iu\u000eZ3m!\t\u0019\u0002!D\u0001\u0003!\t\u0019R#\u0003\u0002\u0017\u0005\tY\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0003\u0002\tU$\u0018\u000e\\\u0005\u00039e\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!q\u0002A!b\u0001\n\u0003z\u0012aA;jIV\t\u0001\u0005\u0005\u0002\"O9\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t13\u0005K\u0002\u001eWE\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00021[\t)1+\u001b8dK\u0006\n!'A\u00032]Yr\u0003\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u0003!\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007MZ\u0013\u0007\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t+\u0005I\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0005\u0003\u0019a\u0017N\\1mO&\u0011ah\u000f\u0002\u0007-\u0016\u001cGo\u001c:)\u0007YZ\u0003)I\u0001B\u0003\u0015\u0011d\u0006\r\u00181\u0011!\u0019\u0005A!A!\u0002\u0013I\u0014!D2pK\u001a4\u0017nY5f]R\u001c\b\u0005K\u0002CW\u0001C\u0001B\u0012\u0001\u0003\u0006\u0004%\taR\u0001\nS:$XM]2faR,\u0012\u0001\u0013\t\u0003E%K!AS\u0012\u0003\r\u0011{WO\u00197fQ\r)5&\r\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0011\u0006Q\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u0011)\u00071[\u0013\u0007\u0003\u0005Q\u0001\t\u0015\r\u0011\"\u0001H\u0003\u0015\u00198-\u00197fQ\ry5&\r\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0011\u000611oY1mK\u0002B3AU\u00162\u0011\u00191\u0006\u0001\"\u0001\u0005/\u00061A(\u001b8jiz\"RA\u0005-[9zCQAH+A\u0002\u0001B3\u0001W\u00162\u0011\u00159T\u000b1\u0001:Q\rQ6\u0006\u0011\u0005\u0006\rV\u0003\r\u0001\u0013\u0015\u00049.\n\u0004\"\u0002)V\u0001\u0004A\u0005f\u00010,c!)\u0011\r\u0001C\u0001E\u0006q1/\u001a;GK\u0006$XO]3t\u0007>dGCA2e\u001b\u0005\u0001\u0001\"B3a\u0001\u0004\u0001\u0013!\u0002<bYV,\u0007f\u00011,c!)\u0001\u000e\u0001C\u0001S\u0006\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003G*DQ!Z4A\u0002\u0001B3aZ\u00162\u0011\u0015i\u0007\u0001\"\u0001o\u0003a\u0019X\r^)vC:$\u0018\u000e\\3Qe>\u0014\u0017MY5mSRLWm\u001d\u000b\u0003G>DQ!\u001a7A\u0002A\u00042AI9I\u0013\t\u00118EA\u0003BeJ\f\u0017\u0010K\u0002mWEBQ!\u001e\u0001\u0005\u0002Y\fqb]3u#V\fg\u000e^5mKN\u001cu\u000e\u001c\u000b\u0003G^DQ!\u001a;A\u0002\u0001B3\u0001^\u00162\u0011\u0015Q\b\u0001\"\u0001|\u0003A\u0001(/\u001a3jGR\fV/\u00198uS2,7\u000f\u0006\u0002:y\")Q0\u001fa\u0001s\u0005Aa-Z1ukJ,7\u000fK\u0002zW\u0001Cq!!\u0001\u0001\t\u0003\t\u0019!A\u0004qe\u0016$\u0017n\u0019;\u0015\u0007!\u000b)\u0001C\u0003~\u007f\u0002\u0007\u0011\bK\u0002\u0000W\u0001Cq!a\u0003\u0001\t\u0003\ni!A\u0005ue\u0006t7OZ8s[R!\u0011qBA\u001c!\u0011\t\t\"!\r\u000f\t\u0005M\u00111\u0006\b\u0005\u0003+\t9C\u0004\u0003\u0002\u0018\u0005\u0015b\u0002BA\r\u0003GqA!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?a\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0019\u0011\u0011\u0006\u0004\u0002\u0007M\fH.\u0003\u0003\u0002.\u0005=\u0012a\u00029bG.\fw-\u001a\u0006\u0004\u0003S1\u0011\u0002BA\u001a\u0003k\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u00055\u0012q\u0006\u0005\t\u0003s\tI\u00011\u0001\u0002<\u00059A-\u0019;bg\u0016$\b\u0007BA\u001f\u0003\u0013\u0002b!a\u0010\u0002B\u0005\u0015SBAA\u0018\u0013\u0011\t\u0019%a\f\u0003\u000f\u0011\u000bG/Y:fiB!\u0011qIA%\u0019\u0001!A\"a\u0013\u00028\u0005\u0005\t\u0011!B\u0001\u0003\u001b\u00121a\u0018\u00134#\u0011\ty%!\u0016\u0011\u0007\t\n\t&C\u0002\u0002T\r\u0012qAT8uQ&tw\rE\u0002#\u0003/J1!!\u0017$\u0005\r\te.\u001f\u0015\u0005\u0003\u0013Y\u0003\tC\u0004\u0002`\u0001!\t%!\u0019\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!a\u0019\u0002pA!\u0011QMA6\u001b\t\t9G\u0003\u0003\u0002j\u0005=\u0012!\u0002;za\u0016\u001c\u0018\u0002BA7\u0003O\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011!\t\t(!\u0018A\u0002\u0005\r\u0014AB:dQ\u0016l\u0017\r\u000b\u0003\u0002^-\n\u0004bBA<\u0001\u0011\u0005\u0013\u0011P\u0001\u0005G>\u0004\u0018\u0010F\u0002\u0013\u0003wB\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\u0006Kb$(/\u0019\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011Q\u0011\u0003\u0002\u000bA\f'/Y7\n\t\u0005%\u00151\u0011\u0002\t!\u0006\u0014\u0018-\\'ba\"\"\u0011QO\u00162\u0011\u001d\ty\t\u0001C!\u0003#\u000bQa\u001e:ji\u0016,\"!a%\u0011\u0007a\t)*C\u0002\u0002\u0018f\u0011\u0001\"\u0014'Xe&$XM\u001d\u0015\u0005\u0003\u001b[\u0013\u0007K\u0002\u0001WEB3\u0001AAP!\ra\u0013\u0011U\u0005\u0004\u0003Gk#\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006dwaBAT\u0005!\u0005\u0011\u0011V\u0001\u001b\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0004'\u0005-fAB\u0001\u0003\u0011\u0003\tik\u0005\u0005\u0002,\u0006=\u0016QWA^!\r\u0011\u0013\u0011W\u0005\u0004\u0003g\u001b#AB!osJ+g\r\u0005\u0003\u0019\u0003o\u0013\u0012bAA]3\tQQ\n\u0014*fC\u0012\f'\r\\3\u0011\u0007\t\ni,C\u0002\u0002@\u000e\u0012AbU3sS\u0006d\u0017N_1cY\u0016DqAVAV\t\u0003\t\u0019\r\u0006\u0002\u0002*\"A\u0011qYAV\t\u0003\nI-\u0001\u0003sK\u0006$WCAAf!\u0011A\u0012Q\u001a\n\n\u0007\u0005=\u0017D\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0011\t)mK\u0019\t\u0011\u0005U\u00171\u0016C!\u0003/\fA\u0001\\8bIR\u0019!#!7\t\u000f\u0005m\u00171\u001ba\u0001A\u0005!\u0001/\u0019;iQ\u0011\t\u0019nK\u0019\u0007\u0013\u0005\u0005\u00181\u0016\u0001\u0002,\u0006\r(\u0001I!G)N+(O^5wC2\u0014Vm\u001a:fgNLwN\\'pI\u0016dwK]5uKJ\u001cb!a8\u0002\u0014\u0006\u0015\b\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-h!\u0001\u0005j]R,'O\\1m\u0013\u0011\ty/!;\u0003\u000f1{wmZ5oO\"Q\u00111_Ap\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0011%t7\u000f^1oG\u0016DqAVAp\t\u0003\t9\u0010\u0006\u0003\u0002z\u0006u\b\u0003BA~\u0003?l!!a+\t\u000f\u0005M\u0018Q\u001fa\u0001%\u00199!\u0011AAp\t\n\r!\u0001\u0002#bi\u0006\u001c\u0002\"a@\u00020\n\u0015\u00111\u0018\t\u0004E\t\u001d\u0011b\u0001B\u0005G\t9\u0001K]8ek\u000e$\b\"C\u001c\u0002\u0000\nU\r\u0011\"\u00019\u0011%\u0019\u0015q B\tB\u0003%\u0011\bC\u0005G\u0003\u007f\u0014)\u001a!C\u0001\u000f\"IQ*a@\u0003\u0012\u0003\u0006I\u0001\u0013\u0005\n!\u0006}(Q3A\u0005\u0002\u001dC\u0011bUA\u0000\u0005#\u0005\u000b\u0011\u0002%\t\u000fY\u000by\u0010\"\u0001\u0003\u001aQA!1\u0004B\u0010\u0005C\u0011\u0019\u0003\u0005\u0003\u0003\u001e\u0005}XBAAp\u0011\u00199$q\u0003a\u0001s!1aIa\u0006A\u0002!Ca\u0001\u0015B\f\u0001\u0004A\u0005BCA<\u0003\u007f\f\t\u0011\"\u0001\u0003(QA!1\u0004B\u0015\u0005W\u0011i\u0003\u0003\u00058\u0005K\u0001\n\u00111\u0001:\u0011!1%Q\u0005I\u0001\u0002\u0004A\u0005\u0002\u0003)\u0003&A\u0005\t\u0019\u0001%\t\u0015\tE\u0012q`I\u0001\n\u0003\u0011\u0019$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU\"fA\u001d\u00038-\u0012!\u0011\b\t\u0005\u0005w\u0011\u0019%\u0004\u0002\u0003>)!!q\bB!\u0003%)hn\u00195fG.,GM\u0003\u0002/G%!!Q\tB\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u0013\ny0%A\u0005\u0002\t-\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001bR3\u0001\u0013B\u001c\u0011)\u0011\t&a@\u0012\u0002\u0013\u0005!1J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011)\u0011)&a@\u0002\u0002\u0013\u0005#qK\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\te\u0003\u0003\u0002B.\u0005Kj!A!\u0018\u000b\t\t}#\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0003d\u0005!!.\u0019<b\u0013\rA#Q\f\u0005\u000b\u0005S\ny0!A\u0005\u0002\t-\u0014\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B7!\r\u0011#qN\u0005\u0004\u0005c\u001a#aA%oi\"Q!QOA\u0000\u0003\u0003%\tAa\u001e\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u000bB=\u0011)\u0011YHa\u001d\u0002\u0002\u0003\u0007!QN\u0001\u0004q\u0012\n\u0004B\u0003B@\u0003\u007f\f\t\u0011\"\u0011\u0003\u0002\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0004B1!Q\u0011BF\u0003+j!Aa\"\u000b\u0007\t%5%\u0001\u0006d_2dWm\u0019;j_:LAA!$\u0003\b\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003\u0012\u0006}\u0018\u0011!C\u0001\u0005'\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005+\u0013Y\nE\u0002#\u0005/K1A!'$\u0005\u001d\u0011un\u001c7fC:D!Ba\u001f\u0003\u0010\u0006\u0005\t\u0019AA+\u0011)\u0011y*a@\u0002\u0002\u0013\u0005#\u0011U\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!Q\u000e\u0005\u000b\u0005K\u000by0!A\u0005B\t\u001d\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\te\u0003B\u0003BV\u0003\u007f\f\t\u0011\"\u0011\u0003.\u00061Q-];bYN$BA!&\u00030\"Q!1\u0010BU\u0003\u0003\u0005\r!!\u0016\b\u0015\tM\u0016q\\A\u0001\u0012\u0013\u0011),\u0001\u0003ECR\f\u0007\u0003\u0002B\u000f\u0005o3!B!\u0001\u0002`\u0006\u0005\t\u0012\u0002B]'\u0019\u00119La/\u0002<BI!Q\u0018Bbs!C%1D\u0007\u0003\u0005\u007fS1A!1$\u0003\u001d\u0011XO\u001c;j[\u0016LAA!2\u0003@\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fY\u00139\f\"\u0001\u0003JR\u0011!Q\u0017\u0005\u000b\u0005K\u00139,!A\u0005F\t\u001d\u0006B\u0003Bh\u0005o\u000b\t\u0011\"!\u0003R\u0006)\u0011\r\u001d9msRA!1\u0004Bj\u0005+\u00149\u000e\u0003\u00048\u0005\u001b\u0004\r!\u000f\u0005\u0007\r\n5\u0007\u0019\u0001%\t\rA\u0013i\r1\u0001I\u0011)\u0011YNa.\u0002\u0002\u0013\u0005%Q\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yNa;\u0011\u000b\t\u0012\tO!:\n\u0007\t\r8E\u0001\u0004PaRLwN\u001c\t\u0007E\t\u001d\u0018\b\u0013%\n\u0007\t%8E\u0001\u0004UkBdWm\r\u0005\u000b\u0005[\u0014I.!AA\u0002\tm\u0011a\u0001=%a!A!\u0011_Ap\t#\u0012\u00190\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0011)Pa?\u0011\u0007\t\u001290C\u0002\u0003z\u000e\u0012A!\u00168ji\"9\u00111\u001cBx\u0001\u0004\u0001ca\u0002B\u0000\u0003W#1\u0011\u0001\u0002!\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'o\u0005\u0003\u0003~\u0006-\u0007b\u0002,\u0003~\u0012\u00051Q\u0001\u000b\u0003\u0007\u000f\u0001B!a?\u0003~\"Q11\u0002B\u007f\u0005\u0004%IAa\u0016\u0002\u0013\rd\u0017m]:OC6,\u0007\"CB\b\u0005{\u0004\u000b\u0011\u0002B-\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u0005\t\u0003+\u0014i\u0010\"\u0011\u0004\u0014Q\u0019!c!\u0006\t\u000f\u0005m7\u0011\u0003a\u0001A!Q1\u0011DAV\u0003\u0003%Iaa\u0007\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007;\u0001BAa\u0017\u0004 %!1\u0011\u0005B/\u0005\u0019y%M[3di\"\"\u00111V\u00162Q\u0011\t)kK\u0019")
public class AFTSurvivalRegressionModel
extends Model<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static AFTSurvivalRegressionModel load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams$class.getCensorCol(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams$class.getQuantileProbabilities(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams$class.getQuantilesCol(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams$class.hasQuantilesCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams$class.validateAndTransformSchema(this, schema, fitting);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    public AFTSurvivalRegressionModel setFeaturesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegressionModel setPredictionCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
        double k = 1.0 / this.scale();
        double[] quantiles = (double[])Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities())).map((Function1)new Serializable(this, lambda, k){
            public static final long serialVersionUID = 0L;
            private final double lambda$1;
            private final double k$1;

            public final double apply(double q) {
                return this.apply$mcDD$sp(q);
            }

            public double apply$mcDD$sp(double q) {
                return this.lambda$1 * scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log(1.0 - q)) / this.k$1);
            }
            {
                this.lambda$1 = lambda$1;
                this.k$1 = k$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return Vectors$.MODULE$.dense(quantiles);
    }

    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.predict(features);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictQuantilesUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionModel $outer;

            public final Vector apply(Vector features) {
                return this.$outer.predictQuantiles(features);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(this)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(this)));
        return this.hasQuantilesCol() ? dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).withColumn(this.$(this.quantilesCol()), predictQuantilesUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))) : dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, false);
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients2, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients2;
        this.intercept = intercept;
        this.scale = scale;
        HasFeaturesCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        AFTSurvivalRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private final AFTSurvivalRegressionModel instance;
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$lzycompute() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$module != null) return this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$module;
                this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                return this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$module;
            }
        }

        public AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data() {
            return this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$module == null ? this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$lzycompute() : this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data().apply(this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1(this))).repartition(1).write().parquet(dataPath);
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients2, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients2, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 0: {
                        object = this.coefficients();
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients2, double intercept, double scale) {
                this.coefficients = coefficients2;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Dataset data = this.sparkSession().read().parquet(dataPath);
            Row row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
            Some some = Row$.MODULE$.unapplySeq(row);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                Object coefficients2 = ((SeqLike)some.get()).apply(0);
                Object intercept = ((SeqLike)some.get()).apply(1);
                Object scale = ((SeqLike)some.get()).apply(2);
                if (coefficients2 instanceof Vector) {
                    Vector vector = (Vector)coefficients2;
                    if (intercept instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)intercept);
                        if (scale instanceof Double) {
                            Tuple3 tuple3;
                            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
                            Tuple3 tuple32 = tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
                            Vector coefficients3 = (Vector)tuple32._1();
                            double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients3, intercept2, scale2);
                            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
                            return model;
                        }
                    }
                }
            }
            throw new MatchError((Object)row);
        }
    }
}

