/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import org.apache.spark.mllib.clustering.ExpectationSum;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ExpectationSum$
implements Serializable {
    public static final ExpectationSum$ MODULE$;

    static {
        new ExpectationSum$();
    }

    public ExpectationSum zero(int k, int d) {
        return new ExpectationSum(0.0, (double[])Array$.MODULE$.fill(k, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double()), (DenseVector[])Array$.MODULE$.fill(k, (Function0)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final int d$1;

            public final DenseVector<Object> apply() {
                return DenseVector$.MODULE$.zeros$mDc$sp(this.d$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            }
            {
                this.d$1 = d$1;
            }
        }, ClassTag$.MODULE$.apply(DenseVector.class)), (DenseMatrix[])Array$.MODULE$.fill(k, (Function0)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final int d$1;

            public final DenseMatrix<Object> apply() {
                return DenseMatrix$.MODULE$.zeros$mDc$sp(this.d$1, this.d$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            }
            {
                this.d$1 = d$1;
            }
        }, ClassTag$.MODULE$.apply(DenseMatrix.class)));
    }

    public ExpectationSum add(double[] weights, MultivariateGaussian[] dists, ExpectationSum sums, Vector<Object> x) {
        double[] p = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(weights).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(x){
            public static final long serialVersionUID = 0L;
            private final Vector x$7;

            public final double apply(Tuple2<Object, MultivariateGaussian> x0$2) {
                Tuple2<Object, MultivariateGaussian> tuple2 = x0$2;
                if (tuple2 != null) {
                    double weight = tuple2._1$mcD$sp();
                    MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
                    double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((Vector<Object>)this.x$7);
                    return d;
                }
                throw new MatchError(tuple2);
            }
            {
                this.x$7 = x$7;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(p).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        sums.logLikelihood_$eq(sums.logLikelihood() + package$.MODULE$.log(pSum));
        for (int i = 0; i < sums.k(); ++i) {
            int n = i;
            p[n] = p[n] / pSum;
            int n2 = i;
            sums.weights()[n2] = sums.weights()[n2] + p[i];
            sums.means()[i].$plus$eq(x.$times((Object)BoxesRunTime.boxToDouble((double)p[i]), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
            BLAS$.MODULE$.syr(p[i], Vectors$.MODULE$.fromBreeze(x), (org.apache.spark.mllib.linalg.DenseMatrix)Matrices$.MODULE$.fromBreeze((Matrix<Object>)sums.sigmas()[i]));
        }
        return sums;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExpectationSum$() {
        MODULE$ = this;
    }
}

