/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class KMeans$
implements Serializable {
    public static final KMeans$ MODULE$;
    private final String RANDOM;
    private final String K_MEANS_PARALLEL;

    static {
        new KMeans$();
    }

    public String RANDOM() {
        return this.RANDOM;
    }

    public String K_MEANS_PARALLEL() {
        return this.K_MEANS_PARALLEL;
    }

    public KMeansModel train(RDD<Vector> data, int k, int maxIterations, int runs, String initializationMode, long seed) {
        return new KMeans().setK(k).setMaxIterations(maxIterations).setInitializationMode(initializationMode).setSeed(seed).run(data);
    }

    public KMeansModel train(RDD<Vector> data, int k, int maxIterations, int runs, String initializationMode) {
        return new KMeans().setK(k).setMaxIterations(maxIterations).setInitializationMode(initializationMode).run(data);
    }

    public KMeansModel train(RDD<Vector> data, int k, int maxIterations) {
        return this.train(data, k, maxIterations, 1, this.K_MEANS_PARALLEL());
    }

    public KMeansModel train(RDD<Vector> data, int k, int maxIterations, int runs) {
        return this.train(data, k, maxIterations, runs, this.K_MEANS_PARALLEL());
    }

    public Tuple2<Object, Object> findClosest(TraversableOnce<VectorWithNorm> centers, VectorWithNorm point) {
        DoubleRef bestDistance = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        IntRef bestIndex = IntRef.create((int)0);
        IntRef i = IntRef.create((int)0);
        centers.foreach((Function1)new Serializable(point, bestDistance, bestIndex, i){
            public static final long serialVersionUID = 0L;
            private final VectorWithNorm point$1;
            private final DoubleRef bestDistance$1;
            private final IntRef bestIndex$1;
            private final IntRef i$1;

            public final void apply(VectorWithNorm center) {
                double distance;
                double lowerBoundOfSqDist = center.norm() - this.point$1.norm();
                if ((lowerBoundOfSqDist *= lowerBoundOfSqDist) < this.bestDistance$1.elem && (distance = KMeans$.MODULE$.fastSquaredDistance(center, this.point$1)) < this.bestDistance$1.elem) {
                    this.bestDistance$1.elem = distance;
                    this.bestIndex$1.elem = this.i$1.elem;
                }
                ++this.i$1.elem;
            }
            {
                this.point$1 = point$1;
                this.bestDistance$1 = bestDistance$1;
                this.bestIndex$1 = bestIndex$1;
                this.i$1 = i$1;
            }
        });
        return new Tuple2.mcID.sp(bestIndex.elem, bestDistance.elem);
    }

    public double pointCost(TraversableOnce<VectorWithNorm> centers, VectorWithNorm point) {
        return this.findClosest(centers, point)._2$mcD$sp();
    }

    public double fastSquaredDistance(VectorWithNorm v1, VectorWithNorm v2) {
        return MLUtils$.MODULE$.fastSquaredDistance(v1.vector(), v1.norm(), v2.vector(), v2.norm(), MLUtils$.MODULE$.fastSquaredDistance$default$5());
    }

    public boolean validateInitMode(String initMode) {
        boolean bl;
        String string = initMode;
        String string2 = this.RANDOM();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = this.K_MEANS_PARALLEL();
            String string5 = string;
            bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        return bl;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KMeans$() {
        MODULE$ = this;
        this.RANDOM = "random";
        this.K_MEANS_PARALLEL = "k-means||";
    }
}

