/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$13$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$22$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.immutable.ParSeq;
import scala.collection.parallel.immutable.ParSeq$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\teh\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\tS:$XM\u001d8bY&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0011!q\u0002A!a\u0001\n\u0013y\u0012!A6\u0016\u0003\u0001\u0002\"aD\u0011\n\u0005\t\u0002\"aA%oi\"AA\u0005\u0001BA\u0002\u0013%Q%A\u0003l?\u0012*\u0017\u000f\u0006\u0002'SA\u0011qbJ\u0005\u0003QA\u0011A!\u00168ji\"9!fIA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!AA\u0006\u0001B\u0001B\u0003&\u0001%\u0001\u0002lA!Aa\u0006\u0001BA\u0002\u0013%q$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\ta\u0001\u0011\t\u0019!C\u0005c\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0019\u0012\u0004b\u0002\u00160\u0003\u0003\u0005\r\u0001\t\u0005\ti\u0001\u0011\t\u0011)Q\u0005A\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u0010\u0002\tI,hn\u001d\u0005\tq\u0001\u0011\t\u0019!C\u0005s\u0005A!/\u001e8t?\u0012*\u0017\u000f\u0006\u0002'u!9!fNA\u0001\u0002\u0004\u0001\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0011\u0002\u000bI,hn\u001d\u0011\t\u0011y\u0002!\u00111A\u0005\n}\n!#\u001b8ji&\fG.\u001b>bi&|g.T8eKV\t\u0001\t\u0005\u0002B\t:\u0011qBQ\u0005\u0003\u0007B\ta\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111\t\u0005\u0005\t\u0011\u0002\u0011\t\u0019!C\u0005\u0013\u00061\u0012N\\5uS\u0006d\u0017N_1uS>tWj\u001c3f?\u0012*\u0017\u000f\u0006\u0002'\u0015\"9!fRA\u0001\u0002\u0004\u0001\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0015\u0002!\u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0011\t\u00119\u0003!\u00111A\u0005\n}\t1#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faND\u0001\u0002\u0015\u0001\u0003\u0002\u0004%I!U\u0001\u0018S:LG/[1mSj\fG/[8o'R,\u0007o]0%KF$\"A\n*\t\u000f)z\u0015\u0011!a\u0001A!AA\u000b\u0001B\u0001B\u0003&\u0001%\u0001\u000bj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\t\u0005\t-\u0002\u0011\t\u0019!C\u0005/\u00069Q\r]:jY>tW#\u0001-\u0011\u0005=I\u0016B\u0001.\u0011\u0005\u0019!u.\u001e2mK\"AA\f\u0001BA\u0002\u0013%Q,A\u0006faNLGn\u001c8`I\u0015\fHC\u0001\u0014_\u0011\u001dQ3,!AA\u0002aC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006K\u0001W\u0001\tKB\u001c\u0018\u000e\\8oA!A!\r\u0001BA\u0002\u0013%1-\u0001\u0003tK\u0016$W#\u00013\u0011\u0005=)\u0017B\u00014\u0011\u0005\u0011auN\\4\t\u0011!\u0004!\u00111A\u0005\n%\f\u0001b]3fI~#S-\u001d\u000b\u0003M)DqAK4\u0002\u0002\u0003\u0007A\r\u0003\u0005m\u0001\t\u0005\t\u0015)\u0003e\u0003\u0015\u0019X-\u001a3!\u0011\u0015q\u0007\u0001\"\u0003p\u0003\u0019a\u0014N\\5u}QA\u0001O]:ukZ<\b\u0010\u0005\u0002r\u00015\t!\u0001C\u0003\u001f[\u0002\u0007\u0001\u0005C\u0003/[\u0002\u0007\u0001\u0005C\u00037[\u0002\u0007\u0001\u0005C\u0003?[\u0002\u0007\u0001\tC\u0003O[\u0002\u0007\u0001\u0005C\u0003W[\u0002\u0007\u0001\fC\u0003c[\u0002\u0007A\rC\u0003o\u0001\u0011\u0005!\u0010F\u0001qQ\u0011IH0!\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyh!\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001\u007f\u0005\u0015\u0019\u0016N\\2fC\t\t9!A\u00031]ar\u0003\u0007\u0003\u0004\u0002\f\u0001!\taH\u0001\u0005O\u0016$8\nK\u0003\u0002\nq\fy!\t\u0002\u0002\u0012\u0005)\u0011G\f\u001b/a!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011\u0001B:fi.#B!!\u0007\u0002\u001c5\t\u0001\u0001\u0003\u0004\u001f\u0003'\u0001\r\u0001\t\u0015\u0006\u0003'a\u0018Q\u0001\u0005\u0007\u0003C\u0001A\u0011A\u0010\u0002!\u001d,G/T1y\u0013R,'/\u0019;j_:\u001c\b&BA\u0010y\u0006=\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\u0011g\u0016$X*\u0019=Ji\u0016\u0014\u0018\r^5p]N$B!!\u0007\u0002,!1a&!\nA\u0002\u0001BS!!\n}\u0003\u000bAa!!\r\u0001\t\u0003y\u0014!F4fi&s\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0015\u0006\u0003_a\u0018q\u0002\u0005\b\u0003o\u0001A\u0011AA\u001d\u0003U\u0019X\r^%oSRL\u0017\r\\5{CRLwN\\'pI\u0016$B!!\u0007\u0002<!1a(!\u000eA\u0002\u0001CS!!\u000e}\u0003\u000bAa!!\u0011\u0001\t\u0003y\u0012aB4fiJ+hn\u001d\u0015\u0006\u0003\u007fa\u0018q\u0002\u0005\b\u0003\u000f\u0002A\u0011AA%\u0003\u001d\u0019X\r\u001e*v]N$B!!\u0007\u0002L!1a'!\u0012A\u0002\u0001BS!!\u0012}\u0003\u000bAa!!\u0015\u0001\t\u0003y\u0012AF4fi&s\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:)\u000b\u0005=C0a\u0004\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z\u000512/\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\u0006\u0003\u0002\u001a\u0005m\u0003B\u0002(\u0002V\u0001\u0007\u0001\u0005K\u0003\u0002Vq\f)\u0001\u0003\u0004\u0002b\u0001!\taV\u0001\u000bO\u0016$X\t]:jY>t\u0007&BA0y\u0006=\u0001bBA4\u0001\u0011\u0005\u0011\u0011N\u0001\u000bg\u0016$X\t]:jY>tG\u0003BA\r\u0003WBaAVA3\u0001\u0004A\u0006&BA3y\u0006\u0015\u0001BBA9\u0001\u0011\u00051-A\u0004hKR\u001cV-\u001a3)\u000b\u0005=D0a\u0004\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u000591/\u001a;TK\u0016$G\u0003BA\r\u0003wBaAYA;\u0001\u0004!\u0007&BA;y\u0006=\u0001\"CAA\u0001\u0001\u0007I\u0011BAB\u00031Ig.\u001b;jC2lu\u000eZ3m+\t\t)\tE\u0003\u0010\u0003\u000f\u000bY)C\u0002\u0002\nB\u0011aa\u00149uS>t\u0007cA9\u0002\u000e&\u0019\u0011q\u0012\u0002\u0003\u0017-kU-\u00198t\u001b>$W\r\u001c\u0005\n\u0003'\u0003\u0001\u0019!C\u0005\u0003+\u000b\u0001#\u001b8ji&\fG.T8eK2|F%Z9\u0015\u0007\u0019\n9\nC\u0005+\u0003#\u000b\t\u00111\u0001\u0002\u0006\"A\u00111\u0014\u0001!B\u0013\t))A\u0007j]&$\u0018.\u00197N_\u0012,G\u000e\t\u0005\b\u0003?\u0003A\u0011AAQ\u0003=\u0019X\r^%oSRL\u0017\r\\'pI\u0016dG\u0003BA\r\u0003GC\u0001\"!*\u0002\u001e\u0002\u0007\u00111R\u0001\u0006[>$W\r\u001c\u0015\u0006\u0003;c\u0018q\u0002\u0005\b\u0003W\u0003A\u0011AAW\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u0017\u000by\u000b\u0003\u0005\u00022\u0006%\u0006\u0019AAZ\u0003\u0011!\u0017\r^1\u0011\r\u0005U\u00161XA`\u001b\t\t9LC\u0002\u0002:\u001a\t1A\u001d3e\u0013\u0011\ti,a.\u0003\u0007I#E\t\u0005\u0003\u0002B\u0006\u001dWBAAb\u0015\r\t)\rB\u0001\u0007Y&t\u0017\r\\4\n\t\u0005%\u00171\u0019\u0002\u0007-\u0016\u001cGo\u001c:)\u000b\u0005%F0!\u0002\t\u0011\u0005-\u0006\u0001\"\u0001\u0007\u0003\u001f$b!a#\u0002R\u0006M\u0007\u0002CAY\u0003\u001b\u0004\r!a-\t\u0011\u0005U\u0017Q\u001aa\u0001\u0003/\fQ!\u001b8tiJ\u0004RaDAD\u00033\u0004b!a7\u0002f\u0006%XBAAo\u0015\u0011\ty.!9\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003G4\u0011AA7m\u0013\u0011\t9/!8\u0003\u001f%s7\u000f\u001e:v[\u0016tG/\u0019;j_:\u0004B!a;\u0002p6\u0011\u0011Q\u001e\u0006\u0004\u0007\u0005\u0005\u0018bA\u0001\u0002n\"9\u00111\u001f\u0001\u0005\n\u0005U\u0018\u0001\u0004:v]\u0006cwm\u001c:ji\"lGCBAF\u0003o\u0014\t\u0001\u0003\u0005\u00022\u0006E\b\u0019AA}!\u0019\t),a/\u0002|B\u0019\u0011/!@\n\u0007\u0005}(A\u0001\bWK\u000e$xN],ji\"tuN]7\t\u0011\u0005U\u0017\u0011\u001fa\u0001\u0003/DqA!\u0002\u0001\t\u0013\u00119!\u0001\u0006j]&$(+\u00198e_6$BA!\u0003\u0003\u0012A)qBa\u0003\u0003\u0010%\u0019!Q\u0002\t\u0003\u000b\u0005\u0013(/Y=\u0011\u000b=\u0011Y!a?\t\u0011\u0005E&1\u0001a\u0001\u0003sDqA!\u0006\u0001\t\u0013\u00119\"\u0001\nj]&$8*T3b]N\u0004\u0016M]1mY\u0016dG\u0003\u0002B\u0005\u00053A\u0001\"!-\u0003\u0014\u0001\u0007\u0011\u0011 \u0015\u0005\u0001q\f)aB\u0004\u0003 \tA\tA!\t\u0002\r-kU-\u00198t!\r\t(1\u0005\u0004\u0007\u0003\tA\tA!\n\u0014\t\t\rb\u0002\u0006\u0005\b]\n\rB\u0011\u0001B\u0015)\t\u0011\t\u0003\u0003\u0006\u0003.\t\r\"\u0019!C\u0001\u0005_\taAU!O\t>kUC\u0001B\u0019!\u0011\u0011\u0019D!\u0010\u000e\u0005\tU\"\u0002\u0002B\u001c\u0005s\tA\u0001\\1oO*\u0011!1H\u0001\u0005U\u00064\u0018-C\u0002F\u0005kASAa\u000b}\u0003\u000bA\u0011Ba\u0011\u0003$\u0001\u0006IA!\r\u0002\u000fI\u000be\nR(NA!*!\u0011\t?\u0002\u0006!Q!\u0011\nB\u0012\u0005\u0004%\tAa\f\u0002!-{V*R!O'~\u0003\u0016IU!M\u0019\u0016c\u0005&\u0002B$y\u0006\u0015\u0001\"\u0003B(\u0005G\u0001\u000b\u0011\u0002B\u0019\u0003EYu,T#B\u001dN{\u0006+\u0011*B\u00192+E\n\t\u0015\u0006\u0005\u001bb\u0018Q\u0001\u0005\t\u0005+\u0012\u0019\u0003\"\u0001\u0003X\u0005)AO]1j]Rq\u00111\u0012B-\u00057\u0012iFa\u0018\u0003b\t\r\u0004\u0002CAY\u0005'\u0002\r!a-\t\ry\u0011\u0019\u00061\u0001!\u0011\u0019q#1\u000ba\u0001A!1aGa\u0015A\u0002\u0001BaA\u0010B*\u0001\u0004\u0001\u0005B\u00022\u0003T\u0001\u0007A\rK\u0003\u0003Tq\u00149'\t\u0002\u0003j\u0005)\u0011GL\u001a/a!A!Q\u000bB\u0012\t\u0003\u0011i\u0007\u0006\u0007\u0002\f\n=$\u0011\u000fB:\u0005k\u00129\b\u0003\u0005\u00022\n-\u0004\u0019AAZ\u0011\u0019q\"1\u000ea\u0001A!1aFa\u001bA\u0002\u0001BaA\u000eB6\u0001\u0004\u0001\u0003B\u0002 \u0003l\u0001\u0007\u0001\tK\u0003\u0003lq\f)\u0001\u0003\u0005\u0003V\t\rB\u0011\u0001B?)!\tYIa \u0003\u0002\n\r\u0005\u0002CAY\u0005w\u0002\r!a-\t\ry\u0011Y\b1\u0001!\u0011\u0019q#1\u0010a\u0001A!*!1\u0010?\u0002\u0006!A!Q\u000bB\u0012\t\u0003\u0011I\t\u0006\u0006\u0002\f\n-%Q\u0012BH\u0005#C\u0001\"!-\u0003\b\u0002\u0007\u00111\u0017\u0005\u0007=\t\u001d\u0005\u0019\u0001\u0011\t\r9\u00129\t1\u0001!\u0011\u00191$q\u0011a\u0001A!*!q\u0011?\u0002\u0006!I!q\u0013B\u0012\t\u0003!!\u0011T\u0001\fM&tGm\u00117pg\u0016\u001cH\u000f\u0006\u0004\u0003\u001c\n\u0005&Q\u0018\t\u0006\u001f\tu\u0005\u0005W\u0005\u0004\u0005?\u0003\"A\u0002+va2,'\u0007\u0003\u0005\u0003$\nU\u0005\u0019\u0001BS\u0003\u001d\u0019WM\u001c;feN\u0004bAa*\u00038\u0006mh\u0002\u0002BU\u0005gsAAa+\u000326\u0011!Q\u0016\u0006\u0004\u0005_c\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\r\u0011)\fE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011ILa/\u0003\u001fQ\u0013\u0018M^3sg\u0006\u0014G.Z(oG\u0016T1A!.\u0011\u0011!\u0011yL!&A\u0002\u0005m\u0018!\u00029pS:$\b\"\u0003Bb\u0005G!\t\u0001\u0002Bc\u0003%\u0001x.\u001b8u\u0007>\u001cH\u000fF\u0003Y\u0005\u000f\u0014I\r\u0003\u0005\u0003$\n\u0005\u0007\u0019\u0001BS\u0011!\u0011yL!1A\u0002\u0005m\b\"\u0003Bg\u0005G!\tA\u0001Bh\u0003M1\u0017m\u001d;TcV\f'/\u001a3ESN$\u0018M\\2f)\u0015A&\u0011\u001bBk\u0011!\u0011\u0019Na3A\u0002\u0005m\u0018A\u0001<2\u0011!\u00119Na3A\u0002\u0005m\u0018A\u0001<3\u0011%\u0011YNa\t\u0005\u0002\u0019\u0011i.\u0001\twC2LG-\u0019;f\u0013:LG/T8eKR!!q\u001cBs!\ry!\u0011]\u0005\u0004\u0005G\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005O\u0014I\u000e1\u0001A\u0003!Ig.\u001b;N_\u0012,\u0007B\u0003Bv\u0005G\t\t\u0011\"\u0003\u0003n\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u000f\u0005\u0003\u00034\tE\u0018\u0002\u0002Bz\u0005k\u0011aa\u00142kK\u000e$\b&\u0002B\u0012y\u0006\u0015\u0001&\u0002B\u000fy\u0006\u0015\u0001")
public class KMeans
implements Serializable,
Logging {
    private int org$apache$spark$mllib$clustering$KMeans$$k;
    private int org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    private int org$apache$spark$mllib$clustering$KMeans$$runs;
    private String org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    private int initializationSteps;
    private double org$apache$spark$mllib$clustering$KMeans$$epsilon;
    private long seed;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int org$apache$spark$mllib$clustering$KMeans$$k() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$maxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$runs() {
        return this.org$apache$spark$mllib$clustering$KMeans$$runs;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$runs_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$runs = x$1;
    }

    public String org$apache$spark$mllib$clustering$KMeans$$initializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(String x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    public double org$apache$spark$mllib$clustering$KMeans$$epsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(double x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    public int getK() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of clusters must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0)new Serializable(this, maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum of iterations must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(initializationMode);
        return this;
    }

    public int getRuns() {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Getting number of runs has no effect since Spark 2.0.0.";
            }
        });
        return this.org$apache$spark$mllib$clustering$KMeans$$runs();
    }

    public KMeans setRuns(int runs) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting number of runs has no effect since Spark 2.0.0.";
            }
        });
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0)new Serializable(this, initializationSteps){
            public static final long serialVersionUID = 0L;
            private final int initializationSteps$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of initialization steps must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.initializationSteps$1)}));
            }
            {
                this.initializationSteps$1 = initializationSteps$1;
            }
        });
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0)new Serializable(this, epsilon){
            public static final long serialVersionUID = 0L;
            private final double epsilon$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distance threshold must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.epsilon$1)}));
            }
            {
                this.epsilon$1 = epsilon$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.org$apache$spark$mllib$clustering$KMeans$$k(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "mismatched cluster count";
            }
        });
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        return this.run(data, (Option<Instrumentation<org.apache.spark.ml.clustering.KMeans>>)None$.MODULE$);
    }

    public KMeansModel run(RDD<Vector> data, Option<Instrumentation<org.apache.spark.ml.clustering.KMeans>> instr) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        RDD norms = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector x$1) {
                return Vectors$.MODULE$.norm(x$1, 2.0);
            }
        }, ClassTag$.MODULE$.Double());
        norms.persist();
        RDD zippedData = data.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector v = (Vector)tuple2._1();
                    double norm2 = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm2);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        KMeansModel model = this.runAlgorithm((RDD<VectorWithNorm>)zippedData, instr);
        norms.unpersist(norms.unpersist$default$1());
        StorageLevel storageLevel3 = data.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        return model;
    }

    private KMeansModel runAlgorithm(RDD<VectorWithNorm> data, Option<Instrumentation<org.apache.spark.ml.clustering.KMeans>> instr) {
        Option<KMeansModel> option;
        block12: {
            VectorWithNorm[][] vectorWithNormArray;
            int numRuns;
            long initStartTime;
            SparkContext sc;
            block11: {
                block10: {
                    int n;
                    sc = data.sparkContext();
                    initStartTime = System.nanoTime();
                    if (this.initialModel().nonEmpty()) {
                        if (this.org$apache$spark$mllib$clustering$KMeans$$runs() > 1) {
                            this.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Ignoring runs; one run is allowed when initialModel is given.";
                                }
                            });
                        }
                        n = 1;
                    } else {
                        n = this.org$apache$spark$mllib$clustering$KMeans$$runs();
                    }
                    numRuns = n;
                    option = this.initialModel();
                    if (!(option instanceof Some)) break block10;
                    Some some = (Some)option;
                    KMeansModel kMeansCenters = (KMeansModel)some.x();
                    vectorWithNormArray = (VectorWithNorm[][])((Object[])new VectorWithNorm[][]{(VectorWithNorm[])Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final VectorWithNorm apply(Vector s) {
                            return new VectorWithNorm(s);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)))});
                    break block11;
                }
                if (!None$.MODULE$.equals(option)) break block12;
                String string = this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
                String string2 = KMeans$.MODULE$.RANDOM();
                vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data);
            }
            VectorWithNorm[][] centers = vectorWithNormArray;
            double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, initTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final double initTimeInSeconds$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialization with ", " took "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$clustering$KMeans$$initializationMode()}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.initTimeInSeconds$1)}))).append((Object)" seconds.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.initTimeInSeconds$1 = initTimeInSeconds$1;
                }
            });
            boolean[] active = (boolean[])Array$.MODULE$.fill(numRuns, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return true;
                }
            }, ClassTag$.MODULE$.Boolean());
            double[] costs = (double[])Array$.MODULE$.fill(numRuns, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return 0.0;
                }
            }, ClassTag$.MODULE$.Double());
            ArrayBuffer activeRuns = (ArrayBuffer)new ArrayBuffer().$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRuns));
            IntRef iteration = IntRef.create((int)0);
            long iterationStartTime = System.nanoTime();
            instr.map((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm[][] centers$1;

                public final void apply(Instrumentation<org.apache.spark.ml.clustering.KMeans> x$2) {
                    x$2.logNumFeatures(this.centers$1[0][0].vector().size());
                }
                {
                    this.centers$1 = centers$1;
                }
            });
            while (iteration.elem < this.org$apache$spark$mllib$clustering$KMeans$$maxIterations() && !activeRuns.isEmpty()) {
                VectorWithNorm[][] activeCenters = (VectorWithNorm[][])((TraversableOnce)activeRuns.map((Function1)new Serializable(this, centers){
                    public static final long serialVersionUID = 0L;
                    private final VectorWithNorm[][] centers$1;

                    public final VectorWithNorm[] apply(int r) {
                        return this.centers$1[r];
                    }
                    {
                        this.centers$1 = centers$1;
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
                ArrayBuffer costAccums = (ArrayBuffer)activeRuns.map((Function1)new Serializable(this, sc){
                    public static final long serialVersionUID = 0L;
                    private final SparkContext sc$1;

                    public final DoubleAccumulator apply(int x$3) {
                        return this.sc$1.doubleAccumulator();
                    }
                    {
                        this.sc$1 = sc$1;
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                Broadcast bcActiveCenters = sc.broadcast((Object)activeCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class))));
                Map totalContribs = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1)new Serializable(this, costAccums, bcActiveCenters){
                    public static final long serialVersionUID = 0L;
                    public final ArrayBuffer costAccums$1;
                    private final Broadcast bcActiveCenters$1;

                    public final Iterator<Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>>> apply(Iterator<VectorWithNorm> points) {
                        VectorWithNorm[][] thisActiveCenters = (VectorWithNorm[][])this.bcActiveCenters$1.value();
                        int runs = thisActiveCenters.length;
                        int k = thisActiveCenters[0].length;
                        int dims = thisActiveCenters[0][0].vector().size();
                        Vector[][] sums = (Vector[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this, dims){
                            public static final long serialVersionUID = 0L;
                            private final int dims$1;

                            public final Vector apply() {
                                return Vectors$.MODULE$.zeros(this.dims$1);
                            }
                            {
                                this.dims$1 = dims$1;
                            }
                        }, ClassTag$.MODULE$.apply(Vector.class));
                        long[][] counts = (long[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }, ClassTag$.MODULE$.Long());
                        points.foreach((Function1)new Serializable(this, thisActiveCenters, runs, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$13 $outer;
                            public final VectorWithNorm[][] thisActiveCenters$1;
                            private final int runs$1;
                            public final Vector[][] sums$1;
                            public final long[][] counts$1;

                            public final void apply(VectorWithNorm point) {
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.runs$1).foreach$mVc$sp((Function1)new Serializable(this, point){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$13$$anonfun$apply$4 $outer;
                                    private final VectorWithNorm point$3;

                                    public final void apply(int i) {
                                        this.apply$mcVI$sp(i);
                                    }

                                    public void apply$mcVI$sp(int i) {
                                        Tuple2<Object, Object> tuple2 = KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)Predef$.MODULE$.refArrayOps((Object[])this.$outer.thisActiveCenters$1[i]), this.point$3);
                                        if (tuple2 != null) {
                                            Tuple2.mcID.sp sp2;
                                            int bestCenter = tuple2._1$mcI$sp();
                                            double cost = tuple2._2$mcD$sp();
                                            Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(bestCenter, cost);
                                            int bestCenter2 = sp3._1$mcI$sp();
                                            double cost2 = sp3._2$mcD$sp();
                                            ((DoubleAccumulator)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().costAccums$1.apply(i)).add(cost2);
                                            Vector sum = this.$outer.sums$1[i][bestCenter2];
                                            BLAS$.MODULE$.axpy(1.0, this.point$3.vector(), sum);
                                            long[] lArray = this.$outer.counts$1[i];
                                            lArray[bestCenter2] = lArray[bestCenter2] + 1L;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.point$3 = point$3;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$13 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.thisActiveCenters$1 = thisActiveCenters$1;
                                this.runs$1 = runs$1;
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        });
                        IndexedSeq contribs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), runs).flatMap((Function1)new Serializable(this, k, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final int k$2;
                            public final Vector[][] sums$1;
                            public final long[][] counts$1;

                            public final IndexedSeq<Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>>> apply(int i) {
                                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.k$2).map((Function1)new Serializable(this, i){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$13$$anonfun$15 $outer;
                                    private final int i$2;

                                    public final Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>> apply(int j) {
                                        return new Tuple2((Object)new Tuple2.mcII.sp(this.i$2, j), (Object)new Tuple2((Object)this.$outer.sums$1[this.i$2][j], (Object)BoxesRunTime.boxToLong((long)this.$outer.counts$1[this.i$2][j])));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.i$2 = i$2;
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.k$2 = k$2;
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        return contribs.iterator();
                    }
                    {
                        this.costAccums$1 = costAccums$1;
                        this.bcActiveCenters$1 = bcActiveCenters$1;
                    }
                }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;

                    public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> x, Tuple2<Vector, Object> y) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(x, y);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
                bcActiveCenters.unpersist(false);
                ((TraversableLike)activeRuns.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                        Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, centers, active, costs, iteration, costAccums, totalContribs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;
                    private final VectorWithNorm[][] centers$1;
                    private final boolean[] active$1;
                    private final double[] costs$1;
                    public final IntRef iteration$1;
                    private final ArrayBuffer costAccums$1;
                    private final Map totalContribs$1;

                    public final void apply(Tuple2<Object, Object> x$6) {
                        Tuple2<Object, Object> tuple2 = x$6;
                        if (tuple2 != null) {
                            int run2 = tuple2._1$mcI$sp();
                            int i = tuple2._2$mcI$sp();
                            boolean changed = false;
                            for (int j = 0; j < this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(); ++j) {
                                Tuple2 tuple22 = (Tuple2)this.totalContribs$1.apply((Object)new Tuple2.mcII.sp(i, j));
                                if (tuple22 != null) {
                                    Tuple2 tuple23;
                                    Vector sum = (Vector)tuple22._1();
                                    long count = tuple22._2$mcJ$sp();
                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)sum, (Object)BoxesRunTime.boxToLong((long)count));
                                    Vector sum2 = (Vector)tuple24._1();
                                    long count2 = tuple24._2$mcJ$sp();
                                    if (count2 == 0L) continue;
                                    BLAS$.MODULE$.scal(1.0 / (double)count2, sum2);
                                    VectorWithNorm newCenter = new VectorWithNorm(sum2);
                                    if (KMeans$.MODULE$.fastSquaredDistance(newCenter, this.centers$1[run2][j]) > this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon() * this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon()) {
                                        changed = true;
                                    }
                                    this.centers$1[run2][j] = newCenter;
                                    continue;
                                }
                                throw new MatchError((Object)tuple22);
                            }
                            if (!changed) {
                                this.active$1[run2] = false;
                                this.$outer.logInfo((Function0<String>)new Serializable(this, run2){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$runAlgorithm$5 $outer;
                                    private final int run$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Run ").append((Object)BoxesRunTime.boxToInteger((int)this.run$1)).append((Object)" finished in ").append((Object)BoxesRunTime.boxToInteger((int)(this.$outer.iteration$1.elem + 1))).append((Object)" iterations").toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.run$1 = run$1;
                                    }
                                });
                            }
                            this.costs$1[run2] = Predef$.MODULE$.Double2double(((DoubleAccumulator)this.costAccums$1.apply(i)).value());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.centers$1 = centers$1;
                        this.active$1 = active$1;
                        this.costs$1 = costs$1;
                        this.iteration$1 = iteration$1;
                        this.costAccums$1 = costAccums$1;
                        this.totalContribs$1 = totalContribs$1;
                    }
                });
                activeRuns = (ArrayBuffer)activeRuns.filter((Function1)new Serializable(this, active){
                    public static final long serialVersionUID = 0L;
                    private final boolean[] active$1;

                    public final boolean apply(int x$7) {
                        return this.apply$mcZI$sp(x$7);
                    }

                    public boolean apply$mcZI$sp(int x$7) {
                        return this.active$1[x$7];
                    }
                    {
                        this.active$1 = active$1;
                    }
                });
                ++iteration.elem;
            }
            double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, iterationTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final double iterationTimeInSeconds$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations took "})).s((Seq)Nil$.MODULE$)).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.iterationTimeInSeconds$1)}))).append((Object)" seconds.").toString();
                }
                {
                    this.iterationTimeInSeconds$1 = iterationTimeInSeconds$1;
                }
            });
            if (iteration.elem == this.org$apache$spark$mllib$clustering$KMeans$$maxIterations()) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$KMeans$$maxIterations())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this, iteration){
                    public static final long serialVersionUID = 0L;
                    private final IntRef iteration$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                    }
                    {
                        this.iteration$1 = iteration$1;
                    }
                });
            }
            Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(costs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
            if (tuple2 != null) {
                Tuple2.mcDI.sp sp2;
                double minCost = tuple2._1$mcD$sp();
                int bestRun = tuple2._2$mcI$sp();
                Tuple2.mcDI.sp sp3 = sp2 = new Tuple2.mcDI.sp(minCost, bestRun);
                double minCost2 = sp3._1$mcD$sp();
                int bestRun2 = sp3._2$mcI$sp();
                this.logInfo((Function0<String>)new Serializable(this, minCost2){
                    public static final long serialVersionUID = 0L;
                    private final double minCost$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cost for the best run is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minCost$1)}));
                    }
                    {
                        this.minCost$1 = minCost$1;
                    }
                });
                return new KMeansModel((Vector[])Predef$.MODULE$.refArrayOps((Object[])centers[bestRun2]).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(VectorWithNorm x$9) {
                        return x$9.vector();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))));
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(option);
    }

    private VectorWithNorm[][] initRandom(RDD<VectorWithNorm> data) {
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs() * this.org$apache$spark$mllib$clustering$KMeans$$k(), (long)new XORShiftRandom(this.seed()).nextInt())).toSeq();
        return (VectorWithNorm[][])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final Seq sample$1;

            public final VectorWithNorm[] apply(int r) {
                return (VectorWithNorm[])((TraversableOnce)((TraversableLike)this.sample$1.slice(r * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), (r + 1) * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final VectorWithNorm apply(VectorWithNorm v) {
                        return new VectorWithNorm(Vectors$.MODULE$.dense(v.vector().toArray()), v.norm());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sample$1 = sample$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
    }

    private VectorWithNorm[][] initKMeansParallel(RDD<VectorWithNorm> data) {
        ArrayBuffer[] centers = (ArrayBuffer[])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<VectorWithNorm> apply(int r) {
                return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        RDD costs = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;

            public final double[] apply(VectorWithNorm x$10) {
                return (double[])Array$.MODULE$.fill(this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Double.POSITIVE_INFINITY;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int seed = new XORShiftRandom(this.seed()).nextInt();
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs(), (long)seed)).toSeq();
        Predef$.MODULE$.require(sample.size() >= this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function0)new Serializable(this, data, sample){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final RDD data$1;
            private final Seq sample$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Required ", " samples but got ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs()), BoxesRunTime.boxToInteger((int)this.sample$2.size()), this.data$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.data$1 = data$1;
                this.sample$2 = sample$2;
            }
        });
        ArrayBuffer[] newCenters = (ArrayBuffer[])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final Seq sample$2;

            public final ArrayBuffer<VectorWithNorm> apply(int r) {
                return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VectorWithNorm[]{((VectorWithNorm)this.sample$2.apply(r)).toDense()}));
            }
            {
                this.sample$2 = sample$2;
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        IntRef step = IntRef.create((int)0);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ArrayBuffer.class)));
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).map((Function1)new Serializable(this, bcNewCenters){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                public final Broadcast bcNewCenters$1;

                public final double[] apply(Tuple2<VectorWithNorm, double[]> x0$2) {
                    Tuple2<VectorWithNorm, double[]> tuple2 = x0$2;
                    if (tuple2 != null) {
                        VectorWithNorm point = (VectorWithNorm)tuple2._1();
                        double[] cost = (double[])tuple2._2();
                        double[] dArray = (double[])Array$.MODULE$.tabulate(this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, point, cost){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$initKMeansParallel$2 $outer;
                            private final VectorWithNorm point$2;
                            private final double[] cost$1;

                            public final double apply(int r) {
                                return this.apply$mcDI$sp(r);
                            }

                            public double apply$mcDI$sp(int r) {
                                return scala.math.package$.MODULE$.min(KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((ArrayBuffer[])this.$outer.bcNewCenters$1.value())[r], this.point$2), this.cost$1[r]);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.point$2 = point$2;
                                this.cost$1 = cost$1;
                            }
                        }, ClassTag$.MODULE$.Double());
                        return dArray;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.bcNewCenters$1 = bcNewCenters$1;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double[] sumCosts = (double[])costs.aggregate((Object)new double[this.org$apache$spark$mllib$clustering$KMeans$$runs()], (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final double[] apply(double[] s, double[] v) {
                    for (int r = 0; r < this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(); ++r) {
                        int n = r;
                        s[n] = s[n] + v[r];
                    }
                    return s;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final double[] apply(double[] s0, double[] s1) {
                    for (int r = 0; r < this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(); ++r) {
                        int n = r;
                        s0[n] = s0[n] + s1[r];
                    }
                    return s0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            bcNewCenters.unpersist(false);
            preCosts.unpersist(false);
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Serializable x$14 = new Serializable(this, seed, step, sumCosts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final int seed$1;
                private final IntRef step$1;
                public final double[] sumCosts$1;

                public final Iterator<Tuple2<VectorWithNorm, IndexedSeq<Object>>> apply(int index2, Iterator<Tuple2<VectorWithNorm, double[]>> pointsWithCosts) {
                    XORShiftRandom rand2 = new XORShiftRandom((long)(this.seed$1 ^ this.step$1.elem << 16 ^ index2));
                    return pointsWithCosts.flatMap((Function1)new Serializable(this, rand2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$22 $outer;
                        public final XORShiftRandom rand$1;

                        public final Iterable<Tuple2<VectorWithNorm, IndexedSeq<Object>>> apply(Tuple2<VectorWithNorm, double[]> x0$3) {
                            Tuple2<VectorWithNorm, double[]> tuple2 = x0$3;
                            if (tuple2 != null) {
                                VectorWithNorm p = (VectorWithNorm)tuple2._1();
                                double[] c = (double[])tuple2._2();
                                IndexedSeq rs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$runs()).filter((Function1)new Serializable(this, c){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$22$$anonfun$apply$8 $outer;
                                    private final double[] c$1;

                                    public final boolean apply(int r) {
                                        return this.apply$mcZI$sp(r);
                                    }

                                    public boolean apply$mcZI$sp(int r) {
                                        return this.$outer.rand$1.nextDouble() < 2.0 * this.c$1[r] * (double)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$k() / this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().sumCosts$1[r];
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.c$1 = c$1;
                                    }
                                });
                                Iterable iterable = rs.nonEmpty() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)p, (Object)rs))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                return iterable;
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ $anonfun$22 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rand$1 = rand$1;
                        }
                    });
                }

                public /* synthetic */ KMeans org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.seed$1 = seed$1;
                    this.step$1 = step$1;
                    this.sumCosts$1 = sumCosts$1;
                }
            };
            boolean x$15 = qual$1.mapPartitionsWithIndex$default$2();
            Tuple2[] chosen = (Tuple2[])qual$1.mapPartitionsWithIndex((Function2)x$14, x$15, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            this.mergeNewCenters$1(centers, newCenters);
            Predef$.MODULE$.refArrayOps((Object[])chosen).foreach((Function1)new Serializable(this, newCenters){
                public static final long serialVersionUID = 0L;
                public final ArrayBuffer[] newCenters$1;

                public final void apply(Tuple2<VectorWithNorm, IndexedSeq<Object>> x0$4) {
                    Tuple2<VectorWithNorm, IndexedSeq<Object>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        VectorWithNorm p = (VectorWithNorm)tuple2._1();
                        IndexedSeq rs = (IndexedSeq)tuple2._2();
                        rs.foreach((Function1)new Serializable(this, p){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$initKMeansParallel$3 $outer;
                            private final VectorWithNorm p$1;

                            public final ArrayBuffer<VectorWithNorm> apply(int x$11) {
                                return this.$outer.newCenters$1[x$11].$plus$eq((Object)this.p$1.toDense());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.p$1 = p$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.newCenters$1 = newCenters$1;
                }
            });
            ++step.elem;
        }
        this.mergeNewCenters$1(centers, newCenters);
        costs.unpersist(false);
        Broadcast bcCenters = data.context().broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ArrayBuffer.class)));
        Map weightMap = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, bcCenters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            public final Broadcast bcCenters$1;

            public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(VectorWithNorm p) {
                return package$.MODULE$.Iterator().tabulate(this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$23 $outer;
                    private final VectorWithNorm p$2;

                    public final Tuple2<Tuple2<Object, Object>, Object> apply(int r) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(r, KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)((ArrayBuffer[])this.$outer.bcCenters$1.value())[r], this.p$2)._1$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)1.0));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.p$2 = p$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bcCenters$1 = bcCenters$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$12, double x$13) {
                return this.apply$mcDDD$sp(x$12, x$13);
            }

            public double apply$mcDDD$sp(double x$12, double x$13) {
                return x$12 + x$13;
            }
        }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
        bcCenters.unpersist(false);
        ParSeq finalCenters = (ParSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.org$apache$spark$mllib$clustering$KMeans$$runs()).par().map((Function1)new Serializable(this, centers, weightMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final ArrayBuffer[] centers$2;
            public final Map weightMap$1;

            public final VectorWithNorm[] apply(int r) {
                VectorWithNorm[] myCenters = (VectorWithNorm[])this.centers$2[r].toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
                double[] myWeights = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), myCenters.length).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;
                    private final int r$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        return BoxesRunTime.unboxToDouble((Object)this.$outer.weightMap$1.getOrElse((Object)new Tuple2.mcII.sp(this.r$1, i), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                return LocalKMeans$.MODULE$.kMeansPlusPlus(r, myCenters, myWeights, this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), 30);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.centers$2 = centers$2;
                this.weightMap$1 = weightMap$1;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
        return (VectorWithNorm[][])finalCenters.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
    }

    public final Tuple2 org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(Tuple2 x, Tuple2 y) {
        BLAS$.MODULE$.axpy(1.0, (Vector)x._1(), (Vector)y._1());
        return new Tuple2(y._1(), (Object)BoxesRunTime.boxToLong((long)(x._2$mcJ$sp() + y._2$mcJ$sp())));
    }

    private final void mergeNewCenters$1(ArrayBuffer[] centers$2, ArrayBuffer[] newCenters$1) {
        for (int r = 0; r < this.org$apache$spark$mllib$clustering$KMeans$$runs(); ++r) {
            centers$2[r].$plus$plus$eq((TraversableOnce)newCenters$1[r]);
            newCenters$1[r].clear();
        }
    }

    private KMeans(int k, int maxIterations, int runs, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = k;
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = maxIterations;
        this.org$apache$spark$mllib$clustering$KMeans$$runs = runs;
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = epsilon;
        this.seed = seed;
        Logging.class.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    public KMeans() {
        this(2, 20, 1, KMeans$.MODULE$.K_MEANS_PARALLEL(), 5, 1.0E-4, Utils$.MODULE$.random().nextLong());
    }
}

