/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressor$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.RandomForestParams$class;
import org.apache.spark.ml.tree.RandomForestRegressorParams;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u00015\u0011QCU1oI>lgi\u001c:fgR\u0014Vm\u001a:fgN|'O\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019i2\u0005E\u0003\u0010!IA\"$D\u0001\u0005\u0013\t\tBAA\u0005Qe\u0016$\u0017n\u0019;peB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u001a\u00015\t!\u0001\u0005\u0002\u001a7%\u0011AD\u0001\u0002\u001c%\u0006tGm\\7G_J,7\u000f\u001e*fOJ,7o]5p]6{G-\u001a7\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011\u0001\u0002;sK\u0016L!AI\u0010\u00037I\u000bg\u000eZ8n\r>\u0014Xm\u001d;SK\u001e\u0014Xm]:peB\u000b'/Y7t!\t!s%D\u0001&\u0015\t1C!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016D\u0001B\u000b\u0001\u0003\u0006\u0004%\teK\u0001\u0004k&$W#\u0001\u0017\u0011\u00055\u001adB\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0018)\u0007%:T\b\u0005\u00029w5\t\u0011H\u0003\u0002;\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005qJ$!B*j]\u000e,\u0017%\u0001 \u0002\u000bErCG\f\u0019\t\u0011\u0001\u0003!\u0011!Q\u0001\n1\nA!^5eA!\u001aqhN\u001f\t\u000b\r\u0003A\u0011\u0001#\u0002\rqJg.\u001b;?)\tAR\tC\u0003+\u0005\u0002\u0007A\u0006K\u0002FouB3AQ\u001c>\u0011\u0015\u0019\u0005\u0001\"\u0001J)\u0005A\u0002f\u0001%8{!)A\n\u0001C!\u001b\u0006Y1/\u001a;NCb$U\r\u001d;i)\tqu*D\u0001\u0001\u0011\u0015\u00016\n1\u0001R\u0003\u00151\u0018\r\\;f!\tq#+\u0003\u0002T_\t\u0019\u0011J\u001c;)\u0007-;T\bC\u0003W\u0001\u0011\u0005s+\u0001\u0006tKRl\u0015\r\u001f\"j]N$\"A\u0014-\t\u000bA+\u0006\u0019A))\u0007U;T\bC\u0003\\\u0001\u0011\u0005C,\u0001\ftKRl\u0015N\\%ogR\fgnY3t!\u0016\u0014hj\u001c3f)\tqU\fC\u0003Q5\u0002\u0007\u0011\u000bK\u0002[ouBQ\u0001\u0019\u0001\u0005B\u0005\fab]3u\u001b&t\u0017J\u001c4p\u000f\u0006Lg\u000e\u0006\u0002OE\")\u0001k\u0018a\u0001GB\u0011a\u0006Z\u0005\u0003K>\u0012a\u0001R8vE2,\u0007fA08{!)\u0001\u000e\u0001C!S\u0006\u00012/\u001a;NCblU-\\8ss&sWJ\u0011\u000b\u0003\u001d*DQ\u0001U4A\u0002EC3aZ\u001c>\u0011\u0015i\u0007\u0001\"\u0011o\u0003=\u0019X\r^\"bG\",gj\u001c3f\u0013\u0012\u001cHC\u0001(p\u0011\u0015\u0001F\u000e1\u0001q!\tq\u0013/\u0003\u0002s_\t9!i\\8mK\u0006t\u0007f\u000178{!)Q\u000f\u0001C!m\u0006)2/\u001a;DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dGC\u0001(x\u0011\u0015\u0001F\u000f1\u0001RQ\r!x'\u0010\u0005\u0006u\u0002!\te_\u0001\fg\u0016$\u0018*\u001c9ve&$\u0018\u0010\u0006\u0002Oy\")\u0001+\u001fa\u0001Y!\u001a\u0011pN\u001f\t\r}\u0004A\u0011IA\u0001\u0003I\u0019X\r^*vEN\fW\u000e\u001d7j]\u001e\u0014\u0016\r^3\u0015\u00079\u000b\u0019\u0001C\u0003Q}\u0002\u00071\rK\u0002\u007fouBq!!\u0003\u0001\t\u0003\nY!A\u0004tKR\u001cV-\u001a3\u0015\u00079\u000bi\u0001C\u0004Q\u0003\u000f\u0001\r!a\u0004\u0011\u00079\n\t\"C\u0002\u0002\u0014=\u0012A\u0001T8oO\"\"\u0011qA\u001c>\u0011\u001d\tI\u0002\u0001C!\u00037\t1b]3u\u001dVlGK]3fgR\u0019a*!\b\t\rA\u000b9\u00021\u0001RQ\u0011\t9bN\u001f\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&\u0005A2/\u001a;GK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ=\u0015\u00079\u000b9\u0003\u0003\u0004Q\u0003C\u0001\r\u0001\f\u0015\u0005\u0003C9T\bC\u0004\u0002.\u0001!\t&a\f\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0007i\t\t\u0004\u0003\u0005\u00024\u0005-\u0002\u0019AA\u001b\u0003\u001d!\u0017\r^1tKR\u0004D!a\u000e\u0002HA1\u0011\u0011HA \u0003\u0007j!!a\u000f\u000b\u0007\u0005ub!A\u0002tc2LA!!\u0011\u0002<\t9A)\u0019;bg\u0016$\b\u0003BA#\u0003\u000fb\u0001\u0001\u0002\u0007\u0002J\u0005E\u0012\u0011!A\u0001\u0006\u0003\tYEA\u0002`IE\nB!!\u0014\u0002TA\u0019a&a\u0014\n\u0007\u0005EsFA\u0004O_RD\u0017N\\4\u0011\u00079\n)&C\u0002\u0002X=\u00121!\u00118z\u0011\u001d\tY\u0006\u0001C!\u0003;\nAaY8qsR\u0019\u0001$a\u0018\t\u0011\u0005\u0005\u0014\u0011\fa\u0001\u0003G\nQ!\u001a=ue\u0006\u0004B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S\"\u0011!\u00029be\u0006l\u0017\u0002BA7\u0003O\u0012\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0005\u00033:T\bK\u0002\u0001ou:q!!\u001e\u0003\u0011\u0003\t9(A\u000bSC:$w.\u001c$pe\u0016\u001cHOU3he\u0016\u001c8o\u001c:\u0011\u0007e\tIH\u0002\u0004\u0002\u0005!\u0005\u00111P\n\t\u0003s\ni(a!\u0002\nB\u0019a&a \n\u0007\u0005\u0005uF\u0001\u0004B]f\u0014VM\u001a\t\u0005I\u0005\u0015\u0005$C\u0002\u0002\b\u0016\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002/\u0003\u0017K1!!$0\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d\u0019\u0015\u0011\u0010C\u0001\u0003##\"!a\u001e\t\u0015\u0005U\u0015\u0011\u0010b\u0001\n\u000b\t9*A\ntkB\u0004xN\u001d;fI&k\u0007/\u001e:ji&,7/\u0006\u0002\u0002\u001aB!a&a'-\u0013\r\tij\f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0005\u0003';T\bC\u0005\u0002$\u0006e\u0004\u0015!\u0004\u0002\u001a\u0006!2/\u001e9q_J$X\rZ%naV\u0014\u0018\u000e^5fg\u0002BC!!)8{!Q\u0011\u0011VA=\u0005\u0004%)!a&\u0002AM,\b\u000f]8si\u0016$g)Z1ukJ,7+\u001e2tKR\u001cFO]1uK\u001eLWm\u001d\u0015\u0005\u0003O;T\bC\u0005\u00020\u0006e\u0004\u0015!\u0004\u0002\u001a\u0006\t3/\u001e9q_J$X\r\u001a$fCR,(/Z*vEN,Go\u0015;sCR,w-[3tA!\"\u0011QV\u001c>\u0011!\t),!\u001f\u0005B\u0005]\u0016\u0001\u00027pC\u0012$2\u0001GA]\u0011\u001d\tY,a-A\u00021\nA\u0001]1uQ\"*\u00111W\u001c\u0002@\u0006\u0012\u0011\u0011Y\u0001\u0006e9\u0002d\u0006\r\u0005\u000b\u0003\u000b\fI(!A\u0005\n\u0005\u001d\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!3\u0011\t\u0005-\u0017Q[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006!A.\u00198h\u0015\t\t\u0019.\u0001\u0003kCZ\f\u0017\u0002BAl\u0003\u001b\u0014aa\u00142kK\u000e$\b\u0006BA=ouBC!a\u001d8{\u0001")
public class RandomForestRegressor
extends Predictor<Vector, RandomForestRegressor, RandomForestRegressionModel>
implements RandomForestRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final Param<String> featureSubsetStrategy;
    private final DoubleParam subsamplingRate;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static MLReader<RandomForestRegressor> read() {
        return RandomForestRegressor$.MODULE$.read();
    }

    public static RandomForestRegressor load(String string) {
        return RandomForestRegressor$.MODULE$.load(string);
    }

    public static String[] supportedFeatureSubsetStrategies() {
        return RandomForestRegressor$.MODULE$.supportedFeatureSubsetStrategies();
    }

    public static String[] supportedImpurities() {
        return RandomForestRegressor$.MODULE$.supportedImpurities();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$featureSubsetStrategy_$eq(Param x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams$class.getNumTrees(this);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return RandomForestParams$class.getFeatureSubsetStrategy(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public RandomForestRegressor setMaxDepth(int value) {
        return (RandomForestRegressor)this.set(this.maxDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public RandomForestRegressor setMaxBins(int value) {
        return (RandomForestRegressor)this.set(this.maxBins(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public RandomForestRegressor setMinInstancesPerNode(int value) {
        return (RandomForestRegressor)this.set(this.minInstancesPerNode(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public RandomForestRegressor setMinInfoGain(double value) {
        return (RandomForestRegressor)this.set(this.minInfoGain(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public RandomForestRegressor setMaxMemoryInMB(int value) {
        return (RandomForestRegressor)this.set(this.maxMemoryInMB(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public RandomForestRegressor setCacheNodeIds(boolean value) {
        return (RandomForestRegressor)this.set(this.cacheNodeIds(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public RandomForestRegressor setCheckpointInterval(int value) {
        return (RandomForestRegressor)this.set(this.checkpointInterval(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public RandomForestRegressor setImpurity(String value) {
        return (RandomForestRegressor)this.set(this.impurity(), value);
    }

    @Override
    public RandomForestRegressor setSubsamplingRate(double value) {
        return (RandomForestRegressor)this.set(this.subsamplingRate(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public RandomForestRegressor setSeed(long value) {
        return (RandomForestRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public RandomForestRegressor setNumTrees(int value) {
        return (RandomForestRegressor)this.set(this.numTrees(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public RandomForestRegressor setFeatureSubsetStrategy(String value) {
        return (RandomForestRegressor)this.set(this.featureSubsetStrategy(), value);
    }

    @Override
    public RandomForestRegressionModel train(Dataset<?> dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
        Strategy strategy = TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, 0, Algo$.MODULE$.Regression(), this.getOldImpurity());
        Instrumentation<RandomForestRegressor> instr = Instrumentation$.MODULE$.create(this, oldDataset);
        instr.logParams((Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.predictionCol(), this.impurity(), this.numTrees(), this.featureSubsetStrategy(), this.maxDepth(), this.maxBins(), this.maxMemoryInMB(), this.minInfoGain(), this.minInstancesPerNode(), this.seed(), this.subsamplingRate(), this.cacheNodeIds(), this.checkpointInterval()}));
        DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(oldDataset, strategy, this.getNumTrees(), this.getFeatureSubsetStrategy(), this.getSeed(), (Option<Instrumentation<?>>)new Some(instr), RandomForest$.MODULE$.run$default$7())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DecisionTreeRegressionModel apply(DecisionTreeModel x$1) {
                return (DecisionTreeRegressionModel)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
        int numFeatures = ((LabeledPoint)oldDataset.first()).features().size();
        RandomForestRegressionModel m = new RandomForestRegressionModel(this.uid(), trees, numFeatures);
        instr.logSuccess(m);
        return m;
    }

    @Override
    public RandomForestRegressor copy(ParamMap extra) {
        return (RandomForestRegressor)this.defaultCopy(extra);
    }

    public RandomForestRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        RandomForestParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
    }

    public RandomForestRegressor() {
        this(Identifiable$.MODULE$.randomUID("rfr"));
    }
}

