/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExport$class;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.spark_project.dmg.pmml.DataDictionary;
import org.spark_project.dmg.pmml.DataField;
import org.spark_project.dmg.pmml.DataType;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.FieldUsageType;
import org.spark_project.dmg.pmml.MiningField;
import org.spark_project.dmg.pmml.MiningFunctionType;
import org.spark_project.dmg.pmml.MiningSchema;
import org.spark_project.dmg.pmml.NumericPredictor;
import org.spark_project.dmg.pmml.OpType;
import org.spark_project.dmg.pmml.PMML;
import org.spark_project.dmg.pmml.RegressionModel;
import org.spark_project.dmg.pmml.RegressionTable;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001a2Q!\u0001\u0002\u0001\r9\u0011\u0001eR3oKJ\fG.\u001b>fI2Kg.Z1s!6kE*T8eK2,\u0005\u0010]8si*\u00111\u0001B\u0001\u0007Kb\u0004xN\u001d;\u000b\u0005\u00151\u0011\u0001\u00029n[2T!a\u0002\u0005\u0002\u000b5dG.\u001b2\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010!6kE*T8eK2,\u0005\u0010]8si\"A!\u0004\u0001B\u0001B\u0003%A$A\u0003n_\u0012,Gn\u0001\u0001\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0011A\u0003:fOJ,7o]5p]&\u0011\u0011E\b\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fY\"A1\u0005\u0001B\u0001B\u0003%A%A\u0006eKN\u001c'/\u001b9uS>t\u0007CA\u0013)\u001d\t\u0001b%\u0003\u0002(#\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9\u0013\u0003C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004C\u0001\f\u0001\u0011\u0015Q2\u00061\u0001\u001d\u0011\u0015\u00193\u00061\u0001%\u0011\u0015\u0011\u0004\u0001\"\u00034\u0003u\u0001x\u000e];mCR,w)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:Q\u001b6cEC\u0001\u001b8!\t\u0001R'\u0003\u00027#\t!QK\\5u\u0011\u0015Q\u0012\u00071\u0001\u001d\u0001")
public class GeneralizedLinearPMMLModelExport
implements PMMLModelExport {
    private final String description;
    private final PMML pmml;

    @Override
    public PMML pmml() {
        return this.pmml;
    }

    @Override
    public void org$apache$spark$mllib$pmml$export$PMMLModelExport$_setter_$pmml_$eq(PMML x$1) {
        this.pmml = x$1;
    }

    @Override
    public PMML getPmml() {
        return PMMLModelExport$class.getPmml(this);
    }

    private void populateGeneralizedLinearPMML(GeneralizedLinearModel model) {
        this.pmml().getHeader().setDescription(this.description);
        if (model.weights().size() > 0) {
            FieldName[] fields = new FieldName[model.weights().size()];
            DataDictionary dataDictionary = new DataDictionary();
            MiningSchema miningSchema = new MiningSchema();
            RegressionTable regressionTable = new RegressionTable(model.intercept());
            RegressionModel regressionModel = new RegressionModel().setFunctionName(MiningFunctionType.REGRESSION).setMiningSchema(miningSchema).setModelName(this.description).addRegressionTables(regressionTable);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), model.weights().size()).foreach((Function1)new Serializable(this, model, fields, dataDictionary, miningSchema, regressionTable){
                public static final long serialVersionUID = 0L;
                private final GeneralizedLinearModel model$1;
                private final FieldName[] fields$1;
                private final DataDictionary dataDictionary$1;
                private final MiningSchema miningSchema$1;
                private final RegressionTable regressionTable$1;

                public final RegressionTable apply(int i) {
                    this.fields$1[i] = FieldName.create(new StringBuilder().append((Object)"field_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                    this.dataDictionary$1.addDataFields(new DataField(this.fields$1[i], OpType.CONTINUOUS, DataType.DOUBLE));
                    this.miningSchema$1.addMiningFields(new MiningField(this.fields$1[i]).setUsageType(FieldUsageType.ACTIVE));
                    return this.regressionTable$1.addNumericPredictors(new NumericPredictor(this.fields$1[i], this.model$1.weights().apply(i)));
                }
                {
                    this.model$1 = model$1;
                    this.fields$1 = fields$1;
                    this.dataDictionary$1 = dataDictionary$1;
                    this.miningSchema$1 = miningSchema$1;
                    this.regressionTable$1 = regressionTable$1;
                }
            });
            FieldName targetField = FieldName.create("target");
            dataDictionary.addDataFields(new DataField(targetField, OpType.CONTINUOUS, DataType.DOUBLE));
            miningSchema.addMiningFields(new MiningField(targetField).setUsageType(FieldUsageType.TARGET));
            dataDictionary.setNumberOfFields(Predef$.MODULE$.int2Integer(dataDictionary.getDataFields().size()));
            this.pmml().setDataDictionary(dataDictionary);
            this.pmml().addModels(regressionModel);
        }
    }

    public GeneralizedLinearPMMLModelExport(GeneralizedLinearModel model, String description) {
        this.description = description;
        PMMLModelExport$class.$init$(this);
        this.populateGeneralizedLinearPMML(model);
    }
}

