/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaConfigUpdater;
import org.apache.spark.streaming.kafka010.InternalKafkaConsumer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!\u0002\u0013&\u0001\u0015z\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011A \t\u0011!\u0003!\u0011!Q\u0001\n\u0001C\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\tI\u0002\u0011\t\u0011)A\u0005\u0017\")Q\r\u0001C\u0001M\"A\u0011\u0010\u0001b\u0001\n\u0003)#\u0010\u0003\u0004|\u0001\u0001\u0006Ia\u0015\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\tY\u0001\u0001Q\u0001\nyD\u0011\"!\u0004\u0001\u0001\u0004%\t!a\u0004\t\u0013\u0005]\u0001\u00011A\u0005\u0002\u0005e\u0001\u0002CA\u0013\u0001\u0001\u0006K!!\u0005\t\u0013\u0005\u001d\u0002\u00011A\u0005\u0002\u0005=\u0001\"CA\u0015\u0001\u0001\u0007I\u0011AA\u0016\u0011!\ty\u0003\u0001Q!\n\u0005E\u0001\"CA\u0019\u0001\u0001\u0007I\u0011BA\u001a\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002H\u0001\u0001\u000b\u0015BA\u001b\u0011%\t\t\u0006\u0001a\u0001\n\u0013\t\u0019\u0006C\u0005\u0002\\\u0001\u0001\r\u0011\"\u0003\u0002^!A\u0011\u0011\r\u0001!B\u0013\t)\u0006C\u0004\u0002f\u0001!\t%a\u001a\t\r\u0005%\u0004\u0001\"\u0003~\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0005bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003+\u0003A\u0011BAL\u000f!\tY*\nE\u0001K\u0005uea\u0002\u0013&\u0011\u0003)\u0013q\u0014\u0005\u0007K\u0002\"\t!!)\t\u0013\u0005\r\u0006E1A\u0005\n\u0005M\u0003\u0002CASA\u0001\u0006I!!\u0016\u0003+%sG/\u001a:oC2\\\u0015MZ6b\u0007>t7/^7fe*\u0011aeJ\u0001\tW\u000647.\u0019\u00192a)\u0011\u0001&K\u0001\ngR\u0014X-Y7j]\u001eT!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u000b\u0004a-,8c\u0001\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0015\u0002\u0011%tG/\u001a:oC2L!\u0001P\u001d\u0003\u000f1{wmZ5oO\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t7\u0001A\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015[\u0013!B6bM.\f\u0017BA$C\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\fW\u000647.\u0019)be\u0006l7/F\u0001L!\u0011a\u0015k\u00150\u000e\u00035S!AT(\u0002\tU$\u0018\u000e\u001c\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJA\u0002NCB\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,4\u001b\u00059&B\u0001-?\u0003\u0019a$o\\8u}%\u0011!lM\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[gA\u0011qLY\u0007\u0002A*\u0011\u0011mT\u0001\u0005Y\u0006tw-\u0003\u0002dA\n1qJ\u00196fGR\fAb[1gW\u0006\u0004\u0016M]1ng\u0002\na\u0001P5oSRtDcA4xqB!\u0001\u000eA5u\u001b\u0005)\u0003C\u00016l\u0019\u0001!Q\u0001\u001c\u0001C\u00025\u0014\u0011aS\t\u0003]F\u0004\"AM8\n\u0005A\u001c$a\u0002(pi\"Lgn\u001a\t\u0003eIL!a]\u001a\u0003\u0007\u0005s\u0017\u0010\u0005\u0002kk\u0012)a\u000f\u0001b\u0001[\n\ta\u000bC\u0003>\u000b\u0001\u0007\u0001\tC\u0003J\u000b\u0001\u00071*A\u0004he>,\b/\u00133\u0016\u0003M\u000b\u0001b\u001a:pkBLE\rI\u0001\tG>t7/^7feV\ta\u0010E\u0003\u0000\u0003\u000fIG/\u0004\u0002\u0002\u0002)\u0019A0a\u0001\u000b\u0007\u0005\u0015A)A\u0004dY&,g\u000e^:\n\t\u0005%\u0011\u0011\u0001\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0002\u0013\r|gn];nKJ\u0004\u0013!B5o+N,WCAA\t!\r\u0011\u00141C\u0005\u0004\u0003+\u0019$a\u0002\"p_2,\u0017M\\\u0001\nS:,6/Z0%KF$B!a\u0007\u0002\"A\u0019!'!\b\n\u0007\u0005}1G\u0001\u0003V]&$\b\"CA\u0012\u0017\u0005\u0005\t\u0019AA\t\u0003\rAH%M\u0001\u0007S:,6/\u001a\u0011\u0002\u001d5\f'o[3e\r>\u00148\t\\8tK\u0006\u0011R.\u0019:lK\u00124uN]\"m_N,w\fJ3r)\u0011\tY\"!\f\t\u0013\u0005\rb\"!AA\u0002\u0005E\u0011aD7be.,GMR8s\u00072|7/\u001a\u0011\u0002\r\t,hMZ3s+\t\t)\u0004E\u0003M\u0003o\tY$C\u0002\u0002:5\u0013A\u0002T5ti&#XM]1u_J\u0004Ra`A\u001fSRLA!a\u0010\u0002\u0002\tq1i\u001c8tk6,'OU3d_J$\u0017A\u00032vM\u001a,'o\u0018\u0013fcR!\u00111DA#\u0011%\t\u0019#EA\u0001\u0002\u0004\t)$A\u0004ck\u001a4WM\u001d\u0011)\u0007I\tY\u0005E\u00023\u0003\u001bJ1!a\u00144\u0005!1x\u000e\\1uS2,\u0017A\u00038fqR|eMZ:fiV\u0011\u0011Q\u000b\t\u0004e\u0005]\u0013bAA-g\t!Aj\u001c8h\u00039qW\r\u001f;PM\u001a\u001cX\r^0%KF$B!a\u0007\u0002`!I\u00111\u0005\u000b\u0002\u0002\u0003\u0007\u0011QK\u0001\f]\u0016DHo\u00144gg\u0016$\b\u0005K\u0002\u0016\u0003\u0017\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002'\u0006q1M]3bi\u0016\u001cuN\\:v[\u0016\u0014\u0018!B2m_N,GCAA\u000e\u0003\r9W\r\u001e\u000b\u0007\u0003w\t\u0019(a\u001e\t\u000f\u0005U\u0014\u00041\u0001\u0002V\u00051qN\u001a4tKRDq!!\u001f\u001a\u0001\u0004\t)&A\u0004uS6,w.\u001e;\u0002\u001d\r|W\u000e]1di\u0016$7\u000b^1siR1\u00111DA@\u0003\u0003Cq!!\u001e\u001b\u0001\u0004\t)\u0006C\u0004\u0002\u0004j\u0001\r!!\u0016\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t\u00035\u0019w.\u001c9bGR,GMT3yiR!\u00111HAE\u0011\u001d\t\u0019i\u0007a\u0001\u0003+\n\u0011cY8na\u0006\u001cG/\u001a3Qe\u00164\u0018n\\;t)\t\tY$\u0001\u0003tK\u0016\\G\u0003BA\u000e\u0003'Cq!!\u001e\u001e\u0001\u0004\t)&\u0001\u0003q_2dG\u0003BA\u000e\u00033Cq!!\u001f\u001f\u0001\u0004\t)&A\u000bJ]R,'O\\1m\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u0005!\u00043C\u0001\u00112)\t\ti*\u0001\bV\u001d.suj\u0016(`\u001f\u001a35+\u0012+\u0002\u001fUs5JT(X\u001d~{eIR*F)\u0002\u0002")
public class InternalKafkaConsumer<K, V>
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final String groupId;
    private final KafkaConsumer<K, V> consumer;
    private boolean inUse;
    private boolean markedForClose;
    private volatile ListIterator<ConsumerRecord<K, V>> buffer;
    private volatile long nextOffset;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    public String groupId() {
        return this.groupId;
    }

    private KafkaConsumer<K, V> consumer() {
        return this.consumer;
    }

    public boolean inUse() {
        return this.inUse;
    }

    public void inUse_$eq(boolean x$1) {
        this.inUse = x$1;
    }

    public boolean markedForClose() {
        return this.markedForClose;
    }

    public void markedForClose_$eq(boolean x$1) {
        this.markedForClose = x$1;
    }

    private ListIterator<ConsumerRecord<K, V>> buffer() {
        return this.buffer;
    }

    private void buffer_$eq(ListIterator<ConsumerRecord<K, V>> x$1) {
        this.buffer = x$1;
    }

    private long nextOffset() {
        return this.nextOffset;
    }

    private void nextOffset_$eq(long x$1) {
        this.nextOffset = x$1;
    }

    public String toString() {
        return new StringBuilder(55).append("InternalKafkaConsumer(").append("hash=").append(Integer.toHexString(this.hashCode())).append(", ").append("groupId=").append(this.groupId()).append(", ").append("topicPartition=").append(this.topicPartition()).append(")").toString();
    }

    private KafkaConsumer<K, V> createConsumer() {
        Map updatedKafkaParams = new KafkaConfigUpdater("executor", ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafkaParams()).asScala()).toMap(Predef$.MODULE$.$conforms())).setAuthenticationConfigIfNeeded().build();
        KafkaConsumer c = new KafkaConsumer(updatedKafkaParams);
        List<Object> topics = Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()});
        c.assign(topics);
        return c;
    }

    public void close() {
        this.consumer().close();
    }

    public ConsumerRecord<K, V> get(long offset, long timeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Get ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" nextOffset ").append(this.nextOffset()).append(" requested ").append(offset).toString());
        if (offset != this.nextOffset()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Initial fetch for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(timeout);
        }
        if (!this.buffer().hasNext()) {
            this.poll(timeout);
        }
        Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Failed to get records for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).append(" after polling for ").append(timeout).toString());
        ObjectRef record = ObjectRef.create(this.buffer().next());
        if (((ConsumerRecord)record.elem).offset() != offset) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Buffer miss for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(timeout);
            Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Failed to get records for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).append(" after polling for ").append(timeout).toString());
            record.elem = this.buffer().next();
            Predef$.MODULE$.require(((ConsumerRecord)record.elem).offset() == offset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(170).append("Got wrong record for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" even after seeking to offset ").append(offset).append(" ").append("got offset ").append(((ConsumerRecord)record$1.elem).offset()).append(" instead. If this is a compacted topic, consider enabling ").append("spark.streaming.kafka.allowNonConsecutiveOffsets").toString());
        }
        this.nextOffset_$eq(offset + 1L);
        return (ConsumerRecord)record.elem;
    }

    public void compactedStart(long offset, long pollTimeoutMs) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("compacted start ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" starting ").append(offset).toString());
        if (offset != this.nextOffset()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Initial fetch for compacted ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(pollTimeoutMs);
            return;
        }
    }

    public ConsumerRecord<K, V> compactedNext(long pollTimeoutMs) {
        if (!this.buffer().hasNext()) {
            this.poll(pollTimeoutMs);
        }
        Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to get records for compacted ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append("after polling for ").append(pollTimeoutMs).toString());
        ConsumerRecord<K, V> record = this.buffer().next();
        this.nextOffset_$eq(record.offset() + 1L);
        return record;
    }

    public ConsumerRecord<K, V> compactedPrevious() {
        return this.buffer().previous();
    }

    private void seek(long offset) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Seeking to ").append(this.topicPartition()).append(" ").append(offset).toString());
        this.consumer().seek(this.topicPartition(), offset);
    }

    private void poll(long timeout) {
        ConsumerRecords p = this.consumer().poll(Duration.ofMillis(timeout));
        List r = p.records(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Polled ").append(p.partitions()).append("  ").append(r.size()).toString());
        this.buffer_$eq(r.listIterator());
    }

    public InternalKafkaConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        Logging.$init$((Logging)this);
        this.groupId = (String)kafkaParams.get("group.id");
        this.consumer = this.createConsumer();
        this.inUse = true;
        this.markedForClose = false;
        this.buffer = Collections.emptyListIterator();
        this.nextOffset = InternalKafkaConsumer$.MODULE$.org$apache$spark$streaming$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET();
    }
}

