/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.StreamDescription;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kinesis.KinesisDataGenerator;
import org.apache.spark.streaming.kinesis.KinesisTestUtils$;
import org.apache.spark.streaming.kinesis.SimpleDataGenerator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t-b!B\u0001\u0003\u0001\ta!\u0001E&j]\u0016\u001c\u0018n\u001d+fgR,F/\u001b7t\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\ttiJ,\u0017-\\*iCJ$7i\\;oi\u000e\u0001\u0001C\u0001\b\u001e\u0013\tqrBA\u0002J]RDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtDC\u0001\u0012%!\t\u0019\u0003!D\u0001\u0003\u0011\u001dQr\u0004%AA\u0002qAqA\n\u0001C\u0002\u0013\u0005q%A\u0006f]\u0012\u0004x.\u001b8u+JdW#\u0001\u0015\u0011\u0005%bcB\u0001\b+\u0013\tYs\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016\u0010\u0011\u0019\u0001\u0004\u0001)A\u0005Q\u0005aQM\u001c3q_&tG/\u0016:mA!9!\u0007\u0001b\u0001\n\u00039\u0013A\u0003:fO&|gNT1nK\"1A\u0007\u0001Q\u0001\n!\n1B]3hS>tg*Y7fA!9a\u0007\u0001b\u0001\n\u00139\u0014AG2sK\u0006$Xm\u0015;sK\u0006lG+[7f_V$8+Z2p]\u0012\u001cX#\u0001\u000f\t\re\u0002\u0001\u0015!\u0003\u001d\u0003m\u0019'/Z1uKN#(/Z1n)&lWm\\;u'\u0016\u001cwN\u001c3tA!91\b\u0001b\u0001\n\u00139\u0014!\b3fg\u000e\u0014\u0018NY3TiJ,\u0017-\u001c)pY2$\u0016.\\3TK\u000e|g\u000eZ:\t\ru\u0002\u0001\u0015!\u0003\u001d\u0003y!Wm]2sS\n,7\u000b\u001e:fC6\u0004v\u000e\u001c7US6,7+Z2p]\u0012\u001c\b\u0005C\u0004@\u0001\u0001\u0007I\u0011\u0002!\u0002\u001bM$(/Z1n\u0007J,\u0017\r^3e+\u0005\t\u0005C\u0001\bC\u0013\t\u0019uBA\u0004C_>dW-\u00198\t\u000f\u0015\u0003\u0001\u0019!C\u0005\r\u0006\t2\u000f\u001e:fC6\u001c%/Z1uK\u0012|F%Z9\u0015\u0005\u001dS\u0005C\u0001\bI\u0013\tIuB\u0001\u0003V]&$\bbB&E\u0003\u0003\u0005\r!Q\u0001\u0004q\u0012\n\u0004BB'\u0001A\u0003&\u0011)\u0001\btiJ,\u0017-\\\"sK\u0006$X\r\u001a\u0011)\u00051{\u0005C\u0001\bQ\u0013\t\tvB\u0001\u0005w_2\fG/\u001b7f\u0011%\u0019\u0006\u00011AA\u0002\u0013%q%A\u0006`gR\u0014X-Y7OC6,\u0007\"C+\u0001\u0001\u0004\u0005\r\u0011\"\u0003W\u0003=y6\u000f\u001e:fC6t\u0015-\\3`I\u0015\fHCA$X\u0011\u001dYE+!AA\u0002!Ba!\u0017\u0001!B\u0013A\u0013\u0001D0tiJ,\u0017-\u001c(b[\u0016\u0004\u0003F\u0001-P\u0011!a\u0006\u0001#b\u0001\n#i\u0016!D6j]\u0016\u001c\u0018n]\"mS\u0016tG/F\u0001_!\tyv-D\u0001a\u0015\t\u0019\u0011M\u0003\u0002cG\u0006A1/\u001a:wS\u000e,7O\u0003\u0002eK\u0006I\u0011-\\1{_:\fwo\u001d\u0006\u0002M\u0006\u00191m\\7\n\u0005!\u0004'aE!nCj|gnS5oKNL7o\u00117jK:$\b\u0002\u00036\u0001\u0011\u0003\u0005\u000b\u0015\u00020\u0002\u001d-Lg.Z:jg\u000ec\u0017.\u001a8uA!AA\u000e\u0001EC\u0002\u0013%Q.\u0001\u0005es:\fWn\u001c#C+\u0005q\u0007CA8u\u001b\u0005\u0001(BA9s\u0003!!wnY;nK:$(BA:b\u0003)!\u0017P\\1n_\u0012\u0014gOM\u0005\u0003kB\u0014\u0001\u0002R=oC6|GI\u0011\u0005\to\u0002A\t\u0011)Q\u0005]\u0006IA-\u001f8b[>$%\t\t\u0005\u0006s\u0002!\tB_\u0001\fO\u0016$\bK]8ek\u000e,'\u000f\u0006\u0002|}B\u00111\u0005`\u0005\u0003{\n\u0011AcS5oKNL7\u000fR1uC\u001e+g.\u001a:bi>\u0014\b\"B@y\u0001\u0004\t\u0015!C1hOJ,w-\u0019;f\u0011\u0019\t\u0019\u0001\u0001C\u0001O\u0005Q1\u000f\u001e:fC6t\u0015-\\3\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005a1M]3bi\u0016\u001cFO]3b[R\tq\tC\u0004\u0002\u000e\u0001!\t!a\u0004\u0002\u0013\u001d,Go\u00155be\u0012\u001cHCAA\t!\u0019\t\u0019\"a\t\u0002*9!\u0011QCA\u0010\u001d\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e7\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003Cy\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003K\t9CA\u0002TKFT1!!\t\u0010!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018A\u0006)Qn\u001c3fY&!\u00111GA\u0017\u0005\u0015\u0019\u0006.\u0019:e\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\t!b\u001d9mSR\u001c\u0006.\u0019:e)\r9\u00151\b\u0005\b\u0003{\t)\u00041\u0001)\u0003\u001d\u0019\b.\u0019:e\u0013\u0012Dq!!\u0011\u0001\t\u0003\t\u0019%\u0001\u0006nKJ<Wm\u00155be\u0012$RaRA#\u0003\u0013Bq!a\u0012\u0002@\u0001\u0007\u0001&\u0001\u0007tQ\u0006\u0014H\rV8NKJ<W\rC\u0004\u0002L\u0005}\u0002\u0019\u0001\u0015\u0002)\u0005$'.Y2f]R\u001c\u0006.\u0019:e)>lUM]4f\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\n\u0001\u0002];tQ\u0012\u000bG/\u0019\u000b\u0007\u0003'\n\t'a\u001a\u0011\r%\n)\u0006KA-\u0013\r\t9F\f\u0002\u0004\u001b\u0006\u0004\bCBA\n\u0003G\tY\u0006E\u0003\u000f\u0003;b\u0002&C\u0002\u0002`=\u0011a\u0001V;qY\u0016\u0014\u0004\u0002CA2\u0003\u001b\u0002\r!!\u001a\u0002\u0011Q,7\u000f\u001e#bi\u0006\u0004R!a\u0005\u0002$qAaa`A'\u0001\u0004\t\u0005bBA(\u0001\u0011\u0005\u00111\u000e\u000b\u0004\u000f\u00065\u0004\u0002CA2\u0003S\u0002\r!a\u001c\u0011\u000b\u0005E\u00141\u0010\u000f\u000e\u0005\u0005M$\u0002BA;\u0003o\nA!\u001e;jY*\u0011\u0011\u0011P\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002~\u0005M$\u0001\u0002'jgRDq!!!\u0001\t\u0003\tI!\u0001\u0007eK2,G/Z*ue\u0016\fW\u000eC\u0004\u0002\u0006\u0002!\t!a\"\u0002'\u0011,G.\u001a;f\tft\u0017-\\8E\u0005R\u000b'\r\\3\u0015\u0007\u001d\u000bI\tC\u0004\u0002\f\u0006\r\u0005\u0019\u0001\u0015\u0002\u0013Q\f'\r\\3OC6,\u0007bBAH\u0001\u0011%\u0011\u0011S\u0001\u000fI\u0016\u001c8M]5cKN#(/Z1n)\u0011\t\u0019*a(\u0011\u000b9\t)*!'\n\u0007\u0005]uB\u0001\u0004PaRLwN\u001c\t\u0005\u0003W\tY*\u0003\u0003\u0002\u001e\u00065\"!E*ue\u0016\fW\u000eR3tGJL\u0007\u000f^5p]\"9\u0011\u0011UAG\u0001\u0004A\u0013\u0001F:ue\u0016\fWNT1nKR{G)Z:de&\u0014W\rC\u0004\u0002&\u0002!I!a*\u00023\u0019Lg\u000e\u001a(p]\u0016C\u0018n\u001d;f]R\u001cFO]3b[:\u000bW.\u001a\u000b\u0002Q!9\u00111\u0016\u0001\u0005\n\u00055\u0016aF<bSR4uN]*ue\u0016\fW\u000eV8CK\u0006\u001bG/\u001b<f)\r9\u0015q\u0016\u0005\b\u0003c\u000bI\u000b1\u0001)\u0003M\u0019HO]3b[:\u000bW.\u001a+p/\u0006LGOR8s\u000f!\t)L\u0001E\u0001\u0005\u0005]\u0016\u0001E&j]\u0016\u001c\u0018n\u001d+fgR,F/\u001b7t!\r\u0019\u0013\u0011\u0018\u0004\b\u0003\tA\tAAA^'\r\tI,\u0004\u0005\bA\u0005eF\u0011AA`)\t\t9\f\u0003\u0006\u0002D\u0006e&\u0019!C\u0001\u0003\u000b\f!$\u001a8w-\u0006\u0014h*Y7f\r>\u0014XI\\1cY&tw\rV3tiN,\"!a2\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002x\u0005!A.\u00198h\u0013\ri\u00131\u001a\u0005\n\u0003'\fI\f)A\u0005\u0003\u000f\f1$\u001a8w-\u0006\u0014h*Y7f\r>\u0014XI\\1cY&tw\rV3tiN\u0004\u0003BCAl\u0003s\u0013\r\u0011\"\u0001\u0002F\u0006)RM\u001c3WCJt\u0015-\\3G_J,e\u000e\u001a9pS:$\b\"CAn\u0003s\u0003\u000b\u0011BAd\u0003Y)g\u000e\u001a,be:\u000bW.\u001a$pe\u0016sG\r]8j]R\u0004\u0003BCAp\u0003s\u0013\r\u0011\"\u0001\u0002F\u0006\u0011B-\u001a4bk2$XI\u001c3q_&tG/\u0016:m\u0011%\t\u0019/!/!\u0002\u0013\t9-A\neK\u001a\fW\u000f\u001c;F]\u0012\u0004x.\u001b8u+Jd\u0007\u0005\u0003\u0005\u0002h\u0006eF\u0011AAu\u0003]9W\r\u001e*fO&|gNT1nK\nKXI\u001c3q_&tG\u000fF\u0002)\u0003WDq!!<\u0002f\u0002\u0007\u0001&\u0001\u0005f]\u0012\u0004x.\u001b8u\u0011)\t\t0!/\t\u0006\u0004%\t\u0001Q\u0001\u000fg\"|W\u000f\u001c3Sk:$Vm\u001d;t\u0011)\t)0!/\t\u0002\u0003\u0006K!Q\u0001\u0010g\"|W\u000f\u001c3Sk:$Vm\u001d;tA!Ia%!/\t\u0006\u0004%\ta\n\u0005\na\u0005e\u0006\u0012!Q!\n!Bq!!@\u0002:\u0012\u0005\u0001)A\fjg\u0006;6k\u0011:fI\u0016tG/[1mgB\u0013Xm]3oi\"A!\u0011AA]\t\u0003\u0011\u0019!A\thKR\fukU\"sK\u0012,g\u000e^5bYN$\"A!\u0002\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013Q1Aa\u0003d\u0003\u0011\tW\u000f\u001e5\n\t\t=!\u0011\u0002\u0002\u000f\u0003^\u001b6I]3eK:$\u0018.\u00197t\u0011)\u0011\u0019\"!/\u0012\u0002\u0013\u0005!QC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t]!f\u0001\u000f\u0003\u001a-\u0012!1\u0004\t\u0005\u0005;\u00119#\u0004\u0002\u0003 )!!\u0011\u0005B\u0012\u0003%)hn\u00195fG.,GMC\u0002\u0003&=\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011ICa\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class KinesisTestUtils
implements Logging {
    private final int streamShardCount;
    private final String endpointUrl;
    private final String regionName;
    private final int createStreamTimeoutSeconds;
    private final int describeStreamPollTimeSeconds;
    private volatile boolean streamCreated;
    private volatile String org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName;
    private AmazonKinesisClient kinesisClient;
    private DynamoDB dynamoDB;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$1() {
        return KinesisTestUtils$.MODULE$.$lessinit$greater$default$1();
    }

    public static AWSCredentials getAWSCredentials() {
        return KinesisTestUtils$.MODULE$.getAWSCredentials();
    }

    public static boolean isAWSCredentialsPresent() {
        return KinesisTestUtils$.MODULE$.isAWSCredentialsPresent();
    }

    public static boolean shouldRunTests() {
        return KinesisTestUtils$.MODULE$.shouldRunTests();
    }

    public static String getRegionNameByEndpoint(String string) {
        return KinesisTestUtils$.MODULE$.getRegionNameByEndpoint(string);
    }

    public static String defaultEndpointUrl() {
        return KinesisTestUtils$.MODULE$.defaultEndpointUrl();
    }

    public static String endVarNameForEndpoint() {
        return KinesisTestUtils$.MODULE$.endVarNameForEndpoint();
    }

    public static String envVarNameForEnablingTests() {
        return KinesisTestUtils$.MODULE$.envVarNameForEnablingTests();
    }

    /*
     * WARNING - void declaration
     */
    private AmazonKinesisClient kinesisClient$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                AmazonKinesisClient client = new AmazonKinesisClient(KinesisTestUtils$.MODULE$.getAWSCredentials());
                client.setEndpoint(this.endpointUrl());
                this.kinesisClient = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.kinesisClient;
        }
    }

    private DynamoDB dynamoDB$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                AmazonDynamoDBClient dynamoDBClient = new AmazonDynamoDBClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
                dynamoDBClient.setRegion(RegionUtils.getRegion((String)this.regionName()));
                this.dynamoDB = new DynamoDB((AmazonDynamoDB)dynamoDBClient);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.dynamoDB;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    private int createStreamTimeoutSeconds() {
        return this.createStreamTimeoutSeconds;
    }

    private int describeStreamPollTimeSeconds() {
        return this.describeStreamPollTimeSeconds;
    }

    private boolean streamCreated() {
        return this.streamCreated;
    }

    private void streamCreated_$eq(boolean x$1) {
        this.streamCreated = x$1;
    }

    public String org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName() {
        return this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName;
    }

    private void org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName = x$1;
    }

    public AmazonKinesisClient kinesisClient() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.kinesisClient$lzycompute() : this.kinesisClient;
    }

    private DynamoDB dynamoDB() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dynamoDB$lzycompute() : this.dynamoDB;
    }

    public KinesisDataGenerator getProducer(boolean aggregate) {
        if (aggregate) {
            throw new UnsupportedOperationException("Aggregation is not supported through this code path");
        }
        return new SimpleDataGenerator(this.kinesisClient());
    }

    public String streamName() {
        Predef$.MODULE$.require(this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream not yet created, call createStream() to create one";
            }
        });
        return this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName();
    }

    public void createStream() {
        Predef$.MODULE$.require(!this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream already created";
            }
        });
        this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName_$eq(this.findNonExistentStreamName());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisTestUtils $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CreateStreamRequest createStreamRequest = new CreateStreamRequest();
        createStreamRequest.setStreamName(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        createStreamRequest.setShardCount(Predef$.MODULE$.int2Integer(this.streamShardCount));
        this.kinesisClient().createStream(createStreamRequest);
        this.waitForStreamToBeActive(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        this.streamCreated_$eq(true);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisTestUtils $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Seq<Shard> getShards() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.kinesisClient().describeStream(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName()).getStreamDescription().getShards()).asScala();
    }

    public void splitShard(String shardId) {
        SplitShardRequest splitShardRequest = new SplitShardRequest();
        splitShardRequest.withStreamName(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        splitShardRequest.withShardToSplit(shardId);
        splitShardRequest.withNewStartingHashKey("170141183460469231731687303715884105728");
        this.kinesisClient().splitShard(splitShardRequest);
        this.waitForStreamToBeActive(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
    }

    public void mergeShard(String shardToMerge, String adjacentShardToMerge) {
        MergeShardsRequest mergeShardRequest = new MergeShardsRequest();
        mergeShardRequest.withStreamName(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        mergeShardRequest.withShardToMerge(shardToMerge);
        mergeShardRequest.withAdjacentShardToMerge(adjacentShardToMerge);
        this.kinesisClient().mergeShards(mergeShardRequest);
        this.waitForStreamToBeActive(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
    }

    public Map<String, Seq<Tuple2<Object, String>>> pushData(Seq<Object> testData, boolean aggregate) {
        Predef$.MODULE$.require(this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream not yet created, call createStream() to create one";
            }
        });
        KinesisDataGenerator producer = this.getProducer(aggregate);
        Map<String, Seq<Tuple2<Object, String>>> shardIdToSeqNumbers = producer.sendData(this.streamName(), testData);
        this.logInfo((Function0<String>)new Serializable(this, testData, shardIdToSeqNumbers){
            public static final long serialVersionUID = 0L;
            private final Seq testData$1;
            private final Map shardIdToSeqNumbers$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed ", ":\\n\\t ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testData$1, this.shardIdToSeqNumbers$1.mkString("\n\t")}));
            }
            {
                this.testData$1 = testData$1;
                this.shardIdToSeqNumbers$1 = shardIdToSeqNumbers$1;
            }
        });
        return shardIdToSeqNumbers.toMap(Predef$.MODULE$.$conforms());
    }

    public void pushData(List<Object> testData) {
        this.pushData((Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(testData).asScala()), false);
    }

    public void deleteStream() {
        try {
            if (this.streamCreated()) {
                this.kinesisClient().deleteStream(this.streamName());
            }
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisTestUtils $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.streamName()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public void deleteDynamoDBTable(String tableName) {
        try {
            Table table = this.dynamoDB().getTable(tableName);
            table.delete();
            table.waitForDelete();
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this, tableName){
                public static final long serialVersionUID = 0L;
                private final String tableName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete DynamoDB table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1}));
                }
                {
                    this.tableName$1 = tableName$1;
                }
            });
        }
    }

    private Option<StreamDescription> describeStream(String streamNameToDescribe) {
        None$ none$;
        try {
            DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest().withStreamName(streamNameToDescribe);
            StreamDescription desc = this.kinesisClient().describeStream(describeStreamRequest).getStreamDescription();
            none$ = new Some((Object)desc);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    private String findNonExistentStreamName() {
        void var1_1;
        String testStreamName = null;
        do {
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
        } while (this.describeStream(testStreamName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KinesisTestUtils-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)package$.MODULE$.abs(Random$.MODULE$.nextLong()))}))).nonEmpty());
        return var1_1;
    }

    private void waitForStreamToBeActive(String streamNameToWaitFor) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startTime = System.currentTimeMillis();
                long endTime = startTime + TimeUnit.SECONDS.toMillis(this.createStreamTimeoutSeconds());
                while (System.currentTimeMillis() < endTime) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
                    this.describeStream(streamNameToWaitFor).foreach((Function1)new Serializable(this, object){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KinesisTestUtils $outer;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(StreamDescription description) {
                            String streamStatus = description.getStreamStatus();
                            this.$outer.logDebug((Function0<String>)new Serializable(this, streamStatus){
                                public static final long serialVersionUID = 0L;
                                private final String streamStatus$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t- current state: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamStatus$1}));
                                }
                                {
                                    this.streamStatus$1 = streamStatus$1;
                                }
                            });
                            if ("ACTIVE".equals(streamStatus)) {
                                throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                Predef$.MODULE$.require(false, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KinesisTestUtils $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stream ", " never became active"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.streamName()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public KinesisTestUtils(int streamShardCount) {
        this.streamShardCount = streamShardCount;
        Logging.class.$init$((Logging)this);
        this.endpointUrl = KinesisTestUtils$.MODULE$.endpointUrl();
        this.regionName = KinesisTestUtils$.MODULE$.getRegionNameByEndpoint(this.endpointUrl());
        this.createStreamTimeoutSeconds = 300;
        this.describeStreamPollTimeSeconds = 1;
        this.streamCreated = false;
    }
}

