/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.unpack;

import com.github.junrar.exception.RarException;
import com.github.junrar.unpack.Unpack15;
import com.github.junrar.unpack.decode.AudioVariables;
import com.github.junrar.unpack.decode.BitDecode;
import com.github.junrar.unpack.decode.Decode;
import com.github.junrar.unpack.decode.DistDecode;
import com.github.junrar.unpack.decode.LitDecode;
import com.github.junrar.unpack.decode.LowDistDecode;
import com.github.junrar.unpack.decode.MultDecode;
import com.github.junrar.unpack.decode.RepDecode;
import java.io.IOException;
import java.util.Arrays;

public abstract class Unpack20
extends Unpack15 {
    protected MultDecode[] MD = new MultDecode[4];
    protected byte[] UnpOldTable20 = new byte[1028];
    protected int UnpAudioBlock;
    protected int UnpChannels;
    protected int UnpCurChannel;
    protected int UnpChannelDelta;
    protected AudioVariables[] AudV = new AudioVariables[4];
    protected LitDecode LD = new LitDecode();
    protected DistDecode DD = new DistDecode();
    protected LowDistDecode LDD = new LowDistDecode();
    protected RepDecode RD = new RepDecode();
    protected BitDecode BD = new BitDecode();
    public static final int[] LDecode = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 20, 24, 28, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224};
    public static final byte[] LBits = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};
    public static final int[] DDecode = new int[]{0, 1, 2, 3, 4, 6, 8, 12, 16, 24, 32, 48, 64, 96, 128, 192, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096, 6144, 8192, 12288, 16384, 24576, 32768, 49152, 65536, 98304, 131072, 196608, 262144, 327680, 393216, 458752, 524288, 589824, 655360, 720896, 786432, 851968, 917504, 983040};
    public static final int[] DBits = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    public static final int[] SDDecode = new int[]{0, 4, 8, 16, 32, 64, 128, 192};
    public static final int[] SDBits = new int[]{2, 2, 3, 4, 5, 6, 6, 6};

    protected void unpack20(boolean solid) throws IOException, RarException {
        if (this.suspended) {
            this.unpPtr = this.wrPtr;
        } else {
            this.unpInitData(solid);
            if (!this.unpReadBuf()) {
                return;
            }
            if (!solid && !this.ReadTables20()) {
                return;
            }
            --this.destUnpSize;
        }
        while (this.destUnpSize >= 0L) {
            int Distance;
            int Bits2;
            this.unpPtr &= 0x3FFFFF;
            if (this.inAddr > this.readTop - 30 && !this.unpReadBuf()) break;
            if ((this.wrPtr - this.unpPtr & 0x3FFFFF) < 270 && this.wrPtr != this.unpPtr) {
                this.oldUnpWriteBuf();
                if (this.suspended) {
                    return;
                }
            }
            if (this.UnpAudioBlock != 0) {
                int AudioNumber = this.decodeNumber(this.MD[this.UnpCurChannel]);
                if (AudioNumber == 256) {
                    if (this.ReadTables20()) continue;
                    break;
                }
                this.window[this.unpPtr++] = this.DecodeAudio(AudioNumber);
                if (++this.UnpCurChannel == this.UnpChannels) {
                    this.UnpCurChannel = 0;
                }
                --this.destUnpSize;
                continue;
            }
            int Number2 = this.decodeNumber(this.LD);
            if (Number2 < 256) {
                this.window[this.unpPtr++] = (byte)Number2;
                --this.destUnpSize;
                continue;
            }
            if (Number2 > 269) {
                int Length2 = LDecode[Number2 -= 270] + 3;
                Bits2 = LBits[Number2];
                if (Bits2 > 0) {
                    Length2 += this.getbits() >>> 16 - Bits2;
                    this.addbits(Bits2);
                }
                int DistNumber = this.decodeNumber(this.DD);
                int Distance2 = DDecode[DistNumber] + 1;
                Bits2 = DBits[DistNumber];
                if (Bits2 > 0) {
                    Distance2 += this.getbits() >>> 16 - Bits2;
                    this.addbits(Bits2);
                }
                if (Distance2 >= 8192) {
                    ++Length2;
                    if ((long)Distance2 >= 262144L) {
                        ++Length2;
                    }
                }
                this.CopyString20(Length2, Distance2);
                continue;
            }
            if (Number2 == 269) {
                if (this.ReadTables20()) continue;
                break;
            }
            if (Number2 == 256) {
                this.CopyString20(this.lastLength, this.lastDist);
                continue;
            }
            if (Number2 < 261) {
                Distance = this.oldDist[this.oldDistPtr - (Number2 - 256) & 3];
                int LengthNumber = this.decodeNumber(this.RD);
                int Length3 = LDecode[LengthNumber] + 2;
                Bits2 = LBits[LengthNumber];
                if (Bits2 > 0) {
                    Length3 += this.getbits() >>> 16 - Bits2;
                    this.addbits(Bits2);
                }
                if (Distance >= 257) {
                    ++Length3;
                    if (Distance >= 8192) {
                        ++Length3;
                        if (Distance >= 262144) {
                            ++Length3;
                        }
                    }
                }
                this.CopyString20(Length3, Distance);
                continue;
            }
            if (Number2 >= 270) continue;
            Distance = SDDecode[Number2 -= 261] + 1;
            Bits2 = SDBits[Number2];
            if (Bits2 > 0) {
                Distance += this.getbits() >>> 16 - Bits2;
                this.addbits(Bits2);
            }
            this.CopyString20(2, Distance);
        }
        this.ReadLastTables();
        this.oldUnpWriteBuf();
    }

    protected void CopyString20(int length, int distance) {
        int n = distance;
        this.oldDist[this.oldDistPtr++ & 3] = n;
        this.lastDist = n;
        this.lastLength = length;
        this.destUnpSize -= (long)length;
        int destPtr = this.unpPtr - distance;
        if (destPtr < 4194004 && this.unpPtr < 4194004) {
            if (destPtr + length <= this.unpPtr) {
                System.arraycopy(this.window, destPtr, this.window, this.unpPtr, length);
                this.unpPtr += length;
            } else {
                this.window[this.unpPtr++] = this.window[destPtr++];
                this.window[this.unpPtr++] = this.window[destPtr++];
                while (length > 2) {
                    --length;
                    this.window[this.unpPtr++] = this.window[destPtr++];
                }
            }
        } else {
            while (length-- != 0) {
                this.window[this.unpPtr] = this.window[destPtr++ & 0x3FFFFF];
                this.unpPtr = this.unpPtr + 1 & 0x3FFFFF;
            }
        }
    }

    protected void makeDecodeTables(byte[] lenTab, int offset, Decode dec, int size) {
        int i;
        int[] lenCount = new int[16];
        int[] tmpPos = new int[16];
        Arrays.fill(lenCount, 0);
        Arrays.fill(dec.getDecodeNum(), 0);
        for (i = 0; i < size; ++i) {
            int n = lenTab[offset + i] & 0xF;
            lenCount[n] = lenCount[n] + 1;
        }
        lenCount[0] = 0;
        tmpPos[0] = 0;
        dec.getDecodePos()[0] = 0;
        dec.getDecodeLen()[0] = 0;
        long N2 = 0L;
        for (i = 1; i < 16; ++i) {
            long M = (N2 = 2L * (N2 + (long)lenCount[i])) << 15 - i;
            if (M > 65535L) {
                M = 65535L;
            }
            dec.getDecodeLen()[i] = (int)M;
            int n = dec.getDecodePos()[i - 1] + lenCount[i - 1];
            dec.getDecodePos()[i] = n;
            tmpPos[i] = n;
        }
        for (i = 0; i < size; ++i) {
            if (lenTab[offset + i] == 0) continue;
            int n = lenTab[offset + i] & 0xF;
            int n2 = tmpPos[n];
            tmpPos[n] = n2 + 1;
            dec.getDecodeNum()[n2] = i;
        }
        dec.setMaxNum(size);
    }

    protected int decodeNumber(Decode dec) {
        int[] decodeLen;
        long bitField = this.getbits() & 0xFFFE;
        int bits = bitField < (long)(decodeLen = dec.getDecodeLen())[8] ? (bitField < (long)decodeLen[4] ? (bitField < (long)decodeLen[2] ? (bitField < (long)decodeLen[1] ? 1 : 2) : (bitField < (long)decodeLen[3] ? 3 : 4)) : (bitField < (long)decodeLen[6] ? (bitField < (long)decodeLen[5] ? 5 : 6) : (bitField < (long)decodeLen[7] ? 7 : 8))) : (bitField < (long)decodeLen[12] ? (bitField < (long)decodeLen[10] ? (bitField < (long)decodeLen[9] ? 9 : 10) : (bitField < (long)decodeLen[11] ? 11 : 12)) : (bitField < (long)decodeLen[14] ? (bitField < (long)decodeLen[13] ? 13 : 14) : 15));
        this.addbits(bits);
        int N2 = dec.getDecodePos()[bits] + ((int)bitField - decodeLen[bits - 1] >>> 16 - bits);
        if (N2 >= dec.getMaxNum()) {
            N2 = 0;
        }
        return dec.getDecodeNum()[N2];
    }

    protected boolean ReadTables20() throws IOException, RarException {
        int I;
        int TableSize;
        byte[] BitLength = new byte[19];
        byte[] Table2 = new byte[1028];
        if (this.inAddr > this.readTop - 25 && !this.unpReadBuf()) {
            return false;
        }
        int BitField2 = this.getbits();
        this.UnpAudioBlock = BitField2 & 0x8000;
        if (0 == (BitField2 & 0x4000)) {
            Arrays.fill(this.UnpOldTable20, (byte)0);
        }
        this.addbits(2);
        if (this.UnpAudioBlock != 0) {
            this.UnpChannels = (BitField2 >>> 12 & 3) + 1;
            if (this.UnpCurChannel >= this.UnpChannels) {
                this.UnpCurChannel = 0;
            }
            this.addbits(2);
            TableSize = 257 * this.UnpChannels;
        } else {
            TableSize = 374;
        }
        for (I = 0; I < 19; ++I) {
            BitLength[I] = (byte)(this.getbits() >>> 12);
            this.addbits(4);
        }
        this.makeDecodeTables(BitLength, 0, this.BD, 19);
        I = 0;
        while (I < TableSize) {
            int N2;
            if (this.inAddr > this.readTop - 5 && !this.unpReadBuf()) {
                return false;
            }
            int Number2 = this.decodeNumber(this.BD);
            if (Number2 < 16) {
                Table2[I] = (byte)(Number2 + this.UnpOldTable20[I] & 0xF);
                ++I;
                continue;
            }
            if (Number2 == 16) {
                N2 = (this.getbits() >>> 14) + 3;
                this.addbits(2);
                while (N2-- > 0 && I < TableSize) {
                    Table2[I] = Table2[I - 1];
                    ++I;
                }
                continue;
            }
            if (Number2 == 17) {
                N2 = (this.getbits() >>> 13) + 3;
                this.addbits(3);
            } else {
                N2 = (this.getbits() >>> 9) + 11;
                this.addbits(7);
            }
            while (N2-- > 0 && I < TableSize) {
                Table2[I++] = 0;
            }
        }
        if (this.inAddr > this.readTop) {
            return true;
        }
        if (this.UnpAudioBlock != 0) {
            for (I = 0; I < this.UnpChannels; ++I) {
                this.makeDecodeTables(Table2, I * 257, this.MD[I], 257);
            }
        } else {
            this.makeDecodeTables(Table2, 0, this.LD, 298);
            this.makeDecodeTables(Table2, 298, this.DD, 48);
            this.makeDecodeTables(Table2, 346, this.RD, 28);
        }
        System.arraycopy(Table2, 0, this.UnpOldTable20, 0, this.UnpOldTable20.length);
        return true;
    }

    protected void unpInitData20(boolean Solid) {
        if (!Solid) {
            int i;
            this.UnpCurChannel = 0;
            this.UnpChannelDelta = 0;
            this.UnpChannels = 1;
            for (i = 0; i < this.AudV.length; ++i) {
                this.AudV[i] = new AudioVariables();
            }
            Arrays.fill(this.UnpOldTable20, (byte)0);
            for (i = 0; i < this.MD.length; ++i) {
                this.MD[i] = new MultDecode();
            }
        }
    }

    protected void ReadLastTables() throws IOException, RarException {
        if (this.readTop >= this.inAddr + 5) {
            if (this.UnpAudioBlock != 0) {
                if (this.decodeNumber(this.MD[this.UnpCurChannel]) == 256) {
                    this.ReadTables20();
                }
            } else if (this.decodeNumber(this.LD) == 269) {
                this.ReadTables20();
            }
        }
    }

    protected byte DecodeAudio(int Delta2) {
        AudioVariables v = this.AudV[this.UnpCurChannel];
        v.setByteCount(v.getByteCount() + 1);
        v.setD4(v.getD3());
        v.setD3(v.getD2());
        v.setD2(v.getLastDelta() - v.getD1());
        v.setD1(v.getLastDelta());
        int PCh = 8 * v.getLastChar() + v.getK1() * v.getD1();
        PCh += v.getK2() * v.getD2() + v.getK3() * v.getD3();
        PCh += v.getK4() * v.getD4() + v.getK5() * this.UnpChannelDelta;
        PCh = PCh >>> 3 & 0xFF;
        int Ch = PCh - Delta2;
        int D = (byte)Delta2 << 3;
        int[] nArray = v.getDif();
        nArray[0] = nArray[0] + Math.abs(D);
        int[] nArray2 = v.getDif();
        nArray2[1] = nArray2[1] + Math.abs(D - v.getD1());
        int[] nArray3 = v.getDif();
        nArray3[2] = nArray3[2] + Math.abs(D + v.getD1());
        int[] nArray4 = v.getDif();
        nArray4[3] = nArray4[3] + Math.abs(D - v.getD2());
        int[] nArray5 = v.getDif();
        nArray5[4] = nArray5[4] + Math.abs(D + v.getD2());
        int[] nArray6 = v.getDif();
        nArray6[5] = nArray6[5] + Math.abs(D - v.getD3());
        int[] nArray7 = v.getDif();
        nArray7[6] = nArray7[6] + Math.abs(D + v.getD3());
        int[] nArray8 = v.getDif();
        nArray8[7] = nArray8[7] + Math.abs(D - v.getD4());
        int[] nArray9 = v.getDif();
        nArray9[8] = nArray9[8] + Math.abs(D + v.getD4());
        int[] nArray10 = v.getDif();
        nArray10[9] = nArray10[9] + Math.abs(D - this.UnpChannelDelta);
        int[] nArray11 = v.getDif();
        nArray11[10] = nArray11[10] + Math.abs(D + this.UnpChannelDelta);
        v.setLastDelta((byte)(Ch - v.getLastChar()));
        this.UnpChannelDelta = v.getLastDelta();
        v.setLastChar(Ch);
        if ((v.getByteCount() & 0x1F) == 0) {
            int MinDif = v.getDif()[0];
            int NumMinDif = 0;
            v.getDif()[0] = 0;
            for (int I = 1; I < v.getDif().length; ++I) {
                if (v.getDif()[I] < MinDif) {
                    MinDif = v.getDif()[I];
                    NumMinDif = I;
                }
                v.getDif()[I] = 0;
            }
            switch (NumMinDif) {
                case 1: {
                    if (v.getK1() < -16) break;
                    v.setK1(v.getK1() - 1);
                    break;
                }
                case 2: {
                    if (v.getK1() >= 16) break;
                    v.setK1(v.getK1() + 1);
                    break;
                }
                case 3: {
                    if (v.getK2() < -16) break;
                    v.setK2(v.getK2() - 1);
                    break;
                }
                case 4: {
                    if (v.getK2() >= 16) break;
                    v.setK2(v.getK2() + 1);
                    break;
                }
                case 5: {
                    if (v.getK3() < -16) break;
                    v.setK3(v.getK3() - 1);
                    break;
                }
                case 6: {
                    if (v.getK3() >= 16) break;
                    v.setK3(v.getK3() + 1);
                    break;
                }
                case 7: {
                    if (v.getK4() < -16) break;
                    v.setK4(v.getK4() - 1);
                    break;
                }
                case 8: {
                    if (v.getK4() >= 16) break;
                    v.setK4(v.getK4() + 1);
                    break;
                }
                case 9: {
                    if (v.getK5() < -16) break;
                    v.setK5(v.getK5() - 1);
                    break;
                }
                case 10: {
                    if (v.getK5() >= 16) break;
                    v.setK5(v.getK5() + 1);
                }
            }
        }
        return (byte)Ch;
    }
}

