/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.DateTimeType;
import com.healthmarketscience.jackcess.InvalidValueException;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.expr.Identifier;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CalcColEvalContext;
import com.healthmarketscience.jackcess.impl.CalculatedColumnUtil;
import com.healthmarketscience.jackcess.impl.ColDefaultValueEvalContext;
import com.healthmarketscience.jackcess.impl.ColValidatorEvalContext;
import com.healthmarketscience.jackcess.impl.ComplexColumnImpl;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.DateTimeContext;
import com.healthmarketscience.jackcess.impl.InternalColumnValidator;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.LongValueColumnImpl;
import com.healthmarketscience.jackcess.impl.MemoColumnImpl;
import com.healthmarketscience.jackcess.impl.NumericColumnImpl;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.PropertyMapImpl;
import com.healthmarketscience.jackcess.impl.PropertyMaps;
import com.healthmarketscience.jackcess.impl.SqlHelper;
import com.healthmarketscience.jackcess.impl.TableCreator;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TableMutator;
import com.healthmarketscience.jackcess.impl.TextColumnImpl;
import com.healthmarketscience.jackcess.impl.UnsupportedColumnImpl;
import com.healthmarketscience.jackcess.impl.UsageMap;
import com.healthmarketscience.jackcess.impl.complex.ComplexValueForeignKeyImpl;
import com.healthmarketscience.jackcess.impl.expr.NumberFormatter;
import com.healthmarketscience.jackcess.util.ColumnValidator;
import com.healthmarketscience.jackcess.util.SimpleColumnValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnImpl
implements Column,
Comparable<ColumnImpl>,
DateTimeContext {
    protected static final Log LOG = LogFactory.getLog(ColumnImpl.class);
    public static final Object RETURN_ROW_ID = "<RETURN_ROW_ID>";
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MILLI = 1000000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    static final long MILLIS_BETWEEN_EPOCH_AND_1900 = 2209161600000L;
    public static final LocalDate BASE_LD = LocalDate.of(1899, 12, 30);
    public static final LocalTime BASE_LT = LocalTime.of(0, 0);
    public static final LocalDateTime BASE_LDT = LocalDateTime.of(BASE_LD, BASE_LT);
    private static final LocalDate BASE_EXT_LD = LocalDate.of(1, 1, 1);
    private static final LocalTime BASE_EXT_LT = LocalTime.of(0, 0);
    private static final LocalDateTime BASE_EXT_LDT = LocalDateTime.of(BASE_EXT_LD, BASE_EXT_LT);
    private static final byte[] EXT_LDT_TRAILER = new byte[]{58, 55, 0};
    private static final DateTimeFactory DEF_DATE_TIME_FACTORY = new DefaultDateTimeFactory();
    static final DateTimeFactory LDT_DATE_TIME_FACTORY = new LDTDateTimeFactory();
    public static final byte FIXED_LEN_FLAG_MASK = 1;
    public static final byte AUTO_NUMBER_FLAG_MASK = 4;
    public static final byte AUTO_NUMBER_GUID_FLAG_MASK = 64;
    public static final byte HYPERLINK_FLAG_MASK = -128;
    public static final byte UPDATABLE_FLAG_MASK = 2;
    protected static final byte COMPRESSED_UNICODE_EXT_FLAG_MASK = 1;
    private static final byte CALCULATED_EXT_FLAG_MASK = -64;
    static final byte NUMERIC_NEGATIVE_BYTE = -128;
    private static final short GENERAL_SORT_ORDER_VALUE = 1033;
    public static final SortOrder GENERAL_97_SORT_ORDER = new SortOrder(1033, -1);
    public static final SortOrder GENERAL_LEGACY_SORT_ORDER = new SortOrder(1033, 0);
    public static final SortOrder GENERAL_SORT_ORDER = new SortOrder(1033, 1);
    private static final Pattern GUID_PATTERN = Pattern.compile("\\s*[{]?([\\p{XDigit}]{8})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{12})[}]?\\s*");
    private static final byte[] TEXT_COMPRESSION_HEADER = new byte[]{-1, -2};
    private static final char MIN_COMPRESS_CHAR = '\u0001';
    private static final char MAX_COMPRESS_CHAR = '\u00ff';
    static final int INVALID_AUTO_NUMBER = 0;
    static final int INVALID_LENGTH = -1;
    private final TableImpl _table;
    private final boolean _variableLength;
    private final boolean _autoNumber;
    private final boolean _calculated;
    private final DataType _type;
    private final short _columnLength;
    private final short _columnNumber;
    private int _columnIndex;
    private final int _displayIndex;
    private final String _name;
    private final int _fixedDataOffset;
    private final int _varLenTableIndex;
    private final AutoNumberGenerator _autoNumberGenerator;
    private PropertyMap _props;
    private ColumnValidator _validator = SimpleColumnValidator.INSTANCE;
    private ColDefaultValueEvalContext _defValue;
    private int _lengthInUnits = -1;

    protected ColumnImpl(TableImpl table, String name, DataType type, int colNumber, int fixedOffset, int varLenIndex) {
        this._table = table;
        this._name = name;
        this._type = type;
        this._columnLength = !this._type.isVariableLength() ? (short)type.getFixedSize() : (short)type.getMaxSize();
        this._variableLength = type.isVariableLength();
        this._autoNumber = false;
        this._calculated = false;
        this._autoNumberGenerator = null;
        this._columnNumber = (short)colNumber;
        this._columnIndex = colNumber;
        this._displayIndex = colNumber;
        this._fixedDataOffset = fixedOffset;
        this._varLenTableIndex = varLenIndex;
    }

    ColumnImpl(InitArgs args) throws IOException {
        this._table = args.table;
        this._name = args.name;
        this._displayIndex = args.displayIndex;
        this._type = args.type;
        this._columnNumber = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_NUMBER);
        this._columnLength = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_LENGTH);
        this._variableLength = (args.flags & 1) == 0;
        this._autoNumber = (args.flags & 0x44) != 0;
        this._calculated = (args.extFlags & 0xFFFFFFC0) != 0;
        this._autoNumberGenerator = this.createAutoNumberGenerator();
        if (this._variableLength) {
            this._varLenTableIndex = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_VARIABLE_TABLE_INDEX);
            this._fixedDataOffset = 0;
        } else {
            this._fixedDataOffset = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_FIXED_DATA_OFFSET);
            this._varLenTableIndex = 0;
        }
    }

    public static ColumnImpl create(TableImpl table, ByteBuffer buffer, int offset, String name, int displayIndex) throws IOException {
        PropertyMapImpl colProps;
        Byte resultType;
        InitArgs args = new InitArgs(table, buffer, offset, name, displayIndex);
        boolean calculated = (args.extFlags & 0xFFFFFFC0) != 0;
        byte colType = args.colType;
        if (calculated && (resultType = (Byte)(colProps = table.getPropertyMaps().get(name)).getValue("ResultType")) != null) {
            colType = resultType;
        }
        try {
            args.type = DataType.fromByte(colType);
        }
        catch (IOException e) {
            LOG.warn(ColumnImpl.withErrorContext("Unsupported column type " + colType, table.getDatabase(), table.getName(), name));
            boolean variableLength = (args.flags & 1) == 0;
            args.type = variableLength ? DataType.UNSUPPORTED_VARLEN : DataType.UNSUPPORTED_FIXEDLEN;
            return new UnsupportedColumnImpl(args);
        }
        if (calculated) {
            return CalculatedColumnUtil.create(args);
        }
        switch (args.type) {
            case TEXT: {
                return new TextColumnImpl(args);
            }
            case MEMO: {
                return new MemoColumnImpl(args);
            }
            case COMPLEX_TYPE: {
                return new ComplexColumnImpl(args);
            }
        }
        if (args.type.getHasScalePrecision()) {
            return new NumericColumnImpl(args);
        }
        if (args.type.isLongValue()) {
            return new LongValueColumnImpl(args);
        }
        return new ColumnImpl(args);
    }

    void setUsageMaps(UsageMap ownedPages, UsageMap freeSpacePages) {
    }

    void collectUsageMapPages(Collection<Integer> pages) {
    }

    void postTableLoadInit() throws IOException {
    }

    @Override
    public TableImpl getTable() {
        return this._table;
    }

    @Override
    public DatabaseImpl getDatabase() {
        return this.getTable().getDatabase();
    }

    public JetFormat getFormat() {
        return this.getDatabase().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getDatabase().getPageChannel();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isVariableLength() {
        return this._variableLength;
    }

    @Override
    public boolean isAutoNumber() {
        return this._autoNumber;
    }

    public short getColumnNumber() {
        return this._columnNumber;
    }

    @Override
    public int getColumnIndex() {
        return this._columnIndex;
    }

    public void setColumnIndex(int newColumnIndex) {
        this._columnIndex = newColumnIndex;
    }

    public int getDisplayIndex() {
        return this._displayIndex;
    }

    @Override
    public DataType getType() {
        return this._type;
    }

    @Override
    public int getSQLType() throws IOException {
        return this._type.getSQLType();
    }

    @Override
    public boolean isCompressedUnicode() {
        return false;
    }

    @Override
    public byte getPrecision() {
        return (byte)this.getType().getDefaultPrecision();
    }

    @Override
    public byte getScale() {
        return (byte)this.getType().getDefaultScale();
    }

    public SortOrder getTextSortOrder() {
        return null;
    }

    public short getTextCodePage() {
        return 0;
    }

    @Override
    public short getLength() {
        return this._columnLength;
    }

    @Override
    public final short getLengthInUnits() {
        if (this._lengthInUnits == -1) {
            this._lengthInUnits = this.calcLengthInUnits();
        }
        return (short)this._lengthInUnits;
    }

    protected int calcLengthInUnits() {
        return this.getType().toUnitSize(this.getLength(), this.getFormat());
    }

    @Override
    public boolean isCalculated() {
        return this._calculated;
    }

    public int getVarLenTableIndex() {
        return this._varLenTableIndex;
    }

    public int getFixedDataOffset() {
        return this._fixedDataOffset;
    }

    protected Charset getCharset() {
        return this.getDatabase().getCharset();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.getDatabase().getTimeZone();
    }

    @Override
    public ZoneId getZoneId() {
        return this.getDatabase().getZoneId();
    }

    @Override
    public DateTimeFactory getDateTimeFactory() {
        return this.getDatabase().getDateTimeFactory();
    }

    @Override
    public boolean isAppendOnly() {
        return this.getVersionHistoryColumn() != null;
    }

    @Override
    public ColumnImpl getVersionHistoryColumn() {
        return null;
    }

    public int getOwnedPageCount() {
        return 0;
    }

    public void setVersionHistoryColumn(ColumnImpl versionHistoryCol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHyperlink() {
        return false;
    }

    @Override
    public ComplexColumnInfo<? extends ComplexValue> getComplexInfo() {
        return null;
    }

    void initColumnValidator() throws IOException {
        if (this.getDatabase().isReadOnly()) {
            return;
        }
        this.setColumnValidator(null);
        this.reloadPropertiesValidators();
    }

    void reloadPropertiesValidators() throws IOException {
        String defValueStr;
        boolean allowZeroLen;
        if (this.isAutoNumber()) {
            return;
        }
        if (this.isCalculated()) {
            CalcColEvalContext calcCol = null;
            if (this.getDatabase().isEvaluateExpressions()) {
                PropertyMap props = this.getProperties();
                String calcExpr = (String)props.getValue("Expression");
                calcCol = new CalcColEvalContext(this).setExpr(calcExpr);
            }
            this.setCalcColEvalContext(calcCol);
            return;
        }
        this._validator = this.getColumnValidator();
        this._defValue = null;
        PropertyMap props = this.getProperties();
        boolean required = (Boolean)props.getValue("Required", Boolean.FALSE);
        if (required) {
            this._validator = new RequiredColValidator(this._validator);
        }
        boolean bl = allowZeroLen = !this.getType().isTextual() || (Boolean)props.getValue("AllowZeroLength", Boolean.TRUE) != false;
        if (!allowZeroLen) {
            this._validator = new NoZeroLenColValidator(this._validator);
        }
        if (!this.getDatabase().isEvaluateExpressions()) {
            return;
        }
        String exprStr = PropertyMaps.getTrimmedStringProperty(props, "ValidationRule");
        if (exprStr != null) {
            String helpStr = PropertyMaps.getTrimmedStringProperty(props, "ValidationText");
            this._validator = new ColValidatorEvalContext(this).setExpr(exprStr, helpStr).toColumnValidator(this._validator);
        }
        if ((defValueStr = PropertyMaps.getTrimmedStringProperty(props, "DefaultValue")) != null) {
            this._defValue = new ColDefaultValueEvalContext(this).setExpr(defValueStr);
        }
    }

    void propertiesUpdated() throws IOException {
        this.reloadPropertiesValidators();
    }

    @Override
    public ColumnValidator getColumnValidator() {
        return this._validator instanceof InternalColumnValidator ? ((InternalColumnValidator)this._validator).getExternal() : this._validator;
    }

    @Override
    public void setColumnValidator(ColumnValidator newValidator) {
        if (this.isAutoNumber()) {
            if (newValidator != null) {
                throw new IllegalArgumentException(this.withErrorContext("Cannot set ColumnValidator for autonumber columns"));
            }
            return;
        }
        if (newValidator == null && (newValidator = this.getDatabase().getColumnValidatorFactory().createValidator(this)) == null) {
            newValidator = SimpleColumnValidator.INSTANCE;
        }
        if (this._validator instanceof InternalColumnValidator) {
            ((InternalColumnValidator)this._validator).setExternal(newValidator);
        } else {
            this._validator = newValidator;
        }
    }

    byte getOriginalDataType() {
        return this._type.getValue();
    }

    private AutoNumberGenerator createAutoNumberGenerator() {
        if (!this._autoNumber || this._type == null) {
            return null;
        }
        switch (this._type) {
            case LONG: {
                return new LongAutoNumberGenerator();
            }
            case GUID: {
                return new GuidAutoNumberGenerator();
            }
            case COMPLEX_TYPE: {
                return new ComplexTypeAutoNumberGenerator();
            }
        }
        LOG.warn(this.withErrorContext("Unknown auto number column type " + (Object)((Object)this._type)));
        return new UnsupportedAutoNumberGenerator(this._type);
    }

    public AutoNumberGenerator getAutoNumberGenerator() {
        return this._autoNumberGenerator;
    }

    @Override
    public PropertyMap getProperties() throws IOException {
        if (this._props == null) {
            this._props = this.getTable().getPropertyMaps().get(this.getName());
        }
        return this._props;
    }

    @Override
    public Object setRowValue(Object[] rowArray, Object value) {
        rowArray[this._columnIndex] = value;
        return value;
    }

    @Override
    public Object setRowValue(Map<String, Object> rowMap, Object value) {
        rowMap.put(this._name, value);
        return value;
    }

    @Override
    public Object getRowValue(Object[] rowArray) {
        return rowArray[this._columnIndex];
    }

    @Override
    public Object getRowValue(Map<String, ?> rowMap) {
        return rowMap.get(this._name);
    }

    public boolean storeInNullMask() {
        return this.getType() == DataType.BOOLEAN;
    }

    public boolean writeToNullMask(Object value) {
        return ColumnImpl.toBooleanValue(value);
    }

    public Object readFromNullMask(boolean isNull) {
        return !isNull;
    }

    public Object read(byte[] data) throws IOException {
        return this.read(data, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public Object read(byte[] data, ByteOrder order) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(order);
        switch (this.getType()) {
            case BOOLEAN: {
                throw new IOException(this.withErrorContext("Tried to read a boolean from data instead of null mask."));
            }
            case BYTE: {
                return buffer.get();
            }
            case INT: {
                return buffer.getShort();
            }
            case LONG: {
                return buffer.getInt();
            }
            case DOUBLE: {
                return buffer.getDouble();
            }
            case FLOAT: {
                return Float.valueOf(buffer.getFloat());
            }
            case SHORT_DATE_TIME: {
                return this.readDateValue(buffer);
            }
            case BINARY: {
                return data;
            }
            case TEXT: {
                return this.decodeTextValue(data);
            }
            case MONEY: {
                return this.readCurrencyValue(buffer);
            }
            case NUMERIC: {
                return this.readNumericValue(buffer);
            }
            case GUID: {
                return ColumnImpl.readGUIDValue(buffer, order);
            }
            case EXT_DATE_TIME: {
                return ColumnImpl.readExtendedDateValue(buffer);
            }
            case UNKNOWN_0D: 
            case UNKNOWN_11: {
                return data;
            }
            case COMPLEX_TYPE: {
                return new ComplexValueForeignKeyImpl(this, buffer.getInt());
            }
            case BIG_INT: {
                return buffer.getLong();
            }
        }
        throw new IOException(this.withErrorContext("Unrecognized data type: " + (Object)((Object)this._type)));
    }

    private BigDecimal readCurrencyValue(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() != 8) {
            throw new IOException(this.withErrorContext("Invalid money value"));
        }
        return new BigDecimal(BigInteger.valueOf(buffer.getLong(0)), 4);
    }

    private void writeCurrencyValue(ByteBuffer buffer, Object value) throws IOException {
        Object inValue = value;
        try {
            BigDecimal decVal = this.toBigDecimal(value);
            inValue = decVal;
            decVal = decVal.setScale(4);
            buffer.putLong(decVal.movePointRight(4).longValueExact());
        }
        catch (ArithmeticException e) {
            throw new IOException(this.withErrorContext("Currency value '" + inValue + "' out of range"), e);
        }
    }

    private BigDecimal readNumericValue(ByteBuffer buffer) {
        boolean negate = buffer.get() != 0;
        byte[] tmpArr = ByteUtil.getBytes(buffer, 16);
        if (buffer.order() != ByteOrder.BIG_ENDIAN) {
            ColumnImpl.fixNumericByteOrder(tmpArr);
        }
        return ColumnImpl.toBigDecimal(tmpArr, negate, this.getScale());
    }

    static BigDecimal toBigDecimal(byte[] bytes, boolean negate, int scale) {
        if ((bytes[0] & 0x80) != 0) {
            bytes = ByteUtil.copyOf(bytes, 0, bytes.length + 1, 1);
        }
        BigInteger intVal = new BigInteger(bytes);
        if (negate) {
            intVal = intVal.negate();
        }
        return new BigDecimal(intVal, scale);
    }

    private void writeNumericValue(ByteBuffer buffer, Object value) throws IOException {
        Object inValue = value;
        try {
            BigDecimal decVal = this.toBigDecimal(value);
            inValue = decVal;
            int signum = decVal.signum();
            if (signum < 0) {
                decVal = decVal.negate();
            }
            buffer.put(signum < 0 ? (byte)-128 : 0);
            decVal = decVal.setScale(this.getScale());
            if (decVal.precision() > this.getPrecision()) {
                throw new InvalidValueException(this.withErrorContext("Numeric value is too big for specified precision " + this.getPrecision() + ": " + decVal));
            }
            byte[] intValBytes = this.toUnscaledByteArray(decVal, this.getType().getFixedSize() - 1);
            if (buffer.order() != ByteOrder.BIG_ENDIAN) {
                ColumnImpl.fixNumericByteOrder(intValBytes);
            }
            buffer.put(intValBytes);
        }
        catch (ArithmeticException e) {
            throw new IOException(this.withErrorContext("Numeric value '" + inValue + "' out of range"), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] toUnscaledByteArray(BigDecimal decVal, int maxByteLen) throws IOException {
        byte[] intValBytes = decVal.unscaledValue().toByteArray();
        if (intValBytes.length > maxByteLen) {
            if (intValBytes[0] != 0) throw new InvalidValueException(this.withErrorContext("Too many bytes for valid BigInteger?"));
            if (intValBytes.length - 1 != maxByteLen) throw new InvalidValueException(this.withErrorContext("Too many bytes for valid BigInteger?"));
            return ByteUtil.copyOf(intValBytes, 1, maxByteLen);
        }
        if (intValBytes.length >= maxByteLen) return intValBytes;
        return ByteUtil.copyOf(intValBytes, 0, maxByteLen, maxByteLen - intValBytes.length);
    }

    private Object readDateValue(ByteBuffer buffer) {
        long dateBits = buffer.getLong();
        return this.getDateTimeFactory().fromDateBits(this, dateBits);
    }

    private static Object readExtendedDateValue(ByteBuffer buffer) {
        long numDays = ColumnImpl.readExtDateLong(buffer, 19);
        buffer.get();
        long seconds = ColumnImpl.readExtDateLong(buffer, 12);
        long nanos = ColumnImpl.readExtDateLong(buffer, 7) * 100L;
        ByteUtil.forward(buffer, EXT_LDT_TRAILER.length);
        return BASE_EXT_LDT.plusDays(numDays).plusSeconds(seconds).plusNanos(nanos);
    }

    private static long readExtDateLong(ByteBuffer buffer, int numChars) {
        long val = 0L;
        for (int i = 0; i < numChars; ++i) {
            char digit = (char)buffer.get();
            long inc = digit - 48;
            val = val * 10L + inc;
        }
        return val;
    }

    public long fromDateDouble(double value) {
        return ColumnImpl.fromDateDouble(value, this.getTimeZone());
    }

    private static long fromDateDouble(double value, TimeZone tz) {
        long localTime = ColumnImpl.fromLocalDateDouble(value);
        return localTime - ColumnImpl.getFromLocalTimeZoneOffset(localTime, tz);
    }

    static long fromLocalDateDouble(double value) {
        long datePart = (long)value * 86400000L;
        long timePart = Math.round(Math.abs(value) % 1.0 * 8.64E7);
        long time = datePart + timePart;
        return time - 2209161600000L;
    }

    public static LocalDateTime ldtFromLocalDateDouble(double value) {
        Duration dateTimeOffset = ColumnImpl.durationFromLocalDateDouble(value);
        return BASE_LDT.plus(dateTimeOffset);
    }

    private static Duration durationFromLocalDateDouble(double value) {
        long dateSeconds = (long)value * 86400L;
        double secondsDouble = Math.abs(value) % 1.0 * 86400.0;
        long timeSeconds = (long)secondsDouble;
        long timeMillis = (long)(ColumnImpl.roundToMillis(secondsDouble % 1.0) * 1000.0);
        return Duration.ofSeconds(dateSeconds + timeSeconds, timeMillis * 1000000L);
    }

    private void writeDateValue(ByteBuffer buffer, Object value) throws InvalidValueException {
        if (value == null) {
            buffer.putDouble(0.0);
        } else if (value instanceof DateExt) {
            buffer.putLong(((DateExt)value).getDateBits());
        } else {
            buffer.putDouble(this.toDateDouble(value));
        }
    }

    private void writeExtendedDateValue(ByteBuffer buffer, Object value) throws InvalidValueException {
        LocalDateTime ldt = BASE_EXT_LDT;
        if (value != null) {
            ldt = ColumnImpl.toLocalDateTime(value, this);
        }
        LocalDate ld = ldt.toLocalDate();
        LocalTime lt = ldt.toLocalTime();
        long numDays = BASE_EXT_LD.until(ld, ChronoUnit.DAYS);
        long numSeconds = BASE_EXT_LT.until(lt, ChronoUnit.SECONDS);
        long nanos = lt.getNano();
        ColumnImpl.writeExtDateLong(buffer, numDays, 19);
        buffer.put((byte)58);
        ColumnImpl.writeExtDateLong(buffer, numSeconds, 12);
        ColumnImpl.writeExtDateLong(buffer, nanos / 100L, 7);
        buffer.put(EXT_LDT_TRAILER);
    }

    private static void writeExtDateLong(ByteBuffer buffer, long val, int numChars) {
        int start;
        int end = buffer.position();
        for (int i = start = end + numChars - 1; i >= end; --i) {
            char digit = (char)(48 + (char)(val % 10L));
            buffer.put(i, (byte)digit);
            val /= 10L;
        }
        ByteUtil.forward(buffer, numChars);
    }

    public double toDateDouble(Object value) throws InvalidValueException {
        try {
            return ColumnImpl.toDateDouble(value, this);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidValueException(this.withErrorContext(iae.getMessage()), iae);
        }
    }

    private static double toDateDouble(Object value, DateTimeContext dtc) {
        return dtc.getDateTimeFactory().toDateDouble(value, dtc);
    }

    static LocalDateTime toLocalDateTime(Object value, DateTimeContext dtc) {
        if (value instanceof TemporalAccessor) {
            return ColumnImpl.temporalToLocalDateTime((TemporalAccessor)value, dtc);
        }
        Instant inst = Instant.ofEpochMilli(ColumnImpl.toDateLong(value));
        return LocalDateTime.ofInstant(inst, dtc.getZoneId());
    }

    private static LocalDateTime temporalToLocalDateTime(TemporalAccessor value, DateTimeContext dtc) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).withZoneSameInstant(dtc.getZoneId()).toLocalDateTime();
        }
        if (value instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)value, dtc.getZoneId());
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atTime(BASE_LT);
        }
        if (value instanceof LocalTime) {
            return ((LocalTime)value).atDate(BASE_LD);
        }
        try {
            ZoneId zoneId;
            ZoneId zone;
            LocalTime lt;
            LocalDate ld = value.query(TemporalQueries.localDate());
            if (ld == null) {
                ld = BASE_LD;
            }
            if ((lt = value.query(TemporalQueries.localTime())) == null) {
                lt = BASE_LT;
            }
            if ((zone = value.query(TemporalQueries.zone())) != null && !(zoneId = dtc.getZoneId()).equals(zone)) {
                return ZonedDateTime.of(ld, lt, zone).withZoneSameInstant(zoneId).toLocalDateTime();
            }
            return LocalDateTime.of(ld, lt);
        }
        catch (ArithmeticException | DateTimeException e) {
            throw new IllegalArgumentException("Unsupported temporal type " + value.getClass(), e);
        }
    }

    private static Instant toInstant(TemporalAccessor value, DateTimeContext dtc) {
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toInstant();
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        return ColumnImpl.temporalToLocalDateTime(value, dtc).atZone(dtc.getZoneId()).toInstant();
    }

    static double toLocalDateDouble(long time) {
        long timePart;
        if ((time += 2209161600000L) < 0L && (timePart = -time % 86400000L) > 0L) {
            time -= 2L * (86400000L - timePart);
        }
        return (double)time / 8.64E7;
    }

    public static double toDateDouble(LocalDateTime ldt) {
        Duration dateTimeOffset = Duration.between(BASE_LDT, ldt);
        return ColumnImpl.toLocalDateDouble(dateTimeOffset);
    }

    private static double toLocalDateDouble(Duration time) {
        long dateTimeSeconds = time.getSeconds();
        long timeSeconds = dateTimeSeconds % 86400L;
        if (timeSeconds < 0L) {
            timeSeconds += 86400L;
        }
        long dateSeconds = dateTimeSeconds - timeSeconds;
        long timeNanos = time.getNano();
        double timeDouble = (ColumnImpl.roundToMillis((double)timeNanos / 1.0E9) + (double)timeSeconds) / 86400.0;
        double dateDouble = (double)dateSeconds / 86400.0;
        if (dateSeconds < 0L) {
            timeDouble = -timeDouble;
        }
        return dateDouble + timeDouble;
    }

    private static double roundToMillis(double dbl) {
        return dbl == 0.0 ? dbl : new BigDecimal(dbl).setScale(3, NumberFormatter.ROUND_MODE).doubleValue();
    }

    private static long toDateLong(Object value) {
        return value instanceof Date ? ((Date)value).getTime() : (value instanceof Calendar ? ((Calendar)value).getTimeInMillis() : ((Number)value).longValue());
    }

    private static long getToLocalTimeZoneOffset(long time, TimeZone tz) {
        return tz.getOffset(time);
    }

    private static long getFromLocalTimeZoneOffset(long time, TimeZone tz) {
        return tz.getOffset(time - (long)tz.getRawOffset());
    }

    private static String readGUIDValue(ByteBuffer buffer, ByteOrder order) {
        if (order != ByteOrder.BIG_ENDIAN) {
            byte[] tmpArr = ByteUtil.getBytes(buffer, 16);
            ByteUtil.swap4Bytes(tmpArr, 0);
            ByteUtil.swap2Bytes(tmpArr, 4);
            ByteUtil.swap2Bytes(tmpArr, 6);
            buffer = ByteBuffer.wrap(tmpArr);
        }
        StringBuilder sb = new StringBuilder(22);
        sb.append("{");
        sb.append(ByteUtil.toHexString(buffer, 0, 4, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 4, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 6, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 8, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 10, 6, false));
        sb.append("}");
        return sb.toString();
    }

    private void writeGUIDValue(ByteBuffer buffer, Object value) throws IOException {
        Matcher m4 = GUID_PATTERN.matcher(ColumnImpl.toCharSequence(value));
        if (!m4.matches()) {
            throw new InvalidValueException(this.withErrorContext("Invalid GUID: " + value));
        }
        ByteBuffer origBuffer = null;
        byte[] tmpBuf = null;
        if (buffer.order() != ByteOrder.BIG_ENDIAN) {
            origBuffer = buffer;
            tmpBuf = new byte[16];
            buffer = ByteBuffer.wrap(tmpBuf);
        }
        ByteUtil.writeHexString(buffer, m4.group(1));
        ByteUtil.writeHexString(buffer, m4.group(2));
        ByteUtil.writeHexString(buffer, m4.group(3));
        ByteUtil.writeHexString(buffer, m4.group(4));
        ByteUtil.writeHexString(buffer, m4.group(5));
        if (tmpBuf != null) {
            ByteUtil.swap4Bytes(tmpBuf, 0);
            ByteUtil.swap2Bytes(tmpBuf, 4);
            ByteUtil.swap2Bytes(tmpBuf, 6);
            origBuffer.put(tmpBuf);
        }
    }

    static boolean isGUIDValue(Object value) throws IOException {
        return GUID_PATTERN.matcher(ColumnImpl.toCharSequence(value)).matches();
    }

    public Object generateDefaultValue() throws IOException {
        return this._defValue != null ? this._defValue.eval() : null;
    }

    public Object validate(Object obj) throws IOException {
        return this._validator.validate(this, obj);
    }

    protected CalcColEvalContext getCalculationContext() {
        throw new UnsupportedOperationException();
    }

    protected void setCalcColEvalContext(CalcColEvalContext calcCol) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer write(Object obj, int remainingRowLength) throws IOException {
        return this.write(obj, remainingRowLength, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public ByteBuffer write(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
        if (ColumnImpl.isRawData(obj)) {
            return ByteBuffer.wrap(((RawData)obj).getBytes());
        }
        return this.writeRealData(obj, remainingRowLength, order);
    }

    protected ByteBuffer writeRealData(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
        if (!this.isVariableLength() || !this.getType().isVariableLength()) {
            return this.writeFixedLengthField(obj, order);
        }
        switch (this.getType()) {
            case NUMERIC: {
                ByteBuffer buffer = PageChannel.createBuffer(this.getType().getFixedSize(), order);
                this.writeNumericValue(buffer, obj);
                buffer.flip();
                return buffer;
            }
            case TEXT: {
                return this.encodeTextValue(obj, 0, this.getLengthInUnits(), false).order(order);
            }
            case BINARY: 
            case UNKNOWN_0D: 
            case UNSUPPORTED_VARLEN: {
                break;
            }
            default: {
                throw new RuntimeException(this.withErrorContext("unexpected inline var length type: " + (Object)((Object)this.getType())));
            }
        }
        ByteBuffer buffer = ByteBuffer.wrap(ColumnImpl.toByteArray(obj)).order(order);
        return buffer;
    }

    protected ByteBuffer writeFixedLengthField(Object obj, ByteOrder order) throws IOException {
        int size = this.getType().getFixedSize(this._columnLength);
        ByteBuffer buffer = this.writeFixedLengthField(obj, PageChannel.createBuffer(size, order));
        buffer.flip();
        return buffer;
    }

    protected ByteBuffer writeFixedLengthField(Object obj, ByteBuffer buffer) throws IOException {
        obj = ColumnImpl.booleanToInteger(obj);
        switch (this.getType()) {
            case BOOLEAN: {
                break;
            }
            case BYTE: {
                buffer.put(this.toNumber(obj).byteValue());
                break;
            }
            case INT: {
                buffer.putShort(this.toNumber(obj).shortValue());
                break;
            }
            case LONG: {
                buffer.putInt(this.toNumber(obj).intValue());
                break;
            }
            case MONEY: {
                this.writeCurrencyValue(buffer, obj);
                break;
            }
            case FLOAT: {
                buffer.putFloat(this.toNumber(obj).floatValue());
                break;
            }
            case DOUBLE: {
                buffer.putDouble(this.toNumber(obj).doubleValue());
                break;
            }
            case SHORT_DATE_TIME: {
                this.writeDateValue(buffer, obj);
                break;
            }
            case TEXT: {
                short numChars = this.getLengthInUnits();
                buffer.put(this.encodeTextValue(obj, numChars, numChars, true));
                break;
            }
            case GUID: {
                this.writeGUIDValue(buffer, obj);
                break;
            }
            case NUMERIC: {
                this.writeNumericValue(buffer, obj);
                break;
            }
            case COMPLEX_TYPE: 
            case BINARY: 
            case UNKNOWN_0D: 
            case UNKNOWN_11: {
                buffer.putInt(this.toNumber(obj).intValue());
                break;
            }
            case BIG_INT: {
                buffer.putLong(this.toNumber(obj).longValue());
                break;
            }
            case EXT_DATE_TIME: {
                this.writeExtendedDateValue(buffer, obj);
                break;
            }
            case UNSUPPORTED_FIXEDLEN: {
                byte[] bytes = ColumnImpl.toByteArray(obj);
                if (bytes.length != this.getLength()) {
                    throw new InvalidValueException(this.withErrorContext("Invalid fixed size binary data, size " + this.getLength() + ", got " + bytes.length));
                }
                buffer.put(bytes);
                break;
            }
            default: {
                throw new IOException(this.withErrorContext("Unsupported data type: " + (Object)((Object)this.getType())));
            }
        }
        return buffer;
    }

    String decodeTextValue(byte[] data) throws IOException {
        boolean isCompressed;
        boolean bl = isCompressed = data.length > 1 && data[0] == TEXT_COMPRESSION_HEADER[0] && data[1] == TEXT_COMPRESSION_HEADER[1];
        if (isCompressed) {
            int dataStart;
            StringBuilder textBuf = new StringBuilder(data.length);
            int dataEnd = dataStart = TEXT_COMPRESSION_HEADER.length;
            boolean inCompressedMode = true;
            while (dataEnd < data.length) {
                if (data[dataEnd] == 0) {
                    this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, textBuf);
                    inCompressedMode = !inCompressedMode;
                    dataStart = ++dataEnd;
                    continue;
                }
                ++dataEnd;
            }
            this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, textBuf);
            return textBuf.toString();
        }
        return ColumnImpl.decodeUncompressedText(data, this.getCharset());
    }

    private void decodeTextSegment(byte[] data, int dataStart, int dataEnd, boolean inCompressedMode, StringBuilder textBuf) {
        if (dataEnd <= dataStart) {
            return;
        }
        int dataLength = dataEnd - dataStart;
        if (inCompressedMode) {
            byte[] tmpData = new byte[dataLength * 2];
            int tmpIdx = 0;
            for (int i = dataStart; i < dataEnd; ++i) {
                tmpData[tmpIdx] = data[i];
                tmpIdx += 2;
            }
            data = tmpData;
            dataStart = 0;
            dataLength = data.length;
        }
        textBuf.append(ColumnImpl.decodeUncompressedText(data, dataStart, dataLength, this.getCharset()));
    }

    private static CharBuffer decodeUncompressedText(byte[] textBytes, int startPos, int length, Charset charset) {
        return charset.decode(ByteBuffer.wrap(textBytes, startPos, length));
    }

    ByteBuffer encodeTextValue(Object obj, int minChars, int maxChars, boolean forceUncompressed) throws IOException {
        CharSequence text = ColumnImpl.toCharSequence(obj);
        if (text.length() > maxChars || text.length() < minChars) {
            throw new InvalidValueException(this.withErrorContext("Text is wrong length for " + (Object)((Object)this.getType()) + " column, max " + maxChars + ", min " + minChars + ", got " + text.length()));
        }
        if (!forceUncompressed && this.isCompressedUnicode() && text.length() <= this.getFormat().MAX_COMPRESSED_UNICODE_SIZE && ColumnImpl.isUnicodeCompressible(text)) {
            byte[] encodedChars = new byte[TEXT_COMPRESSION_HEADER.length + text.length()];
            encodedChars[0] = TEXT_COMPRESSION_HEADER[0];
            encodedChars[1] = TEXT_COMPRESSION_HEADER[1];
            for (int i = 0; i < text.length(); ++i) {
                encodedChars[i + ColumnImpl.TEXT_COMPRESSION_HEADER.length] = (byte)text.charAt(i);
            }
            return ByteBuffer.wrap(encodedChars);
        }
        return ColumnImpl.encodeUncompressedText(text, this.getCharset());
    }

    private static boolean isUnicodeCompressible(CharSequence text) {
        if (text.length() <= TEXT_COMPRESSION_HEADER.length) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= '\u0001' && c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    private static byte getColumnBitFlags(ColumnBuilder col) {
        byte flags = 2;
        if (!col.isVariableLength()) {
            flags = (byte)(flags | 1);
        }
        if (col.isAutoNumber()) {
            int autoNumFlags = 0;
            switch (col.getType()) {
                case COMPLEX_TYPE: 
                case LONG: {
                    autoNumFlags = 4;
                    break;
                }
                case GUID: {
                    autoNumFlags = 64;
                    break;
                }
            }
            flags = (byte)(flags | autoNumFlags);
        }
        if (col.isHyperlink()) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        return flags;
    }

    public String toString() {
        ToStringBuilder sb = CustomToStringStyle.builder(this).append("name", "(" + this._table.getName() + ") " + this._name);
        byte typeValue = this.getOriginalDataType();
        sb.append("type", "0x" + Integer.toHexString(typeValue) + " (" + (Object)((Object)this._type) + ")").append("number", this._columnNumber).append("length", this._columnLength).append("variableLength", this._variableLength);
        if (this._calculated) {
            sb.append("calculated", this._calculated).append("expression", CustomToStringStyle.ignoreNull(this.getCalculationContext()));
        }
        if (this._type.isTextual()) {
            sb.append("compressedUnicode", this.isCompressedUnicode()).append("textSortOrder", this.getTextSortOrder());
            if (this.getTextCodePage() > 0) {
                sb.append("textCodePage", this.getTextCodePage());
            }
            if (this.isAppendOnly()) {
                sb.append("appendOnly", this.isAppendOnly());
            }
            if (this.isHyperlink()) {
                sb.append("hyperlink", this.isHyperlink());
            }
        }
        if (this._type.getHasScalePrecision()) {
            sb.append("precision", this.getPrecision()).append("scale", this.getScale());
        }
        if (this._autoNumber) {
            sb.append("lastAutoNumber", this._autoNumberGenerator.getLast());
        }
        sb.append("complexInfo", CustomToStringStyle.ignoreNull(this.getComplexInfo())).append("validator", CustomToStringStyle.ignoreNull(this._validator != SimpleColumnValidator.INSTANCE ? this._validator : null)).append("defaultValue", CustomToStringStyle.ignoreNull(this._defValue));
        return sb.toString();
    }

    public static String decodeUncompressedText(byte[] textBytes, Charset charset) {
        return ColumnImpl.decodeUncompressedText(textBytes, 0, textBytes.length, charset).toString();
    }

    public static ByteBuffer encodeUncompressedText(CharSequence text, Charset charset) {
        CharBuffer cb = text instanceof CharBuffer ? (CharBuffer)text : CharBuffer.wrap(text);
        return charset.encode(cb);
    }

    @Override
    public int compareTo(ColumnImpl other) {
        if (this._columnNumber > other.getColumnNumber()) {
            return 1;
        }
        if (this._columnNumber < other.getColumnNumber()) {
            return -1;
        }
        return 0;
    }

    public static short countVariableLength(List<ColumnBuilder> columns) {
        short rtn = 0;
        for (ColumnBuilder col : columns) {
            if (!col.isVariableLength()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }

    BigDecimal toBigDecimal(Object value) {
        return ColumnImpl.toBigDecimal(value, this.getDatabase());
    }

    static BigDecimal toBigDecimal(Object value, DatabaseImpl db) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.valueOf(-1L) : BigDecimal.ZERO;
        }
        if (value instanceof Date) {
            return new BigDecimal(ColumnImpl.toDateDouble(value, db));
        }
        if (value instanceof LocalDateTime) {
            return new BigDecimal(ColumnImpl.toDateDouble((LocalDateTime)value));
        }
        return new BigDecimal(value.toString());
    }

    private Number toNumber(Object value) {
        return ColumnImpl.toNumber(value, this.getDatabase());
    }

    private static Number toNumber(Object value, DatabaseImpl db) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? -1 : 0;
        }
        if (value instanceof Date) {
            return ColumnImpl.toDateDouble(value, db);
        }
        if (value instanceof LocalDateTime) {
            return ColumnImpl.toDateDouble((LocalDateTime)value);
        }
        return Double.valueOf(value.toString());
    }

    public static CharSequence toCharSequence(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        if (SqlHelper.INSTANCE.isClob(value)) {
            return SqlHelper.INSTANCE.getClobString(value);
        }
        if (value instanceof Reader) {
            char[] buf = new char[8192];
            StringBuilder sout = new StringBuilder();
            Reader in = (Reader)value;
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                sout.append(buf, 0, read);
            }
            return sout;
        }
        return value.toString();
    }

    public static byte[] toByteArray(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof InMemoryBlob) {
            return ((InMemoryBlob)value).getBytes();
        }
        if (SqlHelper.INSTANCE.isBlob(value)) {
            return SqlHelper.INSTANCE.getBlobBytes(value);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (value instanceof InputStream) {
            ByteUtil.copy((InputStream)value, bout);
        } else {
            ObjectOutputStream oos = new ObjectOutputStream(bout);
            oos.writeObject(value);
            oos.close();
        }
        return bout.toByteArray();
    }

    public static boolean toBooleanValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).compareTo(BigDecimal.ZERO) != 0;
            }
            if (obj instanceof BigInteger) {
                return ((BigInteger)obj).compareTo(BigInteger.ZERO) != 0;
            }
            return ((Number)obj).doubleValue() != 0.0;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    private static void fixNumericByteOrder(byte[] bytes) {
        for (int i = 0; i < bytes.length; i += 4) {
            ByteUtil.swap4Bytes(bytes, i);
        }
    }

    protected static Object booleanToInteger(Object obj) {
        if (obj instanceof Boolean) {
            obj = (Boolean)obj != false ? -1 : 0;
        }
        return obj;
    }

    public static RawData rawDataWrapper(byte[] bytes) {
        return new RawData(bytes);
    }

    public static boolean isRawData(Object value) {
        return value instanceof RawData;
    }

    protected static void writeDefinitions(TableCreator creator, ByteBuffer buffer) throws IOException {
        short longVariableOffset = creator.countNonLongVariableLength();
        creator.setColumnOffsets(0, 0, longVariableOffset);
        for (ColumnBuilder col : creator.getColumns()) {
            ColumnImpl.writeDefinition(creator, col, buffer);
        }
        for (ColumnBuilder col : creator.getColumns()) {
            TableImpl.writeName(buffer, col.getName(), creator.getCharset());
        }
    }

    protected static void writeDefinition(TableMutator mutator, ColumnBuilder col, ByteBuffer buffer) throws IOException {
        TableMutator.ColumnOffsets colOffsets = mutator.getColumnOffsets();
        buffer.put(col.getType().getValue());
        buffer.putInt(1625);
        buffer.putShort(col.getColumnNumber());
        if (col.isVariableLength()) {
            buffer.putShort(colOffsets.getNextVariableOffset(col));
        } else {
            buffer.putShort((short)0);
        }
        buffer.putShort(col.getColumnNumber());
        if (col.getType().isTextual()) {
            ColumnImpl.writeSortOrder(buffer, col.getTextSortOrder(), mutator.getFormat());
        } else {
            if (col.getType().getHasScalePrecision() && !col.isCalculated()) {
                buffer.put(col.getPrecision());
                buffer.put(col.getScale());
            } else {
                buffer.put((byte)0);
                buffer.put((byte)0);
            }
            buffer.putShort((short)0);
        }
        buffer.put(ColumnImpl.getColumnBitFlags(col));
        if (col.isCalculated()) {
            buffer.put((byte)-64);
        } else if (col.isCompressedUnicode()) {
            buffer.put((byte)1);
        } else {
            buffer.put((byte)0);
        }
        buffer.putInt(0);
        if (col.isVariableLength()) {
            buffer.putShort((short)0);
        } else {
            buffer.putShort(colOffsets.getNextFixedOffset(col));
        }
        if (!col.getType().isLongValue()) {
            int length = col.getLength();
            if (col.isCalculated()) {
                length = !col.getType().isVariableLength() || col.getType().getHasScalePrecision() ? 39 : (int)((short)(length + 23));
            }
            buffer.putShort((short)length);
        } else {
            buffer.putShort((short)0);
        }
    }

    protected static void writeColUsageMapDefinitions(TableCreator creator, ByteBuffer buffer) throws IOException {
        for (ColumnBuilder lvalCol : creator.getLongValueColumns()) {
            ColumnImpl.writeColUsageMapDefinition(creator, lvalCol, buffer);
        }
    }

    protected static void writeColUsageMapDefinition(TableMutator creator, ColumnBuilder lvalCol, ByteBuffer buffer) throws IOException {
        TableMutator.ColumnState colState = creator.getColumnState(lvalCol);
        buffer.putShort(lvalCol.getColumnNumber());
        buffer.put(colState.getUmapOwnedRowNumber());
        ByteUtil.put3ByteInt(buffer, colState.getUmapPageNumber());
        buffer.put(colState.getUmapFreeRowNumber());
        ByteUtil.put3ByteInt(buffer, colState.getUmapPageNumber());
    }

    static SortOrder readSortOrder(ByteBuffer buffer, int position, JetFormat format) {
        short value = buffer.getShort(position);
        if (value == 0) {
            return format.DEFAULT_SORT_ORDER;
        }
        short version = format.DEFAULT_SORT_ORDER.getVersion();
        if (format.SIZE_SORT_ORDER == 4) {
            version = buffer.get(position + 3);
        }
        if (value == 1033) {
            if (version == GENERAL_SORT_ORDER.getVersion()) {
                return GENERAL_SORT_ORDER;
            }
            if (version == GENERAL_LEGACY_SORT_ORDER.getVersion()) {
                return GENERAL_LEGACY_SORT_ORDER;
            }
            if (version == GENERAL_97_SORT_ORDER.getVersion()) {
                return GENERAL_97_SORT_ORDER;
            }
        }
        return new SortOrder(value, version);
    }

    static short readCodePage(ByteBuffer buffer, int offset, JetFormat format) {
        int cpOffset = format.OFFSET_COLUMN_CODE_PAGE;
        return cpOffset >= 0 ? buffer.getShort(offset + cpOffset) : (short)0;
    }

    static byte readExtraFlags(ByteBuffer buffer, int offset, JetFormat format) {
        int extFlagsOffset = format.OFFSET_COLUMN_EXT_FLAGS;
        return extFlagsOffset >= 0 ? buffer.get(offset + extFlagsOffset) : (byte)0;
    }

    private static void writeSortOrder(ByteBuffer buffer, SortOrder sortOrder, JetFormat format) {
        if (sortOrder == null) {
            sortOrder = format.DEFAULT_SORT_ORDER;
        }
        buffer.putShort(sortOrder.getValue());
        if (format.SIZE_SORT_ORDER == 4) {
            buffer.put((byte)0);
            buffer.put((byte)sortOrder.getVersion());
        }
    }

    static boolean isImmutableValue(Object value) {
        return !(value instanceof byte[]);
    }

    public static Object toInternalValue(DataType dataType, Object value, DatabaseImpl db) throws IOException {
        return ColumnImpl.toInternalValue(dataType, value, db, null);
    }

    static Object toInternalValue(DataType dataType, Object value, DatabaseImpl db, DateTimeFactory factory) throws IOException {
        if (value == null) {
            return null;
        }
        switch (dataType) {
            case BOOLEAN: {
                return value instanceof Boolean ? value : Boolean.valueOf(ColumnImpl.toBooleanValue(value));
            }
            case BYTE: {
                return value instanceof Byte ? value : Byte.valueOf(ColumnImpl.toNumber(value, db).byteValue());
            }
            case INT: {
                return value instanceof Short ? value : Short.valueOf(ColumnImpl.toNumber(value, db).shortValue());
            }
            case LONG: {
                return value instanceof Integer ? value : Integer.valueOf(ColumnImpl.toNumber(value, db).intValue());
            }
            case MONEY: {
                return ColumnImpl.toBigDecimal(value, db);
            }
            case FLOAT: {
                return value instanceof Float ? value : Float.valueOf(ColumnImpl.toNumber(value, db).floatValue());
            }
            case DOUBLE: {
                return value instanceof Double ? value : Double.valueOf(ColumnImpl.toNumber(value, db).doubleValue());
            }
            case SHORT_DATE_TIME: {
                if (factory == null) {
                    factory = db.getDateTimeFactory();
                }
                return factory.toInternalValue(db, value);
            }
            case TEXT: 
            case MEMO: 
            case GUID: {
                return value instanceof String ? value : ColumnImpl.toCharSequence(value).toString();
            }
            case NUMERIC: {
                return ColumnImpl.toBigDecimal(value, db);
            }
            case COMPLEX_TYPE: {
                return value;
            }
            case BIG_INT: {
                return value instanceof Long ? value : Long.valueOf(ColumnImpl.toNumber(value, db).longValue());
            }
            case EXT_DATE_TIME: {
                return ColumnImpl.toLocalDateTime(value, db);
            }
        }
        return ColumnImpl.toByteArray(value);
    }

    protected static DateTimeFactory getDateTimeFactory(DateTimeType type) {
        return type == DateTimeType.LOCAL_DATE_TIME ? LDT_DATE_TIME_FACTORY : DEF_DATE_TIME_FACTORY;
    }

    String withErrorContext(String msg) {
        return ColumnImpl.withErrorContext(msg, this.getDatabase(), this.getTable().getName(), this.getName());
    }

    boolean isThisColumn(Identifier identifier) {
        return this.getTable().isThisTable(identifier) && this.getName().equalsIgnoreCase(identifier.getObjectName());
    }

    private static String withErrorContext(String msg, DatabaseImpl db, String tableName, String colName) {
        return msg + " (Db=" + db.getName() + ";Table=" + tableName + ";Column=" + colName + ")";
    }

    static interface InMemoryBlob {
        public byte[] getBytes() throws IOException;
    }

    private static final class LDTDateTimeFactory
    extends DateTimeFactory {
        private LDTDateTimeFactory() {
        }

        @Override
        public DateTimeType getType() {
            return DateTimeType.LOCAL_DATE_TIME;
        }

        @Override
        public Object fromDateBits(ColumnImpl col, long dateBits) {
            return ColumnImpl.ldtFromLocalDateDouble(Double.longBitsToDouble(dateBits));
        }

        @Override
        public double toDateDouble(Object value, DateTimeContext dtc) {
            if (!(value instanceof TemporalAccessor)) {
                value = Instant.ofEpochMilli(ColumnImpl.toDateLong(value));
            }
            return ColumnImpl.toDateDouble(ColumnImpl.temporalToLocalDateTime((TemporalAccessor)value, dtc));
        }

        @Override
        public Object toInternalValue(DatabaseImpl db, Object value) {
            return ColumnImpl.toLocalDateTime(value, db);
        }
    }

    private static final class DefaultDateTimeFactory
    extends DateTimeFactory {
        private DefaultDateTimeFactory() {
        }

        @Override
        public DateTimeType getType() {
            return DateTimeType.DATE;
        }

        @Override
        public Object fromDateBits(ColumnImpl col, long dateBits) {
            long time = col.fromDateDouble(Double.longBitsToDouble(dateBits));
            return new DateExt(time, dateBits);
        }

        @Override
        public double toDateDouble(Object value, DateTimeContext dtc) {
            long time = 0L;
            time = value instanceof TemporalAccessor ? ColumnImpl.toInstant((TemporalAccessor)value, dtc).toEpochMilli() : ColumnImpl.toDateLong(value);
            time += ColumnImpl.getToLocalTimeZoneOffset(time, dtc.getTimeZone());
            return ColumnImpl.toLocalDateDouble(time);
        }

        @Override
        public Object toInternalValue(DatabaseImpl db, Object value) {
            return value instanceof Date ? value : new Date(ColumnImpl.toDateLong(value));
        }
    }

    protected static abstract class DateTimeFactory {
        protected DateTimeFactory() {
        }

        public abstract DateTimeType getType();

        public abstract Object fromDateBits(ColumnImpl var1, long var2);

        public abstract double toDateDouble(Object var1, DateTimeContext var2);

        public abstract Object toInternalValue(DatabaseImpl var1, Object var2);
    }

    private static final class NoZeroLenColValidator
    extends InternalColumnValidator {
        private NoZeroLenColValidator(ColumnValidator delegate) {
            super(delegate);
        }

        @Override
        protected Object internalValidate(Column col, Object val) throws IOException {
            CharSequence valStr = ColumnImpl.toCharSequence(val);
            if (valStr != null && valStr.length() == 0) {
                throw new InvalidValueException(((ColumnImpl)col).withErrorContext("Zero length string is not allowed"));
            }
            return valStr;
        }

        @Override
        protected void appendToString(StringBuilder sb) {
            sb.append("allowZeroLength=false");
        }
    }

    private static final class RequiredColValidator
    extends InternalColumnValidator {
        private RequiredColValidator(ColumnValidator delegate) {
            super(delegate);
        }

        @Override
        protected Object internalValidate(Column col, Object val) throws IOException {
            if (val == null) {
                throw new InvalidValueException(((ColumnImpl)col).withErrorContext("Missing value for required column"));
            }
            return val;
        }

        @Override
        protected void appendToString(StringBuilder sb) {
            sb.append("required=true");
        }
    }

    static final class InitArgs {
        public final TableImpl table;
        public final ByteBuffer buffer;
        public final int offset;
        public final String name;
        public final int displayIndex;
        public final byte colType;
        public final byte flags;
        public final byte extFlags;
        public DataType type;

        InitArgs(TableImpl table, ByteBuffer buffer, int offset, String name, int displayIndex) {
            this.table = table;
            this.buffer = buffer;
            this.offset = offset;
            this.name = name;
            this.displayIndex = displayIndex;
            this.colType = buffer.get(offset + table.getFormat().OFFSET_COLUMN_TYPE);
            this.flags = buffer.get(offset + table.getFormat().OFFSET_COLUMN_FLAGS);
            this.extFlags = ColumnImpl.readExtraFlags(buffer, offset, table.getFormat());
        }
    }

    public static final class SortOrder {
        private final short _value;
        private final short _version;

        public SortOrder(short value, short version) {
            this._value = value;
            this._version = version;
        }

        public short getValue() {
            return this._value;
        }

        public short getVersion() {
            return this._version;
        }

        public int hashCode() {
            return this._value;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this._value == ((SortOrder)o)._value && this._version == ((SortOrder)o)._version;
        }

        public String toString() {
            return CustomToStringStyle.valueBuilder(this).append(null, this._value + "(" + this._version + ")").toString();
        }
    }

    private final class UnsupportedAutoNumberGenerator
    extends AutoNumberGenerator {
        private final DataType _genType;

        private UnsupportedAutoNumberGenerator(DataType genType) {
            this._genType = genType;
        }

        @Override
        public Object getLast() {
            return null;
        }

        @Override
        public Object getNext(TableImpl.WriteRowState writeRowState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void restoreLast(Object last) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataType getType() {
            return this._genType;
        }
    }

    private final class ComplexTypeAutoNumberGenerator
    extends AutoNumberGenerator {
        private ComplexTypeAutoNumberGenerator() {
        }

        @Override
        public Object getLast() {
            return ColumnImpl.this.getTable().getLastComplexTypeAutoNumber();
        }

        @Override
        public Object getNext(TableImpl.WriteRowState writeRowState) {
            int nextComplexAutoNum = writeRowState.getComplexAutoNumber();
            if (nextComplexAutoNum <= 0) {
                nextComplexAutoNum = ColumnImpl.this.getTable().getNextComplexTypeAutoNumber();
                writeRowState.setComplexAutoNumber(nextComplexAutoNum);
            }
            return new ComplexValueForeignKeyImpl(ColumnImpl.this, nextComplexAutoNum);
        }

        @Override
        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) throws IOException {
            ComplexValueForeignKey inComplexFK = null;
            inComplexFK = inRowValue instanceof ComplexValueForeignKey ? (ComplexValueForeignKey)inRowValue : new ComplexValueForeignKeyImpl(ColumnImpl.this, ColumnImpl.this.toNumber(inRowValue).intValue());
            if (inComplexFK.getColumn() != ColumnImpl.this) {
                throw new InvalidValueException(ColumnImpl.this.withErrorContext("Wrong column for complex value foreign key, found " + inComplexFK.getColumn().getName()));
            }
            if (inComplexFK.get() < 1) {
                throw new InvalidValueException(ColumnImpl.this.withErrorContext("Invalid complex value foreign key value " + inComplexFK.get()));
            }
            int prevRowValue = writeRowState.getComplexAutoNumber();
            if (prevRowValue <= 0) {
                writeRowState.setComplexAutoNumber(inComplexFK.get());
            } else if (prevRowValue != inComplexFK.get()) {
                throw new InvalidValueException(ColumnImpl.this.withErrorContext("Inconsistent complex value foreign key values: found " + prevRowValue + ", given " + inComplexFK));
            }
            ColumnImpl.this.getTable().adjustComplexTypeAutoNumber(inComplexFK.get());
            return inComplexFK;
        }

        @Override
        public void restoreLast(Object last) {
            if (last instanceof ComplexValueForeignKey) {
                ColumnImpl.this.getTable().restoreLastComplexTypeAutoNumber(((ComplexValueForeignKey)last).get());
            }
        }

        @Override
        public DataType getType() {
            return DataType.COMPLEX_TYPE;
        }
    }

    private final class GuidAutoNumberGenerator
    extends AutoNumberGenerator {
        private Object _lastAutoNumber;

        private GuidAutoNumberGenerator() {
        }

        @Override
        public Object getLast() {
            return this._lastAutoNumber;
        }

        @Override
        public Object getNext(TableImpl.WriteRowState writeRowState) {
            this._lastAutoNumber = "{" + UUID.randomUUID() + "}";
            return this._lastAutoNumber;
        }

        @Override
        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) throws IOException {
            this._lastAutoNumber = ColumnImpl.toCharSequence(inRowValue);
            return this._lastAutoNumber;
        }

        @Override
        public void restoreLast(Object last) {
            this._lastAutoNumber = null;
        }

        @Override
        public DataType getType() {
            return DataType.GUID;
        }
    }

    private final class LongAutoNumberGenerator
    extends AutoNumberGenerator {
        private LongAutoNumberGenerator() {
        }

        @Override
        public Object getLast() {
            return ColumnImpl.this.getTable().getLastLongAutoNumber();
        }

        @Override
        public Object getNext(TableImpl.WriteRowState writeRowState) {
            return ColumnImpl.this.getTable().getNextLongAutoNumber();
        }

        @Override
        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) throws IOException {
            int inAutoNum = ColumnImpl.this.toNumber(inRowValue).intValue();
            if (inAutoNum <= 0 && !ColumnImpl.this.getTable().isAllowAutoNumberInsert()) {
                throw new InvalidValueException(ColumnImpl.this.withErrorContext("Invalid auto number value " + inAutoNum));
            }
            ColumnImpl.this.getTable().adjustLongAutoNumber(inAutoNum);
            return inAutoNum;
        }

        @Override
        public void restoreLast(Object last) {
            if (last instanceof Integer) {
                ColumnImpl.this.getTable().restoreLastLongAutoNumber((Integer)last);
            }
        }

        @Override
        public DataType getType() {
            return DataType.LONG;
        }
    }

    public abstract class AutoNumberGenerator {
        protected AutoNumberGenerator() {
        }

        public abstract Object getLast();

        public abstract Object getNext(TableImpl.WriteRowState var1);

        public abstract Object handleInsert(TableImpl.WriteRowState var1, Object var2) throws IOException;

        public abstract void restoreLast(Object var1);

        public abstract DataType getType();
    }

    private static final class RawData
    implements Serializable,
    InMemoryBlob {
        private static final long serialVersionUID = 0L;
        private final byte[] _bytes;

        private RawData(byte[] bytes) {
            this._bytes = bytes;
        }

        @Override
        public byte[] getBytes() {
            return this._bytes;
        }

        public String toString() {
            return CustomToStringStyle.valueBuilder(this).append((String)null, this.getBytes()).toString();
        }

        private Object writeReplace() throws ObjectStreamException {
            return this.getBytes();
        }
    }

    private static final class DateExt
    extends Date {
        private static final long serialVersionUID = 0L;
        private final transient long _dateBits;

        private DateExt(long time, long dateBits) {
            super(time);
            this._dateBits = dateBits;
        }

        public long getDateBits() {
            return this._dateBits;
        }

        @Override
        public void setDate(int time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHours(int time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMinutes(int time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMonth(int time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSeconds(int time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setYear(int time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTime(long time) {
            throw new UnsupportedOperationException();
        }

        private Object writeReplace() throws ObjectStreamException {
            return new Date(super.getTime());
        }
    }
}

