/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jempbox.xmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.jempbox.impl.XMLUtil;
import org.apache.jempbox.xmp.Thumbnail;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaBasicJobTicket;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaDynamicMedia;
import org.apache.jempbox.xmp.XMPSchemaIptc4xmpCore;
import org.apache.jempbox.xmp.XMPSchemaMediaManagement;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.jempbox.xmp.XMPSchemaPagedText;
import org.apache.jempbox.xmp.XMPSchemaPhotoshop;
import org.apache.jempbox.xmp.XMPSchemaRightsManagement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPMetadata {
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String ENCODING_UTF16BE = "UTF-16BE";
    public static final String ENCODING_UTF16LE = "UTF-16LE";
    protected Document xmpDocument;
    protected String encoding = "UTF-8";
    protected Map<String, Class<?>> nsMappings = new HashMap();

    public XMPMetadata() throws IOException {
        this.xmpDocument = XMLUtil.newDocument();
        ProcessingInstruction beginXPacket = this.xmpDocument.createProcessingInstruction("xpacket", "begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"");
        this.xmpDocument.appendChild(beginXPacket);
        Element xmpMeta = this.xmpDocument.createElementNS("adobe:ns:meta/", "x:xmpmeta");
        xmpMeta.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "adobe:ns:meta/");
        this.xmpDocument.appendChild(xmpMeta);
        Element rdf = this.xmpDocument.createElement("rdf:RDF");
        rdf.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        xmpMeta.appendChild(rdf);
        ProcessingInstruction endXPacket = this.xmpDocument.createProcessingInstruction("xpacket", "end=\"w\"");
        this.xmpDocument.appendChild(endXPacket);
        this.init();
    }

    public XMPMetadata(Document doc) {
        this.xmpDocument = doc;
        this.init();
    }

    private void init() {
        this.nsMappings.put("http://ns.adobe.com/pdf/1.3/", XMPSchemaPDF.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/", XMPSchemaBasic.class);
        this.nsMappings.put("http://purl.org/dc/elements/1.1/", XMPSchemaDublinCore.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/mm/", XMPSchemaMediaManagement.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/rights/", XMPSchemaRightsManagement.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/bj/", XMPSchemaBasicJobTicket.class);
        this.nsMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/", XMPSchemaDynamicMedia.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/t/pg/", XMPSchemaPagedText.class);
        this.nsMappings.put("http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", XMPSchemaIptc4xmpCore.class);
        this.nsMappings.put("http://ns.adobe.com/photoshop/1.0/", XMPSchemaPhotoshop.class);
    }

    public void addXMLNSMapping(String namespace, Class<?> xmpSchema) {
        if (!XMPSchema.class.isAssignableFrom(xmpSchema)) {
            throw new IllegalArgumentException("Only XMPSchemas can be mapped to.");
        }
        this.nsMappings.put(namespace, xmpSchema);
    }

    public XMPSchemaPDF getPDFSchema() throws IOException {
        return (XMPSchemaPDF)this.getSchemaByClass(XMPSchemaPDF.class);
    }

    public XMPSchemaBasic getBasicSchema() throws IOException {
        return (XMPSchemaBasic)this.getSchemaByClass(XMPSchemaBasic.class);
    }

    public XMPSchemaDublinCore getDublinCoreSchema() throws IOException {
        return (XMPSchemaDublinCore)this.getSchemaByClass(XMPSchemaDublinCore.class);
    }

    public XMPSchemaMediaManagement getMediaManagementSchema() throws IOException {
        return (XMPSchemaMediaManagement)this.getSchemaByClass(XMPSchemaMediaManagement.class);
    }

    public XMPSchemaRightsManagement getRightsManagementSchema() throws IOException {
        return (XMPSchemaRightsManagement)this.getSchemaByClass(XMPSchemaRightsManagement.class);
    }

    public XMPSchemaBasicJobTicket getBasicJobTicketSchema() throws IOException {
        return (XMPSchemaBasicJobTicket)this.getSchemaByClass(XMPSchemaBasicJobTicket.class);
    }

    public XMPSchemaDynamicMedia getDynamicMediaSchema() throws IOException {
        return (XMPSchemaDynamicMedia)this.getSchemaByClass(XMPSchemaDynamicMedia.class);
    }

    public XMPSchemaPagedText getPagedTextSchema() throws IOException {
        return (XMPSchemaPagedText)this.getSchemaByClass(XMPSchemaPagedText.class);
    }

    public XMPSchemaMediaManagement addMediaManagementSchema() {
        XMPSchemaMediaManagement schema = new XMPSchemaMediaManagement(this);
        return (XMPSchemaMediaManagement)this.basicAddSchema(schema);
    }

    public XMPSchemaRightsManagement addRightsManagementSchema() {
        XMPSchemaRightsManagement schema = new XMPSchemaRightsManagement(this);
        return (XMPSchemaRightsManagement)this.basicAddSchema(schema);
    }

    public XMPSchemaBasicJobTicket addBasicJobTicketSchema() {
        XMPSchemaBasicJobTicket schema = new XMPSchemaBasicJobTicket(this);
        return (XMPSchemaBasicJobTicket)this.basicAddSchema(schema);
    }

    public XMPSchemaDynamicMedia addDynamicMediaSchema() {
        XMPSchemaDynamicMedia schema = new XMPSchemaDynamicMedia(this);
        return (XMPSchemaDynamicMedia)this.basicAddSchema(schema);
    }

    public XMPSchemaPagedText addPagedTextSchema() {
        XMPSchemaPagedText schema = new XMPSchemaPagedText(this);
        return (XMPSchemaPagedText)this.basicAddSchema(schema);
    }

    public void addSchema(XMPSchema schema) {
        Element rdf = this.getRDFElement();
        rdf.appendChild(schema.getElement());
    }

    public void save(String file) throws Exception {
        XMLUtil.save(this.xmpDocument, file, this.encoding);
    }

    public void save(OutputStream outStream) throws TransformerException {
        XMLUtil.save((Node)this.xmpDocument, outStream, this.encoding);
    }

    public byte[] asByteArray() throws Exception {
        return XMLUtil.asByteArray(this.xmpDocument, this.encoding);
    }

    public Document getXMPDocument() {
        return this.xmpDocument;
    }

    protected XMPSchema basicAddSchema(XMPSchema schema) {
        Element rdf = this.getRDFElement();
        rdf.appendChild(schema.getElement());
        return schema;
    }

    public XMPSchemaPDF addPDFSchema() {
        XMPSchemaPDF schema = new XMPSchemaPDF(this);
        return (XMPSchemaPDF)this.basicAddSchema(schema);
    }

    public XMPSchemaDublinCore addDublinCoreSchema() {
        XMPSchemaDublinCore schema = new XMPSchemaDublinCore(this);
        return (XMPSchemaDublinCore)this.basicAddSchema(schema);
    }

    public XMPSchemaBasic addBasicSchema() {
        XMPSchemaBasic schema = new XMPSchemaBasic(this);
        return (XMPSchemaBasic)this.basicAddSchema(schema);
    }

    public XMPSchemaIptc4xmpCore addIptc4xmpCoreSchema() {
        XMPSchemaIptc4xmpCore schema = new XMPSchemaIptc4xmpCore(this);
        return (XMPSchemaIptc4xmpCore)this.basicAddSchema(schema);
    }

    public XMPSchemaPhotoshop addPhotoshopSchema() {
        XMPSchemaPhotoshop schema = new XMPSchemaPhotoshop(this);
        return (XMPSchemaPhotoshop)this.basicAddSchema(schema);
    }

    public void setEncoding(String xmlEncoding) {
        this.encoding = xmlEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private Element getRDFElement() {
        Element rdf = null;
        NodeList nodes = this.xmpDocument.getElementsByTagName("rdf:RDF");
        if (nodes.getLength() > 0) {
            rdf = (Element)nodes.item(0);
        }
        return rdf;
    }

    public static XMPMetadata load(String file) throws IOException {
        return new XMPMetadata(XMLUtil.parse(file));
    }

    public static XMPMetadata load(InputSource is) throws IOException {
        return new XMPMetadata(XMLUtil.parse(is));
    }

    public static XMPMetadata load(InputStream is) throws IOException {
        return new XMPMetadata(XMLUtil.parse(is));
    }

    public static void main(String[] args) throws Exception {
        XMPMetadata metadata = new XMPMetadata();
        XMPSchemaPDF pdf = metadata.addPDFSchema();
        pdf.setAbout("uuid:b8659d3a-369e-11d9-b951-000393c97fd8");
        pdf.setKeywords("ben,bob,pdf");
        pdf.setPDFVersion("1.3");
        pdf.setProducer("Acrobat Distiller 6.0.1 for Macintosh");
        XMPSchemaDublinCore dc = metadata.addDublinCoreSchema();
        dc.addContributor("Ben Litchfield");
        dc.addContributor("Solar Eclipse");
        dc.addContributor("Some Other Guy");
        XMPSchemaBasic basic = metadata.addBasicSchema();
        Thumbnail t2 = new Thumbnail(metadata);
        t2.setFormat("JPEG");
        t2.setImage("IMAGE_DATA");
        t2.setHeight(new Integer(100));
        t2.setWidth(new Integer(200));
        basic.setThumbnail(t2);
        basic.setBaseURL("http://www.pdfbox.org/");
        List<XMPSchema> schemas = metadata.getSchemas();
        System.out.println("schemas=" + schemas);
        metadata.save("test.xmp");
    }

    public List<XMPSchema> getSchemas() throws IOException {
        NodeList schemaList = this.xmpDocument.getElementsByTagName("rdf:Description");
        ArrayList<XMPSchema> retval = new ArrayList<XMPSchema>(schemaList.getLength());
        for (int i = 0; i < schemaList.getLength(); ++i) {
            Element schema = (Element)schemaList.item(i);
            boolean found = false;
            NamedNodeMap attributes = schema.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (!name.startsWith("xmlns:") || !this.nsMappings.containsKey(value)) continue;
                Class<?> schemaClass = this.nsMappings.get(value);
                try {
                    Constructor<?> ctor = schemaClass.getDeclaredConstructor(Element.class, String.class);
                    retval.add((XMPSchema)ctor.newInstance(schema, name.substring(6)));
                    found = true;
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Error: Class " + schemaClass.getName() + " must have a constructor with the signature of " + schemaClass.getName() + "( org.w3c.dom.Element, java.lang.String )");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            if (found) continue;
            retval.add(new XMPSchema(schema, null));
        }
        return retval;
    }

    public List<XMPSchema> getSchemasByNamespaceURI(String namespaceURI) throws IOException {
        LinkedList<XMPSchema> result = new LinkedList<XMPSchema>();
        Class<?> schemaClass = this.nsMappings.get(namespaceURI);
        if (schemaClass == null) {
            return result;
        }
        for (XMPSchema schema : this.getSchemas()) {
            if (!schemaClass.isAssignableFrom(schema.getClass())) continue;
            result.add(schema);
        }
        return result;
    }

    public boolean hasUnknownSchema() throws IOException {
        NodeList schemaList = this.xmpDocument.getElementsByTagName("rdf:Description");
        for (int i = 0; i < schemaList.getLength(); ++i) {
            Element schema = (Element)schemaList.item(i);
            NamedNodeMap attributes = schema.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (!name.startsWith("xmlns:") || this.nsMappings.containsKey(value) || value.equals("http://ns.adobe.com/xap/1.0/sType/ResourceEvent#")) continue;
                return true;
            }
        }
        return false;
    }

    public XMPSchema getSchemaByClass(Class<?> targetSchema) throws IOException {
        for (XMPSchema element : this.getSchemas()) {
            if (!element.getClass().getName().equals(targetSchema.getName())) continue;
            return element;
        }
        return null;
    }

    public void merge(XMPMetadata metadata) throws IOException {
        List<XMPSchema> schemas2 = metadata.getSchemas();
        for (XMPSchema schema2 : schemas2) {
            XMPSchema schema1 = this.getSchemaByClass(schema2.getClass());
            if (schema1 == null) {
                Element rdf = this.getRDFElement();
                rdf.appendChild(this.xmpDocument.importNode(schema2.getElement(), true));
                continue;
            }
            schema1.merge(schema2);
        }
    }
}

