/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.CFRule12Record;
import org.apache.poi.hssf.record.cf.IconMultiStateThreshold;
import org.apache.poi.hssf.record.cf.Threshold;
import org.apache.poi.hssf.usermodel.HSSFConditionalFormattingThreshold;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import org.apache.poi.ss.usermodel.IconMultiStateFormatting;

public final class HSSFIconMultiStateFormatting
implements IconMultiStateFormatting {
    private final HSSFSheet sheet;
    private final org.apache.poi.hssf.record.cf.IconMultiStateFormatting iconFormatting;

    HSSFIconMultiStateFormatting(CFRule12Record cfRule12Record, HSSFSheet sheet) {
        this.sheet = sheet;
        this.iconFormatting = cfRule12Record.getMultiStateFormatting();
    }

    @Override
    public IconMultiStateFormatting.IconSet getIconSet() {
        return this.iconFormatting.getIconSet();
    }

    @Override
    public void setIconSet(IconMultiStateFormatting.IconSet set) {
        this.iconFormatting.setIconSet(set);
    }

    @Override
    public boolean isIconOnly() {
        return this.iconFormatting.isIconOnly();
    }

    @Override
    public void setIconOnly(boolean only) {
        this.iconFormatting.setIconOnly(only);
    }

    @Override
    public boolean isReversed() {
        return this.iconFormatting.isReversed();
    }

    @Override
    public void setReversed(boolean reversed) {
        this.iconFormatting.setReversed(reversed);
    }

    public HSSFConditionalFormattingThreshold[] getThresholds() {
        Threshold[] t2 = this.iconFormatting.getThresholds();
        HSSFConditionalFormattingThreshold[] ht = new HSSFConditionalFormattingThreshold[t2.length];
        for (int i = 0; i < t2.length; ++i) {
            ht[i] = new HSSFConditionalFormattingThreshold(t2[i], this.sheet);
        }
        return ht;
    }

    @Override
    public void setThresholds(ConditionalFormattingThreshold[] thresholds) {
        Threshold[] t2 = new Threshold[thresholds.length];
        for (int i = 0; i < t2.length; ++i) {
            t2[i] = ((HSSFConditionalFormattingThreshold)thresholds[i]).getThreshold();
        }
        this.iconFormatting.setThresholds(t2);
    }

    @Override
    public HSSFConditionalFormattingThreshold createThreshold() {
        return new HSSFConditionalFormattingThreshold(new IconMultiStateThreshold(), this.sheet);
    }
}

