/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.input.CloseShieldReader;
import org.apache.commons.io.output.CloseShieldWriter;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.PrettyMetadataKeyComparator;

public class JsonMetadata {
    static volatile boolean PRETTY_PRINT = false;

    public static void toJson(Metadata metadata, Writer writer) throws IOException {
        if (metadata == null) {
            writer.write("null");
            return;
        }
        long max = TikaConfig.getMaxJsonStringFieldLength();
        try (JsonGenerator jsonGenerator = new JsonFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(TikaConfig.getMaxJsonStringFieldLength()).build()).createGenerator(new CloseShieldWriter(writer));){
            if (PRETTY_PRINT) {
                jsonGenerator.useDefaultPrettyPrinter();
            }
            JsonMetadata.writeMetadataObject(metadata, jsonGenerator, PRETTY_PRINT);
        }
    }

    static void writeMetadataObject(Metadata metadata, JsonGenerator jsonGenerator, boolean prettyPrint) throws IOException {
        jsonGenerator.writeStartObject();
        String[] names = metadata.names();
        if (prettyPrint) {
            Arrays.sort(names, new PrettyMetadataKeyComparator());
        }
        for (String n : names) {
            String[] vals = metadata.getValues(n);
            if (vals.length == 0) continue;
            if (vals.length == 1) {
                jsonGenerator.writeStringField(n, vals[0]);
                continue;
            }
            if (vals.length <= 1) continue;
            jsonGenerator.writeArrayFieldStart(n);
            for (String val : vals) {
                jsonGenerator.writeString(val);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }

    public static Metadata fromJson(Reader reader) throws IOException {
        Metadata m4 = null;
        try (JsonParser jParser = new JsonFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(TikaConfig.getMaxJsonStringFieldLength()).build()).createParser(new CloseShieldReader(reader));){
            m4 = JsonMetadata.readMetadataObject(jParser);
        }
        return m4;
    }

    public static Metadata readMetadataObject(JsonParser jParser) throws IOException {
        Metadata metadata = new Metadata();
        JsonToken token = jParser.currentToken();
        if (token == null) {
            token = jParser.nextToken();
            if (token != JsonToken.START_OBJECT) {
                throw new IOException("expected start object, but got: " + token.name());
            }
            token = jParser.nextToken();
        } else if (token == JsonToken.START_OBJECT) {
            token = jParser.nextToken();
        }
        while (token != JsonToken.END_OBJECT) {
            token = jParser.currentToken();
            if (token != JsonToken.FIELD_NAME) {
                throw new IOException("expected field name, but got: " + token.name());
            }
            String key = jParser.getCurrentName();
            token = jParser.nextToken();
            if (token == JsonToken.START_ARRAY) {
                while (jParser.nextToken() != JsonToken.END_ARRAY) {
                    metadata.add(key, jParser.getText());
                }
            } else {
                if (token != JsonToken.VALUE_STRING) {
                    throw new IOException("expected string value, but found: " + token.name());
                }
                String value = jParser.getValueAsString();
                metadata.set(key, value);
            }
            token = jParser.nextToken();
        }
        return metadata;
    }

    public static void setPrettyPrinting(boolean prettyPrint) {
        PRETTY_PRINT = prettyPrint;
    }
}

