/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.math.BigInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmConstants;
import org.apache.tika.parser.microsoft.chm.ChmLzxState;
import org.apache.tika.parser.microsoft.chm.ChmParsingException;
import org.apache.tika.parser.microsoft.chm.ChmSection;

public class ChmLzxBlock {
    private static int MAX_CONTENT_SIZE = 0x3200000;
    private int block_number;
    private long block_length;
    private ChmLzxState state;
    private byte[] content = null;
    private ChmSection chmSection = null;
    private int contentLength = 0;
    private int previousBlockType = -1;

    public ChmLzxBlock(int blockNumber, byte[] dataSegment, long blockLength, ChmLzxBlock prevBlock) throws TikaException {
        if (this.validateConstructorParams(blockNumber, dataSegment, blockLength)) {
            this.setBlockNumber(blockNumber);
            if (prevBlock != null && prevBlock.getState().getBlockLength() > prevBlock.getState().getBlockRemaining()) {
                this.setChmSection(new ChmSection(dataSegment, prevBlock.getContent()));
            } else {
                this.setChmSection(new ChmSection(dataSegment));
            }
            this.setBlockLength(blockLength);
            this.checkLzxBlock(prevBlock);
            if (prevBlock == null || blockLength < (long)((int)this.getBlockLength())) {
                this.setContent((int)this.getBlockLength());
            } else {
                this.setContent((int)blockLength);
            }
            if (prevBlock != null && prevBlock.getState() != null) {
                this.previousBlockType = prevBlock.getState().getBlockType();
            }
        } else {
            throw new TikaException("Check your chm lzx block parameters");
        }
        this.extractContent();
    }

    protected int getContentLength() {
        return this.contentLength;
    }

    protected void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    private ChmSection getChmSection() {
        return this.chmSection;
    }

    private void setChmSection(ChmSection chmSection) {
        this.chmSection = chmSection;
    }

    private void assertStateNotNull() throws TikaException {
        if (this.getState() == null) {
            throw new ChmParsingException("state is null");
        }
    }

    private void extractContent() throws TikaException {
        this.assertStateNotNull();
        if (this.getChmSection().getData() != null) {
            boolean continueLoop = true;
            while (continueLoop && (long)this.getContentLength() < this.getBlockLength()) {
                int tempLen;
                if (this.getState() != null && this.getState().getBlockRemaining() == 0) {
                    if (this.getState().getHadStarted() == ChmCommons.LzxState.NOT_STARTED_DECODING) {
                        this.getState().setHadStarted(ChmCommons.LzxState.STARTED_DECODING);
                        if (this.getChmSection().getSyncBits(1) == 1) {
                            int intelSizeTemp = (this.getChmSection().getSyncBits(16) << 16) + this.getChmSection().getSyncBits(16);
                            if (intelSizeTemp >= 0) {
                                this.getState().setIntelFileSize(intelSizeTemp);
                            } else {
                                this.getState().setIntelFileSize(0);
                            }
                        }
                    }
                    this.getState().setBlockType(this.getChmSection().getSyncBits(3));
                    this.getState().setBlockLength((this.getChmSection().getSyncBits(16) << 8) + this.getChmSection().getSyncBits(8));
                    this.getState().setBlockRemaining(this.getState().getBlockLength());
                    if (this.getState().getBlockType() > 3 && this.previousBlockType >= 0 && this.previousBlockType < 3) {
                        this.getState().setBlockType(this.previousBlockType);
                    }
                    switch (this.getState().getBlockType()) {
                        case 2: {
                            this.createAlignedTreeTable();
                        }
                        case 1: {
                            this.createMainTreeTable();
                            this.createLengthTreeTable();
                            if (this.getState().getMainTreeLengtsTable()[232] == 0) break;
                            this.getState().setIntelState(ChmCommons.IntelState.STARTED);
                            break;
                        }
                        case 3: {
                            this.getState().setIntelState(ChmCommons.IntelState.STARTED);
                            if (this.getChmSection().getTotal() > 16) {
                                this.getChmSection().setSwath(this.getChmSection().getSwath() - 1);
                            }
                            this.getState().setR0(new BigInteger(this.getChmSection().reverseByteOrder(this.getChmSection().unmarshalBytes(4))).longValue());
                            this.getState().setR1(new BigInteger(this.getChmSection().reverseByteOrder(this.getChmSection().unmarshalBytes(4))).longValue());
                            this.getState().setR2(new BigInteger(this.getChmSection().reverseByteOrder(this.getChmSection().unmarshalBytes(4))).longValue());
                            break;
                        }
                    }
                }
                if ((long)(this.getContentLength() + this.getState().getBlockRemaining()) > this.getBlockLength()) {
                    this.getState().setBlockRemaining(this.getContentLength() + this.getState().getBlockRemaining() - (int)this.getBlockLength());
                    tempLen = (int)this.getBlockLength();
                } else {
                    tempLen = this.getContentLength() + this.getState().getBlockRemaining();
                    this.getState().setBlockRemaining(0);
                }
                int lastLength = this.getContentLength();
                switch (this.getState().getBlockType()) {
                    case 2: {
                        this.decompressAlignedBlock(tempLen, this.getChmSection().getPrevContent() == null ? this.getChmSection().getData() : this.getChmSection().getPrevContent());
                        break;
                    }
                    case 1: {
                        this.decompressVerbatimBlock(tempLen, this.getChmSection().getPrevContent() == null ? this.getChmSection().getData() : this.getChmSection().getPrevContent());
                        break;
                    }
                    case 3: {
                        this.decompressUncompressedBlock(tempLen, this.getChmSection().getPrevContent() == null ? this.getChmSection().getData() : this.getChmSection().getPrevContent());
                    }
                }
                this.getState().increaseFramesRead();
                if (this.getState().getFramesRead() < 32768 && this.getState().getIntelFileSize() != 0) {
                    this.intelE8Decoding();
                }
                continueLoop = this.getContentLength() > lastLength;
            }
        }
    }

    protected void intelE8Decoding() {
        if (this.getBlockLength() <= 6L || this.getState().getIntelState() == ChmCommons.IntelState.NOT_STARTED) {
            this.getState().setBlockRemaining(this.getState().getBlockRemaining() - (int)this.getBlockLength());
        } else {
            long curpos = this.getState().getBlockRemaining();
            this.getState().setBlockRemaining(this.getState().getBlockRemaining() - (int)this.getBlockLength());
            int i = 0;
            while ((long)i < this.getBlockLength() - 10L) {
                if (this.content[i] != 232) {
                    ++i;
                    continue;
                }
                byte[] b = new byte[]{this.getContent()[i + 3], this.getContent()[i + 2], this.getContent()[i + 1], this.getContent()[i + 0]};
                long absoff = new BigInteger(b).longValue();
                if (absoff >= -curpos && absoff < (long)this.getState().getIntelFileSize()) {
                    long reloff = absoff >= 0L ? absoff - curpos : absoff + (long)this.getState().getIntelFileSize();
                    this.getContent()[i + 0] = (byte)reloff;
                    this.getContent()[i + 1] = (byte)(reloff >>> 8);
                    this.getContent()[i + 2] = (byte)(reloff >>> 16);
                    this.getContent()[i + 3] = (byte)(reloff >>> 24);
                }
                i += 4;
                curpos += 5L;
            }
        }
    }

    private short[] createPreLenTable() {
        short[] tmp = new short[20];
        for (int i = 0; i < 20; ++i) {
            tmp[i] = (short)this.getChmSection().getSyncBits(4);
        }
        return tmp;
    }

    private void createLengthTreeTable() throws TikaException {
        short[] prelentable = this.createPreLenTable();
        if (prelentable == null) {
            throw new ChmParsingException("pretreetable is null");
        }
        short[] pretreetable = this.createTreeTable2(prelentable, 104, 6, 20);
        if (pretreetable == null) {
            throw new ChmParsingException("pretreetable is null");
        }
        this.createLengthTreeLenTable(0, 249, pretreetable, prelentable);
        this.getState().setLengthTreeTable(this.createTreeTable2(this.getState().getLengthTreeLengtsTable(), 4596, 12, 249));
    }

    private void decompressUncompressedBlock(int len, byte[] prevcontent) {
        if ((long)(this.getContentLength() + this.getState().getBlockRemaining()) <= this.getBlockLength()) {
            for (int i = this.getContentLength(); i < this.getContentLength() + this.getState().getBlockRemaining(); ++i) {
                this.content[i] = this.getChmSection().getByte();
            }
            this.setContentLength(this.getContentLength() + this.getState().getBlockRemaining());
            this.getState().setBlockRemaining(0);
        } else {
            int i = this.getContentLength();
            while ((long)i < this.getBlockLength()) {
                this.content[i] = this.getChmSection().getByte();
                ++i;
            }
            this.getState().setBlockRemaining((int)this.getBlockLength() - this.getContentLength());
            this.setContentLength((int)this.getBlockLength());
        }
    }

    private void decompressAlignedBlock(int len, byte[] prevcontent) throws TikaException {
        if (this.getChmSection() == null || this.getState() == null || this.getState().getMainTreeTable() == null) {
            throw new ChmParsingException("chm section is null");
        }
        int matchlen = 0;
        int matchfooter = 0;
        int matchoffset = 0;
        for (int i = this.getContentLength(); i < len; ++i) {
            int runsrc;
            int x;
            int border = this.getChmSection().peekBits(12);
            if (border >= this.getState().mainTreeTable.length) {
                throw new ChmParsingException("error decompressing aligned block.");
            }
            short s2 = this.getState().mainTreeTable[this.getChmSection().peekBits(12)];
            if (s2 >= this.getState().getMainTreeElements()) {
                x = 12;
                do {
                    s2 = (short)(s2 << 1);
                    s2 = (short)(s2 + this.getChmSection().checkBit(++x));
                } while ((s2 = this.getState().mainTreeTable[s2]) >= this.getState().getMainTreeElements());
            }
            this.getChmSection().getSyncBits(this.getState().getMainTreeLengtsTable()[s2]);
            if (s2 < 256) {
                this.content[i] = (byte)s2;
                continue;
            }
            matchlen = (s2 = (short)(s2 - 256)) & 7;
            if (matchlen == 7) {
                matchfooter = this.getState().lengthTreeTable[this.getChmSection().peekBits(12)];
                if (matchfooter >= 250) {
                    x = 12;
                    do {
                        matchfooter <<= 1;
                        matchfooter += this.getChmSection().checkBit(++x);
                    } while ((matchfooter = this.getState().lengthTreeTable[matchfooter]) >= 249);
                }
                this.getChmSection().getSyncBits(this.getState().lengthTreeLengtsTable[matchfooter]);
                matchlen += matchfooter;
            }
            matchlen += 2;
            matchoffset = s2 >>> 3;
            if (matchoffset > 2) {
                int extra = ChmConstants.EXTRA_BITS[matchoffset];
                matchoffset = ChmConstants.POSITION_BASE[matchoffset] - 2;
                if (extra > 3) {
                    long verbatim_bits = this.getChmSection().getSyncBits(extra -= 3);
                    matchoffset = (int)((long)matchoffset + (verbatim_bits << 3));
                    int aligned_bits = this.getChmSection().peekBits(7);
                    int t2 = this.getState().getAlignedTreeTable()[aligned_bits];
                    if (t2 >= this.getState().getMainTreeElements()) {
                        x = 7;
                        do {
                            t2 <<= 1;
                            t2 += this.getChmSection().checkBit(++x);
                        } while ((t2 = this.getState().getAlignedTreeTable()[t2]) >= this.getState().getMainTreeElements());
                    }
                    this.getChmSection().getSyncBits(this.getState().getAlignedLenTable()[t2]);
                    matchoffset += t2;
                } else if (extra == 3) {
                    int g2 = this.getChmSection().peekBits(7);
                    int t3 = this.getState().getAlignedTreeTable()[g2];
                    if (t3 >= this.getState().getMainTreeElements()) {
                        x = 7;
                        do {
                            t3 <<= 1;
                            t3 += this.getChmSection().checkBit(++x);
                        } while ((t3 = this.getState().getAlignedTreeTable()[t3]) >= this.getState().getMainTreeElements());
                    }
                    this.getChmSection().getSyncBits(this.getState().getAlignedLenTable()[t3]);
                    matchoffset += t3;
                } else if (extra > 0) {
                    long l = this.getChmSection().getSyncBits(extra);
                    matchoffset = (int)((long)matchoffset + l);
                } else {
                    matchoffset = 1;
                }
                this.getState().setR2(this.getState().getR1());
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(matchoffset);
            } else if (matchoffset == 0) {
                matchoffset = (int)this.getState().getR0();
            } else if (matchoffset == 1) {
                matchoffset = (int)this.getState().getR1();
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(matchoffset);
            } else {
                matchoffset = (int)this.getState().getR2();
                this.getState().setR2(this.getState().getR0());
                this.getState().setR0(matchoffset);
            }
            int rundest = i;
            if ((i += matchlen - 1) > len) break;
            if (runsrc < 0) {
                if (matchlen + runsrc <= 0) {
                    runsrc = prevcontent.length + runsrc;
                    while (matchlen-- > 0) {
                        this.content[rundest++] = prevcontent[runsrc++];
                    }
                    continue;
                }
                runsrc = prevcontent.length + runsrc;
                while (runsrc < prevcontent.length) {
                    this.content[rundest++] = prevcontent[runsrc++];
                }
                matchlen = matchlen + runsrc - prevcontent.length;
                runsrc = 0;
                while (matchlen-- > 0) {
                    this.content[rundest++] = this.content[runsrc++];
                }
                continue;
            }
            for (runsrc = rundest - matchoffset; runsrc < 0 && matchlen-- > 0; ++runsrc) {
                this.content[rundest++] = this.content[(int)((long)runsrc + this.getBlockLength())];
            }
            while (matchlen-- > 0) {
                this.content[rundest++] = this.content[runsrc++];
            }
        }
        this.setContentLength(len);
    }

    private void assertShortArrayNotNull(short[] array) throws TikaException {
        if (array == null) {
            throw new ChmParsingException("short[] is null");
        }
    }

    private void decompressVerbatimBlock(int len, byte[] prevcontent) throws TikaException {
        int matchlen = 0;
        int matchfooter = 0;
        int matchoffset = 0;
        for (int i = this.getContentLength(); i < len; ++i) {
            int runsrc;
            int x;
            int f = this.getChmSection().peekBits(12);
            this.assertShortArrayNotNull(this.getState().getMainTreeTable());
            short s2 = this.getState().getMainTreeTable()[f];
            if (s2 >= 512) {
                x = 12;
                do {
                    s2 = (short)(s2 << 1);
                    s2 = (short)(s2 + this.getChmSection().checkBit(++x));
                } while ((s2 = this.getState().getMainTreeTable()[s2]) >= 512);
            }
            this.getChmSection().getSyncBits(this.getState().getMainTreeLengtsTable()[s2]);
            if (s2 < 256) {
                this.content[i] = (byte)s2;
                continue;
            }
            matchlen = (s2 = (short)(s2 - 256)) & 7;
            if (matchlen == 7) {
                matchfooter = this.getState().getLengthTreeTable()[this.getChmSection().peekBits(12)];
                if (matchfooter >= 249) {
                    x = 12;
                    do {
                        matchfooter <<= 1;
                        matchfooter += this.getChmSection().checkBit(++x);
                    } while ((matchfooter = this.getState().getLengthTreeTable()[matchfooter]) >= 249);
                }
                this.getChmSection().getSyncBits(this.getState().getLengthTreeLengtsTable()[matchfooter]);
                matchlen += matchfooter;
            }
            matchlen += 2;
            matchoffset = s2 >>> 3;
            if (matchoffset > 2) {
                if (matchoffset != 3) {
                    short extra = ChmConstants.EXTRA_BITS[matchoffset];
                    long l = this.getChmSection().getSyncBits(extra);
                    matchoffset = (int)((long)(ChmConstants.POSITION_BASE[matchoffset] - 2) + l);
                } else {
                    matchoffset = 1;
                }
                this.getState().setR2(this.getState().getR1());
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(matchoffset);
            } else if (matchoffset == 0) {
                matchoffset = (int)this.getState().getR0();
            } else if (matchoffset == 1) {
                matchoffset = (int)this.getState().getR1();
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(matchoffset);
            } else {
                matchoffset = (int)this.getState().getR2();
                this.getState().setR2(this.getState().getR0());
                this.getState().setR0(matchoffset);
            }
            int rundest = i;
            if ((i += matchlen - 1) > len) break;
            if (runsrc < 0) {
                if (matchlen + runsrc <= 0) {
                    runsrc = prevcontent.length + runsrc;
                    while (matchlen-- > 0 && prevcontent != null && runsrc + 1 > 0) {
                        if (rundest >= this.content.length || runsrc >= this.content.length) continue;
                        this.content[rundest++] = prevcontent[runsrc++];
                    }
                    continue;
                }
                runsrc = prevcontent.length + runsrc;
                while (runsrc < prevcontent.length) {
                    if (rundest >= this.content.length || runsrc >= this.content.length) continue;
                    this.content[rundest++] = prevcontent[runsrc++];
                }
                matchlen = matchlen + runsrc - prevcontent.length;
                runsrc = 0;
                while (matchlen-- > 0) {
                    this.content[rundest++] = this.content[runsrc++];
                }
                continue;
            }
            for (runsrc = rundest - matchoffset; runsrc < 0 && matchlen-- > 0; ++runsrc) {
                this.content[rundest++] = this.content[(int)((long)runsrc + this.getBlockLength())];
            }
            while (matchlen-- > 0) {
                if (rundest >= this.content.length || runsrc >= this.content.length) continue;
                this.content[rundest++] = this.content[runsrc++];
            }
        }
        this.setContentLength(len);
    }

    private void createLengthTreeLenTable(int offset, int tablelen, short[] pretreetable, short[] prelentable) throws TikaException {
        if (prelentable == null || this.getChmSection() == null || pretreetable == null || prelentable == null) {
            throw new ChmParsingException("is null");
        }
        int i = offset;
        while (i < tablelen) {
            int j;
            int y;
            int x;
            int z = pretreetable[this.getChmSection().peekBits(6)];
            if (z >= 20) {
                x = 6;
                do {
                    z <<= 1;
                    z += this.getChmSection().checkBit(++x);
                } while ((z = pretreetable[z]) >= 20);
            }
            this.getChmSection().getSyncBits(prelentable[z]);
            if (z < 17) {
                z = this.getState().getLengthTreeLengtsTable()[i] - z;
                if (z < 0) {
                    z += 17;
                }
                this.getState().getLengthTreeLengtsTable()[i] = (short)z;
                ++i;
                continue;
            }
            if (z == 17) {
                y = this.getChmSection().getSyncBits(4);
                y += 4;
                for (j = 0; j < y; ++j) {
                    if (i >= this.getState().getLengthTreeLengtsTable().length) continue;
                    this.getState().getLengthTreeLengtsTable()[i++] = 0;
                }
                continue;
            }
            if (z == 18) {
                y = this.getChmSection().getSyncBits(5);
                y += 20;
                for (j = 0; j < y; ++j) {
                    this.getState().getLengthTreeLengtsTable()[i++] = 0;
                }
                continue;
            }
            if (z != 19) continue;
            y = this.getChmSection().getSyncBits(1);
            y += 4;
            z = pretreetable[this.getChmSection().peekBits(6)];
            if (z >= 20) {
                x = 6;
                do {
                    z <<= 1;
                    z += this.getChmSection().checkBit(++x);
                } while ((z = pretreetable[z]) >= 20);
            }
            this.getChmSection().getSyncBits(prelentable[z]);
            z = this.getState().getLengthTreeLengtsTable()[i] - z;
            if (z < 0) {
                z += 17;
            }
            for (j = 0; j < y; ++j) {
                this.getState().getLengthTreeLengtsTable()[i++] = (short)z;
            }
        }
    }

    private void createMainTreeTable() throws TikaException {
        short[] prelentable = this.createPreLenTable();
        short[] pretreetable = this.createTreeTable2(prelentable, 104, 6, 20);
        this.createMainTreeLenTable(0, 256, pretreetable, prelentable);
        prelentable = this.createPreLenTable();
        pretreetable = this.createTreeTable2(prelentable, 104, 6, 20);
        this.createMainTreeLenTable(256, this.getState().mainTreeLengtsTable.length, pretreetable, prelentable);
        this.getState().setMainTreeTable(this.createTreeTable2(this.getState().mainTreeLengtsTable, 5408, 12, this.getState().getMainTreeElements()));
    }

    private void createMainTreeLenTable(int offset, int tablelen, short[] pretreetable, short[] prelentable) throws TikaException {
        if (pretreetable == null) {
            throw new ChmParsingException("pretreetable is null");
        }
        int i = offset;
        while (i < tablelen) {
            int j;
            int y;
            int x;
            int f = this.getChmSection().peekBits(6);
            int z = pretreetable[f];
            if (z >= 20) {
                x = 6;
                do {
                    z <<= 1;
                    z += this.getChmSection().checkBit(++x);
                } while ((z = pretreetable[z]) >= 20);
            }
            this.getChmSection().getSyncBits(prelentable[z]);
            if (z < 17) {
                z = this.getState().getMainTreeLengtsTable()[i] - z;
                if (z < 0) {
                    z += 17;
                }
                this.getState().mainTreeLengtsTable[i] = (short)z;
                ++i;
                continue;
            }
            if (z == 17) {
                y = this.getChmSection().getSyncBits(4);
                y += 4;
                for (j = 0; j < y; ++j) {
                    this.assertInRange(this.getState().getMainTreeLengtsTable(), i);
                    this.getState().mainTreeLengtsTable[i++] = 0;
                }
                continue;
            }
            if (z == 18) {
                y = this.getChmSection().getSyncBits(5);
                y += 20;
                for (j = 0; j < y; ++j) {
                    this.assertInRange(this.getState().getMainTreeLengtsTable(), i);
                    this.getState().mainTreeLengtsTable[i++] = 0;
                }
                continue;
            }
            if (z != 19) continue;
            y = this.getChmSection().getSyncBits(1);
            y += 4;
            z = pretreetable[this.getChmSection().peekBits(6)];
            if (z >= 20) {
                x = 6;
                do {
                    z <<= 1;
                    z += this.getChmSection().checkBit(++x);
                } while ((z = pretreetable[z]) >= 20);
            }
            this.getChmSection().getSyncBits(prelentable[z]);
            z = this.getState().mainTreeLengtsTable[i] - z;
            if (z < 0) {
                z += 17;
            }
            for (j = 0; j < y; ++j) {
                if (i >= this.getState().getMainTreeLengtsTable().length) continue;
                this.getState().mainTreeLengtsTable[i++] = (short)z;
            }
        }
    }

    private void assertInRange(short[] array, int index) throws ChmParsingException {
        if (index >= array.length) {
            throw new ChmParsingException(index + " is bigger than " + array.length);
        }
    }

    private short[] createAlignedLenTable() {
        int tablelen = 8;
        int bits = 3;
        short[] tmp = new short[tablelen];
        for (int i = 0; i < tablelen; ++i) {
            tmp[i] = (short)this.getChmSection().getSyncBits(bits);
        }
        return tmp;
    }

    private void createAlignedTreeTable() throws ChmParsingException {
        this.getState().setAlignedLenTable(this.createAlignedLenTable());
        this.getState().setAlignedTreeTable(this.createTreeTable2(this.getState().getAlignedLenTable(), 144, 7, 8));
    }

    private short[] createTreeTable2(short[] lentable, int tablelen, int bits, int maxsymbol) throws ChmParsingException {
        long fill;
        int leaf;
        int sym;
        int bit_num;
        long bit_mask;
        short[] tmp = new short[tablelen];
        int pos = 0;
        long table_mask = 1 << bits;
        long next_symbol = bit_mask = table_mask >> 1;
        for (bit_num = 1; bit_num <= bits; ++bit_num) {
            for (sym = 0; sym < maxsymbol; sym = (int)((short)(sym + 1))) {
                if (lentable.length <= sym || lentable[sym] != bit_num) continue;
                leaf = pos;
                if ((long)(pos = (int)((long)pos + bit_mask)) > table_mask) {
                    throw new ChmParsingException("Table overflow");
                }
                fill = bit_mask;
                while (fill-- > 0L) {
                    tmp[leaf++] = sym;
                }
            }
            bit_mask >>= 1;
        }
        if ((long)pos != table_mask) {
            leaf = pos;
            while ((long)leaf < table_mask) {
                tmp[leaf] = 0;
                ++leaf;
            }
            pos <<= 16;
            table_mask <<= 16;
            bit_mask = 32768L;
            while (bit_num <= 16) {
                for (sym = 0; sym < maxsymbol; sym = (int)((short)(sym + 1))) {
                    if (lentable.length <= sym || lentable[sym] != bit_num) continue;
                    leaf = pos >> 16;
                    for (fill = 0L; fill < (long)(bit_num - bits); ++fill) {
                        if (tmp[leaf] == 0 && (next_symbol << 1) + 1L < (long)tmp.length) {
                            tmp[(int)(next_symbol << 1)] = 0;
                            tmp[(int)(next_symbol << 1) + 1] = 0;
                            tmp[leaf] = (short)next_symbol++;
                        }
                        leaf = tmp[leaf] << 1;
                        if ((pos >> (int)(15L - fill) & 1) == 0) continue;
                        ++leaf;
                    }
                    tmp[leaf] = sym;
                    if ((long)(pos = (int)((long)pos + bit_mask)) <= table_mask) continue;
                    throw new ChmParsingException("Table overflow");
                }
                bit_mask >>= 1;
                ++bit_num;
            }
        }
        if ((long)pos == table_mask) {
            return tmp;
        }
        return tmp;
    }

    public byte[] getContent() {
        return this.content;
    }

    private void setContent(int contentLength) throws TikaException {
        if (contentLength > MAX_CONTENT_SIZE) {
            throw new TikaMemoryLimitException("content length (" + contentLength + " bytes) is > MAX_CONTENT_SIZE");
        }
        this.content = new byte[contentLength];
    }

    public byte[] getContent(int startOffset, int endOffset) throws TikaException {
        return this.getContent() != null ? ChmCommons.copyOfRange(this.getContent(), startOffset, endOffset) : new byte[1];
    }

    public byte[] getContent(int start) throws TikaException {
        return this.getContent() != null ? ChmCommons.copyOfRange(this.getContent(), start, this.getContent().length) : new byte[1];
    }

    private void checkLzxBlock(ChmLzxBlock chmPrevLzxBlock) throws TikaException {
        if (chmPrevLzxBlock == null && this.getBlockLength() < Integer.MAX_VALUE) {
            this.setState(new ChmLzxState((int)this.getBlockLength()));
        } else {
            this.setState(chmPrevLzxBlock.getState().clone());
        }
    }

    private boolean validateConstructorParams(int blockNumber, byte[] dataSegment, long blockLength) throws TikaException {
        int goodParameter = 0;
        if (blockNumber >= 0) {
            ++goodParameter;
        } else {
            throw new ChmParsingException("block number should be possitive");
        }
        if (dataSegment != null && dataSegment.length > 0) {
            ++goodParameter;
        } else {
            throw new ChmParsingException("data segment should not be null");
        }
        if (blockLength <= 0L) {
            throw new ChmParsingException("block length should be more than zero");
        }
        return ++goodParameter == 3;
    }

    public int getBlockNumber() {
        return this.block_number;
    }

    private void setBlockNumber(int block_number) {
        this.block_number = block_number;
    }

    private long getBlockLength() {
        return this.block_length;
    }

    private void setBlockLength(long block_length) {
        this.block_length = block_length;
    }

    public ChmLzxState getState() {
        return this.state;
    }

    private void setState(ChmLzxState state) {
        this.state = state;
    }
}

