/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.microsoft.onenote.OneNotePropertyEnum;
import org.apache.tika.parser.microsoft.onenote.OneNoteTreeWalkerOptions;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.EightBytesOfData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.FourBytesOfData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.IProperty;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.PrtFourBytesOfLengthFollowedByData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.CellManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.PropertySet;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionStoreObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionStoreObjectGroup;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexCellMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexRevisionMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.CellID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.HeaderCell;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.PropertyID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.PropertyType;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.unsigned.Unsigned;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitConverter;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class MSOneStorePackage {
    private static final long TIME32_EPOCH_DIFF_1980;
    private static final long DATETIME_EPOCH_DIFF_1601;
    private static final Pattern HYPERLINK_PATTERN;
    private static final String P = "p";
    private final Set<String> authors = new HashSet<String>();
    private final Set<String> mostRecentAuthors = new HashSet<String>();
    private final Set<String> originalAuthors = new HashSet<String>();
    public StorageIndexDataElementData storageIndex;
    public StorageManifestDataElementData storageManifest;
    public CellManifestDataElementData headerCellCellManifest;
    public RevisionManifestDataElementData headerCellRevisionManifest;
    public List<RevisionManifestDataElementData> revisionManifests;
    public List<CellManifestDataElementData> cellManifests;
    public HeaderCell headerCell;
    public List<RevisionStoreObjectGroup> dataRoot;
    public List<RevisionStoreObjectGroup> OtherFileNodeList;
    private boolean mostRecentAuthorProp = false;
    private boolean originalAuthorProp = false;
    private Instant lastModifiedTimestamp = Instant.MIN;
    private long creationTimestamp = Long.MAX_VALUE;
    private long lastModified = Long.MIN_VALUE;

    public MSOneStorePackage() {
        this.revisionManifests = new ArrayList<RevisionManifestDataElementData>();
        this.cellManifests = new ArrayList<CellManifestDataElementData>();
        this.OtherFileNodeList = new ArrayList<RevisionStoreObjectGroup>();
    }

    public StorageIndexCellMapping findStorageIndexCellMapping(CellID cellID) {
        StorageIndexCellMapping storageIndexCellMapping = null;
        if (this.storageIndex != null) {
            storageIndexCellMapping = this.storageIndex.storageIndexCellMappingList.stream().filter(s2 -> s2.cellID.equals(cellID)).findFirst().orElse(new StorageIndexCellMapping());
        }
        return storageIndexCellMapping;
    }

    public StorageIndexRevisionMapping findStorageIndexRevisionMapping(ExGuid revisionExtendedGUID) {
        StorageIndexRevisionMapping instance = null;
        if (this.storageIndex != null) {
            instance = this.storageIndex.storageIndexRevisionMappingList.stream().filter(r -> r.revisionExGuid.equals(revisionExtendedGUID)).findFirst().orElse(new StorageIndexRevisionMapping());
        }
        return instance;
    }

    private boolean propertyIsBinary(OneNotePropertyEnum property) {
        return property == OneNotePropertyEnum.RgOutlineIndentDistance || property == OneNotePropertyEnum.NotebookManagementEntityGuid || property == OneNotePropertyEnum.RichEditTextUnicode;
    }

    public void walkTree(OneNoteTreeWalkerOptions options, Metadata metadata, XHTMLContentHandler xhtml) throws SAXException, TikaException, IOException {
        for (RevisionStoreObjectGroup revisionStoreObjectGroup : this.OtherFileNodeList) {
            for (RevisionStoreObject revisionStoreObject : revisionStoreObjectGroup.objects) {
                PropertySet propertySet = revisionStoreObject.propertySet.objectSpaceObjectPropSet.body;
                for (int i = 0; i < propertySet.rgData.size(); ++i) {
                    IProperty property = propertySet.rgData.get(i);
                    PropertyID propertyID = propertySet.rgPrids[i];
                    PropertyType propertyType = PropertyType.fromIntVal(propertyID.type);
                    OneNotePropertyEnum oneNotePropertyEnum = OneNotePropertyEnum.of(Unsigned.uint(propertyID.value).longValue());
                    if (oneNotePropertyEnum == OneNotePropertyEnum.LastModifiedTimeStamp) {
                        long fullval = this.getScalar(property);
                        Instant instant = Instant.ofEpochSecond(fullval / 10000000L + DATETIME_EPOCH_DIFF_1601);
                        if (instant.isAfter(this.lastModifiedTimestamp)) {
                            this.lastModifiedTimestamp = instant;
                        }
                        metadata.set("onenote:lastModifiedTimestamp", String.valueOf(this.lastModifiedTimestamp.toEpochMilli()));
                        continue;
                    }
                    if (oneNotePropertyEnum == OneNotePropertyEnum.CreationTimeStamp) {
                        long scalar = this.getScalar(property);
                        long creationTs = scalar + TIME32_EPOCH_DIFF_1980;
                        if (creationTs < this.creationTimestamp) {
                            this.creationTimestamp = creationTs;
                        }
                        metadata.set("onenote:creationTimestamp", String.valueOf(this.creationTimestamp));
                        continue;
                    }
                    if (oneNotePropertyEnum == OneNotePropertyEnum.LastModifiedTime) {
                        long scalar = this.getScalar(property);
                        long lastMod = scalar + TIME32_EPOCH_DIFF_1980;
                        if (lastMod > this.lastModified) {
                            this.lastModified = lastMod;
                        }
                        metadata.set(TikaCoreProperties.MODIFIED, String.valueOf(this.lastModified));
                        continue;
                    }
                    if (oneNotePropertyEnum == OneNotePropertyEnum.Author) {
                        String author = new String(((PrtFourBytesOfLengthFollowedByData)property).data, StandardCharsets.UTF_8);
                        if (this.mostRecentAuthorProp) {
                            this.mostRecentAuthors.add(author);
                            continue;
                        }
                        if (this.originalAuthorProp) {
                            this.originalAuthors.add(author);
                            continue;
                        }
                        this.authors.add(author);
                        continue;
                    }
                    if (oneNotePropertyEnum == OneNotePropertyEnum.AuthorMostRecent) {
                        this.mostRecentAuthorProp = true;
                        continue;
                    }
                    if (oneNotePropertyEnum == OneNotePropertyEnum.AuthorOriginal) {
                        this.originalAuthorProp = true;
                        continue;
                    }
                    if (propertyType != PropertyType.FourBytesOfLengthFollowedByData) continue;
                    boolean isBinary = this.propertyIsBinary(oneNotePropertyEnum);
                    PrtFourBytesOfLengthFollowedByData dataProperty = (PrtFourBytesOfLengthFollowedByData)property;
                    if ((dataProperty.data.length & 1) == 0 && oneNotePropertyEnum != OneNotePropertyEnum.TextExtendedAscii && !isBinary) {
                        if (!options.getUtf16PropertiesToPrint().contains((Object)oneNotePropertyEnum)) continue;
                        xhtml.startElement(P);
                        xhtml.characters(new String(dataProperty.data, StandardCharsets.UTF_16LE));
                        xhtml.endElement(P);
                        continue;
                    }
                    if (oneNotePropertyEnum == OneNotePropertyEnum.TextExtendedAscii) {
                        xhtml.startElement(P);
                        xhtml.characters(new String(dataProperty.data, StandardCharsets.US_ASCII));
                        xhtml.endElement(P);
                        continue;
                    }
                    if (!isBinary) {
                        if (!options.getUtf16PropertiesToPrint().contains((Object)oneNotePropertyEnum)) continue;
                        xhtml.startElement(P);
                        xhtml.characters(new String(dataProperty.data, StandardCharsets.UTF_16LE));
                        xhtml.endElement(P);
                        continue;
                    }
                    if (oneNotePropertyEnum != OneNotePropertyEnum.RichEditTextUnicode) continue;
                    this.handleRichEditTextUnicode(dataProperty.data, xhtml);
                }
            }
        }
        if (!this.authors.isEmpty()) {
            metadata.set(TikaCoreProperties.CREATOR, this.authors.toArray(new String[0]));
        }
        if (!this.mostRecentAuthors.isEmpty()) {
            metadata.set(Property.externalTextBag("onenote:mostRecentAuthors"), this.mostRecentAuthors.toArray(new String[0]));
        }
        if (!this.originalAuthors.isEmpty()) {
            metadata.set(Property.externalTextBag("onenote:originalAuthors"), this.originalAuthors.toArray(new String[0]));
        }
    }

    private void handleRichEditTextUnicode(byte[] arr, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        int firstNull = 0;
        for (int i = 0; i < arr.length - 1; i += 2) {
            if (arr[i] != 0 || arr[i + 1] != 0) continue;
            firstNull = Math.max(i, 0);
            break;
        }
        if (firstNull == 0) {
            return;
        }
        String txt = new String(arr, 0, firstNull, StandardCharsets.UTF_16LE);
        Matcher m4 = HYPERLINK_PATTERN.matcher(txt);
        if (m4.find()) {
            xhtml.startElement("a", "href", m4.group(1));
            xhtml.characters(m4.group(2));
            xhtml.endElement("a");
        } else {
            xhtml.startElement(P);
            xhtml.characters(txt);
            xhtml.endElement(P);
        }
    }

    private long getScalar(IProperty property) throws TikaException, IOException {
        if (property instanceof FourBytesOfData) {
            FourBytesOfData fourBytesOfDataProp = (FourBytesOfData)property;
            return BitConverter.toUInt32(fourBytesOfDataProp.data, 0);
        }
        if (property instanceof EightBytesOfData) {
            EightBytesOfData fourBytesOfDataProp = (EightBytesOfData)property;
            return BitConverter.toInt64(fourBytesOfDataProp.data, 0);
        }
        throw new TikaException("Could not parse scalar of type " + property.getClass());
    }

    static {
        HYPERLINK_PATTERN = Pattern.compile("\ufddfHYPERLINK\\s+\"([^\"]+)\"([^\"]+)$");
        LocalDateTime time32Epoch1980 = LocalDateTime.of(1980, Month.JANUARY, 1, 0, 0);
        Instant instant = time32Epoch1980.atZone(ZoneOffset.UTC).toInstant();
        TIME32_EPOCH_DIFF_1980 = (instant.toEpochMilli() - Instant.EPOCH.toEpochMilli()) / 1000L;
        LocalDateTime time32Epoch1601 = LocalDateTime.of(1601, Month.JANUARY, 1, 0, 0);
        instant = time32Epoch1601.atZone(ZoneOffset.UTC).toInstant();
        DATETIME_EPOCH_DIFF_1601 = (instant.toEpochMilli() - Instant.EPOCH.toEpochMilli()) / 1000L;
    }
}

