/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006;

import java.util.HashMap;
import java.util.Map;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.AbstractPartHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class CorePropertiesHandler
extends AbstractPartHandler {
    static final String DC_NS = "http://purl.org/dc/elements/1.1";
    static final String DC_TERMS_NS = "http://purl.org/dc/terms";
    static final String CP_NS = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    final StringBuilder buffer = new StringBuilder();
    final Map<String, Map<String, Property>> properties = new HashMap<String, Map<String, Property>>();
    private final Metadata metadata;

    public CorePropertiesHandler(Metadata metadata) {
        this.metadata = metadata;
        this.addProperties();
    }

    void addProperties() {
        Map<String, Property> dc = this.properties.get(DC_NS);
        if (dc == null) {
            dc = new HashMap<String, Property>();
        }
        dc.put("creator", TikaCoreProperties.CREATOR);
        dc.put("title", TikaCoreProperties.TITLE);
        dc.put("description", TikaCoreProperties.DESCRIPTION);
        this.properties.put(DC_NS, dc);
        Map<String, Property> dcTerms = this.properties.get(DC_TERMS_NS);
        if (dcTerms == null) {
            dcTerms = new HashMap<String, Property>();
        }
        dcTerms.put("created", TikaCoreProperties.CREATED);
        dcTerms.put("modified", TikaCoreProperties.MODIFIED);
        this.properties.put(DC_TERMS_NS, dcTerms);
        Map<String, Property> cp = this.properties.get(CP_NS);
        if (cp == null) {
            cp = new HashMap<String, Property>();
        }
        cp.put("category", OfficeOpenXMLCore.CATEGORY);
        cp.put("contentStatus", OfficeOpenXMLCore.CONTENT_STATUS);
        cp.put("lastModifiedBy", TikaCoreProperties.MODIFIER);
        cp.put("lastPrinted", OfficeOpenXMLCore.LAST_PRINTED);
        cp.put("revision", OfficeOpenXMLCore.REVISION);
        cp.put("subject", DublinCore.SUBJECT);
        cp.put("version", OfficeOpenXMLCore.VERSION);
        this.properties.put(CP_NS, cp);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.buffer.setLength(0);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Property prop = this.getProperty(uri, localName);
        if (prop != null) {
            if (prop.isMultiValuePermitted()) {
                this.metadata.add(prop, this.buffer.toString());
            } else {
                this.metadata.set(prop, this.buffer.toString());
            }
        }
        this.buffer.setLength(0);
    }

    private Property getProperty(String uri, String localName) {
        Map<String, Property> m4;
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ((m4 = this.properties.get(uri)) != null) {
            return m4.get(localName);
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    @Override
    public String getContentType() {
        return "application/vnd.openxmlformats-package.core-properties+xml";
    }
}

