/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.regex;

import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.regex.RegularExpression;

public class SchemaRegularExpression
extends RegularExpression {
    static final Map<String, SchemaRegularExpression> knownPatterns = SchemaRegularExpression.buildKnownPatternMap();

    private SchemaRegularExpression(String pattern) {
        super(pattern, "X");
    }

    public static RegularExpression forPattern(String s2) {
        SchemaRegularExpression tre = knownPatterns.get(s2);
        if (tre != null) {
            return tre;
        }
        return new RegularExpression(s2, "X");
    }

    private static Map<String, SchemaRegularExpression> buildKnownPatternMap() {
        HashMap<String, SchemaRegularExpression> result = new HashMap<String, SchemaRegularExpression>();
        result.put("\\c+", new SchemaRegularExpression("\\c+"){

            @Override
            public boolean matches(String s2) {
                return XMLChar.isValidNmtoken(s2);
            }
        });
        result.put("\\i\\c*", new SchemaRegularExpression("\\i\\c*"){

            @Override
            public boolean matches(String s2) {
                return XMLChar.isValidName(s2);
            }
        });
        result.put("[\\i-[:]][\\c-[:]]*", new SchemaRegularExpression("[\\i-[:]][\\c-[:]]*"){

            @Override
            public boolean matches(String s2) {
                return XMLChar.isValidNCName(s2);
            }
        });
        return result;
    }
}

