/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit.rules;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.MinimalCoverageMatcher;
import org.camunda.bpm.extension.process_test_coverage.listeners.CompensationEventCoverageHandler;
import org.camunda.bpm.extension.process_test_coverage.listeners.FlowNodeHistoryEventHandler;
import org.camunda.bpm.extension.process_test_coverage.listeners.PathCoverageParseListener;
import org.camunda.bpm.extension.process_test_coverage.model.AggregatedCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.ClassCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.MethodCoverage;
import org.camunda.bpm.extension.process_test_coverage.util.CoverageReportUtil;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestCoverageProcessEngineRule
extends ProcessEngineRule {
    private static Logger logger = Logger.getLogger(TestCoverageProcessEngineRule.class.getCanonicalName());
    private CoverageTestRunState coverageTestRunState;
    private boolean firstRun = true;
    private boolean detailedCoverageLogging = false;
    private Collection<Matcher<Double>> classCoverageAssertionMatchers = new LinkedList<Matcher<Double>>();
    private Map<String, Collection<Matcher<Double>>> testMethodNameToCoverageMatchers = new HashMap<String, Collection<Matcher<Double>>>();

    public void addTestMethodCoverageAssertionMatcher(String testMethodName, Matcher<Double> matcher) {
        Collection<Matcher<Double>> matchers = this.testMethodNameToCoverageMatchers.get(testMethodName);
        if (matchers == null) {
            matchers = new LinkedList<Matcher<Double>>();
            this.testMethodNameToCoverageMatchers.put(testMethodName, matchers);
        }
        matchers.add(matcher);
    }

    public void addClassCoverageAssertionMatcher(MinimalCoverageMatcher matcher) {
        this.classCoverageAssertionMatchers.add((Matcher<Double>)matcher);
    }

    public void starting(Description description) {
        this.validateRuleAnnotations(description);
        super.initializeProcessEngine();
        this.initializeRunState(description);
        super.starting(description);
        this.initializeMethodCoverage(description);
    }

    public void finished(Description description) {
        this.handleTestMethodCoverage(description);
        this.handleClassCoverage(description);
        if (this.identityService != null) {
            super.finished(description);
        }
    }

    private void validateRuleAnnotations(Description description) {
        if (this.firstRun && !description.isTest()) {
            int numberOfCoverageRules = 0;
            for (Field field : description.getTestClass().getFields()) {
                Class<?> fieldType = field.getType();
                if (!((Object)((Object)this)).getClass().isAssignableFrom(fieldType)) continue;
                ++numberOfCoverageRules;
                boolean isClassRule = field.isAnnotationPresent(ClassRule.class);
                boolean isRule = field.isAnnotationPresent(Rule.class);
                if (!isClassRule || isRule) continue;
                throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + " can only be used as a @ClassRule if it is also a @Rule!");
            }
            if (numberOfCoverageRules > 1) {
                throw new RuntimeException("Only one coverage rule can be used per test class!");
            }
        }
    }

    private void initializeMethodCoverage(Description description) {
        if (this.deploymentId != null) {
            List deployedProcessDefinitions = this.processEngine.getRepositoryService().createProcessDefinitionQuery().deploymentId(this.deploymentId).list();
            this.coverageTestRunState.initializeTestMethodCoverage(this.processEngine, this.deploymentId, deployedProcessDefinitions, description.getMethodName());
        }
    }

    private void initializeRunState(Description description) {
        if (this.firstRun) {
            this.coverageTestRunState = new CoverageTestRunState();
            this.coverageTestRunState.setTestClassName(description.getClassName());
            this.initializeListenerRunState();
            this.firstRun = false;
        }
        this.coverageTestRunState.setCurrentTestMethodName(description.getMethodName());
    }

    private void initializeListenerRunState() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        FlowNodeHistoryEventHandler historyEventHandler = (FlowNodeHistoryEventHandler)processEngineConfiguration.getHistoryEventHandler();
        historyEventHandler.setCoverageTestRunState(this.coverageTestRunState);
        List bpmnParseListeners = processEngineConfiguration.getCustomPostBPMNParseListeners();
        for (BpmnParseListener parseListener : bpmnParseListeners) {
            if (!(parseListener instanceof PathCoverageParseListener)) continue;
            PathCoverageParseListener listener = (PathCoverageParseListener)parseListener;
            listener.setCoverageTestRunState(this.coverageTestRunState);
        }
        EventHandler compensationEventHandler = processEngineConfiguration.getEventHandler("compensate");
        if (compensationEventHandler != null && compensationEventHandler instanceof CompensationEventCoverageHandler) {
            CompensationEventCoverageHandler compensationEventCoverageHandler = (CompensationEventCoverageHandler)compensationEventHandler;
            compensationEventCoverageHandler.setCoverageTestRunState(this.coverageTestRunState);
        } else {
            logger.warning("CompensationEventCoverageHandler not registered with process engine configuration! Compensation boundary events coverage will not be registered.");
        }
    }

    private void handleTestMethodCoverage(Description description) {
        boolean testMethodHasDeployment;
        Deployment methodDeploymentAnnotation = (Deployment)description.getAnnotation(Deployment.class);
        Deployment classDeploymentAnnotation = description.getTestClass().getAnnotation(Deployment.class);
        boolean bl = testMethodHasDeployment = methodDeploymentAnnotation != null || classDeploymentAnnotation != null;
        if (testMethodHasDeployment) {
            String testName = description.getMethodName();
            MethodCoverage testCoverage = this.coverageTestRunState.getTestMethodCoverage(testName);
            double coveragePercentage = testCoverage.getCoveragePercentage();
            logger.info(testName + " test method coverage is " + coveragePercentage);
            this.logCoverageDetail(testCoverage);
            CoverageReportUtil.createCurrentTestMethodReport(this.processEngine, this.coverageTestRunState);
            if (this.testMethodNameToCoverageMatchers.containsKey(testName)) {
                this.assertCoverage(coveragePercentage, this.testMethodNameToCoverageMatchers.get(testName));
            }
        }
    }

    private void handleClassCoverage(Description description) {
        if (!description.isTest()) {
            ClassCoverage classCoverage = this.coverageTestRunState.getClassCoverage();
            classCoverage.assertAllDeploymentsEqual();
            double classCoveragePercentage = classCoverage.getCoveragePercentage();
            logger.info(this.coverageTestRunState.getTestClassName() + " test class coverage is: " + classCoveragePercentage);
            this.logCoverageDetail(classCoverage);
            CoverageReportUtil.createClassReport(this.processEngine, this.coverageTestRunState);
            this.assertCoverage(classCoveragePercentage, this.classCoverageAssertionMatchers);
        }
    }

    private void assertCoverage(double coverage, Collection<Matcher<Double>> matchers) {
        for (Matcher<Double> matcher : matchers) {
            Assert.assertThat((Object)coverage, matcher);
        }
    }

    private void logCoverageDetail(AggregatedCoverage coverage) {
        if (logger.isLoggable(Level.FINE) || this.isDetailedCoverageLogging()) {
            logger.log(Level.INFO, coverage.toString());
        }
    }

    public boolean isDetailedCoverageLogging() {
        return this.detailedCoverageLogging;
    }

    public void setDetailedCoverageLogging(boolean detailedCoverageLogging) {
        this.detailedCoverageLogging = detailedCoverageLogging;
    }

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void succeeded(Description description) {
        super.succeeded(description);
        logger.info(description.getDisplayName() + " succeeded.");
    }

    protected void failed(Throwable e, Description description) {
        super.failed(e, description);
        logger.info(description.getDisplayName() + " failed.");
    }
}

