/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit.rules;

import org.camunda.bpm.extension.process_test_coverage.junit.rules.MinimalCoverageMatcher;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.TestCoverageProcessEngineRule;

public class TestCoverageProcessEngineRuleBuilder {
    public static final String DEFAULT_ASSERT_AT_LEAST_PROPERTY = "org.camunda.bpm.extension.process_test_coverage.ASSERT_AT_LEAST";
    private TestCoverageProcessEngineRule rule = new TestCoverageProcessEngineRule();

    public static TestCoverageProcessEngineRuleBuilder create() {
        return TestCoverageProcessEngineRuleBuilder.createBase().optionalAssertCoverageAtLeastProperty(DEFAULT_ASSERT_AT_LEAST_PROPERTY);
    }

    public TestCoverageProcessEngineRuleBuilder optionalAssertCoverageAtLeastProperty(String key) {
        String assertAtLeast = System.getProperty(key);
        if (assertAtLeast != null) {
            try {
                MinimalCoverageMatcher minimalCoverageMatcher = new MinimalCoverageMatcher(Double.parseDouble(assertAtLeast));
                this.rule.addClassCoverageAssertionMatcher(minimalCoverageMatcher);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("BAD TEST CONFIGURATION: optionalAssertCoverageAtLeastProperty( \"" + key + "\" ) must be double");
            }
        }
        return this;
    }

    public static TestCoverageProcessEngineRuleBuilder createBase() {
        return new TestCoverageProcessEngineRuleBuilder();
    }

    public TestCoverageProcessEngineRuleBuilder withDetailedCoverageLogging() {
        this.rule.setDetailedCoverageLogging(true);
        return this;
    }

    public TestCoverageProcessEngineRuleBuilder assertClassCoverageAtLeast(double percentage) {
        if (0.0 > percentage || percentage > 1.0) {
            throw new RuntimeException("BAD TEST CONFIGURATION: coverageAtLeast " + percentage + " (" + 100.0 * percentage + "%) ");
        }
        this.rule.addClassCoverageAssertionMatcher(new MinimalCoverageMatcher(percentage));
        return this;
    }

    public TestCoverageProcessEngineRule build() {
        return this.rule;
    }
}

