/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.listeners;

import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.event.CompensationEventHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.util.Api;

public class CompensationEventCoverageHandler
extends CompensationEventHandler {
    private CoverageTestRunState coverageTestRunState;

    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (Api.Camunda.supportsCompensationEventCoverage()) {
            ActivityImpl activity = eventSubscription.getActivity();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)activity.getProcessDefinition();
            String processDefinitionKey = processDefinition.getKey();
            ActivityImpl sourceEvent = (ActivityImpl)activity.getProperty(BpmnProperties.COMPENSATION_BOUNDARY_EVENT.getName());
            String sourceEventId = sourceEvent.getActivityId();
            CoveredFlowNode compensationBoundaryEvent = new CoveredFlowNode(processDefinitionKey, sourceEventId);
            compensationBoundaryEvent.setEnded(true);
            this.coverageTestRunState.addCoveredElement(compensationBoundaryEvent);
        }
        super.handleEvent(eventSubscription, payload, commandContext);
    }

    public void setCoverageTestRunState(CoverageTestRunState coverageTestRunState) {
        this.coverageTestRunState = coverageTestRunState;
    }
}

