/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.listeners;

import java.util.EnumSet;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.DbHistoryEventHandler;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.util.Api;

public class FlowNodeHistoryEventHandler
extends DbHistoryEventHandler {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());
    private CoverageTestRunState coverageTestRunState;

    public void handleEvent(HistoryEvent historyEvent) {
        super.handleEvent(historyEvent);
        if (this.coverageTestRunState == null) {
            this.logger.warning("Coverage history event listener in use but no coverage run state assigned!");
            return;
        }
        if (historyEvent instanceof HistoricActivityInstanceEventEntity) {
            HistoricActivityInstanceEventEntity activityEvent = (HistoricActivityInstanceEventEntity)historyEvent;
            String processDefinitionKey = historyEvent.getProcessDefinitionId().substring(0, historyEvent.getProcessDefinitionId().indexOf(":"));
            CoveredFlowNode coveredActivity = new CoveredFlowNode(processDefinitionKey, activityEvent.getActivityId());
            if (this.isInitialEvent(historyEvent)) {
                this.coverageTestRunState.addCoveredElement(coveredActivity);
            } else if (this.isEndEvent(historyEvent)) {
                this.coverageTestRunState.endCoveredElement(coveredActivity);
            }
        }
    }

    protected boolean isInitialEvent(HistoryEvent historyEvent) {
        String isInitialEvent = "isInitialEvent";
        return Api.feature(DbHistoryEventHandler.class, isInitialEvent, HistoryEvent.class).isSupported() ? super.isInitialEvent(historyEvent) : ((Boolean)Api.feature(DbHistoryEventHandler.class, isInitialEvent, String.class).invoke((Object)this, historyEvent.getEventType())).booleanValue();
    }

    private boolean isEndEvent(HistoryEvent historyEvent) {
        EnumSet<HistoryEventTypes> endEventTypes = EnumSet.of(HistoryEventTypes.ACTIVITY_INSTANCE_END, HistoryEventTypes.PROCESS_INSTANCE_END, HistoryEventTypes.TASK_INSTANCE_COMPLETE);
        for (HistoryEventTypes endEventType : endEventTypes) {
            if (!historyEvent.getEventType().equals(endEventType.getEventName())) continue;
            return true;
        }
        return false;
    }

    public void setCoverageTestRunState(CoverageTestRunState coverageTestRunState) {
        this.coverageTestRunState = coverageTestRunState;
    }
}

