/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.model;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredElement;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredSequenceFlow;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;

public class ProcessCoverage {
    private static final String TOSTRING_TEMPLATE = "ProcessCoverage [processDefinitionId=''{0}'', coverage={1} ({2}/{3}), flowNodes=({4}/{5}), sequenceFlows=({6}/{7}), coveredFlowNodeIds={8}, definitionFlowNodes={9}]";
    private static final Logger logger = Logger.getLogger(ProcessCoverage.class.getCanonicalName());
    private ProcessDefinition processDefinition;
    private Set<CoveredFlowNode> coveredFlowNodes = new HashSet<CoveredFlowNode>();
    private Set<FlowNode> definitionFlowNodes;
    private Set<CoveredSequenceFlow> coveredSequenceFlows = new HashSet<CoveredSequenceFlow>();
    private Set<SequenceFlow> definitionSequenceFlows;

    public ProcessCoverage(ProcessEngine processEngine, ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
        BpmnModelInstance modelInstance = processEngine.getRepositoryService().getBpmnModelInstance(this.getProcessDefinitionId());
        this.definitionFlowNodes = new HashSet<FlowNode>(modelInstance.getModelElementsByType(FlowNode.class));
        this.definitionSequenceFlows = new HashSet<SequenceFlow>(modelInstance.getModelElementsByType(SequenceFlow.class));
    }

    public void addCoveredElement(CoveredElement element) {
        if (element instanceof CoveredFlowNode) {
            this.coveredFlowNodes.add((CoveredFlowNode)element);
        } else if (element instanceof CoveredSequenceFlow) {
            this.coveredSequenceFlows.add((CoveredSequenceFlow)element);
        } else {
            logger.log(Level.SEVERE, "Attempted adding unsupported element to process coverage. Process definition ID: {0} Element ID: {1}", new Object[]{element.getProcessDefinitionKey(), element.getElementId()});
        }
    }

    public void endCoveredElement(CoveredElement element) {
        if (element instanceof CoveredFlowNode) {
            CoveredFlowNode endedFlowNode = (CoveredFlowNode)element;
            this.coveredFlowNodes.remove(endedFlowNode);
            endedFlowNode.setEnded(true);
            this.coveredFlowNodes.add(endedFlowNode);
        } else {
            logger.log(Level.SEVERE, "Attempted ending unsupported element to process coverage. Process definition ID: {0} Element ID: {1}", new Object[]{element.getProcessDefinitionKey(), element.getElementId()});
        }
    }

    public double getCoveragePercentage() {
        return (double)this.getNumberOfAllCovered() / (double)this.getNumberOfAllDefined();
    }

    public Set<FlowNode> getDefinitionFlowNodes() {
        return this.definitionFlowNodes;
    }

    public Set<SequenceFlow> getDefinitionSequenceFlows() {
        return this.definitionSequenceFlows;
    }

    public Set<CoveredFlowNode> getCoveredFlowNodes() {
        return this.coveredFlowNodes;
    }

    public Set<String> getCoveredFlowNodeIds() {
        HashSet<String> coveredFlowNodeIds = new HashSet<String>();
        for (CoveredFlowNode activity : this.coveredFlowNodes) {
            coveredFlowNodeIds.add(activity.getElementId());
        }
        return coveredFlowNodeIds;
    }

    private Set<String> getDefinitionSequenceFlowIds() {
        HashSet<String> definitionFlowNodeIds = new HashSet<String>();
        for (FlowNode activity : this.definitionFlowNodes) {
            definitionFlowNodeIds.add(activity.getId());
        }
        return definitionFlowNodeIds;
    }

    public Set<CoveredSequenceFlow> getCoveredSequenceFlows() {
        return this.coveredSequenceFlows;
    }

    public Set<String> getCoveredSequenceFlowIds() {
        HashSet<String> sequenceFlowIds = new HashSet<String>();
        for (CoveredSequenceFlow sequenceFlow : this.coveredSequenceFlows) {
            sequenceFlowIds.add(sequenceFlow.getElementId());
        }
        return sequenceFlowIds;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public String getProcessDefinitionId() {
        return this.processDefinition.getId();
    }

    public String getProcessDefinitionKey() {
        return this.processDefinition.getKey();
    }

    public String toString() {
        return MessageFormat.format(TOSTRING_TEMPLATE, this.getProcessDefinitionId(), this.getCoveragePercentage(), this.getNumberOfAllCovered(), this.getNumberOfAllDefined(), this.coveredFlowNodes.size(), this.definitionFlowNodes.size(), this.coveredSequenceFlows.size(), this.definitionSequenceFlows.size(), this.getCoveredFlowNodeIds(), this.getDefinitionSequenceFlowIds());
    }

    private int getNumberOfAllCovered() {
        return this.coveredFlowNodes.size() + this.coveredSequenceFlows.size();
    }

    private int getNumberOfAllDefined() {
        return this.definitionFlowNodes.size() + this.definitionSequenceFlows.size();
    }
}

