/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.eclipse.aether.RepositorySystem;

public abstract class AbstractVersionsDisplayMojo
extends AbstractVersionsUpdaterMojo {
    static final String NL = System.getProperty("line.separator");
    private static final int DEFAULT_OUTPUT_LINE_WIDTH = 80;
    static final int INFO_PAD_SIZE = 72;
    @Parameter(property="versions.outputFile")
    protected File outputFile;
    @Parameter(property="versions.logOutput", defaultValue="true")
    protected boolean logOutput;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    protected String outputEncoding;
    @Parameter(property="versions.outputLineWidth", defaultValue="80")
    protected int outputLineWidth;
    private boolean outputFileError = false;

    @Inject
    protected AbstractVersionsDisplayMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    protected void logInit() {
        if (this.outputFile != null && !this.outputFileError) {
            if (this.outputFile.isFile()) {
                String outputFileName;
                String key = AbstractVersionsDisplayMojo.class.getName() + ".outputFile";
                try {
                    outputFileName = this.outputFile.getCanonicalPath();
                }
                catch (IOException e) {
                    outputFileName = this.outputFile.getAbsolutePath();
                }
                LinkedHashSet<String> files = (LinkedHashSet<String>)this.getPluginContext().get(key);
                files = files == null ? new LinkedHashSet<String>() : new LinkedHashSet(files);
                if (!files.contains(outputFileName) && !this.outputFile.delete()) {
                    this.getLog().error((CharSequence)("Cannot delete " + this.outputFile + " will append instead"));
                }
                files.add(outputFileName);
                this.getPluginContext().put(key, files);
            } else if (this.outputFile.exists()) {
                this.getLog().error((CharSequence)("Cannot send output to " + this.outputFile + " as it exists but is not a file"));
                this.outputFileError = true;
            } else if (!this.outputFile.getParentFile().isDirectory() && !this.outputFile.getParentFile().mkdirs()) {
                this.outputFileError = true;
            }
            if (!this.outputFileError && StringUtils.isBlank((CharSequence)this.outputEncoding)) {
                this.outputEncoding = System.getProperty("file.encoding");
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.outputEncoding + ", i.e. build is platform dependent!"));
            }
        }
    }

    protected void logLine(boolean error, String line) {
        if (this.logOutput) {
            if (error) {
                this.getLog().error((CharSequence)line);
            } else {
                this.getLog().info((CharSequence)line);
            }
        }
        if (this.outputFile != null && !this.outputFileError) {
            try {
                Files.write(this.outputFile.toPath(), (error ? "> " + line + NL : line + NL).getBytes(this.outputEncoding), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot send output to " + this.outputFile), (Throwable)e);
                this.outputFileError = true;
            }
        }
    }

    protected int getOutputLineWidthOffset() {
        return this.outputLineWidth - 80;
    }
}

