/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.OIDTokenizer;

public class DERObjectIdentifier
extends DERObject {
    String identifier;

    public static DERObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERObjectIdentifier.getInstance(aSN1TaggedObject.getObject());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        boolean bl = true;
        int n = 0;
        while (n != byArray.length) {
            int n2 = byArray[n] & 0xFF;
            l = l * 128L + (long)(n2 & 0x7F);
            if ((n2 & 0x80) == 0) {
                if (bl) {
                    switch ((int)l / 40) {
                        case 0: {
                            stringBuffer.append('0');
                            break;
                        }
                        case 1: {
                            stringBuffer.append('1');
                            l -= 40L;
                            break;
                        }
                        default: {
                            stringBuffer.append('2');
                            l -= 80L;
                        }
                    }
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(Long.toString(l));
                l = 0L;
            }
            ++n;
        }
        this.identifier = stringBuffer.toString();
    }

    public DERObjectIdentifier(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (('0' > c || c > '9') && c != '.') {
                throw new IllegalArgumentException("string " + string + " not an OID");
            }
            --n;
        }
        this.identifier = string;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream outputStream, long l) throws IOException {
        if (l >= 128L) {
            if (l >= 16384L) {
                if (l >= 0x200000L) {
                    if (l >= 0x10000000L) {
                        if (l >= 0x800000000L) {
                            if (l >= 0x40000000000L) {
                                if (l >= 0x2000000000000L) {
                                    if (l >= 0x100000000000000L) {
                                        outputStream.write((int)(l >> 56) | 0x80);
                                    }
                                    outputStream.write((int)(l >> 49) | 0x80);
                                }
                                outputStream.write((int)(l >> 42) | 0x80);
                            }
                            outputStream.write((int)(l >> 35) | 0x80);
                        }
                        outputStream.write((int)(l >> 28) | 0x80);
                    }
                    outputStream.write((int)(l >> 21) | 0x80);
                }
                outputStream.write((int)(l >> 14) | 0x80);
            }
            outputStream.write((int)(l >> 7) | 0x80);
        }
        outputStream.write((int)l & 0x7F);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        this.writeField(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            this.writeField(byteArrayOutputStream, Long.parseLong(oIDTokenizer.nextToken()));
        }
        dEROutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dEROutputStream.writeEncoded(6, byArray);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)object).identifier);
    }

    public String toString() {
        return this.getId();
    }
}

