/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashSet
extends AbstractCollection
implements Set,
Cloneable,
Serializable {
    static final long serialVersionUID = 1619330892277906704L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] entries;
    protected transient int count = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;

    public IdentityHashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.entries = new Entry[capacity];
    }

    public IdentityHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashSet() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new Entry[32];
    }

    public IdentityHashSet(Collection c) {
        this(Math.max((int)((float)c.size() / 0.75f) + 1, 32), 0.75f);
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.hash == hash && obj == e.value) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private void rehash() {
        int oldCapacity = this.entries.length;
        Entry[] oldEntries = this.entries;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newEntries = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = newEntries;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldEntries[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newEntries[index];
                newEntries[index] = e;
            }
        }
    }

    @Override
    public boolean add(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.hash == hash && obj == e.value) {
                return false;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            copyOfEntries = this.entries;
            index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        }
        copyOfEntries[index] = e = new Entry(hash, obj, copyOfEntries[index]);
        ++this.count;
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (obj == null) {
            return false;
        }
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && obj == e.value) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    copyOfEntries[index] = e.next;
                }
                --this.count;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("IdentityHashSet removeAll");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("IdentityHashSet retainAll");
    }

    @Override
    public void clear() {
        if (this.count > 0) {
            Entry[] copyOfEntries = this.entries;
            int i = copyOfEntries.length;
            while (--i >= 0) {
                copyOfEntries[i] = null;
            }
            this.count = 0;
        }
    }

    public Object clone() {
        try {
            Entry[] copyOfEntries = this.entries;
            IdentityHashSet clone = (IdentityHashSet)super.clone();
            clone.entries = new Entry[copyOfEntries.length];
            int i = copyOfEntries.length;
            while (i-- > 0) {
                Entry entry = clone.entries[i] = copyOfEntries[i] != null ? (Entry)copyOfEntries[i].clone() : null;
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Iterator iterator() {
        return new IdentityHashSetIterator();
    }

    private void writeObject(ObjectOutputStream s) throws IOException, ClassNotFoundException {
        s.defaultWriteObject();
        s.writeInt(this.entries.length);
        s.writeInt(this.count);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.entries = new Entry[numBuckets];
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            this.add(s.readObject());
            ++i;
        }
    }

    static class Entry {
        int hash;
        Object value;
        Entry next;

        Entry(int hash, Object value, Entry next) {
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            Entry rootNode;
            Entry currentNode = this;
            Entry currentNodeClone = rootNode = new Entry(this.hash, this.value, null);
            while (currentNode.next != null) {
                currentNodeClone.next = new Entry(currentNode.next.hash, currentNode.next.value, null);
                currentNode = currentNode.next;
                currentNodeClone = currentNodeClone.next;
            }
            return rootNode;
        }
    }

    class IdentityHashSetIterator
    implements Iterator {
        Entry[] copyOfEntries;
        int index;
        Entry entry;
        Entry lastReturned;

        IdentityHashSetIterator() {
            this.copyOfEntries = IdentityHashSet.this.entries;
            this.index = this.copyOfEntries.length;
            this.entry = null;
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            Entry e = this.entry;
            int i = this.index;
            Entry[] tmp = this.copyOfEntries;
            while (e == null && i > 0) {
                e = tmp[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        public Object next() {
            Entry et = this.entry;
            int i = this.index;
            Entry[] tmp = this.copyOfEntries;
            while (et == null && i > 0) {
                et = tmp[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                Entry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return e.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Entry[] copyOfEntries = IdentityHashSet.this.entries;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % copyOfEntries.length;
            Entry e = copyOfEntries[index];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    if (prev == null) {
                        copyOfEntries[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --IdentityHashSet.this.count;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

