/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.tycho.p2.repository.GAV;

public class RepositoryLayoutHelper {
    public static final String PROP_GROUP_ID = "maven-groupId";
    public static final String PROP_ARTIFACT_ID = "maven-artifactId";
    public static final String PROP_VERSION = "maven-version";
    public static final String PROP_CLASSIFIER = "maven-classifier";
    public static final String PROP_EXTENSION = "maven-extension";
    public static final String CLASSIFIER_P2_METADATA = "p2metadata";
    public static final String EXTENSION_P2_METADATA = "xml";
    public static final String FILE_NAME_P2_METADATA = "p2content.xml";
    public static final String CLASSIFIER_P2_ARTIFACTS = "p2artifacts";
    public static final String EXTENSION_P2_ARTIFACTS = "xml";
    public static final String FILE_NAME_P2_ARTIFACTS = "p2artifacts.xml";
    public static final String FILE_NAME_LOCAL_ARTIFACTS = "local-artifacts.properties";
    public static final String KEY_ARTIFACT_MAIN = "artifact.main";
    public static final String KEY_ARTIFACT_ATTACHED = "artifact.attached.";
    public static final String DEFAULT_EXTERNSION = "jar";
    public static final String PACK200_CLASSIFIER = "pack200";
    public static final String PACK200_EXTENSION = "jar.pack.gz";

    public static String getRelativePath(GAV gav, String classifier, String extension) {
        return RepositoryLayoutHelper.getRelativePath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), classifier, extension);
    }

    public static String getRelativePath(String groupId, String artifactId, String version, String classifier, String extension) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(groupId, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken()).append('/');
        }
        sb.append(artifactId).append('/').append(version).append('/');
        sb.append(artifactId).append('-').append(version);
        if (classifier != null) {
            sb.append('-').append(classifier);
        }
        sb.append('.').append(extension != null ? extension : DEFAULT_EXTERNSION);
        return sb.toString();
    }

    public static GAV getP2Gav(String classifier, String id, String version) {
        return new GAV("p2." + classifier, id, version);
    }

    public static GAV getGAV(Map properties) {
        String groupId = (String)properties.get(PROP_GROUP_ID);
        String artifactId = (String)properties.get(PROP_ARTIFACT_ID);
        String version = (String)properties.get(PROP_VERSION);
        return RepositoryLayoutHelper.getGAV(groupId, artifactId, version);
    }

    public static GAV getGAV(String groupId, String artifactId, String version) {
        if (groupId != null && artifactId != null && version != null) {
            return new GAV(groupId, artifactId, version);
        }
        return null;
    }

    public static String getClassifier(Map properties) {
        return (String)properties.get(PROP_CLASSIFIER);
    }

    public static String getExtension(Map properties) {
        String explicitExtension = (String)properties.get(PROP_EXTENSION);
        return explicitExtension == null ? DEFAULT_EXTERNSION : explicitExtension;
    }
}

