/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;

public final class ListQueryable<T>
implements IQueryable<T> {
    private final List<IQueryable<T>> queryList = new ArrayList<IQueryable<T>>();

    public IQueryResult<T> query(IQuery<T> query, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.queryList.size());
        ArrayList results = new ArrayList();
        for (IQueryable<T> queryable : this.queryList) {
            results.add(queryable.query(query, (IProgressMonitor)subMonitor.split(1)));
        }
        return new ListQueryResult(results);
    }

    public void add(IQueryable<T> child) {
        this.queryList.add(child);
    }

    private static final class ListQueryResult<R>
    implements IQueryResult<R> {
        private List<IQueryResult<R>> resultList;

        public ListQueryResult(List<IQueryResult<R>> resultList) {
            this.resultList = resultList;
        }

        public IQueryResult<R> query(IQuery<R> query, IProgressMonitor monitor) {
            return query.perform(this.iterator());
        }

        public boolean isEmpty() {
            return this.resultList.isEmpty() || this.resultList.stream().allMatch(IQueryResult::isEmpty);
        }

        public Iterator<R> iterator() {
            return this.stream().iterator();
        }

        private Stream<R> stream() {
            return this.resultList.stream().flatMap(r -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(r.iterator(), 16), false));
        }

        public R[] toArray(Class<R> clazz) {
            return this.stream().toArray((int s) -> (Object[])Array.newInstance(clazz, s));
        }

        public Set<R> toSet() {
            return this.stream().collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public Set<R> toUnmodifiableSet() {
            return this.stream().collect(Collectors.toUnmodifiableSet());
        }
    }
}

