/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryComponent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;
import org.eclipse.tycho.p2maven.transport.P2MirrorDisablingArtifactRepositoryManager;
import org.eclipse.tycho.p2maven.transport.RemoteArtifactRepositoryManager;

@Component(role=IAgentServiceFactory.class, hint="org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager")
public class RemoteArtifactRepositoryManagerAgentFactory
implements IAgentServiceFactory {
    @Requirement
    Logger logger;
    @Requirement
    IRepositoryIdManager repositoryIdManager;
    @Requirement
    MavenAuthenticator authenticator;

    public Object createService(IProvisioningAgent agent) {
        IArtifactRepositoryManager plainRepoManager = (IArtifactRepositoryManager)new ArtifactRepositoryComponent().createService(agent);
        if (this.getDisableP2MirrorsConfiguration()) {
            plainRepoManager = new P2MirrorDisablingArtifactRepositoryManager(plainRepoManager, this.logger);
        }
        return new RemoteArtifactRepositoryManager(plainRepoManager, this.repositoryIdManager, this.authenticator);
    }

    private boolean getDisableP2MirrorsConfiguration() {
        String key = "tycho.disableP2Mirrors";
        String value = System.getProperty(key);
        boolean disableP2Mirrors = Boolean.parseBoolean(value);
        if (disableP2Mirrors && this.logger.isDebugEnabled()) {
            String message = key + "=" + value + " -> ignoring mirrors specified in p2 artifact repositories";
            this.logger.debug(message);
        }
        return disableP2Mirrors;
    }
}

