/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler.jdt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

@Component(role=Compiler.class, hint="jdt")
public class JDTCompiler
extends AbstractCompiler {
    private static final String SEPARATOR = "----------";
    private static final char[] SEPARATOR_CHARS = new char[]{'/', '\\'};
    private static final char[] ADAPTER_PREFIX = "#ADAPTER#".toCharArray();
    private static final char[] ADAPTER_ENCODING = "ENCODING#".toCharArray();
    private static final char[] ADAPTER_ACCESS = "ACCESS#".toCharArray();
    String logFileName;
    Map customDefaultOptions;
    private Map fileEncodings = null;
    private Map dirEncodings = null;
    private List accessRules = null;

    public JDTCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        List messages;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JDTCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return Collections.EMPTY_LIST;
        }
        this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        this.checkCompilerArgs(config.getCustomCompilerArguments());
        String[] args = this.buildCompilerArguments(config, sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                executable = "javac";
            }
            messages = this.compileOutOfProcess(config.getWorkingDirectory(), executable, args);
        } else {
            messages = this.compileInProcess(args);
        }
        return messages;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return this.buildCompilerArguments(config, JDTCompiler.getSourceFiles((CompilerConfiguration)config));
    }

    public String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List sourceLocations;
        ArrayList<String> args = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            String cp = this.createClasspathArgument(classpathEntries);
            args.add(cp);
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty() && sourceFiles.length == 0) {
            args.add("-sourcepath");
            args.add(JDTCompiler.getPathString((List)sourceLocations));
        }
        for (int i = 0; i < sourceFiles.length; ++i) {
            args.add(sourceFiles[i]);
        }
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            args.add("-g");
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!StringUtils.isEmpty((String)config.getMaxmem())) {
            args.add("-J-Xmx" + config.getMaxmem());
        }
        if (!StringUtils.isEmpty((String)config.getMeminitial())) {
            args.add("-J-Xms" + config.getMeminitial());
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (StringUtils.isEmpty((String)config.getTargetVersion())) {
            args.add("-target");
            args.add("1.1");
        } else {
            args.add("-target");
            args.add(config.getTargetVersion());
        }
        if (!JDTCompiler.suppressSource(config) && StringUtils.isEmpty((String)config.getSourceVersion())) {
            args.add("-source");
            args.add("1.3");
        } else if (!JDTCompiler.suppressSource(config)) {
            args.add("-source");
            args.add(config.getSourceVersion());
        }
        if (!JDTCompiler.suppressEncoding(config) && !StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        for (Map.Entry entry : config.getCustomCompilerArguments().entrySet()) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || key.startsWith("@")) continue;
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }

    private static boolean suppressSource(CompilerConfiguration config) {
        return "1.3".equals(config.getCompilerVersion());
    }

    private static boolean suppressEncoding(CompilerConfiguration config) {
        return "1.3".equals(config.getCompilerVersion());
    }

    List compileOutOfProcess(File workingDirectory, String executable, String[] args) throws CompilerException {
        throw new UnsupportedOperationException("compileoutOfProcess not supported");
    }

    List compileInProcess(String[] args) throws CompilerException {
        List messages;
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        Main compiler = new Main(new PrintWriter(out), new PrintWriter(err), false);
        compiler.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        compiler.compile(args);
        try {
            String output = err.toString();
            System.out.println(output);
            messages = JDTCompiler.parseModernStream(new BufferedReader(new StringReader(output)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return messages;
    }

    protected static List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        Pattern linePattern = Pattern.compile("(\\d*). (ERROR|WARNING) in (.*)");
        Pattern lineNrPattern = Pattern.compile(" \\(at line (\\d*)\\)");
        Pattern pointerPattern = Pattern.compile("(\\s*)(\\^*)");
        int lineNr = -1;
        String file = null;
        String type = null;
        int startCol = 0;
        int endCol = 0;
        while (true) {
            String line;
            StringBuilder buffer = new StringBuilder(EOL);
            boolean processing = false;
            do {
                if ((line = input.readLine()) == null) {
                    return errors;
                }
                if (!processing) {
                    Matcher matcher = linePattern.matcher(line);
                    processing = matcher.matches();
                    if (!processing) continue;
                    matcher.group(1);
                    type = matcher.group(2);
                    file = matcher.group(3);
                    continue;
                }
                if (line.equals(SEPARATOR)) continue;
                Matcher m = lineNrPattern.matcher(line);
                if (m.matches()) {
                    lineNr = Integer.parseInt(m.group(1));
                    continue;
                }
                m = pointerPattern.matcher(line);
                if (m.matches()) {
                    startCol = m.group(1).length();
                    endCol = startCol + m.group(2).length();
                }
                buffer.append(line).append(EOL);
            } while (!line.endsWith(SEPARATOR));
            if (!processing) continue;
            CompilerError error = new CompilerError(file, "ERROR".equals(type), lineNr, lineNr, startCol, endCol, buffer.toString());
            errors.add(error);
        }
    }

    private String createClasspathArgument(List classpath) {
        String[] pathElements = classpath.toArray(new String[classpath.size()]);
        if (pathElements.length == 0) {
            return "";
        }
        if (this.accessRules == null) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < pathElements.length; ++i) {
                result.append(pathElements[i]);
                if (i >= pathElements.length - 1) continue;
                result.append(File.pathSeparatorChar);
            }
            return result.toString();
        }
        int rulesLength = this.accessRules.size();
        String[] rules = this.accessRules.toArray(new String[rulesLength]);
        int nextRule = 0;
        StringBuffer result = new StringBuffer();
        int max = pathElements.length;
        block1: for (int i = 0; i < max; ++i) {
            if (i > 0) {
                result.append(File.pathSeparatorChar);
            }
            String pathElement = pathElements[i];
            result.append(pathElement);
            for (int j = nextRule; j < rulesLength; j += 2) {
                int ruleLength;
                String rule = rules[j];
                if (pathElement.endsWith(rule)) {
                    result.append(rules[j + 1]);
                    nextRule = j + 2;
                    continue block1;
                }
                if (rule.endsWith(File.separator)) {
                    ruleLength = rule.length();
                    if (!pathElement.regionMatches(false, pathElement.length() - ruleLength + 1, rule, 0, ruleLength - 1)) continue;
                    result.append(rules[j + 1]);
                    nextRule = j + 2;
                    continue block1;
                }
                if (!pathElement.endsWith(File.separator)) continue;
                ruleLength = rule.length();
                if (!pathElement.regionMatches(false, pathElement.length() - ruleLength - 1, rule, 0, ruleLength)) continue;
                result.append(rules[j + 1]);
                nextRule = j + 2;
                continue block1;
            }
        }
        String s = result.toString();
        return s;
    }

    private void checkCompilerArgs(Map args) {
        for (String arg : args.keySet()) {
            if (arg.charAt(0) != '@') continue;
            try {
                char[] content = Util.getFileCharContent((File)new File(arg.substring(1)), null);
                int offset = 0;
                int prefixLength = ADAPTER_PREFIX.length;
                while ((offset = CharOperation.indexOf((char[])ADAPTER_PREFIX, (char[])content, (boolean)true, (int)offset)) > -1) {
                    int accessStart;
                    int start = offset + prefixLength;
                    int end = CharOperation.indexOf((char)'\n', (char[])content, (int)start);
                    if (end == -1) {
                        end = content.length;
                    }
                    while (CharOperation.isWhitespace((char)content[end])) {
                        --end;
                    }
                    if (CharOperation.equals((char[])ADAPTER_ENCODING, (char[])content, (int)start, (int)(start + ADAPTER_ENCODING.length))) {
                        CharOperation.replace((char[])content, (char[])SEPARATOR_CHARS, (char)File.separatorChar, (int)start, (int)(end + 1));
                        int encodeStart = CharOperation.lastIndexOf((char)'[', (char[])content, (int)(start += ADAPTER_ENCODING.length), (int)end);
                        if (start < encodeStart && encodeStart < end) {
                            boolean isFile = CharOperation.equals((char[])SuffixConstants.SUFFIX_java, (char[])content, (int)(encodeStart - 5), (int)encodeStart, (boolean)false);
                            String str = String.valueOf(content, start, encodeStart - start);
                            String enc = String.valueOf(content, encodeStart, end - encodeStart + 1);
                            if (isFile) {
                                if (this.fileEncodings == null) {
                                    this.fileEncodings = new HashMap();
                                }
                                this.fileEncodings.put(str, enc);
                            } else {
                                if (this.dirEncodings == null) {
                                    this.dirEncodings = new HashMap();
                                }
                                this.dirEncodings.put(str, enc);
                            }
                        }
                    } else if (CharOperation.equals((char[])ADAPTER_ACCESS, (char[])content, (int)start, (int)(start + ADAPTER_ACCESS.length)) && (start += ADAPTER_ACCESS.length) < (accessStart = CharOperation.indexOf((char)'[', (char[])content, (int)start, (int)end)) && accessStart < end) {
                        String path = String.valueOf(content, start, accessStart - start);
                        String access = String.valueOf(content, accessStart, end - accessStart + 1);
                        if (this.accessRules == null) {
                            this.accessRules = new ArrayList();
                        }
                        this.accessRules.add(path);
                        this.accessRules.add(access);
                    }
                    offset = end;
                }
            }
            catch (IOException e) {
            }
        }
    }
}

