/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Element;
import java.util.Objects;

public class RepositoryReference {
    private final Element dom;

    public int hashCode() {
        return Objects.hash(this.getLocation(), this.isEnabled());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof RepositoryReference)) return false;
        RepositoryReference other = (RepositoryReference)obj;
        if (!Objects.equals(this.getLocation(), other.getLocation())) return false;
        if (this.isEnabled() != other.isEnabled()) return false;
        return true;
    }

    public String toString() {
        return this.getLocation() + "_" + this.isEnabled();
    }

    public RepositoryReference(Element dom) {
        this.dom = dom;
    }

    public RepositoryReference(String tagname) {
        this.dom = new Element(tagname);
    }

    public String getLocation() {
        return this.dom.getAttributeValue("location");
    }

    public void setLocation(String location) {
        this.dom.setAttribute("location", location);
    }

    public String getName() {
        return this.dom.getAttributeValue("name");
    }

    public void setName(String name) {
        this.dom.setAttribute("name", name);
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.dom.getAttributeValue("enabled"));
    }

    public void setEnabled(boolean enabled) {
        this.dom.setAttribute("enabled", Boolean.toString(enabled));
    }

    Element getDom() {
        return this.dom;
    }
}

