/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import org.apache.commons.io.FileUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.jgroups.Address;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.util.IntegerHelper;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class LevelDBLog
implements Log {
    protected final org.jgroups.logging.Log log = LogFactory.getLog(this.getClass());
    private static final byte[] FIRSTAPPENDED = "FA".getBytes();
    private static final byte[] LASTAPPENDED = "LA".getBytes();
    private static final byte[] CURRENTTERM = "CT".getBytes();
    private static final byte[] COMMITINDEX = "CX".getBytes();
    private static final byte[] VOTEDFOR = "VF".getBytes();
    private DB db;
    private File dbFileName;
    private int currentTerm = 0;
    private Address votedFor = null;
    private int commitIndex = 0;
    private int lastAppended = 0;
    private int firstAppended = 0;

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        Options options = new Options();
        options.createIfMissing(true);
        this.dbFileName = new File(log_name);
        this.db = JniDBFactory.factory.open(this.dbFileName, options);
        this.log.trace("opened %s", new Object[]{this.db});
        if (this.isANewRAFTLog()) {
            this.log.trace("log %s is new, must be initialized", new Object[]{this.dbFileName});
            this.initLogWithMetadata();
        } else {
            this.log.trace("log %s exists, does not have to be initialized", new Object[]{this.dbFileName});
            this.readMetadataFromLog();
        }
        this.checkForConsistency();
    }

    @Override
    public void close() {
        try {
            this.log.trace("closing DB: %s", new Object[]{this.db});
            if (this.db != null) {
                this.db.close();
            }
            this.currentTerm = 0;
            this.votedFor = null;
            this.commitIndex = 0;
            this.lastAppended = 0;
            this.firstAppended = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete() {
        this.close();
        try {
            this.log.trace("deleting DB directory: %s", new Object[]{this.dbFileName});
            FileUtils.deleteDirectory((File)this.dbFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int currentTerm() {
        return this.currentTerm;
    }

    @Override
    public Log currentTerm(int new_term) {
        this.currentTerm = new_term;
        this.log.trace("Updating current term: %d", new Object[]{this.currentTerm});
        this.db.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(this.currentTerm));
        return this;
    }

    @Override
    public Address votedFor() {
        return this.votedFor;
    }

    @Override
    public Log votedFor(Address member) {
        this.votedFor = member;
        try {
            this.log.debug("Updating Voted for: %s", new Object[]{this.votedFor});
            this.db.put(VOTEDFOR, Util.objectToByteBuffer((Object)member));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public int firstAppended() {
        return this.firstAppended;
    }

    @Override
    public int commitIndex() {
        return this.commitIndex;
    }

    @Override
    public Log commitIndex(int new_index) {
        this.commitIndex = new_index;
        this.log.trace("Updating commit index: %d", new Object[]{this.commitIndex});
        this.db.put(COMMITINDEX, IntegerHelper.fromIntToByteArray(this.commitIndex));
        return this;
    }

    @Override
    public int lastAppended() {
        return this.lastAppended;
    }

    @Override
    public void append(int index, boolean overwrite, LogEntry ... entries) {
        this.log.trace("Appending %d entries", new Object[]{entries.length});
        try (WriteBatch batch = this.db.createWriteBatch();){
            for (LogEntry entry : entries) {
                if (overwrite) {
                    this.appendEntry(index, entry, batch);
                } else {
                    this.appendEntryIfAbsent(index, entry, batch);
                }
                this.updateLastAppended(index, batch);
                if (entry.term != this.currentTerm) {
                    this.updateCurrentTerm(entry.term, batch);
                }
                this.log.trace("Flushing batch to DB: %s", new Object[]{batch});
                this.db.write(batch);
                ++index;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public LogEntry get(int index) {
        return this.getLogEntry(index);
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function, int start_index, int end_index) {
        start_index = Math.max(start_index, Math.max(this.firstAppended, 1));
        end_index = Math.min(end_index, this.lastAppended);
        for (int i = start_index; i <= end_index; ++i) {
            LogEntry entry = this.getLogEntry(i);
            function.accept(entry, i);
        }
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function) {
        this.forEach(function, Math.max(1, this.firstAppended), this.lastAppended);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(int upto_index) {
        if (upto_index < this.firstAppended || upto_index > this.lastAppended) {
            return;
        }
        WriteBatch batch = null;
        try {
            batch = this.db.createWriteBatch();
            for (int index = this.firstAppended; index < upto_index; ++index) {
                batch.delete(IntegerHelper.fromIntToByteArray(index));
            }
            this.firstAppended = upto_index;
            batch.put(FIRSTAPPENDED, IntegerHelper.fromIntToByteArray(upto_index));
            this.db.write(batch);
        }
        finally {
            Util.close((Closeable)batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllEntriesStartingFrom(int start_index) {
        if (start_index < this.firstAppended || start_index > this.lastAppended) {
            return;
        }
        WriteBatch batch = null;
        try {
            batch = this.db.createWriteBatch();
            for (int index = start_index; index <= this.lastAppended; ++index) {
                batch.delete(IntegerHelper.fromIntToByteArray(index));
            }
            LogEntry last = this.getLogEntry(start_index - 1);
            if (last == null) {
                this.updateCurrentTerm(0, batch);
            } else {
                this.updateCurrentTerm(last.term, batch);
            }
            this.updateLastAppended(start_index - 1, batch);
            if (this.commitIndex > this.lastAppended) {
                this.commitIndex(this.lastAppended);
            }
            this.db.write(batch);
        }
        finally {
            Util.close((Closeable)batch);
        }
    }

    public byte[] print(byte[] bytes) {
        return this.db.get(bytes);
    }

    public void printMetadata() throws Exception {
        this.log.info("-----------------");
        this.log.info("RAFT Log Metadata");
        this.log.info("-----------------");
        byte[] firstAppendedBytes = this.db.get(FIRSTAPPENDED);
        this.log.info("First Appended: %d", new Object[]{IntegerHelper.fromByteArrayToInt(firstAppendedBytes)});
        byte[] lastAppendedBytes = this.db.get(LASTAPPENDED);
        this.log.info("Last Appended: %d", new Object[]{IntegerHelper.fromByteArrayToInt(lastAppendedBytes)});
        byte[] currentTermBytes = this.db.get(CURRENTTERM);
        this.log.info("Current Term: %d", new Object[]{IntegerHelper.fromByteArrayToInt(currentTermBytes)});
        byte[] commitIndexBytes = this.db.get(COMMITINDEX);
        this.log.info("Commit Index: %d", new Object[]{IntegerHelper.fromByteArrayToInt(commitIndexBytes)});
        Address votedForTmp = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.info("Voted for: %s", new Object[]{votedForTmp});
    }

    public String toString() {
        return "firstAppended=" + this.firstAppended + ", lastAppended=" + this.lastAppended + ", commitIndex=" + this.commitIndex + ", currentTerm=" + this.currentTerm;
    }

    private LogEntry getLogEntry(int index) {
        byte[] entryBytes = this.db.get(IntegerHelper.fromIntToByteArray(index));
        LogEntry entry = null;
        try {
            if (entryBytes != null) {
                entry = (LogEntry)Util.streamableFromByteBuffer(LogEntry.class, (byte[])entryBytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entry;
    }

    private void appendEntryIfAbsent(int index, LogEntry entry, WriteBatch batch) throws Exception {
        if (this.db.get(IntegerHelper.fromIntToByteArray(index)) != null) {
            this.log.trace("Entry %d: %s can't be appended, index already present", new Object[]{index, entry});
            throw new IllegalStateException("Entry at index " + index + " already exists");
        }
        this.appendEntry(index, entry, batch);
    }

    private void appendEntry(int index, LogEntry entry, WriteBatch batch) throws Exception {
        this.log.trace("Appending entry %d: %s", new Object[]{index, entry});
        batch.put(IntegerHelper.fromIntToByteArray(index), Util.streamableToByteBuffer((Streamable)entry));
    }

    private void updateCurrentTerm(int updatedCurrentTerm, WriteBatch batch) {
        this.currentTerm = updatedCurrentTerm;
        this.log.trace("Updating currentTerm: %d", new Object[]{updatedCurrentTerm});
        batch.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(this.currentTerm));
    }

    private void updateLastAppended(int updatedLastAppended, WriteBatch batch) {
        this.lastAppended = updatedLastAppended;
        this.log.trace("Updating lastAppended: %d", new Object[]{updatedLastAppended});
        batch.put(LASTAPPENDED, IntegerHelper.fromIntToByteArray(this.lastAppended));
    }

    private boolean isANewRAFTLog() {
        return this.db.get(FIRSTAPPENDED) == null;
    }

    private void initLogWithMetadata() {
        this.log.debug("Initializing log with empty Metadata");
        WriteBatch batch = this.db.createWriteBatch();
        try {
            batch.put(FIRSTAPPENDED, IntegerHelper.fromIntToByteArray(0));
            batch.put(LASTAPPENDED, IntegerHelper.fromIntToByteArray(0));
            batch.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(0));
            batch.put(COMMITINDEX, IntegerHelper.fromIntToByteArray(0));
            this.db.write(batch);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                batch.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readMetadataFromLog() throws Exception {
        this.firstAppended = IntegerHelper.fromByteArrayToInt(this.db.get(FIRSTAPPENDED));
        this.lastAppended = IntegerHelper.fromByteArrayToInt(this.db.get(LASTAPPENDED));
        this.currentTerm = IntegerHelper.fromByteArrayToInt(this.db.get(CURRENTTERM));
        this.commitIndex = IntegerHelper.fromByteArrayToInt(this.db.get(COMMITINDEX));
        this.votedFor = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.debug("read metadata from log: firstAppended=%d, lastAppended=%d, currentTerm=%d, commitIndex=%d, votedFor=%s", new Object[]{this.firstAppended, this.lastAppended, this.currentTerm, this.commitIndex, this.votedFor});
    }

    private void checkForConsistency() throws Exception {
        int loggedFirstAppended = IntegerHelper.fromByteArrayToInt(this.db.get(FIRSTAPPENDED));
        this.log.trace("FirstAppended in DB is: %d", new Object[]{loggedFirstAppended});
        int loggedLastAppended = IntegerHelper.fromByteArrayToInt(this.db.get(LASTAPPENDED));
        this.log.trace("LastAppended in DB is: %d", new Object[]{loggedLastAppended});
        int loggedCurrentTerm = IntegerHelper.fromByteArrayToInt(this.db.get(CURRENTTERM));
        this.log.trace("CurrentTerm in DB is: %d", new Object[]{loggedCurrentTerm});
        int loggedCommitIndex = IntegerHelper.fromByteArrayToInt(this.db.get(COMMITINDEX));
        this.log.trace("CommitIndex in DB is: %d", new Object[]{loggedCommitIndex});
        Address loggedVotedForAddress = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.trace("VotedFor in DB is: %s", new Object[]{loggedVotedForAddress});
        assert (this.firstAppended == loggedFirstAppended);
        assert (this.lastAppended == loggedLastAppended);
        assert (this.currentTerm == loggedCurrentTerm);
        assert (this.commitIndex == loggedCommitIndex);
        if (this.votedFor != null) assert (this.votedFor.equals(loggedVotedForAddress));
        LogEntry lastAppendedEntry = this.getLogEntry(this.lastAppended);
        assert (lastAppendedEntry == null || lastAppendedEntry.term <= this.currentTerm);
    }
}

