/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kiwiproject.consul.BaseClient;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.model.coordinate.Coordinate;
import org.kiwiproject.consul.model.coordinate.Datacenter;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.QueryMap;

public class CoordinateClient
extends BaseClient {
    private static final String CLIENT_NAME = "coordinate";
    private final Api api;

    CoordinateClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public List<Datacenter> getDatacenters() {
        return this.http.extract(this.api.getDatacenters(), new Integer[0]);
    }

    public List<Coordinate> getNodes(String dc) {
        return this.http.extract(this.api.getNodes(this.dcQuery(dc)), new Integer[0]);
    }

    public List<Coordinate> getNodes() {
        return this.getNodes(null);
    }

    private Map<String, String> dcQuery(String dc) {
        return Objects.nonNull(dc) ? Map.of("dc", dc) : Map.of();
    }

    static interface Api {
        @GET(value="coordinate/datacenters")
        public Call<List<Datacenter>> getDatacenters();

        @GET(value="coordinate/nodes")
        public Call<List<Coordinate>> getNodes(@QueryMap Map<String, String> var1);
    }
}

