/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.acl.AclResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="AclResponse", generator="Immutables")
public final class ImmutableAclResponse
extends AclResponse {
    private final BigInteger createIndex;
    private final BigInteger modifyIndex;
    @Nullable
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final String type;
    @Nullable
    private final String rules;

    private ImmutableAclResponse(BigInteger createIndex, BigInteger modifyIndex, @Nullable String id, @Nullable String name, @Nullable String type, @Nullable String rules) {
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
        this.id = id;
        this.name = name;
        this.type = type;
        this.rules = rules;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public BigInteger createIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public BigInteger modifyIndex() {
        return this.modifyIndex;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="Type")
    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    @JsonProperty(value="Rules")
    public Optional<String> rules() {
        return Optional.ofNullable(this.rules);
    }

    public final ImmutableAclResponse withCreateIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "createIndex");
        if (this.createIndex.equals(newValue)) {
            return this;
        }
        return new ImmutableAclResponse(newValue, this.modifyIndex, this.id, this.name, this.type, this.rules);
    }

    public final ImmutableAclResponse withModifyIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
        if (this.modifyIndex.equals(newValue)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, newValue, this.id, this.name, this.type, this.rules);
    }

    public final ImmutableAclResponse withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, newValue, this.name, this.type, this.rules);
    }

    public final ImmutableAclResponse withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, value, this.name, this.type, this.rules);
    }

    public final ImmutableAclResponse withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, newValue, this.type, this.rules);
    }

    public final ImmutableAclResponse withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, value, this.type, this.rules);
    }

    public final ImmutableAclResponse withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (Objects.equals(this.type, newValue)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, newValue, this.rules);
    }

    public final ImmutableAclResponse withType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, value, this.rules);
    }

    public final ImmutableAclResponse withRules(String value) {
        String newValue = Objects.requireNonNull(value, "rules");
        if (Objects.equals(this.rules, newValue)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, this.type, newValue);
    }

    public final ImmutableAclResponse withRules(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rules, value)) {
            return this;
        }
        return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAclResponse && this.equalTo(0, (ImmutableAclResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableAclResponse another) {
        return this.createIndex.equals(another.createIndex) && this.modifyIndex.equals(another.modifyIndex) && Objects.equals(this.id, another.id) && Objects.equals(this.name, another.name) && Objects.equals(this.type, another.type) && Objects.equals(this.rules, another.rules);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createIndex.hashCode();
        h += (h << 5) + this.modifyIndex.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.rules);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AclResponse").omitNullValues().add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("rules", (Object)this.rules).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAclResponse fromJson(Json json) {
        Builder builder = ImmutableAclResponse.builder();
        if (json.createIndex != null) {
            builder.createIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.modifyIndex(json.modifyIndex);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.rules != null) {
            builder.rules(json.rules);
        }
        return builder.build();
    }

    public static ImmutableAclResponse copyOf(AclResponse instance) {
        if (instance instanceof ImmutableAclResponse) {
            return (ImmutableAclResponse)instance;
        }
        return ImmutableAclResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AclResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATE_INDEX = 1L;
        private static final long INIT_BIT_MODIFY_INDEX = 2L;
        private long initBits = 3L;
        @Nullable
        private BigInteger createIndex;
        @Nullable
        private BigInteger modifyIndex;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String type;
        @Nullable
        private String rules;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AclResponse instance) {
            Optional<String> rulesOptional;
            Optional<String> typeOptional;
            Optional<String> nameOptional;
            Objects.requireNonNull(instance, "instance");
            this.createIndex(instance.createIndex());
            this.modifyIndex(instance.modifyIndex());
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((nameOptional = instance.name()).isPresent()) {
                this.name(nameOptional);
            }
            if ((typeOptional = instance.type()).isPresent()) {
                this.type(typeOptional);
            }
            if ((rulesOptional = instance.rules()).isPresent()) {
                this.rules(rulesOptional);
            }
            return this;
        }

        @JsonProperty(value="CreateIndex")
        @CanIgnoreReturnValue
        public final Builder createIndex(BigInteger createIndex) {
            this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ModifyIndex")
        @CanIgnoreReturnValue
        public final Builder modifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty(value="Type")
        @CanIgnoreReturnValue
        public final Builder type(Optional<String> type) {
            this.type = type.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rules(String rules) {
            this.rules = Objects.requireNonNull(rules, "rules");
            return this;
        }

        @JsonProperty(value="Rules")
        @CanIgnoreReturnValue
        public final Builder rules(Optional<String> rules) {
            this.rules = rules.orElse(null);
            return this;
        }

        public ImmutableAclResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, this.type, this.rules);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("modifyIndex");
            }
            return "Cannot build AclResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AclResponse", generator="Immutables")
    static final class Json
    extends AclResponse {
        @Nullable
        BigInteger createIndex;
        @Nullable
        BigInteger modifyIndex;
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> name = Optional.empty();
        @Nullable
        Optional<String> type = Optional.empty();
        @Nullable
        Optional<String> rules = Optional.empty();

        Json() {
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(BigInteger createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="Type")
        public void setType(Optional<String> type) {
            this.type = type;
        }

        @JsonProperty(value="Rules")
        public void setRules(Optional<String> rules) {
            this.rules = rules;
        }

        @Override
        public BigInteger createIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger modifyIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rules() {
            throw new UnsupportedOperationException();
        }
    }
}

