/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.query.DnsQuery;
import org.kiwiproject.consul.model.query.ServiceQuery;
import org.kiwiproject.consul.model.query.StoredQuery;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="StoredQuery", generator="Immutables")
public final class ImmutableStoredQuery
extends StoredQuery {
    private final String id;
    private final String name;
    private final String session;
    private final String token;
    private final ServiceQuery service;
    private final DnsQuery dns;

    private ImmutableStoredQuery(String id, String name, String session, String token, ServiceQuery service, DnsQuery dns) {
        this.id = id;
        this.name = name;
        this.session = session;
        this.token = token;
        this.service = service;
        this.dns = dns;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Session")
    public String getSession() {
        return this.session;
    }

    @Override
    @JsonProperty(value="Token")
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="Service")
    public ServiceQuery getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="DNS")
    public DnsQuery getDns() {
        return this.dns;
    }

    public final ImmutableStoredQuery withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableStoredQuery(newValue, this.name, this.session, this.token, this.service, this.dns);
    }

    public final ImmutableStoredQuery withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, newValue, this.session, this.token, this.service, this.dns);
    }

    public final ImmutableStoredQuery withSession(String value) {
        String newValue = Objects.requireNonNull(value, "session");
        if (this.session.equals(newValue)) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, this.name, newValue, this.token, this.service, this.dns);
    }

    public final ImmutableStoredQuery withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, this.name, this.session, newValue, this.service, this.dns);
    }

    public final ImmutableStoredQuery withService(ServiceQuery value) {
        if (this.service == value) {
            return this;
        }
        ServiceQuery newValue = Objects.requireNonNull(value, "service");
        return new ImmutableStoredQuery(this.id, this.name, this.session, this.token, newValue, this.dns);
    }

    public final ImmutableStoredQuery withDns(DnsQuery value) {
        if (this.dns == value) {
            return this;
        }
        DnsQuery newValue = Objects.requireNonNull(value, "dns");
        return new ImmutableStoredQuery(this.id, this.name, this.session, this.token, this.service, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredQuery && this.equalTo(0, (ImmutableStoredQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableStoredQuery another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.session.equals(another.session) && this.token.equals(another.token) && this.service.equals(another.service) && this.dns.equals(another.dns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.session.hashCode();
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.service.hashCode();
        h += (h << 5) + this.dns.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredQuery").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("session", (Object)this.session).add("token", (Object)this.token).add("service", (Object)this.service).add("dns", (Object)this.dns).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredQuery fromJson(Json json) {
        Builder builder = ImmutableStoredQuery.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.dns != null) {
            builder.dns(json.dns);
        }
        return builder.build();
    }

    public static ImmutableStoredQuery copyOf(StoredQuery instance) {
        if (instance instanceof ImmutableStoredQuery) {
            return (ImmutableStoredQuery)instance;
        }
        return ImmutableStoredQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StoredQuery", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_SESSION = 4L;
        private static final long INIT_BIT_TOKEN = 8L;
        private static final long INIT_BIT_SERVICE = 16L;
        private static final long INIT_BIT_DNS = 32L;
        private long initBits = 63L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String session;
        @Nullable
        private String token;
        @Nullable
        private ServiceQuery service;
        @Nullable
        private DnsQuery dns;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.session(instance.getSession());
            this.token(instance.getToken());
            this.service(instance.getService());
            this.dns(instance.getDns());
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Session")
        @CanIgnoreReturnValue
        public final Builder session(String session) {
            this.session = Objects.requireNonNull(session, "session");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Token")
        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(ServiceQuery service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="DNS")
        @CanIgnoreReturnValue
        public final Builder dns(DnsQuery dns) {
            this.dns = Objects.requireNonNull(dns, "dns");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableStoredQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredQuery(this.id, this.name, this.session, this.token, this.service, this.dns);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("session");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("service");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("dns");
            }
            return "Cannot build StoredQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StoredQuery", generator="Immutables")
    static final class Json
    extends StoredQuery {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String session;
        @Nullable
        String token;
        @Nullable
        ServiceQuery service;
        @Nullable
        DnsQuery dns;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Session")
        public void setSession(String session) {
            this.session = session;
        }

        @JsonProperty(value="Token")
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(value="Service")
        public void setService(ServiceQuery service) {
            this.service = service;
        }

        @JsonProperty(value="DNS")
        public void setDns(DnsQuery dns) {
            this.dns = dns;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSession() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceQuery getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DnsQuery getDns() {
            throw new UnsupportedOperationException();
        }
    }
}

