/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.kiwiproject.consul.util.UncheckedGeneralSecurityException;

public class TrustManagerUtils {
    private TrustManagerUtils() {
    }

    public static X509TrustManager getDefaultTrustManager() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            for (TrustManager manager : factory.getTrustManagers()) {
                if (!(manager instanceof X509TrustManager)) continue;
                X509TrustManager trustManager = (X509TrustManager)manager;
                return trustManager;
            }
            throw new IllegalStateException("Default X509TrustManager not found");
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new UncheckedGeneralSecurityException(e);
        }
    }
}

