/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.liquibase.maven.plugins.LiquibaseRollback;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseRollbackSQL
extends LiquibaseRollback {
    @PropertyElement
    protected File migrationSqlOutputFile;
    private Writer outputWriter;

    @Override
    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(db);
        try {
            if (!this.migrationSqlOutputFile.exists()) {
                this.migrationSqlOutputFile.getParentFile().mkdirs();
                if (!this.migrationSqlOutputFile.createNewFile()) {
                    throw new MojoExecutionException("Cannot create the migration SQL file; " + this.migrationSqlOutputFile.getAbsolutePath());
                }
            }
            this.outputWriter = this.getOutputWriter(this.migrationSqlOutputFile);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create SQL output writer", (Exception)e);
        }
        this.getLog().info((CharSequence)("Output SQL Migration File: " + this.migrationSqlOutputFile.getAbsolutePath()));
        return liquibase;
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "migrationSQLOutputFile: " + this.migrationSqlOutputFile));
    }

    @Override
    protected void cleanup(Database db) {
        super.cleanup(db);
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        switch (this.type) {
            case COUNT: {
                liquibase.rollback(this.rollbackCount, this.rollbackScript, new Contexts(this.contexts), new LabelExpression(this.labels), this.outputWriter);
                break;
            }
            case DATE: {
                try {
                    liquibase.rollback(this.parseDate(this.rollbackDate), this.rollbackScript, new Contexts(this.contexts), new LabelExpression(this.labels), this.outputWriter);
                    break;
                }
                catch (ParseException e) {
                    String message = "Error parsing rollbackDate: " + e.getMessage();
                    throw new LiquibaseException(message, (Throwable)e);
                }
            }
            case TAG: {
                liquibase.rollback(this.rollbackTag, this.rollbackScript, new Contexts(this.contexts), new LabelExpression(this.labels), this.outputWriter);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected rollback type, " + (Object)((Object)this.type));
            }
        }
    }
}

